/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.EJBUtil;
import quadbase.datasource.DataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.report.XMLReport;

public class EjbDataSource
extends DataSource {
    private EJBInfo ejbInfo;

    public EjbDataSource(Element source) throws Exception {
        this.ejbInfo = this.readXmlInternal(source);
    }

    public EjbDataSource(String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal) {
        this.ejbInfo = new EJBInfo(jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.ejbInfo, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.ejbInfo, startIndex, count);
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("EJB");
        String jndiName = this.ejbInfo.getJNDIName();
        EJBNode ejbNode = new EJBNode(jndiName);
        ejbNode.setJNDIName(jndiName);
        ejbNode.setHomeName(this.ejbInfo.getHomeName());
        ejbNode.setRemoteName(this.ejbInfo.getRemoteName());
        ejbNode.setSelectedMethod(this.ejbInfo.getSelectedMethodName());
        ejbNode.setParamTable(null);
        ejbNode.setEnvironment(this.ejbInfo.getEnvironment());
        dsInfo.setEjbNode(ejbNode);
        return dsInfo;
    }

    @Override
    public void writeXML(Element el) throws Exception {
        el.setAttribute("Type", "ejb");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.writeXmlInternal(new DataOutputStream(os));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.appendChildrenFromOuputStream(el, os);
    }

    private void writeXmlInternal(DataOutput out) throws IOException {
        int k;
        Object[] vals = this.ejbInfo.getSelectedMethodParamVal();
        int valSize = vals.length;
        Hashtable<String, String> env = this.ejbInfo.getEnvironment();
        int envsize = 0;
        Object[] envKeys = new Object[envsize];
        String[] envValues = new String[envsize];
        if (env != null) {
            envsize = env.size();
            Enumeration<String> e = env.keys();
            int index = 0;
            while (e.hasMoreElements()) {
                envKeys[index] = e.nextElement();
                ++index;
            }
            for (k = 0; k < envsize; ++k) {
                envValues[k] = env.get(envKeys[k]);
            }
        }
        String[] attrs = new String[6 + valSize * 2 + envsize * 2 + 1];
        String[] paramValues = new String[6 + valSize * 2 + envsize * 2 + 1];
        attrs[0] = "Type";
        attrs[1] = "jndiName";
        attrs[2] = "homeName";
        attrs[3] = "remoteName";
        attrs[4] = "selectedMethodName";
        attrs[5] = "paramSize";
        for (k = 6; k < 6 + valSize; ++k) {
            attrs[k] = "paramValType_" + (k - 5);
        }
        for (k = 6 + valSize; k < 6 + valSize * 2; ++k) {
            attrs[k] = "paramValValue_" + (k - 5 - valSize);
        }
        for (k = 6 + valSize * 2; k < 6 + valSize * 2 + envsize; ++k) {
            attrs[k] = "envKey_" + (k - 5 - valSize * 2);
        }
        for (k = 6 + valSize * 2 + envsize; k < 6 + valSize * 2 + envsize * 2; ++k) {
            attrs[k] = "envValue_" + (k - 5 - valSize * 2 - envsize);
        }
        attrs[6 + valSize * 2 + envsize * 2] = "envsize";
        paramValues[0] = "ejb";
        paramValues[1] = this.ejbInfo.getJNDIName();
        paramValues[2] = this.ejbInfo.getHomeName();
        paramValues[3] = this.ejbInfo.getRemoteName();
        paramValues[4] = this.ejbInfo.getSelectedMethodName();
        paramValues[5] = Integer.valueOf(valSize).toString();
        for (k = 6; k < 6 + valSize; ++k) {
            paramValues[k] = vals[k - 6].getClass().getName();
        }
        for (k = 6 + valSize; k < 6 + valSize * 2; ++k) {
            paramValues[k] = vals[k - 6 - valSize].toString();
        }
        for (k = 6 + valSize * 2; k < 6 + valSize * 2 + envsize; ++k) {
            paramValues[k] = (String)envKeys[k - 6 - valSize * 2];
        }
        for (k = 6 + valSize * 2 + envsize; k < 6 + valSize * 2 + envsize * 2; ++k) {
            paramValues[k] = envValues[k - 6 - valSize * 2 - envsize];
        }
        paramValues[6 + valSize * 2 + envsize * 2] = Integer.valueOf(envsize).toString();
        EjbDataSource.openElementTag(out, "DATASOURCE", attrs, paramValues);
        EjbDataSource.closeElementTag(out, "DATASOURCE");
    }

    private EJBInfo readXmlInternal(Element source) throws Exception {
        Node node;
        int j;
        int i;
        Hashtable<String, String> environment = new Hashtable<String, String>();
        String jndiName = source.getAttribute("jndiName");
        if (jndiName == null) {
            throw new Exception("Missing jndiName attribute");
        }
        String homeName = source.getAttribute("homeName");
        if (homeName == null) {
            throw new Exception("Missing homeName attribute");
        }
        String remoteName = source.getAttribute("remoteName");
        if (remoteName == null) {
            throw new Exception("Missing remoteName attribute");
        }
        String selectedMethodName = source.getAttribute("selectedMethodName");
        if (selectedMethodName == null) {
            throw new Exception("Missing selectedMethodName attribute");
        }
        String tmp = source.getAttribute("paramSize");
        if (tmp == null) {
            throw new Exception("Missing paramSize attribute");
        }
        int valSize = Integer.parseInt(tmp);
        Object[] vals = new Object[valSize];
        String[] paramTypes = new String[valSize];
        tmp = source.getAttribute("envsize");
        if (tmp == null) {
            throw new Exception("Missing envsize attribute");
        }
        int envsize = Integer.parseInt(tmp);
        String[] envKeys = new String[envsize];
        String[] envValues = new String[envsize];
        NamedNodeMap attrMap = source.getAttributes();
        for (i = 0; i < attrMap.getLength(); ++i) {
            for (j = 1; j <= valSize; ++j) {
                node = attrMap.item(i);
                if (node.getNodeName().equalsIgnoreCase("paramValType_" + j)) {
                    paramTypes[j - 1] = node.getNodeValue();
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("paramValValue_" + j)) continue;
                vals[j - 1] = EJBUtil.getRuntimeInputValue(paramTypes[j - 1], node.getNodeValue());
            }
        }
        Object[] selectedMethodParamVal = vals;
        for (i = 0; i < attrMap.getLength(); ++i) {
            for (j = 1; j <= envsize; ++j) {
                node = attrMap.item(i);
                if (node.getNodeName().equalsIgnoreCase("envKey_" + j)) {
                    envKeys[j - 1] = node.getNodeValue();
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("envValue_" + j)) continue;
                envValues[j - 1] = node.getNodeValue();
            }
        }
        for (i = 0; i < envsize; ++i) {
            environment.put(envKeys[i], envValues[i]);
        }
        return new EJBInfo(jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, environment);
    }

    private static void openElementTag(DataOutput out, String tag, String[] names, String[] values) throws IOException {
        if (tag == null) {
            return;
        }
        String str = "<" + tag.trim();
        if (names != null && values != null && names.length == values.length) {
            for (int i = 0; i < names.length; ++i) {
                str = str + " " + names[i] + "=\"" + XMLReport.encodeXML(values[i]) + "\" ";
            }
        }
        str = str + ">";
        out.writeBytes(str);
    }

    private static void closeElementTag(DataOutput out, String name) throws IOException {
        if (name != null) {
            out.writeBytes("</" + name.trim() + ">\n");
        }
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            jObj.put("jndiName", (Object)this.ejbInfo.getJNDIName());
            jObj.put("homeName", (Object)this.ejbInfo.getHomeName());
            jObj.put("remoteName", (Object)this.ejbInfo.getRemoteName());
            jObj.put("selectedMethodName", (Object)this.ejbInfo.getSelectedMethodName());
            Object[] params = this.ejbInfo.getSelectedMethodParamVal();
            JSONArray paramsJSON = new JSONArray();
            if (params != null) {
                for (Object param : params) {
                    paramsJSON.put((Object)this.getEjbParamJSON(param));
                }
            }
            jObj.put("selectedMethodParamVal", (Object)paramsJSON);
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "ejb";
    }

    private JSONObject getEjbParamJSON(Object param) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)param.getClass().getName());
        json.put("value", (Object)param.toString());
        return json;
    }

    public static EjbDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String jndiName = jObj.optString("jnidName", "");
        String homeName = jObj.optString("homeName", "");
        String remoteName = jObj.optString("remoteName", "");
        String selectedMethodName = jObj.optString("selectedMethodName", "");
        Object[] obj = null;
        if (jObj.has("selectedMethodParamVal")) {
            JSONArray ja = jObj.getJSONArray("selectedMethodParamVal");
            obj = new Object[ja.length()];
            for (int i = 0; i < ja.length(); ++i) {
                JSONArray param = ja.getJSONArray(i);
                String className = param.getString(0);
                String val = param.getString(1);
                obj[i] = EJBUtil.getRuntimeInputValue(className, val);
            }
        }
        EjbDataSource ejbds = new EjbDataSource(jndiName, homeName, remoteName, selectedMethodName, obj);
        return ejbds;
    }

    public EJBInfo getEjbInfo() {
        return this.ejbInfo;
    }
}

