/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class ExcelDataSource
extends DataSource {
    private ExcelFileInfo excelInfo;

    public ExcelDataSource(Element source) throws Exception {
        this.excelInfo = ExcelFileInfo.readXML(source);
    }

    public ExcelDataSource(ExcelFileInfo excelInfo) {
        this.excelInfo = excelInfo;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.excelInfo, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.excelInfo, startIndex, count);
    }

    @Override
    public void writeXML(Element el) throws Exception {
        el.setAttribute("Type", "excel");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        this.excelInfo.writeXML(writer);
        writer.flush();
        this.appendChildrenFromOuputStream(el, out);
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("ExcelFile");
        dsInfo.setExcelFileInfo(this.excelInfo);
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            jObj.put("filename", (Object)QbUtil.urlEncode(Coder.encode(this.excelInfo.getFilename())));
            jObj.put("sheetName", (Object)QbUtil.urlEncode(this.excelInfo.getSheetName()));
            jObj.put("minRow", this.excelInfo.getMinRow());
            jObj.put("minColumn", this.excelInfo.getMinColumn());
            jObj.put("maxRow", this.excelInfo.getMaxRow());
            jObj.put("maxColumn", this.excelInfo.getMaxColumn());
            jObj.put("includeNewData", this.excelInfo.isIncludeNewData());
            jObj.put("hasHeader", this.excelInfo.hasHeader());
            jObj.put("dataAreRows", this.excelInfo.dataAreRows());
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "excel";
    }

    public static ExcelDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        ExcelFileInfo efi = new ExcelFileInfo(QbUtil.urlDecode(Coder.decode(jObj.getString("filename"))));
        efi.setSheetName(QbUtil.urlEncode(jObj.getString("sheetName")));
        efi.setMinRow(jObj.getInt("minRow"));
        efi.setMaxRow(jObj.getInt("maxRow"));
        efi.setMinColumn(jObj.getInt("minColumn"));
        efi.setMaxColumn(jObj.getInt("maxColumn"));
        efi.setIncludeNewData(jObj.getBoolean("includeNewData"));
        efi.setHasHeader(jObj.getBoolean("hasHeader"));
        efi.setDataAreRows(jObj.getBoolean("dataAreRows"));
        return new ExcelDataSource(efi);
    }
}

