/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import quadbase.common.util.IJNDIDatabaseInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.datasource.InvalidDataSourcesNodeException;
import quadbase.reportdesigner.ReportAPI.QbReport;

public class JNDINodeInfo {
    private String JNDIName;
    private String contextFactory;
    private String providerURL;
    private boolean autoJoin = true;
    private int tableNameFormat = 0;
    private String name;
    private Hashtable env;
    public static final String NODE_ATTRIBUTE_PROVIDER_URL = "Provider_URL";
    public static final String NODE_ATTRIBUTE_JNDINAME = "JNDIName";
    public static final String NODE_ATTRIBUTE_CONTEXT_FACTORY = "Context_Factory";
    public static final String NODE_ATTRIBUTE_AUTO_JOIN = "autoJoin";
    public static final String NODE_ATTRIBUTE_TABLE_NAME_FORMAT = "tableNameFormat";

    public JNDINodeInfo(Node databaseNode) throws InvalidDataSourcesNodeException {
        if (!databaseNode.getNodeName().equals("JNDIDataSource")) {
            throw new InvalidDataSourcesNodeException("expected a database node, non database node found");
        }
        this.setAttributes(databaseNode);
    }

    public JNDINodeInfo(QbReport report) throws Exception {
        if (!(report.getInputData().getDatabaseInfo() instanceof IJNDIDatabaseInfo)) {
            throw new Exception("Data Source Error: expect JNDI data source");
        }
        this.setAttributes(report);
    }

    public JNDINodeInfo(String jndiName, Hashtable env) {
        this.name = "";
        this.contextFactory = "";
        this.providerURL = "";
        this.autoJoin = true;
        this.tableNameFormat = 0;
        this.JNDIName = jndiName;
        if (env != null && env.size() > 0) {
            this.providerURL = (String)env.get("java.naming.provider.url");
            this.contextFactory = (String)env.get("java.naming.factory.initial");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public String getProviderURL() {
        return this.providerURL;
    }

    public boolean isAutoJoin() {
        return this.autoJoin;
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }

    public Hashtable getEnv() {
        return this.env;
    }

    private void setEnvFromDataSource() {
        this.env = new Hashtable();
        if (this.providerURL != null && !this.providerURL.equals("")) {
            this.env.put("java.naming.provider.url", this.providerURL);
        }
        if (this.contextFactory != null && !this.contextFactory.equals("")) {
            this.env.put("java.naming.factory.initial", this.contextFactory);
        }
        if (this.env.size() <= 0) {
            this.env = null;
        }
    }

    private void setAttributes(Node databaseNode) throws InvalidDataSourcesNodeException {
        if (databaseNode.hasAttributes()) {
            NamedNodeMap nodeMap = databaseNode.getAttributes();
            Node nameNode = nodeMap.getNamedItem("name");
            Node jndiNameNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_JNDINAME);
            Node contextFactoryNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_CONTEXT_FACTORY);
            Node providerURLNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_PROVIDER_URL);
            Node autoJoinNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_AUTO_JOIN);
            this.name = nameNode == null ? "" : nameNode.getNodeValue();
            this.JNDIName = jndiNameNode == null ? "" : jndiNameNode.getNodeValue();
            this.contextFactory = contextFactoryNode == null ? "" : contextFactoryNode.getNodeValue();
            this.providerURL = providerURLNode == null ? "" : providerURLNode.getNodeValue();
            this.autoJoin = autoJoinNode == null ? true : Boolean.valueOf(autoJoinNode.getNodeValue());
            try {
                Node tableNameFormatNode = nodeMap.getNamedItem(NODE_ATTRIBUTE_TABLE_NAME_FORMAT);
                if (tableNameFormatNode == null) {
                    this.tableNameFormat = 0;
                }
                this.tableNameFormat = Integer.parseInt(tableNameFormatNode.getNodeValue());
            }
            catch (NumberFormatException e) {
                throw new InvalidDataSourcesNodeException("XML node (" + databaseNode.getNodeName() + ") contains incorrect attributes");
            }
        } else {
            throw new InvalidDataSourcesNodeException("XML node (" + databaseNode.getNodeName() + ") contains incorrect attributes");
        }
        this.setEnvFromDataSource();
    }

    public void setAttributes(QbReport report) {
        this.name = "";
        this.contextFactory = "";
        this.providerURL = "";
        this.autoJoin = true;
        this.tableNameFormat = 0;
        DBInfoBasic dbinfo = report.getReportObj().dbInfo;
        this.JNDIName = dbinfo.getJNDIName();
        this.env = dbinfo.getEnvProperties();
        if (this.env != null && this.env.size() > 0) {
            this.providerURL = (String)this.env.get("java.naming.provider.url");
            this.contextFactory = (String)this.env.get("java.naming.factory.initial");
        }
    }
}

