/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.XMLFieldInfo;

public class JSONXMLFieldInfo
extends XMLFieldInfo {
    public JSONXMLFieldInfo() {
    }

    public JSONXMLFieldInfo(String[] path) {
        super(path);
    }

    public JSONXMLFieldInfo(String[] path, String attrName) {
        super(path, attrName);
    }

    public JSONXMLFieldInfo(XMLFieldInfo fieldInfo) {
        this.setPath(fieldInfo.getPath());
        this.setAlias(fieldInfo.getAlias());
        this.setAttributeDataType(fieldInfo.getAttributeDataType());
        this.setAttributeName(fieldInfo.getAttributeName());
        this.setDateFormat(fieldInfo.getDateFormat());
        this.setElementDataType(fieldInfo.getElementDataType());
        this.setXMLType(fieldInfo.getXMLType());
        this.setRecursive(fieldInfo.isRecursive());
        this.setIsExpandable(fieldInfo.isExpandable());
        this.setIsRequired(fieldInfo.isRequired());
    }

    public static XMLFieldInfo readFromJSONObject(JSONObject jObj) throws JSONException {
        JSONArray jpArray = jObj.getJSONArray("path");
        String[] path = new String[jpArray.length()];
        for (int i = 0; i < jpArray.length(); ++i) {
            path[i] = jpArray.getString(i);
        }
        String alias = jObj.optString("alias");
        String attributeDataType = jObj.optString("attributeDataType");
        String attributeName = jObj.optString("attributeName");
        if (attributeName.trim().equals("")) {
            attributeName = null;
        }
        String dateFormat = jObj.optString("dateFormat");
        String elementDataType = jObj.optString("elementDataType");
        int xmlType = jObj.optInt("xmlType");
        boolean recursive = jObj.optBoolean("isRecursive");
        boolean expandable = jObj.optBoolean("isExpandable");
        boolean required = jObj.optBoolean("isRequired");
        JSONXMLFieldInfo fieldInfo = new JSONXMLFieldInfo(path, attributeName);
        fieldInfo.setAlias(alias);
        fieldInfo.setAttributeDataType(attributeDataType);
        fieldInfo.setDateFormat(dateFormat);
        fieldInfo.setElementDataType(elementDataType);
        fieldInfo.setXMLType(xmlType);
        fieldInfo.setRecursive(recursive);
        fieldInfo.setIsExpandable(expandable);
        fieldInfo.setIsRequired(required);
        return fieldInfo;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jObj = new JSONObject();
        jObj.put("path", (Object)this.getPath());
        jObj.put("alias", (Object)this.getAlias());
        jObj.put("attributeDataType", (Object)this.getAttributeDataType());
        jObj.put("attributeName", (Object)this.getAttributeName());
        jObj.put("columnName", (Object)this.getColumnName());
        jObj.put("dataType", (Object)this.getDataType());
        jObj.put("dateFormat", (Object)this.getDateFormat());
        jObj.put("displayName", (Object)this.getDisplayName());
        jObj.put("elementDataType", (Object)this.getElementDataType());
        jObj.put("xmlType", this.getXMLType());
        jObj.put("isRecursive", this.isRecursive());
        jObj.put("isExpandable", this.isExpandable());
        jObj.put("isRequired", this.isRequired());
        return jObj;
    }

    @Override
    public String toString() {
        try {
            return this.toJSONObject().toString();
        }
        catch (JSONException e) {
            return super.toString();
        }
    }
}

