/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import org.json.JSONObject;
import org.w3c.dom.Element;
import quadbase.common.util.SecuredParameterException;
import quadbase.datasource.DataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;
import quadbase.reportdesigner.report.ColData;

public class MemoryDataSource
extends DataSource {
    private final ColData[] colData;

    public MemoryDataSource(ColData[] colData) {
        this.colData = colData;
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("memory");
        dsInfo.setMemoryColData(this.colData);
        return dsInfo;
    }

    @Override
    public void writeXML(Element el) throws Exception {
        throw new UnsupportedOperationException("Cannot write memory datasource to XML");
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception, SecuredParameterException {
        return new DataSheet(null, this.colData);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception, SecuredParameterException {
        return new DataSheet(null, this.colData);
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        throw new UnsupportedOperationException("Cannot write memory datasource to JSON");
    }

    @Override
    public String getType() {
        return "memory";
    }
}

