/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.formula.Formula;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParamUtil;
import quadbase.common.param.ParameterPage;
import quadbase.common.param.ParameterSet;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSource;
import quadbase.datasource.parameters.DataSourceParameterPage;
import quadbase.datasource.util.CustomDateMultiValueParam;
import quadbase.datasource.util.CustomDateParam;
import quadbase.datasource.util.QueryInParam;
import quadbase.datasource.util.QueryMultiValueInParam;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.util.internal.ReportUtil;

public abstract class ParameterizedDataSource
extends DataSource {
    private boolean[] selectAllInfo;
    private boolean[] needUpdate;
    public static final String ALL_OPTION_ENABLED = "allOptionEnabled";
    public static final String ALL_OPTION_LABEL = "allOptionLabel";
    private static final String JDBC_DATE_FORMAT = "yyyy-MM-dd";
    private static final String JDBC_TIME_FORMAT = "hh:mm:ss";
    private static final String JDBC_TIMESTAMP_FORMAT = "yyyy-MM-dd hh:mm:ss.SSSSSSSSS";

    public abstract void setParameters(HashMap var1) throws Exception;

    public abstract void setDefaultParameters();

    public abstract IQueryInParam[] getInParam();

    public abstract Vector<Object> getDistinctValues(String var1, String var2);

    @Override
    public boolean isParameterized() {
        return true;
    }

    public void setParameters(Object[] values, boolean[] selectAllInfo, boolean[] needUpdate) throws Exception {
        this.selectAllInfo = selectAllInfo;
        this.needUpdate = needUpdate;
        this.setParameters(values);
    }

    public void setParameters(Object[] values, boolean[] selectAllInfo) throws Exception {
        this.selectAllInfo = selectAllInfo;
        this.setParameters(values);
    }

    public void setParameters(Object[] values) throws Exception {
        OrderedParameterSet allParams;
        if (values == null) {
            return;
        }
        if (this.needUpdate == null && this.selectAllInfo != null) {
            int len = this.selectAllInfo.length;
            this.needUpdate = new boolean[len];
            for (int cnt = 0; cnt < len; ++cnt) {
                this.needUpdate[cnt] = true;
            }
        }
        if ((allParams = this.getParametersInSequence()).size() != values.length) {
            throw new IllegalArgumentException("Wrong number of parameters");
        }
        for (int i = 0; i < allParams.size() && i < values.length; ++i) {
            quadbase.common.paramquery.QueryInParam qip;
            String[] temp;
            Param param = allParams.get(i);
            String dateFormat = param.getDateFormat();
            if (!param.isFormulaParam() && param.multiValue()) {
                temp = (String[])values[i];
                if (!param.isMapToColumn() && temp.length <= 1) {
                    values[i] = QbUtil.parseMultiValues(((String[])values[i])[0]);
                }
                param.setValues(ReportUtil.getMultiValueObject(param.getSqlType(), (String[])values[i], dateFormat));
                if (this.selectAllInfo == null || !this.needUpdate[i]) continue;
                if (this.selectAllInfo[i]) {
                    param.setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                    continue;
                }
                param.setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                continue;
            }
            temp = (String[])values[i];
            if (temp.length == 3) {
                if (temp[2] == null || temp[2].equals("")) {
                    temp[2] = "2003";
                }
                String date = temp[0] + "/" + temp[1] + "/" + temp[2];
                param.setValue(ReportUtil.getValueObject(param.getSqlType(), date, "MM/dd/yyyy"));
                continue;
            }
            boolean isAll = false;
            if (param instanceof QueryParam && (qip = ((QueryParam)param).findParam()).isAllOptionEnabled() && qip.getAllOptionLabel() != null && qip.getAllOptionLabel().equals(temp[0])) {
                isAll = true;
                param.setValue(qip.getAllOptionLabel());
            }
            if (isAll) continue;
            param.setValue(ReportUtil.getValueObject(param.getSqlType(), temp[0], dateFormat));
        }
        this.setParameters(allParams);
    }

    public void setParameters(Parameters parameters) throws Exception {
        HashMap<String, Object> paramHash = new HashMap<String, Object>();
        for (int i = 0; i < parameters.size(); ++i) {
            Param param = parameters.get(i);
            if (param.multiValue()) {
                Object[] values = param.getValues().toArray();
                paramHash.put(param.name(), values);
                continue;
            }
            paramHash.put(param.name(), param.getValue());
        }
        this.setParameters(paramHash);
    }

    public ParameterPage getParameterPage() {
        return this.getParameterPage(null);
    }

    public ParameterPage getParameterPage(String servletName) {
        return new DataSourceParameterPage(this.getParametersInSequence(), this.getQueryFileInfo(), servletName, null);
    }

    public OrderedParameterSet getParametersInSequence() {
        IQueryInParam[] inSet;
        if (!this.isParameterized()) {
            return null;
        }
        ParameterSet paramSet = new ParameterSet();
        IQueryFileInfo qi = this.getQueryFileInfo();
        for (IQueryInParam element : inSet = this.getInParam()) {
            Parameter parameter = new Parameter(element);
            QueryParam param = new QueryParam(this.toString(), parameter);
            if (element instanceof QueryInParam) {
                param.setSqlSelect(((QueryInParam)element).getSqlSelect());
            }
            param.setQueryFileInfo(qi);
            paramSet.add(param);
        }
        Vector<ParameterSet> v = new Vector<ParameterSet>(1);
        v.add(paramSet);
        return new OrderedParameterSet(v);
    }

    public OrderedParameterSet getParametersInSequence(quadbase.common.paramquery.QueryInParam[][] queryParams) {
        if (!this.isParameterized()) {
            return null;
        }
        Vector<ParameterSet> v = new Vector<ParameterSet>(queryParams.length);
        IQueryFileInfo qi = this.getQueryFileInfo();
        for (quadbase.common.paramquery.QueryInParam[] queryParam : queryParams) {
            if (queryParam == null) continue;
            ParameterSet paramSet = new ParameterSet();
            for (quadbase.common.paramquery.QueryInParam element : queryParam) {
                if (element == null) continue;
                Parameter parameter = new Parameter(element);
                QueryParam param = new QueryParam(this.toString(), parameter);
                param.setSqlSelect(element.getSqlSelect());
                param.setQueryFileInfo(qi);
                paramSet.add(param);
            }
            v.add(paramSet);
        }
        return new OrderedParameterSet(v);
    }

    public int getMaxParameterOrder() {
        return 0;
    }

    public abstract IQueryFileInfo getQueryFileInfo();

    protected void setParametersInternal(IQueryInParam[] queryInParams, HashMap params) throws Exception {
        if (params == null) {
            return;
        }
        for (Map.Entry entry : params.entrySet()) {
            String name = (String)entry.getKey();
            IQueryInParam param = this.findParameterByName(queryInParams, name);
            if (param == null) {
                throw new Exception("Parameter " + name + " not found in the data source");
            }
            if (entry.getValue() instanceof Object[]) {
                if (!(param instanceof IQueryMultiValueInParam)) {
                    throw new Exception("Cannot set multiple values to single value parameter " + name);
                }
                Object[] values = (Object[])entry.getValue();
                Vector<Object> v = new Vector<Object>(values.length);
                for (Object value : values) {
                    v.add(value);
                }
                ((IQueryMultiValueInParam)param).setValues(v);
                continue;
            }
            if (param instanceof IQueryMultiValueInParam) {
                Vector<Object> v = new Vector<Object>();
                v.add(entry.getValue());
                ((IQueryMultiValueInParam)param).setValues(v);
                continue;
            }
            param.setValue(entry.getValue());
        }
    }

    private IQueryInParam findParameterByName(IQueryInParam[] queryInParams, String name) {
        for (IQueryInParam queryInParam : queryInParams) {
            if (!queryInParam.getParamName().equals(name)) continue;
            return queryInParam;
        }
        return null;
    }

    protected void setDefaultParameters(IQueryInParam[] params) {
        IQueryFileInfo iQueryFileInfo = this.getQueryFileInfo();
        quadbase.common.paramquery.QueryInParam[] parameters = null;
        if (iQueryFileInfo instanceof QueryFileInfo) {
            parameters = ParamUtil.getQueryParamSet((QueryFileInfo)iQueryFileInfo).getParameter();
        }
        for (int i = 0; i < params.length; ++i) {
            Vector<Object> v;
            IQueryInParam param = params[i];
            Object defaultValue = parameters != null && parameters.length > i && parameters[i].getParamName().equals(param.getParamName()) ? parameters[i].getDefaultValue((QueryFileInfo)iQueryFileInfo) : param.getDefaultValue();
            if (defaultValue == null || defaultValue.equals("")) {
                defaultValue = this.getDummyValue(param.getSqlType());
            }
            if (param instanceof quadbase.common.paramquery.QueryMultiValueInParam) {
                v = new Vector<Object>();
                v.add(defaultValue);
                ((quadbase.common.paramquery.QueryMultiValueInParam)param).setValues(v);
                continue;
            }
            if (param instanceof IQueryMultiValueInParam) {
                if (defaultValue instanceof Vector) {
                    ((IQueryMultiValueInParam)param).setValues((Vector)defaultValue);
                    continue;
                }
                v = new Vector();
                v.add(defaultValue);
                ((IQueryMultiValueInParam)param).setValues(v);
                continue;
            }
            param.setValue(defaultValue);
        }
    }

    protected static JSONObject getParamSetJSON(QueryInParamSet paramSet) throws JSONException {
        quadbase.common.paramquery.QueryInParam[] params;
        JSONObject json = new JSONObject();
        if (paramSet == null || paramSet.getParameter().length == 0) {
            return json;
        }
        JSONArray paramArray = new JSONArray();
        for (quadbase.common.paramquery.QueryInParam param : params = paramSet.getParameter()) {
            paramArray.put((Object)ParameterizedDataSource.getParamJSON(param));
        }
        json.put("parameters", (Object)paramArray);
        JSONArray sequenceArray = new JSONArray();
        quadbase.common.paramquery.QueryInParam[][] paramSeq = paramSet.getParameterInPromptSequence();
        if (paramSeq != null) {
            for (quadbase.common.paramquery.QueryInParam[] element : paramSeq) {
                JSONArray paramSeqLevelX = new JSONArray();
                for (quadbase.common.paramquery.QueryInParam element2 : element) {
                    if (element2 == null) {
                        paramSeqLevelX.put((Object)element2);
                        continue;
                    }
                    paramSeqLevelX.put((Object)ParameterizedDataSource.getParamJSON(element2));
                }
                sequenceArray.put((Object)paramSeqLevelX);
            }
        }
        json.put("parameterInPromptSequence", (Object)sequenceArray);
        return json;
    }

    protected static synchronized QueryInParamSet getParamSetFromJSON(JSONObject jObj) {
        try {
            quadbase.common.paramquery.QueryInParam[] params = null;
            if (jObj.has("parameters")) {
                JSONArray pArray = jObj.getJSONArray("parameters");
                params = new quadbase.common.paramquery.QueryInParam[pArray.length()];
                for (int i = 0; i < pArray.length(); ++i) {
                    params[i] = ParameterizedDataSource.getParamFromJSONObject(pArray.getJSONObject(i));
                }
            } else {
                return null;
            }
            quadbase.common.paramquery.QueryInParam[][] paramSeq = null;
            if (jObj.has("parameterInPromptSequence")) {
                JSONArray psArray = jObj.getJSONArray("parameterInPromptSequence");
                paramSeq = new quadbase.common.paramquery.QueryInParam[psArray.length()][];
                block3: for (int i = 0; i < psArray.length(); ++i) {
                    JSONArray paramNameArray = psArray.getJSONArray(i);
                    paramSeq[i] = new quadbase.common.paramquery.QueryInParam[paramNameArray.length()];
                    block4: for (int j = 0; j < paramNameArray.length(); ++j) {
                        if (paramNameArray.isNull(j)) {
                            paramSeq[i][j] = null;
                            continue block3;
                        }
                        JSONObject jsonObj = paramNameArray.getJSONObject(j);
                        String paramName = null;
                        if (jsonObj != null) {
                            paramName = jsonObj.getString("paramName");
                        }
                        if (paramName == null || paramName.equalsIgnoreCase("null")) continue;
                        for (quadbase.common.paramquery.QueryInParam param : params) {
                            if (!paramName.equals(param.getParamName())) continue;
                            paramSeq[i][j] = param;
                            continue block4;
                        }
                    }
                }
            }
            QueryInParamSet paramSet = new QueryInParamSet(params, paramSeq);
            return paramSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static JSONObject getParamJSON(quadbase.common.paramquery.QueryInParam param) throws JSONException {
        JSONObject json = new JSONObject();
        boolean isMultiValue = param instanceof quadbase.common.paramquery.QueryMultiValueInParam;
        json.put("isMultiValue", isMultiValue);
        json.put("isMapToColumn", param.isMapToColumn());
        json.put("isMapToColumnOnly", param.isMapToColumnOnly());
        json.put("isMapToFunctionOnly", param.isMapToFunctionOnly());
        json.put("isMapToSqlSelect", param.isMapToSqlSelect());
        json.put("paramName", (Object)param.getParamName());
        json.put("promptName", (Object)param.getPromptName());
        json.put("columnName", (Object)param.getColumnName());
        json.put("completeName", (Object)param.getCompleteName());
        json.put("dateFormat", (Object)param.getDateFormat());
        json.put("sqlStr", (Object)param.getSqlSelect());
        json.put("sqlType", (Object)(param.getSqlType() + ""));
        json.put("tableName", (Object)param.getTableName());
        json.put("defaultValue", ParameterizedDataSource.getParamValueJSON(param.getDefaultValue(), isMultiValue));
        json.put("defaultSql", (Object)(param.getDefaultSql() == null ? "" : param.getDefaultSql()));
        json.put(ALL_OPTION_ENABLED, param.isAllOptionEnabled());
        json.put(ALL_OPTION_LABEL, (Object)param.getAllOptionLabel());
        String defValVarStr = "null";
        Formula defValVar = param.getDefaultValueVariable();
        if (defValVar != null) {
            defValVarStr = defValVar.toString();
        }
        if (defValVarStr == null) {
            json.put("defaultValueVariable", (Object)"null");
        } else {
            json.put("defaultValueVariable", (Object)defValVarStr);
        }
        json.put("paramIndexMap", (Object)new JSONArray((Object)param.getParamIndexMap()));
        Vector selChoices = param.getSelectionChoices();
        if (selChoices != null && selChoices.size() > 0) {
            json.put("selectionChoices", (Object)new JSONArray((Collection)selChoices));
        }
        json.put("value", ParameterizedDataSource.getParamValueJSON(param.getValue(), isMultiValue));
        String valVarStr = "null";
        Formula valVar = param.getValueVariable();
        if (valVar != null) {
            valVarStr = valVar.toString();
        }
        json.put("valueVariable", (Object)valVarStr);
        return json;
    }

    private static Object getParamValueJSON(Object paramValue, boolean isMultiValue) {
        if (paramValue == null) {
            return "";
        }
        if (paramValue instanceof Vector) {
            Vector v = (Vector)paramValue;
            return new JSONArray((Collection)v);
        }
        if (isMultiValue) {
            return new JSONArray().put((Object)paramValue.toString());
        }
        return paramValue.toString();
    }

    public static Object toObject(int sqlType, String customDateFormat, String value) throws NumberFormatException, ParseException {
        if (value == null) {
            return null;
        }
        value = value.trim();
        String pattern = JDBC_DATE_FORMAT;
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        switch (sqlType) {
            case 16: {
                return Boolean.valueOf(value);
            }
            case -7: {
                return value.trim().equals("1") || value.trim().equalsIgnoreCase("true");
            }
            case 91: {
                if (value.equals("null")) {
                    return null;
                }
                pattern = customDateFormat != null ? customDateFormat : JDBC_DATE_FORMAT;
                df.applyPattern(pattern);
                java.util.Date date = df.parse(value);
                return new Date(date.getTime());
            }
            case 92: {
                if (value.equals("null")) {
                    return null;
                }
                pattern = customDateFormat != null ? customDateFormat : JDBC_TIME_FORMAT;
                df.applyPattern(pattern);
                java.util.Date date = df.parse(value);
                return new Time(date.getTime());
            }
            case 93: {
                if (value.equals("null")) {
                    return null;
                }
                pattern = customDateFormat != null ? customDateFormat : JDBC_TIMESTAMP_FORMAT;
                df.applyPattern(pattern);
                java.util.Date date = df.parse(value);
                return new Timestamp(date.getTime());
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return Double.valueOf(value);
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Integer.valueOf(value);
            }
        }
        return value;
    }

    protected static synchronized quadbase.common.paramquery.QueryInParam getParamFromJSONObject(JSONObject jObj) {
        try {
            String valVariableStr;
            boolean isMultiValue = jObj.optBoolean("isMultiValue");
            boolean mapToColumn = jObj.optBoolean("isMapToColumn");
            boolean mapToFunction = jObj.optBoolean("isMapToFunctionOnly");
            JSONArray ja = jObj.optJSONArray("paramIndexMap");
            int[] paramIndexMap = new int[ja.length()];
            for (int i = 0; i < ja.length(); ++i) {
                paramIndexMap[i] = ja.getInt(i);
            }
            String paramName = jObj.optString("paramName");
            String promptName = jObj.optString("promptName");
            String tableName = jObj.optString("tableName");
            String columnName = jObj.optString("columnName");
            String sqlTypeStr = jObj.optString("sqlType");
            int sqlType = Integer.parseInt(sqlTypeStr);
            String defaultSql = jObj.optString("defaultSql");
            Object defaultValue = null;
            Object valueObj = null;
            quadbase.common.paramquery.QueryInParam param = null;
            if (isMultiValue) {
                Vector<String> dvVect = new Vector<String>();
                JSONArray dv = jObj.optJSONArray("defaultValue");
                if (dv != null) {
                    for (int i = 0; i < dv.length(); ++i) {
                        dvVect.add(dv.getString(i));
                    }
                }
                defaultValue = dvVect;
                Vector<String> valueVect = new Vector<String>();
                JSONArray valArray = jObj.optJSONArray("value");
                for (int i = 0; valArray != null && i < valArray.length(); ++i) {
                    valueVect.add(valArray.getString(i));
                }
                valueObj = valueVect.elementAt(0);
                param = new quadbase.common.paramquery.QueryMultiValueInParam(paramIndexMap, paramName, promptName, mapToColumn, mapToFunction, tableName, columnName, sqlType, defaultValue, defaultSql, false, null, valueObj, valueVect);
            } else {
                String dvStr = jObj.optString("defaultValue");
                defaultValue = dvStr.equals("null") ? null : dvStr;
                String valStr = jObj.optString("value");
                valueObj = valStr.equals("null") ? null : valStr;
                if (defaultValue != null) {
                    defaultValue = ParameterizedDataSource.toObject(sqlType, null, defaultValue.toString());
                }
                if (valueObj != null) {
                    valueObj = ParameterizedDataSource.toObject(sqlType, null, valueObj.toString());
                }
                param = new quadbase.common.paramquery.QueryInParam(paramIndexMap, paramName, promptName, mapToColumn, mapToFunction, tableName, columnName, sqlType, defaultValue, defaultSql, false, null, valueObj);
            }
            JSONArray scArray = jObj.optJSONArray("selectionChoices");
            Vector<String> selectionChoices = null;
            if (scArray != null) {
                selectionChoices = new Vector<String>();
                for (int i = 0; i < scArray.length(); ++i) {
                    selectionChoices.add(scArray.getString(i));
                }
            }
            param.setSelectionChoices(selectionChoices);
            String sqlStr = jObj.optString("sqlStr", null);
            if (sqlStr == null) {
                sqlStr = jObj.optString("sqlSelect", null);
            }
            param.setSqlSelect(sqlStr);
            param.setAllOptionEnabled(jObj.optBoolean(ALL_OPTION_ENABLED, false));
            param.setAllOptionLabel(jObj.optString(ALL_OPTION_LABEL, null));
            String dvVariableStr = jObj.optString("defaultValueVariable", "null");
            if (!dvVariableStr.equals("null")) {
                Formula dvVariable = new Formula(dvVariableStr, dvVariableStr);
                param.setDefaultValueVariable(dvVariable);
            }
            if (!(valVariableStr = jObj.optString("valueVariable", "null")).equals("null")) {
                Formula valVariable = new Formula(valVariableStr);
                param.setValueVariable(valVariable);
            }
            return param;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getDummyValue(int sqlType) {
        switch (sqlType) {
            case -7: 
            case 16: {
                return Boolean.FALSE;
            }
            case 91: {
                return new Date(System.currentTimeMillis());
            }
            case 92: {
                return new Time(System.currentTimeMillis());
            }
            case 93: {
                return new Timestamp(System.currentTimeMillis());
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 0.0;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        return "";
    }

    public static quadbase.reportdesigner.util.IQueryInParam[][] toReportDesignerParam2(IQueryInParam[][] params) {
        if (params == null) {
            return null;
        }
        quadbase.reportdesigner.util.IQueryInParam[][] result = new quadbase.reportdesigner.util.IQueryInParam[params.length][];
        for (int i = 0; i < params.length; ++i) {
            result[i] = ParameterizedDataSource.toReportDesignerParam(params[i]);
        }
        return result;
    }

    public static quadbase.reportdesigner.util.IQueryInParam[] toReportDesignerParam(IQueryInParam[] params) {
        if (params == null) {
            return null;
        }
        quadbase.reportdesigner.util.IQueryInParam[] result = new quadbase.reportdesigner.util.IQueryInParam[params.length];
        for (int i = 0; i < result.length; ++i) {
            if (params[i] == null) continue;
            if (params[i] instanceof IQueryMultiValueInParam) {
                result[i] = QueryMultiValueInParam.valueOf((IQueryMultiValueInParam)params[i]);
                if (!(params[i] instanceof ICustomParameterDateFormat)) continue;
                result[i] = CustomDateMultiValueParam.valueOf((QueryMultiValueInParam)result[i]);
                ((CustomDateMultiValueParam)result[i]).setDateFormat(((ICustomParameterDateFormat)((Object)params[i])).getDateFormat());
                continue;
            }
            result[i] = QueryInParam.valueOf(params[i]);
            if (!(params[i] instanceof ICustomParameterDateFormat)) continue;
            result[i] = CustomDateParam.valueOf((QueryInParam)result[i]);
            ((CustomDateParam)result[i]).setDateFormat(((ICustomParameterDateFormat)((Object)params[i])).getDateFormat());
        }
        return result;
    }
}

