/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import quadbase.common.paramquery.IDistinctValuesProvider;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class SalesForceDataSource
extends ParameterizedDataSource {
    private SalesForceQueryFileInfo sfQueryInfo;

    public SalesForceDataSource(Element source) throws Exception {
        this.sfQueryInfo = SalesForceQueryFileInfo.readSalesForceQueryInfoXML(source);
    }

    public SalesForceDataSource(SalesForceQueryFileInfo sfQueryInfo) {
        this.sfQueryInfo = sfQueryInfo;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.sfQueryInfo, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.sfQueryInfo, startIndex, count);
    }

    @Override
    public void setParameters(HashMap parameters) throws Exception {
        this.setParametersInternal(this.sfQueryInfo.getInParam(), parameters);
    }

    @Override
    public void setDefaultParameters() {
        if (!this.isParameterized()) {
            return;
        }
        IQueryInParam[] params = this.sfQueryInfo.getInParam();
        this.setDefaultParameters(params);
    }

    @Override
    public IQueryInParam[] getInParam() {
        return this.sfQueryInfo.getInParam();
    }

    @Override
    public void writeXML(Element el) throws Exception {
        el.setAttribute("Type", "salesforce");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        this.sfQueryInfo.writeXML(writer);
        writer.flush();
        this.appendChildrenFromOuputStream(el, out);
    }

    @Override
    public boolean isParameterized() {
        return this.sfQueryInfo.isParameterized();
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        return this.sfQueryInfo;
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("SalesForceQuery");
        dsInfo.setSalesForceQueryInfo(this.sfQueryInfo);
        if (this.isParameterized()) {
            dsInfo.setQueryParamSet(this.sfQueryInfo.getInSet());
        }
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            jObj.put("username", (Object)QbUtil.urlEncode(Coder.encode(this.sfQueryInfo.getUserID())));
            jObj.put("password", (Object)QbUtil.urlEncode(Coder.encode(this.sfQueryInfo.getPassword())));
            jObj.put("SOQLQuery", (Object)QbUtil.urlEncode(this.sfQueryInfo.getQuery()));
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
            if (this.isParameterized()) {
                QueryInParamSet paramSet = this.sfQueryInfo.getInSet();
                jObj.put("hasParam", paramSet != null);
                jObj.put("paramSet", (Object)SalesForceDataSource.getParamSetJSON(paramSet));
            } else {
                jObj.put("hasParam", false);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "salesforce";
    }

    public static SalesForceDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String username = QbUtil.urlDecode(Coder.decode(jObj.getString("username")));
        String password = QbUtil.urlDecode(Coder.decode(jObj.optString("password")));
        String SOQLQuery = QbUtil.urlDecode(jObj.optString("SOQLQuery"));
        boolean hasParam = jObj.getBoolean("hasParam");
        QueryInParamSet paramSet = null;
        if (hasParam) {
            JSONObject paramSetJObj = jObj.getJSONObject("paramSet");
            paramSet = SalesForceDataSource.getParamSetFromJSON(paramSetJObj);
        }
        SalesForceQueryFileInfo sfqfi = new SalesForceQueryFileInfo(username, password, SOQLQuery, paramSet);
        return new SalesForceDataSource(sfqfi);
    }

    @Override
    public Vector<Object> getDistinctValues(String tableName, String columnName) {
        IDistinctValuesProvider valuesProvider = (IDistinctValuesProvider)((Object)this.getQueryFileInfo());
        return valuesProvider.getDistinctValues(tableName, columnName);
    }
}

