/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SOAPParam;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.JSONXMLFieldInfo;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class SoapDataSource
extends ParameterizedDataSource {
    private SOAPQueryFileInfo soapInfo;

    public SoapDataSource(Element source) throws Exception {
        this.soapInfo = SOAPQueryFileInfo.readSOAPQueryFileInfoXML(source);
    }

    public SoapDataSource(SOAPQueryFileInfo soapInfo) {
        this.soapInfo = soapInfo;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.soapInfo, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.soapInfo, startIndex, count);
    }

    @Override
    public void setParameters(HashMap parameters) throws Exception {
        this.setParametersInternal(this.soapInfo.getInParam(), parameters);
    }

    @Override
    public void setDefaultParameters() {
        if (!this.isParameterized()) {
            return;
        }
        IQueryInParam[] params = this.soapInfo.getInParam();
        this.setDefaultParameters(params);
    }

    @Override
    public IQueryInParam[] getInParam() {
        return this.soapInfo.getInParam();
    }

    @Override
    public void writeXML(Element el) throws Exception {
        el.setAttribute("Type", "soap");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        this.soapInfo.writeXML(writer);
        writer.flush();
        this.appendChildrenFromOuputStream(el, out);
    }

    @Override
    public boolean isParameterized() {
        return this.soapInfo.isParameterized();
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        return this.soapInfo;
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("SOAPView");
        dsInfo.setSoapInfo(this.soapInfo);
        if (this.isParameterized()) {
            dsInfo.setQueryParamSet(this.soapInfo.getInSet());
        }
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            String wsdlUri = this.soapInfo.getWsdlUri();
            String serviceName = this.soapInfo.getServiceName().toString();
            String portName = this.soapInfo.getPortName();
            String operationName = this.soapInfo.getOperationName();
            XMLFieldInfo[] xmlFieldInfo = this.soapInfo.getXMLFieldInfo();
            wsdlUri = QbUtil.urlEncode(wsdlUri);
            serviceName = QbUtil.urlEncode(serviceName);
            portName = QbUtil.urlEncode(portName);
            operationName = QbUtil.urlEncode(operationName);
            jObj.put("wsdlUri", (Object)wsdlUri);
            jObj.put("serviceName", (Object)serviceName);
            jObj.put("portName", (Object)portName);
            jObj.put("operationName", (Object)operationName);
            JSONArray xmlInfoJSON = new JSONArray();
            for (XMLFieldInfo element : xmlFieldInfo) {
                JSONXMLFieldInfo jxmlFieldInfo = new JSONXMLFieldInfo(element);
                xmlInfoJSON.put((Object)jxmlFieldInfo.toJSONObject());
            }
            jObj.put("xmlFieldInfo", (Object)xmlInfoJSON);
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
            jObj.put("hasParam", this.isParameterized());
            JSONArray soapParamJSON = new JSONArray();
            JSONObject paramSet = new JSONObject();
            if (this.isParameterized()) {
                SOAPParam[] soapParam;
                for (SOAPParam element : soapParam = this.soapInfo.getSOAPInParam()) {
                    soapParamJSON.put((Object)this.getSOAPParamJSON(element));
                }
                paramSet = SoapDataSource.getParamSetJSON(this.soapInfo.getInSet());
            }
            jObj.put("soapParam", (Object)soapParamJSON);
            jObj.put("paramSet", (Object)paramSet);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "soap";
    }

    private JSONObject getSOAPParamJSON(SOAPParam soapParam) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("paramName", (Object)soapParam.getParamName());
        json.put("sqlType", soapParam.getSqlType());
        String promptName = QbUtil.urlEncode(soapParam.getPromptName());
        json.put("promptName", (Object)promptName);
        Object defaultValue = soapParam.getDefaultValue();
        json.put("isMultiDefaultValue", defaultValue instanceof Vector);
        json.put("defaultValue", defaultValue);
        Object value = soapParam.getValue();
        json.put("isMultiValue", value instanceof Vector);
        json.put("value", value);
        json.put("alwaysUseDefault", soapParam.isAlwaysUseDefault());
        return json;
    }

    private static SOAPParam getSOAPParamFromJSONObject(JSONObject jObj) throws JSONException {
        String paramName = jObj.getString("paramName");
        String promptName = jObj.getString("promptName");
        int sqlType = jObj.getInt("sqlType");
        boolean isMultiDefaultValue = jObj.getBoolean("isMultiDefaultValue");
        Object defaultValue = null;
        if (isMultiDefaultValue) {
            JSONArray ja = jObj.getJSONArray("defaultValue");
            Vector<String> vect = new Vector<String>();
            for (int i = 0; i < ja.length(); ++i) {
                vect.add(ja.getString(i));
            }
            defaultValue = vect;
        } else {
            defaultValue = jObj.has("defaultValue") ? jObj.getString("defaultValue") : null;
        }
        Object value = null;
        boolean isMultiValue = jObj.getBoolean("isMultiValue");
        if (isMultiValue) {
            JSONArray ja = jObj.getJSONArray("value");
            Vector<String> vect = new Vector<String>();
            for (int i = 0; i < ja.length(); ++i) {
                vect.add(ja.getString(i));
            }
            value = vect;
        } else {
            String valStr = jObj.getString("value");
            value = SoapDataSource.checkNullStringForJSON(valStr);
        }
        boolean alwaysUseDefault = jObj.getBoolean("alwaysUseDefault");
        SOAPParam soapParam = new SOAPParam(paramName, sqlType, promptName, defaultValue, value, alwaysUseDefault);
        return soapParam;
    }

    private static String checkNullStringForJSON(String str) {
        if (str.equals("null")) {
            return null;
        }
        return str;
    }

    public static SoapDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String wsdlUri = jObj.getString("wsdlUri");
        String serviceName = jObj.getString("serviceName");
        String portName = jObj.getString("portName");
        String operationName = jObj.getString("operationName");
        wsdlUri = QbUtil.urlDecode(wsdlUri);
        serviceName = QbUtil.urlDecode(serviceName);
        portName = QbUtil.urlDecode(portName);
        operationName = QbUtil.urlDecode(operationName);
        JSONArray xfInfo = jObj.getJSONArray("xmlFieldInfo");
        XMLFieldInfo[] xmlFieldInfo = new XMLFieldInfo[xfInfo.length()];
        for (int i = 0; i < xfInfo.length(); ++i) {
            xmlFieldInfo[i] = JSONXMLFieldInfo.readFromJSONObject(xfInfo.getJSONObject(i));
        }
        boolean hasParam = jObj.getBoolean("hasParam");
        SOAPParam[] soapParam = null;
        if (hasParam) {
            JSONArray jspArray = jObj.getJSONArray("soapParam");
            soapParam = new SOAPParam[jspArray.length()];
            for (int i = 0; i < jspArray.length(); ++i) {
                soapParam[i] = SoapDataSource.getSOAPParamFromJSONObject(jspArray.getJSONObject(i));
            }
        }
        QName svcQName = QName.valueOf(serviceName);
        SOAPQueryFileInfo soapQFI = new SOAPQueryFileInfo(wsdlUri, svcQName, portName, operationName, xmlFieldInfo, soapParam);
        return new SoapDataSource(soapQFI);
    }

    @Override
    protected synchronized void setFieldNamesAndDataTypes() throws Exception {
        if (this.fieldNames != null && this.dataTypes != null) {
            return;
        }
        if (this.soapInfo == null) {
            return;
        }
        XMLFieldInfo[] fields = this.soapInfo.getXMLFieldInfo();
        if (fields == null) {
            return;
        }
        this.fieldNames = new String[fields.length];
        this.dataTypes = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.fieldNames[i] = fields[i].getAlias();
            this.dataTypes[i] = fields[i].getDataType();
        }
    }

    @Override
    public Vector<Object> getDistinctValues(String tableName, String columnName) {
        return QueryParser.getDistinctValues((DBInfoBasic)((Object)this.getQueryFileInfo()), tableName, columnName);
    }
}

