/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class TextFileDataSource
extends DataSource {
    private String dataFile;

    public TextFileDataSource(Element source) throws Exception {
        NodeList list = source.getChildNodes();
        if (list.getLength() == 0) {
            throw new Exception("The " + source.getTagName() + " tag cannot be empty");
        }
        Node text = list.item(0);
        if (text.getNodeType() != 4) {
            throw new Exception("Wrong " + source.getTagName() + " tag format");
        }
        this.dataFile = text.getNodeValue();
        if (this.dataFile == null) {
            throw new Exception("Wrong " + source.getTagName() + " tag format");
        }
    }

    public TextFileDataSource(String filename) {
        this.dataFile = filename;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.dataFile, 0, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.dataFile, 0, startIndex, count);
    }

    @Override
    public void writeXML(Element el) {
        Document doc = el.getOwnerDocument();
        el.setAttribute("Type", "file");
        el.appendChild(doc.createCDATASection(this.dataFile));
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("TXTFile");
        dsInfo.setTextFileLocation(this.dataFile);
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        String encodedDataFile = this.dataFile.replace('\\', '/');
        encodedDataFile = QbUtil.urlEncode(encodedDataFile);
        try {
            jObj.put("textFileLocation", (Object)encodedDataFile);
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "file";
    }

    public static TextFileDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String textLoc = jObj.getString("textFileLocation");
        textLoc = QbUtil.urlDecode(textLoc);
        return new TextFileDataSource(textLoc);
    }
}

