/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.DataSource;
import quadbase.datasource.DataSourceInfo;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class XmlFileDataSource
extends DataSource {
    private String dataFile;

    public XmlFileDataSource(Element source) throws Exception {
        NodeList list = source.getChildNodes();
        if (list.getLength() == 0) {
            throw new Exception("The " + source.getTagName() + " tag cannot be empty");
        }
        Node text = list.item(0);
        if (text.getNodeType() != 4) {
            throw new Exception("Wrong " + source.getTagName() + " tag format");
        }
        this.dataFile = text.getNodeValue();
        if (this.dataFile == null) {
            throw new Exception("Wrong " + source.getTagName() + " tag format");
        }
    }

    public XmlFileDataSource(String filename) {
        this.dataFile = filename;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.dataFile, 2, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.dataFile, 2, startIndex, count);
    }

    @Override
    public void writeXML(Element el) {
        Document doc = el.getOwnerDocument();
        el.setAttribute("Type", "xml");
        el.appendChild(doc.createCDATASection(this.dataFile));
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("XMLFile");
        dsInfo.setTextFileLocation(this.dataFile);
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            String encodedDataFile = this.dataFile.replace('\\', '/');
            encodedDataFile = QbUtil.urlEncode(encodedDataFile);
            jObj.put("dataFile", (Object)encodedDataFile);
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "xml";
    }

    public static XmlFileDataSource getXmlDataSourceFromJSONObject(JSONObject jObj) throws JSONException {
        String encDataFile = jObj.optString("dataFile", "");
        String dataFile = QbUtil.urlDecode(encDataFile);
        return new XmlFileDataSource(dataFile);
    }
}

