/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasource.DataSourceInfo;
import quadbase.datasource.JSONXMLFieldInfo;
import quadbase.datasource.ParameterizedDataSource;
import quadbase.reportdesigner.ReportAPI.DataSheet;

public class XmlQueryDataSource
extends ParameterizedDataSource {
    private XMLFileQueryInfo xmlInfo;

    public XmlQueryDataSource(Element source) throws Exception {
        NodeList list = source.getElementsByTagName("XMLFILEQUERYINFO");
        if (list.getLength() == 0) {
            throw new Exception("Missing XMLFILEQUERYINFO tag in the " + source.getTagName() + " tag");
        }
        this.xmlInfo = XMLFileQueryInfo.readXML(list.item(0), 281);
    }

    public XmlQueryDataSource(XMLFileQueryInfo xmlInfo) {
        this.xmlInfo = xmlInfo;
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count) throws Exception {
        return new DataSheet(null, this.xmlInfo, false, null, startIndex, count);
    }

    @Override
    public DataSheet getDataSheet(int startIndex, int count, boolean isAdmin) throws Exception {
        return new DataSheet(null, this.xmlInfo, false, null, startIndex, count);
    }

    @Override
    public void setParameters(HashMap parameters) throws Exception {
        this.setParametersInternal(this.xmlInfo.getInParam(), parameters);
    }

    @Override
    public void setDefaultParameters() {
        if (!this.isParameterized()) {
            return;
        }
        IQueryInParam[] params = this.xmlInfo.getInParam();
        this.setDefaultParameters(params);
    }

    @Override
    public IQueryInParam[] getInParam() {
        if (!this.isParameterized()) {
            return null;
        }
        return this.xmlInfo.getInParam();
    }

    @Override
    public void writeXML(Element el) throws Exception {
        el.setAttribute("Type", "xmlfilequery");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
        this.xmlInfo.writeXML(writer);
        writer.flush();
        this.appendChildrenFromOuputStream(el, os);
    }

    @Override
    public boolean isParameterized() {
        return this.xmlInfo.getInSet() != null;
    }

    @Override
    public IQueryFileInfo getQueryFileInfo() {
        if (!this.isParameterized()) {
            return null;
        }
        return new QueryXMLFileInfo(this.xmlInfo);
    }

    @Override
    public DataSourceInfo getDataSourceInfo() {
        DataSourceInfo dsInfo = new DataSourceInfo();
        dsInfo.setTypeName("XMLQuery");
        dsInfo.setXmlFileQueryInfo(this.xmlInfo);
        if (this.isParameterized()) {
            dsInfo.setQueryParamSet(this.xmlInfo.getInSet());
        }
        return dsInfo;
    }

    @Override
    protected JSONObject toJSONObj(JSONObject jObj) {
        try {
            jObj.put("fileName", (Object)QbUtil.urlEncode(this.xmlInfo.getFileName()));
            XMLFieldInfo[] fieldInfo = this.xmlInfo.getFieldInfo();
            JSONArray fieldInfoJSON = new JSONArray();
            for (XMLFieldInfo element : fieldInfo) {
                JSONXMLFieldInfo jxmlFieldInfo = new JSONXMLFieldInfo(element);
                fieldInfoJSON.put((Object)jxmlFieldInfo.toJSONObject());
            }
            jObj.put("fieldInfo", (Object)fieldInfoJSON);
            jObj.put("condition", (Object)QbUtil.urlEncode(this.xmlInfo.getCondition()));
            XMLFieldInfo[] condInfo = this.xmlInfo.getConditionInfo();
            JSONArray condInfoJSON = new JSONArray();
            for (XMLFieldInfo element : condInfo) {
                JSONXMLFieldInfo jxmlFieldInfo = new JSONXMLFieldInfo(element);
                condInfoJSON.put((Object)jxmlFieldInfo.toJSONObject());
            }
            jObj.put("conditionInfo", (Object)condInfoJSON);
            jObj.put("dtdName", (Object)QbUtil.urlEncode(this.xmlInfo.getDTDName()));
            jObj.put("dtdTreeFileName", (Object)QbUtil.urlEncode(this.xmlInfo.getDTDTreeFileName()));
            jObj.put("hasParam", this.isParameterized());
            if (this.isParameterized()) {
                QueryInParamSet paramSet = this.xmlInfo.getInSet();
                jObj.put("paramSet", (Object)XmlQueryDataSource.getParamSetJSON(paramSet));
            }
            jObj.put("fieldNames", (Object)new JSONArray((Object)this.getFieldNames()));
            jObj.put("dataTypes", (Object)new JSONArray((Object)this.getDataTypes()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jObj;
    }

    @Override
    public String getType() {
        return "xmlfilequery";
    }

    public static XmlQueryDataSource readFromJSONObject(JSONObject jObj) throws JSONException {
        String fileName = jObj.getString("fileName");
        String condition = jObj.optString("condition");
        String dtdName = jObj.optString("dtdName");
        String dtdTreeFileName = jObj.optString("dtdTreeFileName");
        fileName = QbUtil.urlDecode(fileName);
        dtdName = QbUtil.urlDecode(dtdName);
        dtdTreeFileName = QbUtil.urlDecode(dtdTreeFileName);
        condition = QbUtil.urlDecode(condition);
        JSONArray fiArray = jObj.getJSONArray("fieldInfo");
        XMLFieldInfo[] fieldInfo = new XMLFieldInfo[fiArray.length()];
        for (int i = 0; i < fiArray.length(); ++i) {
            JSONObject fieldInfoJObj = fiArray.getJSONObject(i);
            fieldInfo[i] = JSONXMLFieldInfo.readFromJSONObject(fieldInfoJObj);
        }
        JSONArray ciJArray = jObj.getJSONArray("conditionInfo");
        XMLFieldInfo[] condInfo = new XMLFieldInfo[ciJArray.length()];
        for (int i = 0; i < ciJArray.length(); ++i) {
            JSONObject condInfoJObj = ciJArray.getJSONObject(i);
            condInfo[i] = JSONXMLFieldInfo.readFromJSONObject(condInfoJObj);
        }
        boolean hasParam = jObj.getBoolean("hasParam");
        QueryInParamSet paramSet = null;
        if (hasParam) {
            JSONObject paramSetJObj = jObj.getJSONObject("paramSet");
            paramSet = XmlQueryDataSource.getParamSetFromJSON(paramSetJObj);
        }
        if (condition.equalsIgnoreCase("null")) {
            condition = null;
        }
        XMLFileQueryInfo xfqi = new XMLFileQueryInfo(fileName, fieldInfo, condition, condInfo, dtdName, false, paramSet, dtdTreeFileName);
        XmlQueryDataSource xqs = new XmlQueryDataSource(xfqi);
        return xqs;
    }

    @Override
    protected synchronized void setFieldNamesAndDataTypes() throws Exception {
        if (this.fieldNames != null && this.dataTypes != null) {
            return;
        }
        XMLFieldInfo[] xmlFieldInfo = this.xmlInfo.getFieldInfo();
        this.fieldNames = new String[xmlFieldInfo.length];
        this.dataTypes = new String[xmlFieldInfo.length];
        for (int i = 0; i < xmlFieldInfo.length; ++i) {
            this.fieldNames[i] = xmlFieldInfo[i].getAlias();
            String xmlDataType = xmlFieldInfo[i].getDataType();
            int typeID = 7;
            try {
                typeID = xmlDataType.equalsIgnoreCase("datetime") ? 10 : DataType.findType(xmlDataType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dataTypes[i] = DataType.getTypeName(typeID);
        }
    }

    @Override
    public Vector<Object> getDistinctValues(String tableName, String columnName) {
        QueryXMLFileInfo xmlFileInfo = (QueryXMLFileInfo)this.getQueryFileInfo();
        return QueryParser.getDistinctValues(xmlFileInfo.getXMLFileQueryInfo(), columnName);
    }
}

