/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.util.ArrayList;
import java.util.Hashtable;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewField;
import quadbase.datasource.dataview.DataViewQueryConverter;
import quadbase.datasource.dataview.DataViewQueryFilters;

public class DataViewQuery {
    private int version;
    private boolean hasParam;
    private int chartVersion;
    private QueryInParamSet paramSet;
    private int totalFilters;
    private int totalFields;
    private int totalSelectedFields;
    private DataViewQueryFilters filters;
    private String[] columnOrder;
    private String[] aliases;

    public DataViewQuery(int version, boolean hasParam, int chartVersion, QueryInParamSet paramSet, int totalFilters, int totalFields, int totalSelectedFields, DataViewQueryFilters filters, String[] columnOrder, String[] aliases) {
        this.version = version;
        this.hasParam = hasParam;
        this.chartVersion = chartVersion;
        this.paramSet = paramSet;
        this.totalFilters = totalFilters;
        this.totalFields = totalFields;
        this.totalSelectedFields = totalSelectedFields;
        this.filters = filters;
        this.columnOrder = columnOrder;
        this.aliases = aliases;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean hasParam() {
        return this.hasParam;
    }

    public void setHasParam(boolean state) {
        this.hasParam = state;
    }

    public int chartVersion() {
        return this.chartVersion;
    }

    public QueryInParamSet getParamSet() {
        return this.paramSet;
    }

    public void setParamSet(QueryInParamSet params) {
        this.paramSet = params;
    }

    public int getTotalFilters() {
        return this.totalFilters;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public int getTotalSelectedFields() {
        return this.totalSelectedFields;
    }

    public DataViewQueryFilters getFilters() {
        return this.filters;
    }

    public DataViewQueryFilters getSelectedFieldsFilters(DataView dv) {
        DataViewField[] fields = dv.getFields();
        Hashtable<String, Integer> aliasIndex = new Hashtable<String, Integer>();
        int fieldIndex = 0;
        for (DataViewField field : fields) {
            if (field.type == 0) continue;
            aliasIndex.put(field.alias, fieldIndex);
            ++fieldIndex;
        }
        String[] sorts = new String[this.columnOrder.length];
        String[] aggregations = new String[this.columnOrder.length];
        boolean[] show = new boolean[this.columnOrder.length];
        String[] conditions = new String[this.columnOrder.length];
        String[] extraRow = new String[this.columnOrder.length];
        String[] filtersSort = this.filters.getSorts();
        String[] filtersAgg = this.filters.getAggregations();
        boolean[] filtersShow = this.filters.getShow();
        String[] filtersCond = this.filters.getConditions();
        String[] filtersExt = this.filters.getExtraRow();
        int[] aggrOrders = this.filters.getAggrOrders();
        int[] sortOrders = this.filters.getSortOrders();
        for (int i = 0; i < this.columnOrder.length; ++i) {
            int index = (Integer)aliasIndex.get(this.columnOrder[i]);
            sorts[i] = filtersSort[index];
            aggregations[i] = filtersAgg[index];
            show[i] = filtersShow[index];
            conditions[i] = filtersCond[index];
            extraRow[i] = filtersExt[index];
        }
        return new DataViewQueryFilters(sorts, aggregations, show, conditions, extraRow, sortOrders, aggrOrders);
    }

    public String[] getVisibleFieldsNames(DataView dataView) {
        ArrayList<String> result = new ArrayList<String>();
        DataViewQueryFilters selectedFieldsFilters = this.getSelectedFieldsFilters(dataView);
        for (int i = 0; i < this.columnOrder.length; ++i) {
            if (!selectedFieldsFilters.getShow()[i]) continue;
            result.add(this.columnOrder[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getColumnOrder() {
        return this.columnOrder;
    }

    public String[] getRealColumns(DataView dv) {
        if (this.columnOrder == null) {
            return null;
        }
        String[] realColumns = new String[this.columnOrder.length];
        for (int i = 0; i < this.columnOrder.length; ++i) {
            realColumns[i] = this.getRealColumn(this.columnOrder[i], dv);
        }
        return realColumns;
    }

    public String getRealColumn(String alias, DataView dv) {
        DataViewField[] fields = dv.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String[] stringArray;
            if (!alias.equals(fields[i].alias)) continue;
            if (fields[i].isExp) {
                return null;
            }
            if (alias.indexOf(46) == -1) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = fields[i].parentNames[0] + "." + alias;
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = alias;
            }
            String[] column = stringArray;
            String[] realcolumn = DataViewQueryConverter.toRealColumns(column, fields, dv.getTables());
            return realcolumn[0];
        }
        return null;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }
}

