/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewField;
import quadbase.datasource.dataview.DataViewQuery;
import quadbase.datasource.dataview.DataViewQueryFilters;
import quadbase.datasource.dataview.SQLQuery;

public class DataViewQueryConverter {
    private static boolean debug = false;

    public static SQLQuery createQuery(DataView dv, DataViewQuery dvq) {
        return DataViewQueryConverter.createQuery(dv, dvq, null);
    }

    public static SQLQuery createQuery(DataView dv, DataViewQuery dvq, String driverNameOrDbName) {
        int i;
        int[] filterAggrOrder;
        String[] colOrder = dvq.getColumnOrder();
        String[] realColumns = new String[colOrder.length];
        int[] sortOrder = new int[colOrder.length];
        int[] aggrOrder = new int[colOrder.length];
        DataViewField[] dvFields = dv.getFields();
        boolean isExp = false;
        String[] aggrAliases = dvq.getAliases();
        String[] aliasesNew = new String[colOrder.length];
        for (int i2 = 0; i2 < colOrder.length; ++i2) {
            String[] resultCol;
            String colAlias = colOrder[i2];
            String colAggrAlias = "";
            if (aggrAliases != null && !aggrAliases[i2].equals("")) {
                colAggrAlias = aggrAliases[i2];
            }
            if (colAggrAlias.equals("")) {
                colAggrAlias = colAlias;
            }
            String columnName = "";
            for (DataViewField dvField : dvFields) {
                if (dvField.type == 1 && dvField.alias.equals(colAlias)) {
                    isExp = dvField.isDVExp || dvField.isExp;
                    columnName = dvField.colname;
                    aliasesNew[i2] = colAggrAlias;
                    if (columnName.indexOf(46) >= 0) break;
                    columnName = dvField.headingTitle + "." + dvField.alias;
                    break;
                }
                aliasesNew[i2] = colAggrAlias;
            }
            String[] tempCol = new String[]{columnName};
            if (isExp) {
                resultCol = DataViewQueryConverter.toRealColumnsForFormulas(tempCol, dvFields, dv.getTables(), dv.getTableNameFormat());
                resultCol[0] = resultCol[0] + " AS \"" + colAggrAlias + "\"";
                realColumns[i2] = resultCol[0];
                continue;
            }
            resultCol = DataViewQueryConverter.toRealColumns(tempCol, dvFields, dv.getTables(), dv.getTableNameFormat(), true, driverNameOrDbName);
            resultCol[0] = resultCol[0] + " AS \"" + colAggrAlias + "\"";
            realColumns[i2] = resultCol[0];
        }
        DataViewQueryFilters filters = dvq.getFilters();
        String[] sorts = new String[colOrder.length];
        String[] aggrs = new String[colOrder.length];
        String[] conditions = new String[colOrder.length];
        boolean[] show = new boolean[colOrder.length];
        String[] filterSorts = filters.getSorts();
        String[] filterAggrs = filters.getAggregations();
        String[] filterConds = filters.getConditions();
        boolean[] filterShow = filters.getShow();
        int[] filterSortOrder = filters.getSortOrders();
        if (filterSortOrder == null) {
            filterSortOrder = new int[filterSorts.length];
            for (int i3 = 0; i3 < filterSortOrder.length; ++i3) {
                filterSortOrder[i3] = -1;
            }
        }
        if ((filterAggrOrder = filters.getAggrOrders()) == null) {
            filterAggrOrder = new int[filterSorts.length];
            for (i = 0; i < filterAggrOrder.length; ++i) {
                filterAggrOrder[i] = -1;
            }
        }
        for (i = 0; i < colOrder.length; ++i) {
            int filterCounter = 0;
            for (DataViewField dvField : dvFields) {
                if (dvField.type == 0) continue;
                if (dvField.alias.equals(colOrder[i])) {
                    sorts[i] = filterSorts[filterCounter];
                    if (sorts[i] == null) {
                        sorts[i] = "none";
                    }
                    aggrs[i] = filterAggrs[filterCounter];
                    if (aggrs[i] == null) {
                        aggrs[i] = "";
                    }
                    conditions[i] = filterConds[filterCounter];
                    show[i] = filterShow[filterCounter];
                    sortOrder[i] = filterSortOrder[filterCounter];
                    aggrOrder[i] = filterAggrOrder[filterCounter];
                }
                ++filterCounter;
            }
        }
        SQLQuery sqlQuery = DataViewQueryConverter.createQuery(dv, realColumns, sorts, aggrs, conditions, show, null, sortOrder, aggrOrder);
        sqlQuery.setAliases(aliasesNew);
        return sqlQuery;
    }

    public static SQLQuery createQuery(DataView dv, String[] realColumns, String[] sorts, String[] aggregations, String[] conditions, boolean[] show) {
        return DataViewQueryConverter.createQuery(dv, realColumns, sorts, aggregations, conditions, show, null);
    }

    public static SQLQuery createQuery(DataView dv, String[] realColumns, String[] sorts, String[] aggregations, String[] conditions, boolean[] show, int[] reorder) {
        return DataViewQueryConverter.createQuery(dv, realColumns, sorts, aggregations, conditions, show, reorder, null, null);
    }

    public static SQLQuery createQuery(DataView dv, String[] realColumns, String[] sorts, String[] aggregations, String[] conditions, boolean[] show, int[] reorder, int[] sortOrders, int[] aggrOrders) {
        if (reorder != null) {
            String[] newrealColumns = new String[realColumns.length];
            String[] newsorts = new String[realColumns.length];
            String[] newaggregations = new String[realColumns.length];
            String[] newconditions = new String[realColumns.length];
            int[] newSortOrders = new int[sortOrders.length];
            int[] newAggrOrders = new int[aggrOrders.length];
            boolean[] newshow = new boolean[realColumns.length];
            for (int i = 0; i < reorder.length; ++i) {
                newrealColumns[i] = realColumns[reorder[i]];
                newsorts[i] = sorts[reorder[i]];
                newaggregations[i] = aggregations[reorder[i]];
                newconditions[i] = conditions[reorder[i]];
                newshow[i] = show[reorder[i]];
                newSortOrders[i] = sortOrders[reorder[i]];
                newAggrOrders[i] = aggrOrders[reorder[i]];
            }
            realColumns = newrealColumns;
            sorts = newsorts;
            aggregations = newaggregations;
            conditions = newconditions;
            show = newshow;
            sortOrders = newSortOrders;
            aggrOrders = newAggrOrders;
        }
        conditions = DataViewQueryConverter.toRealColumnsForFormulas(conditions, dv.getFields(), dv.getTables(), dv.getTableNameFormat());
        SQLQuery query = new SQLQuery(dv, realColumns);
        query.setCustomAggrOrder(aggrOrders);
        query.setCustomSortOrder(sortOrders);
        for (int i = 0; i < realColumns.length; ++i) {
            if (show[i]) {
                query.setVisible(i);
            }
            if (sorts[i].equalsIgnoreCase("asc")) {
                query.setAscending(i);
            } else if (sorts[i].equalsIgnoreCase("desc")) {
                query.setDescending(i);
            }
            if (aggregations[i].equalsIgnoreCase("sum")) {
                query.setSum(i);
            } else if (aggregations[i].equalsIgnoreCase("ave") || aggregations[i].equalsIgnoreCase("avg")) {
                query.setAve(i);
            } else if (aggregations[i].equalsIgnoreCase("Count")) {
                query.setCount(i);
            } else if (aggregations[i].equalsIgnoreCase("min")) {
                query.setMin(i);
            } else if (aggregations[i].equalsIgnoreCase("max")) {
                query.setMax(i);
            } else if (aggregations[i].equalsIgnoreCase("stDev")) {
                query.setStdDev(i);
            } else if (aggregations[i].equalsIgnoreCase("variance")) {
                query.setVar(i);
            } else if (aggregations[i].equalsIgnoreCase("first")) {
                query.setFirst(i);
            } else if (aggregations[i].equalsIgnoreCase("last")) {
                query.setLast(i);
            }
            if (conditions == null) continue;
            conditions = DataViewQueryConverter.toRealColumnsForFormulas(conditions, dv.getFields(), dv.getTables(), dv.getTableNameFormat());
            if (!(aggregations[i] == null || aggregations[i].equals("") || aggregations[i].equals("[none]") || aggregations[i].equals("Where") || aggregations[i].equals("Group By") || aggregations.length == 1)) {
                query.setHavingCondition(i, conditions[i]);
                continue;
            }
            query.setCondition(i, conditions[i]);
        }
        return query;
    }

    public static String[] toRealColumnsForFormulas(String[] formulaValues, DataViewField[] fieldsMapping, String[][] tablesAliases) {
        return DataViewQueryConverter.toRealColumnsForFormulas(formulaValues, fieldsMapping, tablesAliases, 0);
    }

    public static String[] toRealColumnsForFormulas(String[] formulaValues, DataViewField[] fieldsMapping, String[][] tablesAliases, int tableNameFormat) {
        if (formulaValues == null) {
            return null;
        }
        String[] aliases = DataViewQueryConverter.getAllDataViewAliases(formulaValues);
        DataViewQueryConverter.debug(formulaValues, "!!!!!!!!!!!!!!!!!formulaValues");
        DataViewQueryConverter.debug(aliases, "aliases");
        String[] values = DataViewQueryConverter.toRealColumns(aliases, fieldsMapping, tablesAliases, tableNameFormat, false);
        DataViewQueryConverter.debug(values, "values");
        Hashtable<String, String> aliasMap = new Hashtable<String, String>();
        for (int i = 0; i < aliases.length; ++i) {
            aliasMap.put(aliases[i], values[i]);
        }
        String[] result = new String[formulaValues.length];
        for (int i = 0; i < formulaValues.length; ++i) {
            if (formulaValues[i] == null) continue;
            char[] characters = formulaValues[i].toCharArray();
            StringBuffer aliasBuf = null;
            StringBuffer buf = new StringBuffer();
            boolean parsingAlias = false;
            block6: for (char character : characters) {
                switch (character) {
                    case '{': {
                        aliasBuf = new StringBuffer();
                        parsingAlias = true;
                        continue block6;
                    }
                    case '}': {
                        parsingAlias = false;
                        buf.append(aliasMap.get(aliasBuf.toString()));
                        continue block6;
                    }
                    default: {
                        if (parsingAlias) {
                            aliasBuf.append(character);
                            continue block6;
                        }
                        buf.append(character);
                    }
                }
            }
            result[i] = buf.toString();
        }
        DataViewQueryConverter.debug(result, "RESULT OF MODIFIED NAMES");
        return result;
    }

    public static String[] getAllDataViewAliases(String[] formulaValues) {
        LinkedList<String> aliases = new LinkedList<String>();
        for (String formulaValue : formulaValues) {
            if (formulaValue == null) continue;
            char[] characters = formulaValue.toCharArray();
            StringBuffer aliasBuf = null;
            boolean parsingAlias = false;
            block5: for (char character : characters) {
                switch (character) {
                    case '{': {
                        aliasBuf = new StringBuffer();
                        parsingAlias = true;
                        continue block5;
                    }
                    case '}': {
                        parsingAlias = false;
                        aliases.add(aliasBuf.toString());
                        continue block5;
                    }
                    default: {
                        if (!parsingAlias) continue block5;
                        aliasBuf.append(character);
                    }
                }
            }
        }
        String[] result = new String[aliases.size()];
        Iterator it = aliases.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i] = (String)it.next();
            ++i;
        }
        return result;
    }

    public static String[] combineArrays(String[] a1, String[] a2) {
        if (a1 == null && a2 == null) {
            return null;
        }
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static String[] toRealColumns(String[] visibleColumns, DataViewField[] fieldsMapping, String[][] tablesAliases) {
        return DataViewQueryConverter.toRealColumns(visibleColumns, fieldsMapping, tablesAliases, 0, true);
    }

    public static String[] toRealColumns(String[] visibleColumns, DataViewField[] fieldsMapping, String[][] tablesAliases, int tableNameFormat, boolean userRealTableNames) {
        return DataViewQueryConverter.toRealColumns(visibleColumns, fieldsMapping, tablesAliases, tableNameFormat, userRealTableNames, null);
    }

    public static String[] toRealColumns(String[] visibleColumns, DataViewField[] fieldsMapping, String[][] tablesAliases, int tableNameFormat, boolean userRealTableNames, String driverNameOrDbName) {
        String[] result = new String[visibleColumns.length];
        Hashtable<String, String> tablesAliasMap = new Hashtable<String, String>(tablesAliases.length * 2);
        Hashtable<String, String> fieldsAliasMap = new Hashtable<String, String>(fieldsMapping.length * 2);
        Hashtable<String, Boolean> fieldsExpMap = new Hashtable<String, Boolean>(fieldsMapping.length * 2);
        Hashtable<String, String> columnsToParentMap = new Hashtable<String, String>(fieldsMapping.length * 2);
        Hashtable<String, String> realColumnAliasToRealColumnMap = new Hashtable<String, String>(fieldsMapping.length * 2);
        for (String[] stringArray : tablesAliases) {
            tablesAliasMap.put(stringArray[1], stringArray[0]);
        }
        for (String[] stringArray : fieldsMapping) {
            if (stringArray.type != 1 || stringArray.parentNames.length == 0) continue;
            DataViewQueryConverter.debug("key = " + stringArray.headingTitle + "." + stringArray.alias);
            DataViewQueryConverter.debug("key = " + stringArray.parentNames[0] + "." + stringArray.alias);
            DataViewQueryConverter.debug("key = " + stringArray.alias);
            DataViewQueryConverter.debug("value = " + stringArray.parentNames[0]);
            columnsToParentMap.put(stringArray.headingTitle + "." + stringArray.alias, stringArray.parentNames[0]);
            columnsToParentMap.put(stringArray.parentNames[0] + "." + stringArray.alias, stringArray.parentNames[0]);
            columnsToParentMap.put(stringArray.alias, stringArray.parentNames[0]);
        }
        for (String[] stringArray : fieldsMapping) {
            if (stringArray.type != 1) continue;
            fieldsAliasMap.put(stringArray.alias, stringArray.colname);
            if (stringArray.isExp || stringArray.isDVExp) {
                fieldsExpMap.put(stringArray.alias, stringArray.isExp || stringArray.isDVExp);
            }
            fieldsExpMap.put(stringArray.headingTitle + "." + stringArray.alias, stringArray.isExp || stringArray.isDVExp);
            DataViewQueryConverter.debug("fieldsExpMap.put(" + stringArray.headingTitle + "." + stringArray.alias + "," + (stringArray.isExp || stringArray.isDVExp) + ")");
            realColumnAliasToRealColumnMap.put(stringArray.headingTitle + "." + stringArray.alias, stringArray.colname);
            DataViewQueryConverter.debug("realColumnAliasToRealColumnMap.put(" + stringArray.headingTitle + "." + stringArray.alias + "," + stringArray.colname + ")");
        }
        for (int i = 0; i < visibleColumns.length; ++i) {
            int indexOfSeparator = visibleColumns[i].indexOf(46);
            String aliasTableName = (String)columnsToParentMap.get(visibleColumns[i]);
            DataViewQueryConverter.debug("visibleCol = " + visibleColumns[i]);
            DataViewQueryConverter.debug("aliasTableName = " + aliasTableName);
            String string = visibleColumns[i].substring(indexOfSeparator + 1, visibleColumns[i].length());
            String realTableName = userRealTableNames ? (aliasTableName != null ? (String)tablesAliasMap.get(aliasTableName) : "") : (aliasTableName != null ? aliasTableName : "");
            String realColumnName = (String)fieldsAliasMap.get(string);
            boolean isExp = DataViewQueryConverter.isExp(visibleColumns[i], fieldsExpMap);
            String tempRealColumnName = (String)realColumnAliasToRealColumnMap.get(visibleColumns[i]);
            if (!isExp && tempRealColumnName != null) {
                realColumnName = tempRealColumnName;
            }
            DataViewQueryConverter.debug("isExp [" + DataViewQueryConverter.isExp(visibleColumns[i], fieldsExpMap) + "]");
            DataViewQueryConverter.debug("realTableName = " + realTableName);
            DataViewQueryConverter.debug("realColumnName = " + realColumnName);
            realTableName = SQLQuery.fixTableName(realTableName, driverNameOrDbName);
            if (!isExp) {
                realColumnName = SQLQuery.fixTableName(realColumnName, driverNameOrDbName);
            }
            result[i] = isExp ? realColumnName : (tableNameFormat == 0 ? realTableName + "." + realColumnName : aliasTableName + "." + realColumnName);
            DataViewQueryConverter.debug("converted [" + visibleColumns[i] + "] to [" + result[i] + "]");
        }
        return result;
    }

    static boolean isExp(String columnAlias, Hashtable map) {
        Boolean result = (Boolean)map.get(columnAlias);
        if (result == null) {
            return false;
        }
        return result;
    }

    private static void debug(String msg) {
        if (debug) {
            System.out.println("DEBUG: " + msg);
        }
    }

    private static void debug(String[] msgs, String heading) {
        DataViewQueryConverter.debug(heading);
        if (msgs == null) {
            return;
        }
        for (int i = 0; i < msgs.length; ++i) {
            DataViewQueryConverter.debug("i = " + i + ": " + msgs[i]);
        }
    }
}

