/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasource.dataview.DataViewQuery;
import quadbase.datasource.dataview.DataViewQueryFilters;
import quadbase.datasource.dataview.UnsupportedVersionException;

public class DataViewQueryReader {
    private static int[] supportedVersions = new int[]{1};

    public static int[] getVersions() {
        return supportedVersions;
    }

    public static DataViewQuery getDataViewQuery(String file) throws UnsupportedVersionException, IOException {
        ReadDataFile readfile = new ReadDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        try {
            DataViewQuery result = DataViewQueryReader.getDataViewQuery(readfile.getInputStream(file));
            readfile.close();
            return result;
        }
        catch (Exception e) {
            try {
                readfile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            throw new IOException("failed to read data view file");
        }
    }

    public static DataViewQuery getDataViewQuery(DataInputStream in) throws UnsupportedVersionException, IOException {
        int version = in.readInt();
        int chartVersion = -1;
        QueryInParamSet paramSet = null;
        DataViewQueryFilters filters = null;
        if (!DataViewQueryReader.isSupportVersion(version)) {
            throw new UnsupportedVersionException("VERSION [" + version + "]");
        }
        boolean hasParam = in.readBoolean();
        if (hasParam) {
            chartVersion = in.readInt();
            paramSet = QueryInParamSet.read(in, chartVersion);
        }
        int totalFilters = in.readInt();
        int totalFields = in.readInt();
        filters = DataViewQueryReader.readFilters(in, totalFields);
        int totalSelectedFields = in.readInt();
        String[] columnOrder = DataViewQueryReader.readColumnOrder(in, totalSelectedFields);
        String[] aggrAlias = null;
        try {
            aggrAlias = DataViewQueryReader.readAggrAlias(in, totalSelectedFields);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] sortOrders = DataViewQueryReader.readOrdersIntArray(in);
        int[] aggrOrders = DataViewQueryReader.readOrdersIntArray(in);
        filters.setSortOrders(sortOrders);
        filters.setAggrOrders(aggrOrders);
        return new DataViewQuery(version, hasParam, chartVersion, paramSet, totalFilters, totalFields, totalSelectedFields, filters, columnOrder, aggrAlias);
    }

    public static DataViewQuery getDataViewQuery(JSONObject dvqObj) {
        try {
            int version = Integer.parseInt(dvqObj.getString("version"));
            boolean hasParam = dvqObj.getString("hasParam").equals("true");
            int chartVersion = Integer.parseInt(dvqObj.getString("chartVersion"));
            String[] columnOrder = DataViewQueryReader.getColumnOrder(dvqObj);
            QueryInParamSet paramSet = null;
            if (hasParam) {
                paramSet = DataViewQueryReader.getQueryInParamSet(dvqObj);
            }
            DataViewQueryFilters filters = DataViewQueryReader.getFilters(dvqObj);
            int totalFields = filters.getAggregations().length;
            int totalSelectedFields = columnOrder.length;
            String[] aggrAlias = DataViewQueryReader.getAggrAlias(dvqObj);
            return new DataViewQuery(version, hasParam, chartVersion, paramSet, 5, totalFields, totalSelectedFields, filters, columnOrder, aggrAlias);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isSupportVersion(int version) {
        for (int supportedVersion : supportedVersions) {
            if (version != supportedVersion) continue;
            return true;
        }
        return false;
    }

    private static DataViewQueryFilters readFilters(DataInputStream in, int totalFields) throws IOException {
        String[] sorts = new String[totalFields];
        String[] aggregations = new String[totalFields];
        boolean[] show = new boolean[totalFields];
        String[] conditions = new String[totalFields];
        String[] extraValue = new String[totalFields];
        for (int i = 0; i < totalFields; ++i) {
            sorts[i] = IOUtil.readStr(in);
            aggregations[i] = IOUtil.readStr(in);
            show[i] = Boolean.valueOf(IOUtil.readStr(in));
            conditions[i] = IOUtil.readStr(in);
            extraValue[i] = IOUtil.readStr(in);
        }
        return new DataViewQueryFilters(sorts, aggregations, show, conditions, extraValue);
    }

    private static String[] readColumnOrder(DataInputStream in, int totalSelectedFields) throws IOException {
        String[] selectedFields = new String[totalSelectedFields];
        for (int i = 0; i < selectedFields.length; ++i) {
            selectedFields[i] = IOUtil.readString(in, true);
        }
        return selectedFields;
    }

    private static int[] readOrdersIntArray(DataInputStream in) {
        try {
            if (in.available() == 0) {
                return null;
            }
            String orderStr = IOUtil.readStr(in);
            if (orderStr.equals("none")) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(orderStr, ",");
            int[] orders = new int[st.countTokens()];
            for (int i = 0; i < orders.length; ++i) {
                orders[i] = Integer.parseInt(st.nextToken());
            }
            return orders;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] readAggrAlias(DataInputStream in, int totalSelectedFields) throws IOException {
        String[] selectedFields = new String[totalSelectedFields];
        for (int i = 0; i < selectedFields.length; ++i) {
            selectedFields[i] = IOUtil.readString(in, true);
        }
        return selectedFields;
    }

    private static String[] getColumnOrder(JSONObject dvqObj) throws Exception {
        JSONArray jColOrder = dvqObj.getJSONArray("columnOrder");
        String[] columnOrder = new String[jColOrder.length()];
        for (int i = 0; i < columnOrder.length; ++i) {
            columnOrder[i] = jColOrder.getString(i);
        }
        return columnOrder;
    }

    private static QueryInParamSet getQueryInParamSet(JSONObject dvqObj) throws Exception {
        JSONObject jsonParamSet = null;
        JSONArray paramsJArray = null;
        jsonParamSet = dvqObj.optJSONObject("paramSet");
        if (jsonParamSet == null) {
            return null;
        }
        paramsJArray = jsonParamSet.getJSONArray("parameters");
        QueryInParam[] queryInParams = new QueryInParam[paramsJArray.length()];
        for (int i = 0; i < paramsJArray.length(); ++i) {
            JSONObject jParam = paramsJArray.getJSONObject(i);
            queryInParams[i] = DataViewQueryReader.getQueryInParam(jParam);
        }
        JSONArray paramSequenceJA = jsonParamSet.getJSONArray("parameterInPromptSequence");
        int numOfParams = queryInParams.length;
        QueryInParam[][] paramSeq = new QueryInParam[numOfParams][numOfParams];
        if (paramSequenceJA != null && paramSequenceJA.length() > 0) {
            for (int i = 0; i < paramSequenceJA.length(); ++i) {
                JSONArray psJA2 = paramSequenceJA.getJSONArray(i);
                if (psJA2 == null) continue;
                int j = 0;
                while (j < psJA2.length()) {
                    JSONObject jParam = paramsJArray.getJSONObject(i);
                    paramSeq[i][j] = DataViewQueryReader.getQueryInParam(jParam);
                    ++i;
                }
            }
        }
        QueryInParamSet paramSet = new QueryInParamSet(queryInParams);
        paramSet.setParameterInPromptSequence(paramSeq);
        return paramSet;
    }

    private static QueryInParam getQueryInParam(JSONObject paramObj) throws Exception {
        String valueVariable;
        String paramValue;
        String tableName;
        JSONArray jpIndex = paramObj.getJSONArray("paramIndexMap");
        int[] paramIndexMap = new int[jpIndex.length()];
        for (int i = 0; i < paramIndexMap.length; ++i) {
            paramIndexMap[i] = jpIndex.getInt(i);
        }
        String columnName = paramObj.getString("columnName");
        String dateFormat = paramObj.optString("dateFormat", null);
        if (dateFormat == null || dateFormat.equals("null") || dateFormat.equals("")) {
            dateFormat = null;
        }
        boolean isMapToColumnOnly = paramObj.getString("isMapToColumnOnly").equals("true");
        boolean isMapToFunctionOnly = paramObj.getString("isMapToFunctionOnly").equals("true");
        boolean isMultiValue = paramObj.getString("isMultiValue").equals("true");
        String paramName = paramObj.getString("paramName");
        String promptName = paramObj.getString("promptName");
        int sqlType = Integer.parseInt(paramObj.getString("sqlType"));
        Object defaultVal = paramObj.get("defaultValue");
        String defaultSql = paramObj.getString("defaultSql");
        Vector<Object> defaultValObj = null;
        int mapType = DataType.mapType(sqlType);
        if (defaultVal instanceof JSONArray) {
            Vector<Object> defaultValVect = new Vector<Object>();
            JSONArray jdv = (JSONArray)defaultVal;
            for (int i = 0; i < jdv.length(); ++i) {
                String dfValueStr = jdv.getString(i);
                Object obj = DataType.createObject(dfValueStr, mapType);
                defaultValVect.add(obj);
            }
            defaultValObj = defaultValVect;
        } else {
            String defaultValStr = defaultVal.toString();
            if (defaultValStr.equals("null")) {
                defaultValObj = null;
            } else {
                try {
                    defaultValObj = DataType.createObject(defaultValStr, mapType);
                }
                catch (Exception e) {
                    defaultValObj = null;
                }
            }
        }
        String defaultValueVariable = paramObj.getString("defaultValueVariable");
        if (defaultValueVariable.equals("null")) {
            defaultValueVariable = null;
        }
        Vector<String> selectionChoices = null;
        try {
            JSONArray selChoices = paramObj.getJSONArray("selectionChoices");
            if (selChoices.length() > 0) {
                selectionChoices = new Vector<String>();
                for (int i = 0; i < selChoices.length(); ++i) {
                    selectionChoices.add(selChoices.getString(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sqlSelect = paramObj.optString("sqlSelect");
        if ("null".equals(sqlSelect)) {
            sqlSelect = null;
        }
        if ((tableName = paramObj.getString("tableName")).equals("null")) {
            tableName = null;
        }
        if ((paramValue = paramObj.getString("value")).equals("null")) {
            paramValue = null;
        }
        if ((valueVariable = paramObj.getString("valueVariable")).equals("null")) {
            valueVariable = null;
        }
        QueryInParam queryInParam = null;
        if (isMultiValue) {
            Formula f;
            Vector<String> values = null;
            try {
                Object jobj = paramObj.get("values");
                if (jobj instanceof JSONArray) {
                    JSONArray jval = paramObj.getJSONArray("values");
                    if (jval != null && jval.length() > 0) {
                        values = new Vector<String>();
                        for (int i = 0; i < jval.length(); ++i) {
                            values.add(jval.getString(i));
                        }
                    }
                } else if (jobj instanceof String) {
                    values = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            queryInParam = new QueryMultiValueInParam(paramIndexMap, paramName, promptName, isMapToColumnOnly, isMapToFunctionOnly, tableName, columnName, sqlType, defaultValObj, defaultSql, false, null, paramValue, values);
            if (!"null".equals(defaultValueVariable)) {
                f = new Formula(null, defaultValueVariable);
                queryInParam.setDefaultValueVariable(f);
            }
            queryInParam.setSqlSelect(sqlSelect);
            if (!"null".equals(valueVariable)) {
                f = new Formula(null, valueVariable);
                queryInParam.setValueVariable(f);
            }
        } else {
            Formula f;
            queryInParam = new QueryInParam(paramIndexMap, paramName, promptName, isMapToColumnOnly, isMapToFunctionOnly, tableName, columnName, sqlType, defaultValObj, defaultSql, false, null, paramValue);
            queryInParam.setSelectionChoices(selectionChoices);
            queryInParam.setDateFormat(dateFormat);
            if (defaultValueVariable != null) {
                f = new Formula(null, defaultValueVariable);
                queryInParam.setDefaultValueVariable(f);
            }
            queryInParam.setSqlSelect(sqlSelect);
            if (valueVariable != null) {
                f = new Formula(null, valueVariable);
                queryInParam.setValueVariable(f);
            }
        }
        return queryInParam;
    }

    private static DataViewQueryFilters getFilters(JSONObject dvqObj) throws Exception {
        JSONArray jFiltersArray = dvqObj.getJSONArray("dataViewQueryFilters");
        int totalFields = jFiltersArray.length();
        String[] sorts = new String[totalFields];
        String[] aggregations = new String[totalFields];
        boolean[] show = new boolean[totalFields];
        String[] conditions = new String[totalFields];
        String[] extraValue = new String[totalFields];
        int[] sortOrders = new int[totalFields];
        int[] aggrOrders = new int[totalFields];
        for (int i = 0; i < totalFields; ++i) {
            JSONObject filter = jFiltersArray.getJSONObject(i);
            sorts[i] = filter.getString("sort");
            if (sorts[i].equals("null")) {
                sorts[i] = "";
            }
            aggregations[i] = filter.getString("aggregation");
            if (aggregations[i].equals("null")) {
                aggregations[i] = "";
            }
            conditions[i] = filter.getString("condition");
            if (conditions[i].equals("null")) {
                conditions[i] = "";
            }
            extraValue[i] = filter.getString("extraRow");
            String sortOrderStr = filter.getString("sortOrder");
            sortOrders[i] = sortOrderStr.equals("null") || sortOrderStr.equals("") ? 0 : Integer.parseInt(sortOrderStr);
            String aggrOrderStr = filter.getString("aggrOrder");
            aggrOrders[i] = aggrOrderStr.equals("null") || aggrOrderStr.equals("") ? 0 : Integer.parseInt(aggrOrderStr);
            String showStr = filter.getString("show");
            show[i] = showStr.equals("null") || showStr.equals("") || showStr.equals("true");
        }
        DataViewQueryFilters filters = new DataViewQueryFilters(sorts, aggregations, show, conditions, extraValue);
        filters.setSortOrders(sortOrders);
        filters.setAggrOrders(aggrOrders);
        return filters;
    }

    private static String[] getAggrAlias(JSONObject dvqObj) throws Exception {
        JSONArray jaa = dvqObj.getJSONArray("aggrAlias");
        String[] aggrAlias = new String[jaa.length()];
        for (int i = 0; i < aggrAlias.length; ++i) {
            aggrAlias[i] = jaa.getString(i);
        }
        return aggrAlias;
    }
}

