/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasource.dataview.DataViewQuery;
import quadbase.datasource.dataview.DataViewQueryFilters;

public class DataViewQueryWriter {
    private static int[] supportedVersions = new int[]{1};

    public static int[] getVersions() {
        return supportedVersions;
    }

    public static int getLatestVersion() {
        return supportedVersions[0];
    }

    public static int getChartVersion() {
        return 6612;
    }

    public static boolean saveDataViewQueryFile(DataViewQuery dvq, String file) throws IOException {
        return DataViewQueryWriter.saveDataViewQueryFile(dvq, file, null, null);
    }

    public static boolean saveDataViewQueryFile(DataViewQuery dvq, String file, int[] reorder, int[] newmap) throws IOException {
        if (file == null || file.trim().length() == 0) {
            throw new IOException(LanguageEncoder.getText("Please specify a file name."));
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        boolean result = DataViewQueryWriter.saveDataViewQueryFile(dvq, fstream, reorder, newmap);
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        try {
            wdfile.output(fstream.toByteArray(), file);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return result;
    }

    public static boolean saveDataViewQueryFile(DataViewQuery dvq, OutputStream os) throws IOException {
        return DataViewQueryWriter.saveDataViewQueryFile(dvq, os, null, null);
    }

    public static boolean saveDataViewQueryFile(DataViewQuery dvq, OutputStream os, int[] reorder, int[] newmap) throws IOException {
        DataOutputStream out = new DataOutputStream(os);
        out.writeInt(DataViewQueryWriter.getLatestVersion());
        boolean hasParam = dvq.hasParam();
        out.writeBoolean(hasParam);
        if (hasParam) {
            out.writeInt(6612);
            dvq.getParamSet().write(out);
        }
        int totalFilters = dvq.getTotalFilters();
        int totalFields = dvq.getTotalFields();
        out.writeInt(totalFilters);
        out.writeInt(totalFields);
        DataViewQueryWriter.writeFilters(dvq, out);
        DataViewQueryWriter.writeColumnOrder(dvq, out, reorder, newmap);
        DataViewQueryWriter.saveAggrAlias(dvq, out, reorder, newmap);
        DataViewQueryWriter.writeOrderIntArray(dvq.getFilters().getSortOrders(), out, reorder, newmap);
        DataViewQueryWriter.writeOrderIntArray(dvq.getFilters().getAggrOrders(), out, reorder, newmap);
        return true;
    }

    public static void writeFilters(DataViewQuery dvq, DataOutputStream out) throws IOException {
        DataViewQueryFilters filters = dvq.getFilters();
        String[] sorts = filters.getSorts();
        String[] aggregations = filters.getAggregations();
        boolean[] show = filters.getShow();
        String[] conditions = filters.getConditions();
        String[] extraRow = filters.getExtraRow();
        for (int i = 0; i < dvq.getTotalFields(); ++i) {
            if (i < sorts.length) {
                IOUtil.writeStr(out, sorts[i]);
            } else {
                IOUtil.writeStr(out, null);
            }
            if (i < aggregations.length) {
                IOUtil.writeStr(out, aggregations[i]);
            } else {
                IOUtil.writeStr(out, null);
            }
            if (i < show.length) {
                IOUtil.writeStr(out, String.valueOf(show[i]));
            } else {
                IOUtil.writeStr(out, "true");
            }
            if (i < conditions.length) {
                IOUtil.writeStr(out, conditions[i]);
            } else {
                IOUtil.writeStr(out, null);
            }
            if (i < extraRow.length) {
                IOUtil.writeStr(out, extraRow[i]);
                continue;
            }
            IOUtil.writeStr(out, null);
        }
    }

    public static void writeColumnOrder(DataViewQuery dvq, DataOutputStream out, int[] map, int[] newmap) throws IOException {
        out.writeInt(dvq.getTotalSelectedFields());
        String[] columnOrder = dvq.getColumnOrder();
        if (map != null) {
            String[] result = new String[columnOrder.length];
            int resultIndex = 0;
            block0: for (int element : map) {
                for (int j = 0; j < newmap.length; ++j) {
                    if (newmap[j] != element) continue;
                    result[resultIndex] = columnOrder[j];
                    ++resultIndex;
                    continue block0;
                }
            }
            columnOrder = result;
        }
        for (String element : columnOrder) {
            IOUtil.writeString(out, element);
        }
    }

    private static void writeOrderIntArray(int[] orders, DataOutputStream out, int[] map, int[] newMap) throws IOException {
        if (orders == null) {
            IOUtil.writeStr(out, "none");
            return;
        }
        if (map != null) {
            int[] mappedOrders = new int[orders.length];
            int resultIndex = 0;
            block0: for (int element : map) {
                for (int j = 0; j < newMap.length; ++j) {
                    if (newMap[j] != element) continue;
                    mappedOrders[resultIndex] = orders[j];
                    ++resultIndex;
                    continue block0;
                }
            }
            orders = mappedOrders;
        }
        String result = "";
        if (orders.length > 0) {
            result = result + orders[0];
        }
        for (int i = 1; i < orders.length; ++i) {
            result = result + "," + orders[i];
        }
        IOUtil.writeStr(out, result);
    }

    public static void saveAggrAlias(DataViewQuery dvq, DataOutputStream out, int[] map, int[] newmap) throws IOException {
        String[] aggrAlias = dvq.getAliases();
        if (map != null && aggrAlias != null) {
            String[] result = new String[aggrAlias.length];
            int resultIndex = 0;
            block0: for (int element : map) {
                for (int j = 0; j < newmap.length; ++j) {
                    if (newmap[j] != element) continue;
                    result[resultIndex] = aggrAlias[j];
                    ++resultIndex;
                    continue block0;
                }
            }
            aggrAlias = result;
        }
        for (int i = 0; i < dvq.getTotalSelectedFields(); ++i) {
            if (aggrAlias != null && aggrAlias[i] != null) {
                IOUtil.writeString(out, aggrAlias[i]);
                continue;
            }
            IOUtil.writeString(out, "");
        }
    }

    public static JSONObject toJSONObject(DataViewQuery dvq) {
        if (dvq == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("version", (Object)(dvq.getVersion() + ""));
            json.put("chartVersion", (Object)(dvq.chartVersion() + ""));
            json.put("hasParam", dvq.hasParam());
            json.put("totalFields", dvq.getTotalFields());
            json.put("dataViewQueryFilters", (Object)DataViewQueryWriter.getDVQFiltersJSON(dvq));
            json.put("paramSet", (Object)DataViewQueryWriter.getParamSetJSON(dvq));
            String[] aggrAlias = DataViewQueryWriter.updateAggrAlias(dvq);
            json.put("aggrAlias", (Object)aggrAlias);
            json.put("columnOrder", (Object)dvq.getColumnOrder());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String toJSONString(DataViewQuery dvq) {
        return DataViewQueryWriter.toJSONObject(dvq).toString();
    }

    private static String[] updateAggrAlias(DataViewQuery dvq) {
        String[] aggrAlias = dvq.getAliases();
        if (aggrAlias != null && aggrAlias.length > 0) {
            return aggrAlias;
        }
        String[] colOrder = dvq.getColumnOrder();
        aggrAlias = new String[colOrder.length];
        for (int i = 0; i < colOrder.length; ++i) {
            aggrAlias[i] = "";
        }
        dvq.setAliases(aggrAlias);
        return aggrAlias;
    }

    private static JSONArray getDVQFiltersJSON(DataViewQuery dvq) throws JSONException {
        DataViewQueryFilters dvqf = dvq.getFilters();
        JSONArray json = new JSONArray();
        int numOfFilters = dvq.getTotalFields();
        for (int i = 0; i < numOfFilters; ++i) {
            JSONObject filterJSON = new JSONObject();
            filterJSON.put("sort", (Object)(dvqf.getSorts()[i] + ""));
            if (dvqf.getSortOrders() == null) {
                filterJSON.put("sortOrder", (Object)"null");
            } else {
                filterJSON.put("sortOrder", (Object)(dvqf.getSortOrders()[i] + ""));
            }
            filterJSON.put("aggregation", (Object)(dvqf.getAggregations()[i] + ""));
            if (dvqf.getAggrOrders() == null) {
                filterJSON.put("aggrOrder", (Object)"null");
            } else {
                filterJSON.put("aggrOrder", (Object)(dvqf.getAggrOrders()[i] + ""));
            }
            filterJSON.put("show", (Object)(dvqf.getShow()[i] + ""));
            filterJSON.put("condition", (Object)(dvqf.getConditions()[i] + ""));
            filterJSON.put("extraRow", (Object)(dvqf.getExtraRow()[i] + ""));
            json.put((Object)filterJSON);
        }
        return json;
    }

    private static JSONObject getParamSetJSON(DataViewQuery dvq) throws JSONException {
        QueryInParam[] params;
        JSONObject json = new JSONObject();
        QueryInParamSet paramSet = dvq.getParamSet();
        if (paramSet == null || paramSet.getParameter().length == 0) {
            return json;
        }
        JSONArray paramArray = new JSONArray();
        for (QueryInParam param : params = paramSet.getParameter()) {
            paramArray.put((Object)DataViewQueryWriter.getParamJSON(param));
        }
        json.put("parameters", (Object)paramArray);
        JSONArray sequenceArray = new JSONArray();
        QueryInParam[][] paramSeq = paramSet.getParameterInPromptSequence();
        if (paramSeq != null) {
            for (QueryInParam[] element : paramSeq) {
                JSONArray paramSeqLevelX = new JSONArray();
                for (QueryInParam element2 : element) {
                    if (element2 == null) continue;
                    paramSeqLevelX.put((Object)DataViewQueryWriter.getParamJSON(element2));
                }
                sequenceArray.put((Object)paramSeqLevelX);
            }
        }
        json.put("parameterInPromptSequence", (Object)sequenceArray);
        return json;
    }

    private static JSONObject getParamJSON(QueryInParam param) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("paramIndexMap", (Object)param.getParamIndexMap());
        json.put("columnName", (Object)param.getColumnName());
        json.put("completeName", (Object)param.getCompleteName());
        json.put("dateFormat", (Object)param.getDateFormat());
        json.put("isMultiValue", param instanceof IQueryMultiValueInParam);
        json.put("isMapToColumn", param.isMapToColumn());
        json.put("isMapToColumnOnly", param.isMapToColumnOnly());
        json.put("isMapToFunctionOnly", param.isMapToFunctionOnly());
        json.put("isMapToSqlSelect", param.isMapToSqlSelect());
        json.put("defaultSql", (Object)(param.getDefaultSql() == null ? "" : param.getDefaultSql()));
        Object obj = param.getDefaultValue();
        if (obj instanceof Vector) {
            json.put("defaultValue", (Collection)((Vector)obj));
        } else if (obj != null) {
            json.put("defaultValue", (Object)obj.toString());
        } else {
            json.put("defaultValue", (Object)"null");
        }
        if (param.getDefaultValueVariable() != null && param.getDefaultValueVariable().getText() != null) {
            json.put("defaultValueVariable", (Object)param.getDefaultValueVariable().getText());
        } else {
            json.put("defaultValueVariable", (Object)"null");
        }
        json.put("paramName", (Object)param.getParamName());
        json.put("promptName", (Object)param.getPromptName());
        json.put("selectionChoices", (Collection)param.getSelectionChoices());
        json.put("sqlSelect", (Object)param.getSqlSelect());
        json.put("sqlType", (Object)(param.getSqlType() + ""));
        json.put("tableName", (Object)param.getTableName());
        obj = param.getValue();
        if (obj instanceof Vector) {
            json.put("value", (Collection)((Vector)obj));
        } else if (obj != null) {
            json.put("value", (Object)obj.toString());
        } else {
            json.put("value", (Object)"null");
        }
        if (param instanceof IQueryMultiValueInParam) {
            json.put("isMultiValue", (Object)"true");
            Vector<Object> values = ((QueryMultiValueInParam)param).getValues();
            if (values != null) {
                json.put("values", values);
            } else {
                json.put("values", (Object)"null");
            }
        } else {
            json.put("isMultiValue", (Object)"false");
        }
        if (param.getValueVariable() != null) {
            json.put("valueVariable", (Object)param.getValueVariable());
        } else {
            json.put("valueVariable", (Object)"null");
        }
        return json;
    }
}

