/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.io.DataInputStream;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewField;
import quadbase.datasource.dataview.JoinProperty;
import quadbase.datasource.dataview.UnsupportedVersionException;

public class DataViewReader {
    private static int[] supportedVersions = new int[]{10};
    static boolean debug = false;

    public static int[] getVersions() {
        return supportedVersions;
    }

    public static DataView getDataView(String fileName) throws UnsupportedVersionException, IOException {
        ReadDataFile readfile = new ReadDataFile();
        if (!fileName.toUpperCase().endsWith(".dvw".toUpperCase())) {
            fileName = fileName + ".dvw";
        }
        try {
            DataView result = DataViewReader.getDataView(readfile.getInputStream(fileName));
            readfile.close();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("failed to read data view file");
        }
    }

    public static DataView getDataView(DataInputStream in) throws UnsupportedVersionException, IOException {
        int version = -1;
        int tableNameFormat = -1;
        String[][] tables = null;
        DataViewField[] fields = null;
        JoinProperty[] joins = null;
        String rootObject = null;
        String conditionFormula = null;
        version = in.readInt();
        if (!DataViewReader.isSupportVersion(version)) {
            throw new UnsupportedVersionException("VERSION [" + version + "]");
        }
        tableNameFormat = in.readInt();
        tables = DataViewReader.readTables(in);
        fields = DataViewReader.readFields(in);
        joins = DataViewReader.readJoins(in);
        rootObject = IOUtil.readString(in, true);
        conditionFormula = IOUtil.readString(in, true);
        return new DataView(version, tableNameFormat, tables, fields, joins, rootObject, conditionFormula);
    }

    private static boolean isSupportVersion(int version) {
        for (int supportedVersion : supportedVersions) {
            if (version != supportedVersion) continue;
            return true;
        }
        return false;
    }

    private static String[][] readTables(DataInputStream in) throws IOException {
        String[][] tables = new String[in.readInt()][];
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = new String[2];
            tables[i][0] = IOUtil.readString(in, true);
            tables[i][1] = IOUtil.readString(in, true);
        }
        return tables;
    }

    private static DataViewField[] readFields(DataInputStream in) throws IOException {
        DataViewField[] fields = new DataViewField[in.readInt()];
        String currentHeading = "NONE";
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = new DataViewField();
            fields[i].type = in.readInt();
            if (fields[i].type == 0) {
                currentHeading = fields[i].headingTitle = IOUtil.readString(in, true);
                continue;
            }
            if (fields[i].type != 1) continue;
            fields[i].headingTitle = currentHeading;
            fields[i].alias = IOUtil.readString(in, true);
            fields[i].description = IOUtil.readString(in, true);
            fields[i].colname = IOUtil.readString(in, true);
            fields[i].isExp = in.readBoolean();
            fields[i].isDVExp = in.readBoolean();
            fields[i].parentNames = new String[in.readInt()];
            for (int j = 0; j < fields[i].parentNames.length; ++j) {
                fields[i].parentNames[j] = IOUtil.readString(in, true);
            }
        }
        return fields;
    }

    private static JoinProperty[] readJoins(DataInputStream in) throws IOException {
        JoinProperty[] joins = new JoinProperty[in.readInt()];
        for (int i = 0; i < joins.length; ++i) {
            joins[i] = new JoinProperty();
            joins[i].tableName1 = IOUtil.readString(in, true);
            joins[i].columnName1 = IOUtil.readString(in, true);
            joins[i].tableName2 = IOUtil.readString(in, true);
            joins[i].columnName2 = IOUtil.readString(in, true);
            joins[i].joinType = in.readInt();
        }
        return joins;
    }

    public static DataView getDataView(JSONObject dvObj) throws JSONException {
        int version = Integer.parseInt(dvObj.getString("version"));
        int tableNameFormat = Integer.parseInt(dvObj.getString("tableNameFormat"));
        String rootObject = dvObj.getString("rootObject");
        String conditionFormula = dvObj.getString("conditionFormula");
        String[][] tables = DataViewReader.getTables(dvObj);
        DataViewField[] fields = DataViewReader.getFields(dvObj);
        JoinProperty[] joins = DataViewReader.getJoins(dvObj);
        return new DataView(version, tableNameFormat, tables, fields, joins, rootObject, conditionFormula);
    }

    private static String[][] getTables(JSONObject dvObj) throws JSONException {
        JSONArray jTables = (JSONArray)dvObj.get("tables");
        String[][] tables = new String[jTables.length()][2];
        for (int i = 0; i < jTables.length(); ++i) {
            JSONArray row = (JSONArray)jTables.get(i);
            tables[i][0] = row.getString(0);
            tables[i][1] = row.getString(1);
        }
        return tables;
    }

    private static DataViewField[] getFields(JSONObject dvObj) throws JSONException {
        JSONArray jFields = (JSONArray)dvObj.get("fields");
        DataViewField[] fields = new DataViewField[jFields.length()];
        String currentHeading = "NONE";
        for (int i = 0; i < jFields.length(); ++i) {
            JSONObject jf = jFields.getJSONObject(i);
            fields[i] = new DataViewField();
            fields[i].type = Integer.parseInt(jf.getString("type"));
            if (fields[i].type == 0) {
                currentHeading = fields[i].headingTitle = jf.getString("headingTitle");
                continue;
            }
            if (fields[i].type != 1) continue;
            fields[i].headingTitle = currentHeading;
            fields[i].alias = jf.getString("alias");
            fields[i].description = jf.getString("description");
            fields[i].colname = jf.getString("colname");
            fields[i].isExp = jf.getString("isExp").equals("true");
            fields[i].isDVExp = jf.getString("isDVExp").equals("true");
            JSONArray jpNames = jf.getJSONArray("parentNames");
            fields[i].parentNames = new String[jpNames.length()];
            for (int j = 0; j < fields[i].parentNames.length; ++j) {
                fields[i].parentNames[j] = jpNames.getString(j);
            }
        }
        return fields;
    }

    private static JoinProperty[] getJoins(JSONObject dvObj) throws JSONException {
        JSONArray jjoins = dvObj.getJSONArray("joins");
        JoinProperty[] joins = new JoinProperty[jjoins.length()];
        for (int i = 0; i < joins.length; ++i) {
            JSONObject join = jjoins.getJSONObject(i);
            joins[i] = new JoinProperty();
            joins[i].columnName1 = join.getString("columnName1");
            joins[i].columnName2 = join.getString("columnName2");
            joins[i].tableName1 = join.getString("tableName1");
            joins[i].tableName2 = join.getString("tableName2");
            joins[i].joinType = Integer.parseInt(join.getString("joinType"));
        }
        return joins;
    }
}

