/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.WriteDataFile;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewField;
import quadbase.datasource.dataview.JoinProperty;
import quadbase.util.internal.QbUtil;

public class DataViewWriter {
    private static int[] supportedVersions = new int[]{10};
    static boolean debug = true;

    public static int[] getVersions() {
        return supportedVersions;
    }

    public static void save(DataView dv, String file) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataViewWriter.save(dv, fstream);
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
            file = file + ".dvw";
        }
        wdfile.output(fstream.toByteArray(), file);
    }

    public static void save(DataView dv, OutputStream stream) throws IOException {
        DataOutputStream out = new DataOutputStream(stream);
        out.writeInt(supportedVersions[supportedVersions.length - 1]);
        out.writeInt(dv.getTableNameFormat());
        DataViewWriter.writeTables(dv.getTables(), out);
        DataViewWriter.writeFields(dv.getFields(), out);
        DataViewWriter.writeJoins(dv.getJoins(), out);
        IOUtil.writeString(out, dv.getRootObject());
        IOUtil.writeString(out, dv.getConditionFormula());
        out.flush();
    }

    static void writeTables(String[][] tables, DataOutputStream out) throws IOException {
        out.writeInt(tables.length);
        for (String[] table : tables) {
            IOUtil.writeString(out, table[0]);
            IOUtil.writeString(out, table[1]);
        }
    }

    static void writeFields(DataViewField[] fields, DataOutputStream out) throws IOException {
        out.writeInt(fields.length);
        for (DataViewField field : fields) {
            out.writeInt(field.type);
            if (field.type == 0) {
                IOUtil.writeString(out, field.headingTitle);
                continue;
            }
            if (field.type != 1) continue;
            IOUtil.writeString(out, field.alias);
            IOUtil.writeString(out, field.description);
            IOUtil.writeString(out, field.colname);
            out.writeBoolean(field.isExp);
            out.writeBoolean(field.isDVExp);
            out.writeInt(field.parentNames.length);
            for (String parentName : field.parentNames) {
                IOUtil.writeString(out, parentName);
            }
        }
    }

    static void writeJoins(JoinProperty[] joins, DataOutputStream out) throws IOException {
        out.writeInt(joins.length);
        for (JoinProperty join : joins) {
            IOUtil.writeString(out, join.tableName1);
            try {
                IOUtil.writeString(out, join.columnName1);
            }
            catch (Exception ex) {
                IOUtil.writeString(out, "");
            }
            IOUtil.writeString(out, join.tableName2);
            try {
                IOUtil.writeString(out, join.columnName2);
            }
            catch (Exception ex) {
                IOUtil.writeString(out, "");
            }
            out.writeInt(join.joinType);
        }
    }

    public static String toHtmlString(DataView dv) {
        StringBuffer result = new StringBuffer();
        result.append("<script type=\"text/javascript\">\n<!--\nd = new dTree('d'); \nd.config.useStatusText=true;\n");
        result.append("d.add(0, -1, \"Available Columns\");\n");
        DataViewField[] fields = dv.getFields();
        int parent = -1;
        String heading = "";
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].type == 0) {
                heading = fields[i].headingTitle;
                result.append("d.add(" + (i + 1) + ", 0, \"" + QbUtil.escapeHTML(heading) + "\");\n");
                parent = i + 1;
                continue;
            }
            if (fields[i].type != 1) continue;
            result.append("d.add(" + (i + 1) + ", " + parent + ", \"" + QbUtil.escapeHTML(fields[i].alias) + "\", \"javascript:select('" + QbUtil.escapeHTML(heading) + "." + QbUtil.escapeHTML(fields[i].alias) + "');\");\n");
        }
        result.append("document.write(d);\n-->\n</script>");
        return result.toString();
    }

    public static JSONObject toJSONObject(DataView dv) {
        if (dv == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        try {
            json.put("version", (Object)(dv.getVersion() + ""));
            json.put("tableNameFormat", (Object)(dv.getTableNameFormat() + ""));
            json.put("tables", (Object)DataViewWriter.getTablesJSON(dv));
            json.put("fields", (Object)DataViewWriter.getFieldsJSON(dv));
            json.put("joins", (Object)DataViewWriter.getJoinsJSON(dv));
            json.put("rootObject", (Object)(dv.getRootObject() + ""));
            json.put("conditionFormula", (Object)(dv.getConditionFormula() + ""));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public static String toJSONString(DataView dv) {
        return DataViewWriter.toJSONObject(dv).toString();
    }

    private static JSONArray getTablesJSON(DataView dv) throws JSONException {
        String[][] tables = dv.getTables();
        JSONArray json = new JSONArray((Object)tables);
        return json;
    }

    private static JSONArray getFieldsJSON(DataView dv) throws JSONException {
        DataViewField[] dvf = dv.getFields();
        JSONArray json = new JSONArray();
        for (DataViewField element : dvf) {
            JSONObject fieldJSON = new JSONObject();
            fieldJSON.put("type", (Object)(element.type + ""));
            fieldJSON.put("headingTitle", (Object)element.headingTitle);
            fieldJSON.put("parentNames", (Object)element.parentNames);
            fieldJSON.put("colname", (Object)element.colname);
            fieldJSON.put("alias", (Object)element.alias);
            fieldJSON.put("description", (Object)element.description);
            fieldJSON.put("isExp", (Object)(element.isExp + ""));
            fieldJSON.put("isDVExp", (Object)(element.isDVExp + ""));
            json.put((Object)fieldJSON);
        }
        return json;
    }

    private static JSONArray getJoinsJSON(DataView dv) throws JSONException {
        JoinProperty[] joins = dv.getJoins();
        JSONArray json = new JSONArray();
        for (JoinProperty join : joins) {
            JSONObject joinJSON = new JSONObject();
            joinJSON.put("joinType", (Object)(join.joinType + ""));
            joinJSON.put("tableName1", (Object)join.tableName1);
            joinJSON.put("columnName1", (Object)join.columnName1);
            joinJSON.put("tableName2", (Object)join.tableName2);
            joinJSON.put("columnName2", (Object)join.columnName2);
            json.put((Object)joinJSON);
        }
        return json;
    }
}

