/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasource.dataview.DataView;
import quadbase.datasource.dataview.DataViewField;
import quadbase.datasource.dataview.JoinProperty;
import quadbase.querybuilder.query.QueryBuilder;

public class SQLQuery {
    private static final String SELECT = "SELECT";
    private static final String DISTINCT = "DISTINCT";
    private static final String FROM = "FROM";
    private static final String WHERE = "WHERE";
    private static final String GROUP_BY = "GROUP BY";
    private static final String ORDER_BY = "ORDER BY";
    private static final String HAVING = "HAVING";
    public static final String[] OPERATOR_STRING = new String[]{"=", ">", "<", "LIKE", "BETWEEN", "IN", "NOT"};
    private String[] fields;
    private String[] aggregations;
    private boolean[] selections;
    private short[] orders;
    private String extraCondition;
    private int[] sortOrders;
    private int[] aggrOrders;
    private LinkedList qualifiers;
    private LinkedList tables;
    private LinkedList havingConds;
    private boolean caseSensitive = true;
    private boolean msAccess;
    private boolean distinct = false;
    private String[] aliases = null;
    private Hashtable tableAliasMap = new Hashtable();
    private String[][] dvTables;
    private Vector tableList;
    private Vector deadendPaths;

    public SQLQuery(DataView dv, String[] attributes) {
        this(dv, attributes, true);
    }

    public SQLQuery(DataView dv, String[] attributes, boolean appendCondition) {
        this("", attributes);
        DataViewField[] dvFields = dv.getFields();
        String[] dvfAlias = new String[attributes.length];
        Hashtable<String, String> dvColNameMap = new Hashtable<String, String>();
        for (DataViewField dvField : dvFields) {
            if (dvField.isExp || dvField.isDVExp || dvField.colname == null) continue;
            if (dvField.parentNames[0] != null) {
                dvColNameMap.put(dvField.parentNames[0] + "." + dvField.colname, dvField.alias);
                continue;
            }
            dvColNameMap.put(dvField.colname, dvField.alias);
        }
        if (dvFields != null) {
            for (int i = 0; i < attributes.length; ++i) {
                int lastDot = attributes[i].lastIndexOf(46);
                String colName = attributes[i];
                Object obj = dvColNameMap.get(colName);
                if (obj == null && lastDot > -1) {
                    colName = attributes[i].substring(lastDot + 1);
                    obj = dvColNameMap.get(colName);
                }
                dvfAlias[i] = obj != null ? (String)obj : "";
            }
        }
        this.setAliases(dvfAlias);
        JoinProperty[] joins = dv.getJoins();
        this.dvTables = dv.getTables();
        if (this.dvTables != null) {
            for (String[] dvTable : this.dvTables) {
                this.tableAliasMap.put(dvTable[1], dvTable[0]);
            }
        }
        boolean allInnerJoins = this.allInnerJoins(joins);
        this.tableList = this.bfSearch(SQLQuery.getTableList(attributes), joins);
        if (joins == null || joins.length < 1 || allInnerJoins) {
            String tableStr = "";
            if (this.tableList.size() > 0) {
                int i;
                block3: for (i = this.tableList.size() - 1; i > 0; --i) {
                    String tableName = (String)this.tableList.elementAt(i);
                    tableName = SQLQuery.fixTableName(tableName);
                    for (int j = i - 1; j >= 0; --j) {
                        if (!this.tableList.elementAt(j).equals(tableName)) continue;
                        this.tableList.remove(j);
                        continue block3;
                    }
                }
                for (i = 0; i < this.tableList.size(); ++i) {
                    String tableAliasName = (String)this.tableList.elementAt(i);
                    String tableName = (String)this.tableAliasMap.get(tableAliasName);
                    if (tableName == null) {
                        tableName = (String)this.tableAliasMap.get(SQLQuery.fixTableName(tableAliasName));
                    }
                    if (tableName == null) {
                        String tmp = tableAliasName.replace('[', ' ');
                        tmp = tmp.replace(']', ' ');
                        tmp = tmp.trim();
                        tableName = (String)this.tableAliasMap.get(tmp);
                    }
                    if (tableName == null) {
                        System.out.println("Table Alias not found: " + tableAliasName + "\nmapping=" + this.tableAliasMap);
                        continue;
                    }
                    String tableClause = tableName = SQLQuery.fixTableName(tableName);
                    if (dv.getTableNameFormat() > 0 || !tableName.equals(tableAliasName)) {
                        tableAliasName = SQLQuery.fixTableName(tableAliasName);
                        tableClause = tableClause + " " + tableAliasName;
                    }
                    if (i > 0) {
                        tableClause = ", " + tableClause;
                    }
                    tableStr = tableStr + tableClause;
                }
                this.setTable(tableStr);
            }
            if (allInnerJoins) {
                this.setWhereCondition(this.toJoinConditions(joins, this.tableList));
            }
        } else {
            this.setTable(SQLQuery.toJoinString(this.tableAliasMap, joins, this.tableList));
        }
        if (appendCondition) {
            this.appendWhereCondition(dv.getConditionFormula());
        }
    }

    private Vector bfSearch(Vector selectedTables, JoinProperty[] joins) {
        Vector baseNodes = new Vector();
        for (int i = 0; i < selectedTables.size(); ++i) {
            if (baseNodes.contains(selectedTables.get(i))) continue;
            baseNodes.add(selectedTables.get(i));
        }
        Vector bestPath = new Vector();
        bestPath.add(baseNodes.elementAt(0));
        Vector<Vector> paths = new Vector<Vector>();
        paths.add(bestPath);
        Vector childpaths = new Vector();
        int bestPathScore = 1;
        this.deadendPaths = new Vector();
        while (paths.size() > 0 && bestPathScore != baseNodes.size()) {
            int j;
            int i;
            for (i = 0; i < paths.size() && bestPathScore < baseNodes.size(); ++i) {
                Vector path = (Vector)paths.elementAt(i);
                int temp_score = 0;
                for (j = 0; j < baseNodes.size(); ++j) {
                    String baseNode = (String)baseNodes.elementAt(j);
                    if (!this.contains(path, baseNode)) continue;
                    ++temp_score;
                }
                if (temp_score > bestPathScore) {
                    bestPathScore = temp_score;
                    bestPath = path;
                }
                if (temp_score >= baseNodes.size()) continue;
                Vector temp_children = this.searchHelper(path, joins);
                for (int j2 = 0; j2 < temp_children.size(); ++j2) {
                    childpaths.add(temp_children.elementAt(j2));
                }
            }
            if (childpaths.size() == 0 && bestPathScore != baseNodes.size()) {
                for (i = 0; i < baseNodes.size(); ++i) {
                    String baseNode = (String)baseNodes.elementAt(i);
                    if (this.contains(bestPath, baseNode)) continue;
                    boolean found = false;
                    for (j = 0; j < this.deadendPaths.size(); ++j) {
                        Vector deadendPath = (Vector)this.deadendPaths.get(j);
                        if (!this.contains(deadendPath, baseNode)) continue;
                        found = true;
                        for (int k = 0; k < deadendPath.size(); ++k) {
                            String deadendPathNode = (String)deadendPath.get(k);
                            if (!this.contains(bestPath, deadendPathNode)) {
                                bestPath.add(deadendPathNode);
                            }
                            if (deadendPathNode.equals(baseNode)) break;
                        }
                        ++bestPathScore;
                        childpaths.add(bestPath);
                        i = baseNodes.size();
                    }
                    if (found) continue;
                    bestPath.add(baseNodes.elementAt(i));
                    ++bestPathScore;
                    childpaths.add(bestPath);
                    i = baseNodes.size();
                }
            }
            paths = childpaths;
            childpaths = new Vector();
        }
        Vector results = new Vector();
        for (int i = 0; i < bestPath.size(); ++i) {
            results.add(bestPath.elementAt(i));
        }
        return results;
    }

    private boolean contains(Vector v, String n) {
        return v.contains(n) || v.contains(n.replaceAll("\\[", "").replaceAll("\\]", "")) || v.contains("[" + n + "]");
    }

    private Vector searchHelper(Vector path, JoinProperty[] joins) {
        Vector neighbors = this.getNeighbors((String)path.elementAt(path.size() - 1), joins);
        for (int i = neighbors.size() - 1; i >= 0; --i) {
            String neighbor = (String)neighbors.elementAt(i);
            if (!path.contains(neighbor) && !path.contains("[" + neighbor + "]")) continue;
            neighbors.removeElementAt(i);
        }
        Vector ret = new Vector();
        for (int i = 0; i < neighbors.size(); ++i) {
            Vector childpath = new Vector();
            for (int j = 0; j < path.size(); ++j) {
                childpath.add(path.elementAt(j));
            }
            childpath.add(neighbors.elementAt(i));
            ret.add(childpath);
        }
        if (ret.size() == 0) {
            this.deadendPaths.add(path);
        }
        return ret;
    }

    private Vector getNeighbors(String node, JoinProperty[] joinProperties) {
        Vector<String> ret = new Vector<String>();
        for (JoinProperty join : joinProperties) {
            if (node.equals(join.tableName1) || ("[" + node + "]").equals(join.tableName1) || node.equals("[" + join.tableName1 + "]")) {
                ret.add(join.tableName2);
                continue;
            }
            if (!node.equals(join.tableName2) && !("[" + node + "]").equals(join.tableName2) && !node.equals("[" + join.tableName2 + "]")) continue;
            ret.add(join.tableName1);
        }
        return ret;
    }

    public SQLQuery(String table, String[] attributes) {
        this(table, attributes, false);
    }

    public SQLQuery(String table, String[] attributes, boolean msAccess) {
        this.fields = new String[attributes.length];
        this.aggregations = new String[attributes.length];
        this.selections = new boolean[attributes.length];
        this.orders = new short[attributes.length];
        this.sortOrders = new int[attributes.length];
        this.aggrOrders = new int[attributes.length];
        this.msAccess = msAccess;
        System.arraycopy(attributes, 0, this.fields, 0, this.fields.length);
        for (int i = 0; i < this.selections.length; ++i) {
            this.aggregations[i] = null;
            this.selections[i] = false;
            this.orders[i] = -1;
            this.sortOrders[i] = -1;
            this.aggrOrders[i] = -1;
        }
        this.qualifiers = new LinkedList();
        this.havingConds = new LinkedList();
        this.setTable(table);
    }

    public SQLQuery(String table, String[] attributes, boolean msAccess, boolean caseSensitive) {
        this(table, attributes, msAccess);
        this.setCaseSensitive(caseSensitive);
    }

    public void setAliases(String[] aliases) {
        this.aliases = SQLQuery.fixAliases(aliases);
    }

    public String[] getFields() {
        return this.fields;
    }

    public String[][] getTables() {
        if (this.tables.size() == 0 || this.tables.get(0) == null) {
            return new String[0][0];
        }
        Vector<String[]> tablesVec = new Vector<String[]>();
        for (int i = 0; i < this.tables.size(); ++i) {
            String queryTables = (String)this.tables.get(i);
            queryTables = queryTables.replaceAll(" LEFT OUTER JOIN ", ",");
            queryTables = queryTables.replaceAll(" RIGHT OUTER JOIN ", ",");
            queryTables = queryTables.replaceAll(" INNER JOIN ", ",");
            queryTables = queryTables.replaceAll(" ON ", ",");
            StringTokenizer st = new StringTokenizer(queryTables, ",=()");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                for (String[] dvTable : this.dvTables) {
                    if (!token.equalsIgnoreCase(dvTable[0]) && !token.equalsIgnoreCase(dvTable[1]) && !token.equalsIgnoreCase(dvTable[0] + " " + SQLQuery.fixTableName(dvTable[1]))) continue;
                    tablesVec.add(dvTable);
                }
            }
        }
        String[][] result = new String[tablesVec.size()][2];
        for (int i = 0; i < tablesVec.size(); ++i) {
            result[i][0] = ((String[])tablesVec.get(i))[0];
            result[i][1] = ((String[])tablesVec.get(i))[1];
        }
        return result;
    }

    public void setDistinct(boolean state) {
        this.distinct = state;
    }

    public static String fixTableName(String tableName) {
        return SQLQuery.fixTableName(tableName, null);
    }

    public static String fixTableName(String tableName, String driverNameOrDbName) {
        if (tableName == null) {
            return null;
        }
        if (tableName.indexOf(32) != -1) {
            String result = tableName;
            String leftChar = SQLQuery.getTableWrapChar(driverNameOrDbName, true);
            String rightChar = SQLQuery.getTableWrapChar(driverNameOrDbName, false);
            if (!result.startsWith(leftChar)) {
                result = leftChar + result;
            }
            if (!result.endsWith(rightChar)) {
                result = result + rightChar;
            }
            return result;
        }
        return tableName;
    }

    public static String getTableWrapChar(String driverNameOrDbName, boolean left) {
        int dbType;
        int n = dbType = driverNameOrDbName != null ? QueryBuilder.mapDatabaseType(driverNameOrDbName) : 0;
        if (dbType == 0 && driverNameOrDbName != null) {
            switch (driverNameOrDbName) {
                case "sun.jdbc.odbc.JdbcOdbcDriver": {
                    dbType = 1;
                    break;
                }
                case "com.mysql.jdbc.Driver": {
                    dbType = 5;
                    break;
                }
                case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                    dbType = 3;
                    break;
                }
                case "org.postgresql.Driver": {
                    dbType = 6;
                    break;
                }
                case "oracle.jdbc.driver.OracleDriver": {
                    dbType = 2;
                }
            }
        }
        switch (dbType) {
            case 5: 
            case 10: {
                return "`";
            }
            case 6: {
                return "'";
            }
            case 1: {
                return left ? "[" : "]";
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                return "\"";
            }
        }
        return "";
    }

    public String toString() {
        String orderBy;
        String groupBy;
        String result = SELECT + (this.distinct ? " DISTINCT " : "") + " " + this.expandSelections() + " ";
        String from = this.expandStringArray(this.tables);
        if (from != null && from.length() > 0) {
            result = result + FROM + " " + from;
        }
        if (this.qualifiers.size() > 0) {
            result = result.concat(" WHERE " + this.expandStringAndArray(this.qualifiers));
            if (this.extraCondition != null && this.extraCondition.length() > 0) {
                result = result + " AND " + this.extraCondition;
            }
        } else if (this.extraCondition != null && this.extraCondition.length() > 0) {
            result = result.concat(" WHERE " + this.extraCondition);
        }
        if (!(groupBy = this.constructGroupBy()).equals("")) {
            result = result.concat(" " + groupBy);
            if (this.havingConds != null && this.havingConds.size() > 0) {
                result = result.concat(" HAVING " + this.expandStringAndArray(this.havingConds));
            }
        }
        if (!(orderBy = this.constructOrderBy()).equals("")) {
            result = result.concat(" " + orderBy);
        }
        return result;
    }

    public void setTable(String table) {
        this.tables = new LinkedList();
        if (this.msAccess) {
            this.tables.add("[" + table + "]");
        } else {
            this.tables.add(table);
        }
    }

    public void setVisible(int index) {
        if (!this.fields[index].equals("")) {
            this.selections[index] = true;
        }
    }

    public void setAscending(int index) {
        this.orders[index] = 0;
    }

    public void setDescending(int index) {
        this.orders[index] = 1;
    }

    public void setSum(int index) {
        this.aggregations[index] = "SUM";
    }

    public void setAve(int index) {
        this.aggregations[index] = "AVG";
    }

    public void setCount(int index) {
        this.aggregations[index] = "COUNT";
    }

    public void setMax(int index) {
        this.aggregations[index] = "MAX";
    }

    public void setMin(int index) {
        this.aggregations[index] = "MIN";
    }

    public void setStdDev(int index) {
        this.aggregations[index] = "STDDEV";
    }

    public void setVar(int index) {
        this.aggregations[index] = "VARIANCE";
    }

    public void setFirst(int index) {
        this.aggregations[index] = "FIRST";
    }

    public void setLast(int index) {
        this.aggregations[index] = "LAST";
    }

    public void setLike(int index, String pattern) {
        if (!this.caseSensitive) {
            this.qualifiers.add("upper(" + this.fields[index] + ") LIKE " + this.toAlphaUpperCase(this.fixSingleQuote(pattern)));
        } else {
            this.qualifiers.add(this.fields[index] + " LIKE " + this.fixSingleQuote(pattern));
        }
    }

    public void setNotLike(int index, String pattern) {
        if (!this.caseSensitive) {
            this.qualifiers.add("upper(" + this.fields[index] + ") NOT LIKE " + this.toAlphaUpperCase(this.fixSingleQuote(pattern)));
        } else {
            this.qualifiers.add(this.fields[index] + " NOT LIKE " + this.fixSingleQuote(pattern));
        }
    }

    public void setIsNull(int index) {
        this.qualifiers.add(this.fields[index] + " IS NULL");
    }

    public void setIsNotNull(int index) {
        this.qualifiers.add(this.fields[index] + " IS NOT NULL");
    }

    public void setEqual(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " = " + pattern);
    }

    public void setNotEqual(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " <> " + pattern);
    }

    public void setCharEqual(int index, String pattern) {
        if (!this.caseSensitive) {
            this.qualifiers.add("upper(" + this.fields[index] + ") = " + this.toAlphaUpperCase(this.fixSingleQuote(pattern)));
        } else {
            this.qualifiers.add(this.fields[index] + " = " + this.fixSingleQuote(pattern));
        }
    }

    public void setCharNotEqual(int index, String pattern) {
        if (!this.caseSensitive) {
            this.qualifiers.add("upper(" + this.fields[index] + ") <> " + this.toAlphaUpperCase(this.fixSingleQuote(pattern)));
        } else {
            this.qualifiers.add(this.fields[index] + " <> " + this.fixSingleQuote(pattern));
        }
    }

    public void setGreaterThan(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " > " + pattern);
    }

    public void setGreaterThanOrEq(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " >= " + pattern);
    }

    public void setLessThan(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " < " + pattern);
    }

    public void setLessThanOrEq(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " <= " + pattern);
    }

    public void setIn(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " IN (" + pattern + ")");
    }

    public void setNotIn(int index, String pattern) {
        this.qualifiers.add(this.fields[index] + " NOT IN (" + pattern + ")");
    }

    public void setCharIn(int index, String pattern) {
        if (!this.caseSensitive) {
            this.qualifiers.add("upper(" + this.fields[index] + ") IN (" + this.toAlphaUpperCase(this.fixSingleQuote(pattern)) + ")");
        } else {
            this.qualifiers.add(this.fields[index] + " IN (" + this.fixSingleQuote(pattern) + ")");
        }
    }

    public void setCharNotIn(int index, String pattern) {
        if (!this.caseSensitive) {
            this.qualifiers.add("upper(" + this.fields[index] + ") NOT IN (" + this.toAlphaUpperCase(this.fixSingleQuote(pattern)) + ")");
        } else {
            this.qualifiers.add(this.fields[index] + " NOT IN (" + this.fixSingleQuote(pattern) + ")");
        }
    }

    public void setIsTrue(int index) {
        this.qualifiers.add(this.fields[index] + " = TRUE");
    }

    public void setIsFalse(int index) {
        this.qualifiers.add(this.fields[index] + " = FALSE");
    }

    public void setIsBit0(int index) {
        this.qualifiers.add(this.fields[index] + " = 0");
    }

    public void setIsBit1(int index) {
        this.qualifiers.add(this.fields[index] + " = 1");
    }

    public void setCondition(int index, String condition) {
        if (condition == null) {
            return;
        }
        if ((condition = condition.trim()).length() == 0) {
            return;
        }
        if (condition.charAt(0) == ':') {
            condition = "= " + condition;
        }
        this.fields[index] = this.fields[index].trim();
        int asLoc = this.fields[index].toUpperCase().indexOf(" AS ");
        if (condition.startsWith(this.fields[index])) {
            if (asLoc <= 0) {
                this.qualifiers.add(condition);
            } else {
                this.qualifiers.add(condition.substring(0, asLoc));
            }
        } else if (SQLQuery.startWithOperator(condition)) {
            if (asLoc <= 0) {
                String aggrField = this.aggregations != null && this.aggregations[index] != null ? this.aggregations[index] + "(" + this.fields[index] + ")" : this.fields[index];
                this.qualifiers.add(aggrField + " " + condition);
            } else {
                String formulaName = this.fields[index].substring(0, asLoc);
                this.qualifiers.add(formulaName + " " + condition);
            }
        } else {
            condition = condition.replaceAll("[\\{\\}]", "");
            for (int i = 0; i < this.tableList.size(); ++i) {
                String tableName = (String)this.tableList.elementAt(i);
                String tn = tableName.replaceAll("[\\[\\]]", "");
                if (condition.indexOf(tn + ".") < 0) continue;
                condition = condition.replaceAll(tn + ".", tableName + ".");
            }
            this.qualifiers.add(condition);
        }
    }

    public void setHavingCondition(int index, String condition) {
        String aggrField;
        int asloc;
        if (condition == null) {
            return;
        }
        if ((condition = condition.trim()).length() == 0) {
            return;
        }
        if (condition.charAt(0) == ':') {
            condition = "= " + condition;
        }
        if ((asloc = (aggrField = this.fields[index].trim()).toUpperCase().indexOf(" AS ")) > 0) {
            aggrField = aggrField.substring(0, asloc);
        }
        this.wrapConditionWithAggregation(index, condition, aggrField);
    }

    private void wrapConditionWithAggregation(int index, String condition, String aggrField) {
        aggrField = this.aggregations[index] + "(" + aggrField + ")";
        if (condition.startsWith(this.aggregations[index]) || !SQLQuery.startWithOperator(condition)) {
            this.havingConds.add(condition);
        } else {
            this.havingConds.add(aggrField + " " + condition);
        }
    }

    public void setWhereCondition(String condition) {
        this.extraCondition = condition;
    }

    public void appendWhereCondition(String condition) {
        if (condition == null || condition.trim().length() == 0) {
            return;
        }
        condition = this.updateCondition(condition);
        if (this.extraCondition == null || this.extraCondition.length() == 0) {
            this.extraCondition = condition;
        } else if (condition != null) {
            this.extraCondition = this.extraCondition + " AND (" + condition + ")";
        }
    }

    public String updateCondition(String con) {
        String cond;
        int i;
        Vector strKeys = QueryBuilder.getStringTokenizer(con);
        for (int i2 = 0; i2 < strKeys.size(); ++i2) {
            String[] key = (String[])strKeys.elementAt(i2);
            con = QbUtil.replace(con, key[1], key[0]);
        }
        Vector condVec = new Vector();
        QueryBuilder.andOrTokenizer(con, condVec);
        String str = "";
        String res = "";
        boolean isBetweenOp = false;
        boolean add = true;
        for (i = 0; i < condVec.size(); ++i) {
            String tmp = (String)condVec.elementAt(i);
            if ((" " + tmp).toUpperCase().indexOf(" BETWEEN ") >= 0) {
                str = str + tmp;
                isBetweenOp = true;
                continue;
            }
            if (isBetweenOp && tmp.toUpperCase().indexOf(" AND ") >= 0) {
                str = str + tmp;
                isBetweenOp = false;
                continue;
            }
            if (!isBetweenOp && this.checkAndOr(tmp)) {
                String cond2 = str.trim();
                if (cond2 != null && !cond2.equals("")) {
                    res = res + cond2 + tmp;
                }
                str = "";
                add = true;
                continue;
            }
            if (add && this.isTableIncluded(tmp)) {
                str = str + tmp;
                continue;
            }
            add = false;
            str = "";
        }
        if (!str.equals("") && (cond = str) != null) {
            res = res + cond;
        }
        if (res.trim().toUpperCase().startsWith("AND")) {
            res = res.trim().substring(3);
        }
        if (res.trim().toUpperCase().endsWith("AND")) {
            res = res.trim().substring(0, res.trim().length() - 3);
        }
        if (res.trim().toUpperCase().startsWith("OR")) {
            res = res.trim().substring(2);
        }
        if (res.trim().toUpperCase().endsWith("OR")) {
            res = res.trim().substring(0, res.trim().length() - 2);
        }
        res = this.balanceParentheses(res);
        for (i = 0; i < strKeys.size(); ++i) {
            String[] key = (String[])strKeys.elementAt(i);
            res = QbUtil.replace(res, key[0], key[1]);
        }
        if (res == null || res.trim().equalsIgnoreCase("null") || res.trim().equals("")) {
            return null;
        }
        return res;
    }

    private String balanceParentheses(String str) {
        int i;
        StringBuffer sb = new StringBuffer();
        int parCt = 0;
        Vector<Integer> openPar = new Vector<Integer>();
        for (i = 0; i < str.length(); ++i) {
            boolean append = true;
            if (str.charAt(i) == '(') {
                ++parCt;
                openPar.add(i);
            } else if (str.charAt(i) == ')') {
                if (parCt == 0) {
                    append = false;
                } else {
                    --parCt;
                    openPar.remove(openPar.size() - 1);
                }
            }
            if (!append) continue;
            sb.append(str.charAt(i));
        }
        for (i = openPar.size() - 1; i >= 0; --i) {
            sb.deleteCharAt((Integer)openPar.get(i));
        }
        return sb.toString();
    }

    private boolean checkAndOr(String token) {
        return token.toUpperCase().matches("\\sAND\\s") || token.toUpperCase().matches("\\sOR\\s");
    }

    private boolean isTableIncluded(String token) {
        String tables = " " + this.getTableNameList().replaceAll("\\[", "").replaceAll("\\]", "") + " ";
        int dot = token.indexOf(46);
        if (dot == -1) {
            return true;
        }
        String table = token.substring(0, dot);
        table = table.replace('(', ' ');
        table = table.replace(')', ' ');
        table = table.replace('[', ' ');
        table = table.replace(']', ' ');
        table = table.trim();
        try {
            Integer.parseInt(table);
            return true;
        }
        catch (Exception exception) {
            if (tables.toUpperCase().indexOf(" " + table.toUpperCase() + ",") > -1) {
                return true;
            }
            return tables.toUpperCase().indexOf(" " + table.toUpperCase() + " ") > -1;
        }
    }

    private String getTableNameList() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.tableList.size(); ++i) {
            sb.append(this.tableList.get(i)).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public void setCustomSortOrder(int[] sortOrders) {
        this.sortOrders = sortOrders;
    }

    public void setCustomAggrOrder(int[] aggrOrders) {
        this.aggrOrders = aggrOrders;
    }

    private void setCaseSensitive(boolean state) {
        this.caseSensitive = state;
    }

    private String expandSelections() {
        String result = "";
        boolean isFirst = true;
        for (int i = 0; i < this.selections.length; ++i) {
            String selection;
            if (!this.selections[i]) continue;
            String rename = null;
            if (this.aliases != null && this.aliases.length > i && this.aliases[i] != null && !this.aliases[i].trim().equals("")) {
                rename = this.aliases[i];
            }
            if (this.aggregations[i] == null) {
                selection = rename != null && this.fields[i].indexOf(" AS ") == -1 ? this.fields[i] + " AS \"" + rename + "\"" : this.fields[i];
            } else {
                int asLoc;
                if (rename == null) {
                    asLoc = this.fields[i].toUpperCase().indexOf(" AS ");
                    if (asLoc > 0) {
                        String asAlias = this.fields[i].substring(asLoc + 4);
                        if (asAlias.indexOf(34) >= 0) {
                            asAlias = asAlias.replace('\"', ' ').trim();
                        }
                        rename = asAlias;
                    } else {
                        rename = this.fields[i];
                    }
                }
                while (rename.indexOf(46) != -1) {
                    rename = rename.substring(rename.indexOf(46) + 1, rename.length());
                }
                asLoc = this.fields[i].toUpperCase().lastIndexOf(" AS ");
                if (asLoc > 0) {
                    String tempField = this.fields[i].substring(0, asLoc).trim();
                    asLoc = rename.toUpperCase().lastIndexOf(" AS ");
                    if (asLoc > 0) {
                        rename = rename.substring(asLoc + 4).trim();
                    }
                    selection = this.aggregations[i] + "(" + tempField + ") AS \"" + rename + "\"";
                } else {
                    selection = this.aggregations[i].concat("(" + this.fields[i] + ") AS \"" + rename + "\"");
                }
            }
            if (isFirst) {
                result = result.concat(selection);
                isFirst = false;
                continue;
            }
            result = result.concat(", " + selection);
        }
        return result;
    }

    private String constructGroupBy() {
        String aliasTemp;
        int i;
        int i2;
        String result = new String();
        boolean hasAggregation = false;
        boolean[] needGroupBy = new boolean[this.selections.length];
        for (int i3 = 0; i3 < this.aggregations.length; ++i3) {
            if (this.aggregations[i3] == null || this.aggregations[i3].equals("")) {
                if (!this.selections[i3]) continue;
                needGroupBy[i3] = true;
                continue;
            }
            needGroupBy[i3] = false;
            if (hasAggregation) continue;
            hasAggregation = true;
        }
        if (!hasAggregation) {
            return "";
        }
        Hashtable<Integer, String> custOrderMap = new Hashtable<Integer, String>();
        Hashtable<String, Integer> fieldIndexMap = new Hashtable<String, Integer>();
        int maxAggrOrder = -1;
        if (this.aggrOrders == null) {
            this.aggrOrders = new int[this.aggregations.length];
            for (i2 = 0; i2 < this.aggrOrders.length; ++i2) {
                this.aggrOrders[i2] = -1;
            }
        } else {
            for (i2 = 0; i2 < this.aggrOrders.length; ++i2) {
                if (this.aggrOrders[i2] > 0) {
                    custOrderMap.put(this.aggrOrders[i2], this.fields[i2]);
                }
                if (this.aggrOrders[i2] > maxAggrOrder) {
                    maxAggrOrder = this.aggrOrders[i2];
                }
                fieldIndexMap.put(this.fields[i2], i2);
            }
        }
        Vector<String> fieldNameList = new Vector<String>(10);
        for (i = 1; i <= maxAggrOrder; ++i) {
            int fieldsIndex;
            aliasTemp = (String)custOrderMap.get(i);
            if (aliasTemp == null || !needGroupBy[fieldsIndex = ((Integer)fieldIndexMap.get(aliasTemp)).intValue()]) continue;
            int asLoc = aliasTemp.toLowerCase().indexOf(" as ");
            if (asLoc > 0) {
                aliasTemp = aliasTemp.substring(0, asLoc);
            }
            fieldNameList.add(aliasTemp);
        }
        for (i = 0; i < this.aggrOrders.length; ++i) {
            if (this.aggrOrders[i] > 0 || !needGroupBy[i]) continue;
            aliasTemp = this.fields[i];
            int asLoc = aliasTemp.toLowerCase().indexOf(" as ");
            if (asLoc > 0) {
                aliasTemp = this.fields[i].substring(0, asLoc);
            }
            fieldNameList.add(aliasTemp);
        }
        if (fieldNameList.size() > 0) {
            result = (String)fieldNameList.elementAt(0);
        }
        for (i = 1; i < fieldNameList.size(); ++i) {
            result = result + ", " + fieldNameList.elementAt(i);
        }
        return this.aggregations != null && this.aggregations.length > 1 ? GROUP_BY.concat(" " + result) : result;
    }

    private String constructOrderBy() {
        int i;
        int i2;
        String result = new String();
        Hashtable<Integer, Integer> custOrderMap = new Hashtable<Integer, Integer>();
        int maxSortOrder = -1;
        Vector<String> clauseList = new Vector<String>();
        if (this.sortOrders == null) {
            this.sortOrders = new int[this.fields.length];
            for (i2 = 0; i2 < this.sortOrders.length; ++i2) {
                this.sortOrders[i2] = -1;
            }
        } else {
            for (i2 = 0; i2 < this.sortOrders.length; ++i2) {
                if (this.sortOrders[i2] > 0) {
                    custOrderMap.put(this.sortOrders[i2], i2);
                }
                if (this.sortOrders[i2] <= maxSortOrder) continue;
                maxSortOrder = this.sortOrders[i2];
            }
        }
        Hashtable<Integer, Integer> sortOrderVisibleMap = new Hashtable<Integer, Integer>();
        Vector<String> noOrderSortList = new Vector<String>();
        int visibleColIndex = 0;
        for (i = 0; i < this.sortOrders.length; ++i) {
            if (!this.selections[i]) continue;
            sortOrderVisibleMap.put(i, visibleColIndex);
            if (this.sortOrders[i] == -1 && this.orders[i] >= 0) {
                String orderStr = this.orders[i] == 0 ? " ASC" : " DESC";
                noOrderSortList.add(visibleColIndex + 1 + orderStr);
            }
            ++visibleColIndex;
        }
        for (i = 1; i <= maxSortOrder; ++i) {
            int fieldIndex;
            Object idxObj = custOrderMap.get(i);
            if (idxObj == null || (idxObj = sortOrderVisibleMap.get(fieldIndex = ((Integer)idxObj).intValue())) == null) continue;
            int fieldOrderIndex = (Integer)idxObj;
            if (this.orders[fieldIndex] == -1) continue;
            if (this.orders[fieldIndex] == 0) {
                clauseList.add(fieldOrderIndex + 1 + " ASC");
                continue;
            }
            clauseList.add(fieldOrderIndex + 1 + " DESC");
        }
        for (i = 0; i < noOrderSortList.size(); ++i) {
            clauseList.add((String)noOrderSortList.elementAt(i));
        }
        if (clauseList.size() == 0) {
            return "";
        }
        result = (String)clauseList.elementAt(0);
        for (i = 1; i < clauseList.size(); ++i) {
            result = result + ", " + clauseList.elementAt(i);
        }
        return ORDER_BY.concat(" " + result);
    }

    private String expandStringArray(LinkedList arr) {
        String result = "";
        for (int i = 0; i < arr.size(); ++i) {
            if (arr.get(i) == null) continue;
            result = result.concat((String)arr.get(i));
            if (i + 1 == arr.size()) continue;
            result = result.concat(", ");
        }
        return result;
    }

    private String expandStringAndArray(LinkedList arr) {
        String result = "";
        for (int i = 0; i < arr.size(); ++i) {
            result = result.concat("(" + (String)arr.get(i) + ")");
            if (i + 1 == arr.size()) continue;
            result = result.concat(" AND ");
        }
        return result;
    }

    private String fixSingleQuote(String pattern) {
        char[] characters = pattern.toCharArray();
        StringBuffer buf = new StringBuffer();
        boolean beginValue = true;
        for (int i = 0; i < characters.length; ++i) {
            if (beginValue) {
                if (characters[i] == '\'') {
                    beginValue = false;
                } else if (characters[i] != ' ' && characters[i] != ',') {
                    buf.append('\'');
                    beginValue = false;
                }
            } else if (characters[i] == '\'') {
                beginValue = true;
            } else if (characters[i] == ',') {
                buf.append('\'');
                beginValue = true;
            }
            buf.append(characters[i]);
            if (i != characters.length - 1 || beginValue) continue;
            buf.append('\'');
        }
        return buf.toString();
    }

    private String toAlphaUpperCase(String in) {
        char[] inChar = in.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (char element : inChar) {
            if (element != ',' && element != ' ' && element != '\'') {
                buf.append(Character.toUpperCase(element));
                continue;
            }
            buf.append(element);
        }
        return buf.toString();
    }

    @Deprecated
    static String toJoinString(JoinProperty[] joins) {
        return SQLQuery.toJoinString(null, joins);
    }

    private static String toJoinString(Hashtable tableAliasMap, JoinProperty[] joinProperties) {
        JoinProperty[][] joins = SQLQuery.buildJoins(joinProperties);
        String result = null;
        for (JoinProperty[] join : joins) {
            String curJoin = null;
            Hashtable alreadyInJoin = new Hashtable();
            for (int i = 0; i < join.length; ++i) {
                String secondTableFixed;
                String firstTableFixed;
                String firstTableClause = firstTableFixed = SQLQuery.fixTableName(join[i].tableName1);
                Object obj = alreadyInJoin.get(firstTableFixed);
                if (obj == null) {
                    String tempStr = (String)tableAliasMap.get(firstTableFixed);
                    firstTableClause = tempStr + " " + firstTableFixed;
                }
                String secondTableClause = secondTableFixed = SQLQuery.fixTableName(join[i].tableName2);
                obj = alreadyInJoin.get(secondTableFixed);
                if (obj == null) {
                    String tempStr = (String)tableAliasMap.get(secondTableFixed);
                    secondTableClause = tempStr + " " + secondTableFixed;
                }
                String secondTable = i == 0 ? secondTableClause : "(" + curJoin + ")";
                curJoin = firstTableClause + " " + SQLQuery.toJoinTypeString(join[i].joinType) + " " + secondTable + " ON " + firstTableFixed + "." + join[i].columnName1 + " = " + secondTableFixed + "." + join[i].columnName2;
            }
            result = result == null ? curJoin : result + ", " + curJoin;
        }
        return result;
    }

    private static String toJoinString(Hashtable tableAliasMap, JoinProperty[] joinProperties, Vector tableList) {
        JoinProperty[][] joins = SQLQuery.buildJoins(joinProperties);
        String result = null;
        boolean[] colUsed = new boolean[tableList.size()];
        for (int i = 0; i < colUsed.length; ++i) {
            colUsed[i] = false;
        }
        for (JoinProperty[] join : joins) {
            String curJoin = null;
            Hashtable alreadyInJoin = new Hashtable();
            for (int i = 0; i < join.length; ++i) {
                String secondTable;
                String secondTableFixed;
                String firstTableFixed;
                String firstTableClause = firstTableFixed = SQLQuery.fixTableName(join[i].tableName1);
                Object obj = alreadyInJoin.get(firstTableFixed);
                if (obj == null) {
                    String tempStr = (String)tableAliasMap.get(firstTableFixed);
                    firstTableClause = tempStr + " " + firstTableFixed;
                }
                String secondTableClause = secondTableFixed = SQLQuery.fixTableName(join[i].tableName2);
                obj = alreadyInJoin.get(secondTableFixed);
                if (obj == null) {
                    String tempStr = (String)tableAliasMap.get(secondTableFixed);
                    secondTableClause = tempStr + " " + secondTableFixed;
                }
                String string = secondTable = curJoin == null ? secondTableClause : "(" + curJoin + ")";
                if (!SQLQuery.isAddCondition(tableList, firstTableFixed, secondTableFixed)) continue;
                curJoin = firstTableClause + " " + SQLQuery.toJoinTypeString(join[i].joinType) + " " + secondTable + " ON " + firstTableFixed + "." + join[i].columnName1 + " = " + secondTableFixed + "." + join[i].columnName2;
                for (int k = 0; k < colUsed.length; ++k) {
                    if (SQLQuery.isColUsed((String)tableList.get(k), firstTableFixed)) {
                        colUsed[k] = true;
                        continue;
                    }
                    if (!SQLQuery.isColUsed((String)tableList.get(k), secondTableFixed)) continue;
                    colUsed[k] = true;
                }
                while (i < join.length - 1 && join[i].tableName1.equals(join[i + 1].tableName1) && SQLQuery.isAddCondition(tableList, join[i + 1].tableName1, join[i + 1].tableName2)) {
                    firstTableFixed = SQLQuery.fixTableName(join[++i].tableName1);
                    secondTableFixed = SQLQuery.fixTableName(join[i].tableName2);
                    curJoin = curJoin + " AND " + firstTableFixed + "." + join[i].columnName1 + " = " + secondTableFixed + "." + join[i].columnName2;
                }
            }
            if (result == null && curJoin == null) {
                result = null;
                continue;
            }
            if (result == null && curJoin != null) {
                result = curJoin;
                continue;
            }
            if (result == null || curJoin == null) continue;
            result = result + ", " + curJoin;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < colUsed.length; ++i) {
            if (colUsed[i]) continue;
            String tmp = (String)tableList.get(i);
            if (buf.length() != 0 && SQLQuery.existsInBuffer(buf.toString(), tmp)) continue;
            String tableName = (String)tableAliasMap.get(tmp);
            if (buf.length() == 0) {
                buf.append(tableName).append(" ").append(tmp);
                continue;
            }
            buf.append(", ").append(tableName).append(" ").append(tmp);
        }
        if (buf.length() > 0) {
            result = buf.toString() + (result == null ? "" : ", " + result);
        }
        return result;
    }

    private static String replaceKeywords(String str) {
        String[] keywords;
        for (String keyword : keywords = new String[]{"AND", "OR", "NOT", "LIKE", "BETWEEN", "IN", "IS NULL", "IS NOT NULL", "AS"}) {
            str = str.replaceAll("\\W" + keyword + "\\W", ",");
        }
        return str;
    }

    private static boolean isFunction(String str) {
        String[] funSymbols;
        for (String funSymbol : funSymbols = new String[]{"(", ")", ",", "+", "-", "=", "*", "/", ">", "<", "!", "&"}) {
            if (str.indexOf(funSymbol) <= -1) continue;
            return true;
        }
        return false;
    }

    private static Vector getTableList(String[] attr) {
        Vector<String> tableList = new Vector<String>();
        String[] stringArray = attr;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element;
            String tmpStr = element = stringArray[i];
            if (SQLQuery.isFunction(tmpStr = SQLQuery.replaceKeywords(tmpStr))) {
                StringTokenizer st = new StringTokenizer(tmpStr, "()+-*/%=<>,&|{}!");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.indexOf(46) <= -1 || token.indexOf("'") != -1) continue;
                    tableList.add(token.substring(0, token.indexOf(46)).trim());
                }
                continue;
            }
            if (tmpStr.indexOf(46) == -1) {
                tableList.add(tmpStr);
                continue;
            }
            tableList.add(tmpStr.substring(0, tmpStr.indexOf(46)).trim());
        }
        return tableList;
    }

    private static boolean existsInBuffer(String buffer, String table) {
        StringTokenizer st = new StringTokenizer(buffer, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.equalsIgnoreCase(table + " " + table)) continue;
            return true;
        }
        return false;
    }

    private static boolean isColUsed(String existTabel, String table) {
        String tmp2 = table;
        if (existTabel.equalsIgnoreCase(tmp2)) {
            return true;
        }
        if (existTabel.equalsIgnoreCase("[" + tmp2 + "]")) {
            return true;
        }
        return existTabel.equalsIgnoreCase("\"" + tmp2 + "\"");
    }

    static JoinProperty[][] buildJoins(JoinProperty[] joinProperties) {
        LinkedList partitionedJoins = SQLQuery.partitionJoins(joinProperties);
        Iterator it = partitionedJoins.iterator();
        JoinProperty[][] result = new JoinProperty[partitionedJoins.size()][];
        int i = 0;
        while (it.hasNext()) {
            result[i] = SQLQuery.sortJoin((LinkedList)it.next());
            ++i;
        }
        return result;
    }

    static LinkedList partitionJoins(JoinProperty[] joinProperties) {
        if (joinProperties == null) {
            return null;
        }
        if (joinProperties.length < 1) {
            return null;
        }
        LinkedList partitionsHash = new LinkedList();
        LinkedList partitions = new LinkedList();
        LinkedList<JoinProperty> curPartition = new LinkedList<JoinProperty>();
        partitions.add(curPartition);
        Hashtable<String, String> curHash = new Hashtable<String, String>();
        partitionsHash.add(curHash);
        boolean[] isInPartition = new boolean[joinProperties.length];
        curPartition.add(joinProperties[0]);
        String firstTableFixed = SQLQuery.fixTableName(joinProperties[0].tableName1);
        String secondTableFixed = SQLQuery.fixTableName(joinProperties[0].tableName2);
        curHash.put(firstTableFixed, "");
        curHash.put(secondTableFixed, "");
        for (int i = 0; i < isInPartition.length; ++i) {
            isInPartition[i] = i == 0;
        }
        int lastNotInPartition = joinProperties.length - 1;
        block1: for (int i = 1; i < joinProperties.length; ++i) {
            block2: for (int j = 1; j < joinProperties.length; ++j) {
                int k;
                if (isInPartition[j]) continue;
                firstTableFixed = SQLQuery.fixTableName(joinProperties[j].tableName1);
                secondTableFixed = SQLQuery.fixTableName(joinProperties[j].tableName2);
                if (curHash.get(firstTableFixed) != null || curHash.get(secondTableFixed) != null) {
                    curPartition.add(joinProperties[j]);
                    curHash.put(firstTableFixed, "");
                    curHash.put(secondTableFixed, "");
                    isInPartition[j] = true;
                    for (k = lastNotInPartition; k > 0; --k) {
                        if (isInPartition[k]) continue;
                        lastNotInPartition = k;
                        continue block1;
                    }
                    continue block1;
                }
                if (j != lastNotInPartition) continue;
                curPartition = new LinkedList();
                partitions.add(curPartition);
                curHash = new Hashtable();
                partitionsHash.add(curHash);
                curPartition.add(joinProperties[j]);
                curHash.put(firstTableFixed, "");
                curHash.put(secondTableFixed, "");
                isInPartition[j] = true;
                for (k = lastNotInPartition; k > 0; --k) {
                    if (isInPartition[k]) continue;
                    lastNotInPartition = k;
                    continue block2;
                }
            }
        }
        return partitions;
    }

    static JoinProperty[] sortJoin(LinkedList join) {
        int i;
        if (join.size() < 1) {
            return new JoinProperty[0];
        }
        JoinProperty[] origJoin = SQLQuery.toJoinPropertyArray(join);
        Vector<JoinProperty> joinset = new Vector<JoinProperty>();
        Vector<String> existing = new Vector<String>();
        Vector<JoinProperty> pending = new Vector<JoinProperty>();
        for (i = 0; i < origJoin.length; ++i) {
            if (i == 0) {
                existing.add(origJoin[0].tableName1);
                existing.add(origJoin[0].tableName2);
                joinset.add(origJoin[0]);
                continue;
            }
            pending.add(origJoin[i]);
        }
        while (!pending.isEmpty()) {
            i = 0;
            while (i < pending.size()) {
                JoinProperty currentJoin = (JoinProperty)pending.elementAt(i);
                if (existing.contains(currentJoin.tableName1) && existing.contains(currentJoin.tableName2)) {
                    SQLQuery.insertJoin(joinset, currentJoin);
                    pending.removeElementAt(i);
                    continue;
                }
                if (existing.contains(currentJoin.tableName1)) {
                    joinset.add(SQLQuery.swapTable(currentJoin));
                    existing.add(currentJoin.tableName2);
                    pending.removeElementAt(i);
                    continue;
                }
                if (existing.contains(currentJoin.tableName2)) {
                    joinset.add(currentJoin);
                    existing.add(currentJoin.tableName1);
                    pending.removeElementAt(i);
                    continue;
                }
                ++i;
            }
        }
        JoinProperty[] jp = new JoinProperty[joinset.size()];
        for (int i2 = 0; i2 < joinset.size(); ++i2) {
            jp[i2] = (JoinProperty)joinset.get(i2);
        }
        return jp;
    }

    private static void insertJoin(Vector joins, JoinProperty newJoin) {
        if (joins.size() < 1 || newJoin == null) {
            return;
        }
        int pos = 0;
        for (int i = 1; i < joins.size(); ++i) {
            if (!((JoinProperty)joins.elementAt((int)i)).tableName1.equals(newJoin.tableName1) && !((JoinProperty)joins.elementAt((int)i)).tableName1.equals(newJoin.tableName2)) continue;
            pos = i;
        }
        if (newJoin.tableName1.equals(((JoinProperty)joins.elementAt((int)pos)).tableName2)) {
            joins.insertElementAt(SQLQuery.swapTable(newJoin), pos + 1);
        } else {
            joins.insertElementAt(newJoin, pos + 1);
        }
    }

    private static JoinProperty swapTable(JoinProperty in) {
        JoinProperty result = new JoinProperty();
        result.tableName1 = in.tableName2;
        result.columnName1 = in.columnName2;
        result.tableName2 = in.tableName1;
        result.columnName2 = in.columnName1;
        result.joinType = in.joinType == 1 ? 2 : (in.joinType == 2 ? 1 : 0);
        return result;
    }

    private static JoinProperty[] toJoinPropertyArray(LinkedList join) {
        JoinProperty[] result = new JoinProperty[join.size()];
        Iterator it = join.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i] = (JoinProperty)it.next();
            ++i;
        }
        return result;
    }

    private static String toJoinTypeString(int joinType) {
        switch (joinType) {
            case 1: {
                return "LEFT OUTER JOIN";
            }
            case 2: {
                return "RIGHT OUTER JOIN";
            }
        }
        return "INNER JOIN";
    }

    private String toJoinConditions(JoinProperty[] joins, Vector selectedTables) {
        String result = "";
        for (JoinProperty join : joins) {
            String secondTableFixed;
            String firstTableFixed = SQLQuery.fixTableName(join.tableName1);
            if (!SQLQuery.isAddCondition(selectedTables, firstTableFixed, secondTableFixed = SQLQuery.fixTableName(join.tableName2))) continue;
            String curCondition = "(" + firstTableFixed + "." + join.columnName1 + "=" + secondTableFixed + "." + join.columnName2 + ")";
            result = result.length() > 0 ? result + " AND " + curCondition : curCondition;
        }
        return result;
    }

    private static boolean isAddCondition(Vector selectedTables, String table1, String table2) {
        if (selectedTables == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < selectedTables.size(); ++i) {
            String tmpStr;
            if (((String)selectedTables.get(i)).indexOf(46) > -1) {
                tmpStr = (String)selectedTables.get(i);
                tmpStr = tmpStr.substring(0, tmpStr.indexOf(46));
            } else {
                tmpStr = (String)selectedTables.get(i);
            }
            if (tmpStr != null && tmpStr.length() > 0) {
                buf.append(tmpStr);
            }
            if (i >= selectedTables.size() - 1) continue;
            buf.append(",");
        }
        return SQLQuery.isAddCondition(buf.toString(), table1, table2);
    }

    private static boolean isAddCondition(String selectedTables, String table1, String table2) {
        StringTokenizer st = new StringTokenizer(selectedTables, ",");
        boolean table1In = false;
        boolean table2In = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.indexOf(32) > -1 && !token.startsWith("[")) {
                token = "[" + token;
            }
            if (token.indexOf(32) > -1 && !token.endsWith("]")) {
                token = token + "]";
            }
            if (token.trim().equalsIgnoreCase(table1.trim()) || token.trim().equalsIgnoreCase("[" + table1.trim() + "]") || token.trim().equalsIgnoreCase("\"" + table1.trim() + "\"")) {
                table1In = true;
            }
            if (!token.trim().equalsIgnoreCase(table2.trim()) && !token.trim().equalsIgnoreCase("[" + table2.trim() + "]") && !token.trim().equalsIgnoreCase("\"" + table2.trim() + "\"")) continue;
            table2In = true;
        }
        return table1In && table2In;
    }

    private boolean allInnerJoins(JoinProperty[] joins) {
        for (JoinProperty join : joins) {
            if (join.joinType == 0) continue;
            return false;
        }
        return true;
    }

    private static String[] fixAliases(String[] aliases) {
        Vector<String> currentAliases = new Vector<String>();
        String[] result = new String[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            if (aliases[i].isEmpty()) {
                result[i] = aliases[i];
                continue;
            }
            int lastDot = aliases[i].lastIndexOf(46);
            result[i] = lastDot != -1 ? aliases[i].substring(lastDot + 1, aliases[i].length()) : aliases[i];
            if (currentAliases.contains(result[i])) {
                result[i] = SQLQuery.getUnique(currentAliases, result[i]);
            }
            currentAliases.add(result[i]);
        }
        return result;
    }

    private static String getUnique(Vector v, String s) {
        if (!v.contains(s)) {
            return s;
        }
        int i = 0;
        String s1 = s + "_" + i;
        while (v.contains(s1)) {
            s1 = s + "_" + ++i;
        }
        return s1;
    }

    private static boolean startWithOperator(String condition) {
        String str = condition.trim().toUpperCase();
        for (String element : OPERATOR_STRING) {
            if (str.indexOf(element) != 0) continue;
            return true;
        }
        return false;
    }
}

