/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dataview;

import java.util.Iterator;
import java.util.LinkedList;
import quadbase.datasource.dataview.JoinProperty;
import quadbase.datasource.dataview.SQLQuery;
import quadbase.datasource.dataview.SQLQueryParser;

public class SQLQueryTest {
    public static void main(String[] args) {
        SQLQueryTest.testJoinProperty();
    }

    static void testJoinProperty() {
        SQLQueryTest.testToJoinString();
    }

    static void testToJoinString() {
        JoinProperty[] joins = SQLQueryTest.getTestCase1();
        System.out.println("join string = " + SQLQuery.toJoinString(joins));
    }

    static void testPartitionJoin() {
        JoinProperty[] joins = SQLQueryTest.getTestCase1();
        LinkedList partitionedJoins = SQLQuery.partitionJoins(joins);
        Iterator it = partitionedJoins.iterator();
        int i = 0;
        while (it.hasNext()) {
            LinkedList join = (LinkedList)it.next();
            System.out.println("partition [" + i + "]");
            for (int j = 0; j < join.size(); ++j) {
                JoinProperty joinProp = (JoinProperty)join.get(j);
                if (joinProp == null) continue;
                if (joinProp.tableName1 != null) {
                    System.out.println("tableName1 = " + joinProp.tableName1);
                } else {
                    System.out.println("tableName1 = null");
                }
                if (joinProp.tableName2 != null) {
                    System.out.println("tableName2 = " + joinProp.tableName2);
                    continue;
                }
                System.out.println("tableName2 = null");
            }
            ++i;
        }
    }

    static void testBuildJoin() {
        JoinProperty[] joins = SQLQueryTest.getTestCase1();
        JoinProperty[][] builtJoins = SQLQuery.buildJoins(joins);
        for (int i = 0; i < builtJoins.length; ++i) {
            System.out.println("i = " + i + "\n");
            for (int j = 0; j < builtJoins[i].length; ++j) {
                System.out.println("j = " + j);
                if (builtJoins[i][j] == null) continue;
                if (builtJoins[i][j].tableName1 != null) {
                    System.out.println("tableName1 = " + builtJoins[i][j].tableName1);
                } else {
                    System.out.println("tableName1 = null");
                }
                if (builtJoins[i][j].tableName2 != null) {
                    System.out.println("tableName2 = " + builtJoins[i][j].tableName2);
                    continue;
                }
                System.out.println("tableName2 = null");
            }
        }
    }

    static void testSortJoin() {
        JoinProperty[] joins = SQLQueryTest.getTestCase1();
        LinkedList partitionedJoins = SQLQuery.partitionJoins(joins);
        Iterator it = partitionedJoins.iterator();
        JoinProperty[][] result = new JoinProperty[partitionedJoins.size()][];
        int i = 0;
        while (it.hasNext()) {
            result[i] = SQLQuery.sortJoin((LinkedList)it.next());
            ++i;
        }
        for (i = 0; i < result.length; ++i) {
            System.out.println("i = " + i);
            for (int j = 0; j < result[i].length; ++j) {
                System.out.println("j = " + j);
                if (result[i][j] == null) continue;
                if (result[i][j].tableName1 != null) {
                    System.out.println("tableName1 = " + result[i][j].tableName1);
                } else {
                    System.out.println("tableName1 = null");
                }
                if (result[i][j].tableName2 != null) {
                    System.out.println("tableName2 = " + result[i][j].tableName2);
                    continue;
                }
                System.out.println("tableName2 = null");
            }
        }
    }

    static void testDataView() {
    }

    static void testSqlParser() {
        String query = "SELECT Customer.id, Order.productname, [Order Info].quantity FROM Tables WHERE 1=2";
        String[] fields = SQLQueryParser.getFields(query);
        System.out.println();
        for (int i = 0; i < fields.length; ++i) {
            System.out.println("field[" + i + "] = " + fields[i]);
        }
    }

    static JoinProperty[] getTestCase1() {
        JoinProperty[] joins = new JoinProperty[6];
        joins[0] = new JoinProperty();
        joins[0].joinType = 0;
        joins[0].tableName1 = "ABC";
        joins[0].columnName1 = "ProductID";
        joins[0].tableName2 = "DEF";
        joins[0].columnName2 = "ProductID";
        joins[1] = new JoinProperty();
        joins[1].joinType = 1;
        joins[1].tableName1 = "Orders";
        joins[1].columnName1 = "OrderID";
        joins[1].tableName2 = "Order Details";
        joins[1].columnName2 = "OrderID";
        joins[2] = new JoinProperty();
        joins[2].joinType = 0;
        joins[2].tableName1 = "YYY";
        joins[2].columnName1 = "ProductID";
        joins[2].tableName2 = "DDD";
        joins[2].columnName2 = "ProductID";
        joins[3] = new JoinProperty();
        joins[3].joinType = 0;
        joins[3].tableName1 = "Products";
        joins[3].columnName1 = "ProductID";
        joins[3].tableName2 = "Customers";
        joins[3].columnName2 = "ProductID";
        joins[4] = new JoinProperty();
        joins[4].joinType = 0;
        joins[4].tableName1 = "XXX";
        joins[4].columnName1 = "ProductID";
        joins[4].tableName2 = "YYY";
        joins[4].columnName2 = "ProductID";
        joins[5] = new JoinProperty();
        joins[5].joinType = 0;
        joins[5].tableName1 = "Customers";
        joins[5].columnName1 = "ProductID";
        joins[5].tableName2 = "Orders";
        joins[5].columnName2 = "ProductID";
        return joins;
    }
}

