/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dbquery;

import java.net.URLEncoder;
import java.util.Collection;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DBQuery {
    private Object[][] columnAttrTables;
    private Object[] columnHeaders;
    private int[][] bounds;
    private String[][] joins;
    private String[] visibleTables;
    private Vector[] tableColumns;
    private String queryStr;

    public DBQuery() {
        this.columnAttrTables = new Object[0][0];
        this.columnHeaders = new Object[0];
        this.bounds = new int[0][0];
        this.joins = new String[0][0];
        this.visibleTables = new String[0];
        this.tableColumns = new Vector[0];
        this.queryStr = "";
    }

    public DBQuery(Object[][] tables, Object[] headers, int[][] bounds, String[][] joins, String[] visibleTables, Vector[] tableColumns, String sqlQuery) {
        this.columnAttrTables = tables;
        this.columnHeaders = headers;
        this.bounds = bounds;
        this.joins = joins;
        this.queryStr = sqlQuery;
        this.visibleTables = visibleTables;
        this.tableColumns = tableColumns;
    }

    public Object[][] getColumnAttrTables() {
        return this.columnAttrTables;
    }

    public Object[] getColumnHeaders() {
        return this.columnHeaders;
    }

    public int[][] getBounds() {
        return this.bounds;
    }

    public String[][] getJoins() {
        return this.joins;
    }

    public String getQueryStr() {
        return this.queryStr;
    }

    public String[] getVisibleTables() {
        return this.visibleTables;
    }

    public Vector[] getTableColumns() {
        return this.tableColumns;
    }

    public void setTables(Object[][] tables) {
        this.columnAttrTables = tables;
    }

    public void setHeaders(Object[] headers) {
        this.columnHeaders = headers;
    }

    public void setBounds(int[][] bounds) {
        this.bounds = bounds;
    }

    public void setJoins(String[][] joins) {
        this.joins = joins;
    }

    public void setQueryStr(String queryStr) {
        this.queryStr = queryStr;
    }

    public void setVisibleTables(String[] visibleTables) {
        this.visibleTables = visibleTables;
    }

    public void setTableColumns(Vector[] tableColumns) {
        this.tableColumns = tableColumns;
    }

    private JSONArray toJSArray(Object[] objs) {
        JSONArray ja = new JSONArray();
        for (Object obj : objs) {
            if (obj instanceof Vector) {
                ja.put((Object)new JSONArray((Collection)((Vector)obj)));
                continue;
            }
            ja.put(obj);
        }
        return ja;
    }

    public String toJSONString() {
        String encodedQuery = this.queryStr;
        try {
            encodedQuery = URLEncoder.encode(this.queryStr, "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jObj = new JSONObject();
        try {
            jObj.put("columnAttrTables", (Object)this.toJSArray((Object[])this.columnAttrTables));
            jObj.put("columnHeaders", (Object)this.toJSArray(this.columnHeaders));
            jObj.put("bounds", (Object)this.toJSArray((Object[])this.bounds));
            jObj.put("joins", (Object)this.toJSArray((Object[])this.joins));
            jObj.put("visibleTables", (Object)this.toJSArray(this.visibleTables));
            jObj.put("tableColumns", (Object)this.toJSArray(this.tableColumns));
            jObj.put("queryStr", (Object)encodedQuery);
        }
        catch (JSONException je) {
            je.printStackTrace();
            jObj = new JSONObject();
        }
        return jObj.toString();
    }
}

