/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.dbquery;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.Hashtable;
import java.util.Vector;
import quadbase.common.client.ReadDatabase;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasource.dbquery.DBQuery;

public class QueryReader {
    Object[][] tbl;
    Object[] header;
    String[] visibleTable;
    String[] tableAlias;
    int[][] bounds;
    String[][] joinProperties;
    private String driver;
    private String url;
    private String userName;
    private String password;
    private String JNDIName;
    private boolean useJNDIDataSource;
    private Hashtable<String, String> env = new Hashtable();
    QueryReader[] dictionaries = null;
    String[] dictionaryAlias = null;
    int[][] dictionaryBounds = null;
    Vector[] tableColumns;
    private boolean selectDistinct = false;
    private int tableNameFormat = 0;
    private QueryInParamSet paramSet = null;
    private String beforeSQL = null;
    private String afterSQL = null;

    public void loadQueryFromFile(String fileName, String ext) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        if (!fileName.toUpperCase().endsWith(("." + ext).toUpperCase())) {
            fileName = fileName + "." + ext;
        }
        DataInputStream din = readfile.getInputStream(fileName);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            while (true) {
                bout.write(din.readByte());
            }
        }
        catch (EOFException eOFException) {
            readfile.close();
            this.loadQuery(new DataInputStream(new ByteArrayInputStream(bout.toByteArray())));
            return;
        }
    }

    public void loadQuery(DataInputStream in) throws Exception {
        int i;
        int i2;
        boolean hasParam;
        int version = in.readInt();
        if (version >= 9) {
            this.useJNDIDataSource = in.readBoolean();
        }
        if (this.useJNDIDataSource) {
            this.JNDIName = Coder.decode(IOUtil.readString(in, true));
            String ctxFactory = Coder.decode(IOUtil.readString(in, true));
            String url = Coder.decode(IOUtil.readString(in, true));
            if (ctxFactory != null && !ctxFactory.equals("")) {
                this.env.put("java.naming.factory.initial", ctxFactory);
            }
            if (url != null && !url.equals("")) {
                this.env.put("java.naming.provider.url", url);
            }
        } else {
            this.driver = Coder.decode(IOUtil.readString(in, true));
            this.url = Coder.decode(IOUtil.readString(in, true));
            this.userName = Coder.decode(IOUtil.readString(in, true));
            this.password = Coder.decode(IOUtil.readString(in, true));
        }
        if (version >= 6 && (hasParam = in.readBoolean())) {
            int chartversion = in.readInt();
            this.paramSet = QueryInParamSet.read(in, chartversion);
        }
        int ct = in.readInt();
        this.visibleTable = new String[ct];
        this.tableAlias = new String[ct];
        this.bounds = new int[ct][4];
        for (i2 = ct - 1; i2 >= 0; --i2) {
            this.visibleTable[i2] = IOUtil.readString(in, true);
            this.tableAlias[i2] = IOUtil.readString(in, true);
            if (version < 8) continue;
            this.bounds[i2] = new int[]{in.readInt(), in.readInt(), in.readInt(), in.readInt()};
        }
        ct = in.readInt();
        this.joinProperties = new String[ct][5];
        for (i2 = 0; i2 < ct; ++i2) {
            for (int j = 0; j < 4; ++j) {
                this.joinProperties[i2][j] = IOUtil.readString(in, true);
            }
            this.joinProperties[i2][4] = version >= 2 ? IOUtil.readString(in, true) : "INNER";
        }
        int nRow = in.readInt();
        int nCol = in.readInt();
        this.header = new Object[nCol];
        for (i = 0; i < nCol; ++i) {
            this.header[i] = IOUtil.readStr(in);
        }
        this.tbl = new Object[nRow][nCol];
        for (i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                if (i == 4) {
                    String isShowing = IOUtil.readStr(in);
                    if (isShowing == null) {
                        this.tbl[i][j] = null;
                        continue;
                    }
                    this.tbl[i][j] = Boolean.valueOf(isShowing);
                    continue;
                }
                this.tbl[i][j] = IOUtil.readStr(in);
            }
        }
        if (version >= 3) {
            ct = in.readInt();
            this.dictionaries = new QueryReader[ct];
            this.dictionaryAlias = new String[ct];
            this.dictionaryBounds = new int[ct][];
            for (i = 0; i < ct; ++i) {
                this.dictionaryAlias[i] = IOUtil.readString(in, true);
                if (version >= 8) {
                    this.dictionaryBounds[i] = new int[]{in.readInt(), in.readInt(), in.readInt(), in.readInt()};
                }
                QueryReader lq = new QueryReader();
                lq.loadQuery(in);
                this.dictionaries[i] = lq;
            }
        }
        if (version >= 4) {
            this.selectDistinct = in.readBoolean();
        }
        if (version >= 5) {
            this.tableNameFormat = in.readInt();
        }
        if (version >= 7) {
            this.beforeSQL = IOUtil.readStr(in);
            this.afterSQL = IOUtil.readStr(in);
        }
        this.tableColumns = this.getTableColumns();
    }

    private Vector[] getTableColumns() {
        try {
            Vector[] tableCols = new Vector[this.visibleTable.length];
            ReadDatabase readDB = null;
            QbConnection conn = null;
            if (this.useJNDIDataSource) {
                readDB = new ReadDatabase(this.JNDIName, this.env);
            } else {
                if (this.driver.toLowerCase().indexOf("hsqldb") >= 0) {
                    String jdbcHeader = "jdbc:hsqldb:";
                    String tempURL = this.url.substring(jdbcHeader.length());
                    tempURL = ServerMessage.getPath(tempURL);
                    this.url = jdbcHeader + "//" + tempURL;
                }
                conn = new QbConnection(this.driver, this.url, this.userName, this.password);
                readDB = new ReadDatabase(conn);
            }
            for (int i = 0; i < this.visibleTable.length; ++i) {
                Object[][] columnInfo;
                tableCols[i] = new Vector();
                for (Object[] element : columnInfo = readDB.getTableInfo(this.visibleTable[i])) {
                    String cn = (String)element[0];
                    tableCols[i].add(cn);
                }
            }
            if (conn != null) {
                conn.close();
            }
            readDB.finalize();
            return tableCols;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DBQuery getDBQuery() {
        DBQuery dbQuery = new DBQuery(this.tbl, this.header, this.bounds, this.joinProperties, this.visibleTable, this.tableColumns, this.afterSQL);
        return dbQuery;
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public boolean isSelectDistinct() {
        return this.selectDistinct;
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }

    public QueryInParamSet getParamSet() {
        return this.paramSet;
    }

    public String getBeforeSQL() {
        return this.beforeSQL;
    }
}

