/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.parameters;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import quadbase.common.param.HtmlParameterPageWriter;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterPage;
import quadbase.common.param.Parameters;
import quadbase.datasource.ParameterizedDataSource;

public class DataSourceParameterPrompt {
    private static final boolean RESET_ENABLED = true;
    private ParameterizedDataSource dataSource;
    private String protocol = "http://";
    private String serverName;
    private int serverPort;
    private String contextPath;

    public DataSourceParameterPrompt(HttpServletRequest req, ParameterizedDataSource ds) {
        this.dataSource = ds;
        this.serverName = req.getServerName();
        this.serverPort = req.getServerPort();
        this.protocol = req.isSecure() ? "https://" : "http://";
        this.contextPath = req.getContextPath();
        if (this.contextPath == null) {
            this.contextPath = "";
        }
    }

    public String getSingleParamPage(String actionTarget) {
        StringBuffer buf = new StringBuffer();
        String paramBlock = this.getAllParamTableInPromptOrder();
        buf.append("<html>\n");
        buf.append("<head>\n");
        buf.append("<title></title>\n");
        buf.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        String eresPath = this.protocol + this.serverName + ":" + this.serverPort + this.contextPath;
        buf.append("<script type=\"text/javascript\" src=\"js/datepicker/popcalendar.js\"></script>\n");
        buf.append("<script src=\"../lib/javascript/jquery-1.11.2.min.js\" type=\"text/javascript\"></script>\n");
        buf.append("<script type=\"text/javascript\" src=\"../lib/javascript/DataTypeValidator.js\"></script>\n");
        buf.append("<script type=\"text/javascript\" src=\"" + eresPath + "/ParamOrderHandler.js\"></script>\n");
        buf.append(this.getSingleParamPageJavaScript());
        buf.append("</head>\n");
        buf.append("<body onload=\"initOnload();\">\n");
        buf.append("<form name=\"runreport\" action=\"" + actionTarget + "\" method=\"GET\" onSubmit=\"return validate();\">\n");
        buf.append("<center>\n");
        buf.append("<table>\n");
        buf.append(paramBlock);
        buf.append("</table>\n");
        buf.append("<input type=\"submit\" name=\"Submit\" value=\"Submit\">");
        buf.append("<input type=\"reset\" name=\"Reset\" value=\"Reset\">");
        buf.append("</center>\n");
        buf.append("</form>\n");
        buf.append("</body>\n");
        buf.append("</html>");
        return buf.toString();
    }

    private String getSingleParamPageJavaScript() {
        StringBuffer buf = new StringBuffer();
        buf.append("<script>\n");
        buf.append("var paramOrderHandler = new ParamOrderHandler();\n");
        buf.append("var parray = new Array(" + this.getAllParamNameInPromptOrder() + ");\n");
        buf.append("paramOrderHandler.setParamLevels(parray);\n");
        String eresContext = this.protocol + this.serverName + ":" + this.serverPort + this.contextPath;
        buf.append("paramOrderHandler.serverContext = \"" + eresContext + "\";");
        buf.append("function initOnload() {\n");
        buf.append(" \t//NOTE: init() is from popcalendar.js\n");
        buf.append("\tinit();\n");
        buf.append("\tparamOrderHandler.fromPage = \"LookupServlet\";");
        buf.append("\tparamOrderHandler.initParams();\n");
        buf.append("}\n");
        buf.append("function popCalReturnFunction() {\n");
        buf.append("\t//ctlToPlaceValue is from lib/javascript/datepicker/popcalendar.js\n");
        buf.append("\tvar paramName = ctlToPlaceValue.name;\n");
        buf.append("\tvar paramIndex = parseInt(paramName.substring(11));\n");
        buf.append("\tvar orderIndex = 0;\n");
        buf.append("\tvar counter = 0;\n");
        buf.append("\tvar pLevels = paramOrderHandler.paramLevels;\n");
        buf.append("\tfor (var i = 0; i < pLevels.length; i++) {\n");
        buf.append("\t\tfor (var j = 0; j < pLevels[i].length; j++) {\n");
        buf.append("\t\t\tif (counter == paramIndex) {\n");
        buf.append("\t\t\t\torderIndex = i;\n");
        buf.append("\t\t\t\tbreak;\n");
        buf.append("\t\t\t}\n");
        buf.append("\t\t\tcounter++;\n");
        buf.append("\t\t}\n");
        buf.append("\t}\n");
        buf.append("\tparamOrderHandler.getNextLevelParamValue(orderIndex + 1);\n");
        buf.append("}\n");
        buf.append("function validate() {\n");
        buf.append("\tvar i = 0;\n");
        buf.append("\twhile(document.getElementsByName(\"paramValue_\"+i)[0] != null) {\n");
        buf.append("\t\tvar paramElem = document.getElementsByName(\"paramValue_\"+i)[0];\n");
        buf.append("\t\tvar paramType = document.getElementsByName(\"paramType_\"+i)[0];\n");
        buf.append("\t\tif(paramElem.selectedIndex && paramElem.selectedIndex == -1) {\n");
        buf.append("\t\t\talert(\"Please select a value for each parameter\");\n");
        buf.append("\t\t\treturn false;\n");
        buf.append("\t\t} else {\n");
        buf.append("\t\t\tvar validator = new DataTypeValidator();\n");
        buf.append("\t\t\tvar paramDateFormat = document.getElementsByName(\"paramDateFormat_\"+i)[0];\n");
        buf.append("\t\t\tif(paramElem.value != null && paramType != null && paramType.value != null) {\n");
        buf.append("\t\t\t\tvar result = \"\";\n");
        buf.append("\t\t\t\tif(paramDateFormat == null)\n");
        buf.append("\t\t\t\t\t\tresult = validator.checkType(paramElem.value, paramType.value, paramDateFormat.value);\n");
        buf.append("\t\t\t\telse\n");
        buf.append("\t\t\t\t\t\tresult = validator.checkType(paramElem.value, paramType.value, null);\n");
        buf.append("\t\t\t\tif(result.length > 0) {\n");
        buf.append("\t\t\t\t\talert(result);\n");
        buf.append("\t\t\t\t\treturn false;\n");
        buf.append("\t\t\t\t}\n");
        buf.append("\t\t\t}\n");
        buf.append("\t\t}\n");
        buf.append("\t\ti++;\n");
        buf.append("\t}\n");
        buf.append("\treturn true;\n");
        buf.append("}\n");
        buf.append("</script>\n");
        return buf.toString();
    }

    public String getAllParamTableInPromptOrder() {
        ParameterPage paramPage = this.dataSource.getParameterPage();
        paramPage.setDateParameterCalendar(true, "js/datepicker");
        paramPage.setDateVariable(true, "js/datepicker");
        StringWriter writer = new StringWriter();
        HtmlParameterPageWriter paramPageWriter = new HtmlParameterPageWriter(paramPage, writer);
        try {
            paramPageWriter.writeParamTable(true);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String paramTable = writer.toString();
        return paramTable;
    }

    public String getAllParamNameInPromptOrder() {
        StringBuffer paramNames = new StringBuffer();
        OrderedParameterSet ops = this.dataSource.getParametersInSequence();
        for (int i = 0; i < ops.getOrderCount(); ++i) {
            Parameters parameters = ops.getParamsAt(i);
            paramNames.append("\"");
            if (parameters == null || parameters.size() == 0) {
                paramNames.append("\"");
                continue;
            }
            for (int j = 0; j < parameters.size(); ++j) {
                Param p = parameters.get(j);
                boolean hasValues = p.isMapToColumn() || p.getSelectionChoices() != null && p.getSelectionChoices().size() > 0 || p.getSqlSelect() != null;
                String defValStr = "";
                Object defaultVal = p.getDefaultValue();
                if (defaultVal instanceof Vector) {
                    Vector v = (Vector)defaultVal;
                    if (v.size() > 0) {
                        defValStr = v.elementAt(0).toString();
                    }
                    StringBuilder strBui = new StringBuilder();
                    strBui.append(defValStr);
                    for (int k = 0; k < v.size(); ++k) {
                        strBui.append("^").append(v.elementAt(k));
                        defValStr = defValStr + "^" + v.elementAt(k);
                    }
                    defValStr = strBui.toString();
                } else if (defaultVal != null) {
                    defValStr = defaultVal.toString();
                }
                try {
                    defValStr = URLEncoder.encode(defValStr, "UTF-8");
                }
                catch (Exception v) {
                    // empty catch block
                }
                String attrStr = p.name() + ":" + hasValues + ":" + p.getSqlType() + ":" + defValStr;
                if (j == 0) {
                    paramNames.append(attrStr);
                    continue;
                }
                paramNames.append(",").append(attrStr);
            }
            paramNames.append("\"");
            if (i >= this.dataSource.getMaxParameterOrder()) continue;
            paramNames.append(",");
        }
        return paramNames.toString();
    }
}

