/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasource.util;

import java.util.Vector;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.ISupportsDefaultSql;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryParamValuesProvider;
import quadbase.common.util.internal.DataType;

public class QueryInParam
implements quadbase.reportdesigner.util.IQueryInParam,
IQueryParamValuesProvider,
ISupportsDefaultSql {
    private String paramName;
    private String promptName;
    private boolean mapToColumn;
    private boolean mapToFunction;
    private String tableName;
    private String columnName;
    private int sqlType;
    private String sqlSelect;
    private Object defaultValue;
    private String defaultSql;
    private String allOptionLabel = null;
    private boolean allOptionEnabled = false;
    protected Object value;
    private Formula defaultValueVariable;
    protected Formula valueVariable;
    protected Vector selectionChoices;

    public QueryInParam(String paramName, String promptName, boolean mapToColumn, boolean mapToFunction, String tableName, String columnName, int sqlType, Object defaultValObj, Object value) {
        this(paramName, promptName, mapToColumn, mapToFunction, tableName, columnName, sqlType, null, defaultValObj, null, value, false, null);
    }

    public QueryInParam(String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, Object defaultValue, Object value) {
        this(paramName, promptName, mapToColumn, tableName, columnName, sqlType, null, defaultValue, value);
    }

    public QueryInParam(String paramName, String promptName, boolean mapToColumn, String tableName, String columnName, int sqlType, String sqlSelect, Object defaultValue, Object value) {
        this(paramName, promptName, mapToColumn, false, tableName, columnName, sqlType, sqlSelect, defaultValue, null, value, false, null);
    }

    public QueryInParam(String paramName, String promptName, boolean mapToColumn, boolean mapToFunction, String tableName, String columnName, int sqlType, String sqlSelect, Object defaultValue, String defaultSql, Object value, boolean allOptionEnabled, String allOptionLabel) {
        this.paramName = paramName;
        this.promptName = promptName;
        this.mapToColumn = mapToColumn;
        this.mapToFunction = mapToFunction;
        this.tableName = tableName;
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.sqlSelect = sqlSelect;
        this.defaultSql = defaultSql;
        this.allOptionEnabled = allOptionEnabled;
        this.allOptionLabel = allOptionLabel;
        if (defaultValue instanceof Formula) {
            this.defaultValueVariable = (Formula)defaultValue;
        } else {
            this.defaultValue = this.toSqlObject(defaultValue, sqlType);
        }
        if (value instanceof Formula) {
            this.valueVariable = this.valueVariable;
        } else {
            this.value = this.toSqlObject(value, sqlType);
        }
    }

    @Override
    public String getParamName() {
        return this.paramName;
    }

    @Override
    public String getPromptName() {
        return this.promptName;
    }

    @Override
    public void setPromptName(String promptName) {
        this.promptName = promptName;
    }

    public boolean isMapToColumnOnly() {
        return this.mapToColumn;
    }

    @Override
    public boolean isMapToColumn() {
        return this.mapToColumn || this.mapToFunction;
    }

    @Override
    public void setMapToColumn(boolean mapToColumn) {
        this.mapToColumn = mapToColumn;
    }

    public boolean isMapToFunctionOnly() {
        return this.mapToFunction;
    }

    public void setMapToFunction(boolean mapToFunction) {
        this.mapToFunction = mapToFunction;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public int getSqlType() {
        return this.sqlType;
    }

    @Override
    public void setSqlType(int sqlType) {
        this.sqlType = sqlType;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public void setSqlSelect(String sqlSelect) {
        this.sqlSelect = sqlSelect;
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        if (this.defaultValueVariable != null) {
            try {
                return this.defaultValueVariable.getValue();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Object getDefaultValue(QueryFileInfo fileInfo) {
        if (this.defaultSql != null && !this.defaultSql.isEmpty()) {
            try {
                Vector result = QueryParser.executeSQLSelect((IDatabaseInfo)fileInfo, this.defaultSql, fileInfo.getInSet().getParameter(), 1);
                if (result != null && result.size() == 1 && result.get(0) != null) {
                    return result.get(0);
                }
                return this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.defaultValueVariable != null) {
            try {
                return this.defaultValueVariable.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.valueVariable != null) {
            try {
                return this.valueVariable.getValue();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public Formula getDefaultValueVariable() {
        return this.defaultValueVariable;
    }

    public void setDefaultValueVariable(Formula f) {
        this.defaultValueVariable = f;
    }

    public Formula getValueVariable() {
        return this.valueVariable;
    }

    public void setValueVariable(Formula f) {
        this.valueVariable = f;
    }

    public void setSelectionChoices(Vector choices) {
        this.selectionChoices = choices;
    }

    @Override
    public Vector getSelectionChoices() {
        return this.selectionChoices;
    }

    public static QueryInParam valueOf(IQueryInParam p) {
        QueryInParam q = null;
        if (p instanceof quadbase.common.paramquery.QueryInParam) {
            quadbase.common.paramquery.QueryInParam qip = (quadbase.common.paramquery.QueryInParam)p;
            q = new QueryInParam(qip.getParamName(), qip.getPromptName(), qip.isMapToColumn(), qip.isMapToFunctionOnly(), qip.getTableName(), qip.getColumnName(), p.getSqlType(), qip.getSqlSelect(), qip.getDefaultValue(), qip.getDefaultSql(), p.getValue(), qip.isAllOptionEnabled(), qip.getAllOptionLabel());
        } else {
            q = new QueryInParam(p.getParamName(), p.getPromptName(), p.isMapToColumn(), p.getTableName(), p.getColumnName(), p.getSqlType(), p.getDefaultValue(), p.getValue());
        }
        if (p instanceof IQueryParamValuesProvider) {
            q.setSelectionChoices(((IQueryParamValuesProvider)((Object)p)).getSelectionChoices());
        }
        if (p instanceof quadbase.common.paramquery.QueryInParam) {
            q.setSqlSelect(((quadbase.common.paramquery.QueryInParam)p).getSqlSelect());
            q.setDefaultSql(((quadbase.common.paramquery.QueryInParam)p).getDefaultSql());
        }
        return q;
    }

    public String toString() {
        return this.paramName + " {\npromptName = " + this.promptName + ",\nmapToColumn = " + this.mapToColumn + ",\ntableName = " + this.tableName + ",\ncolumnName = " + this.columnName + ",\nsqlType = " + this.sqlType + ",\ndefaultValue = " + this.defaultValue + ",\nvalue = " + this.value + "}\nselectionChoices = " + this.selectionChoices;
    }

    private Object toSqlObject(Object o, int type) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof String)) {
            return o;
        }
        if (o.equals(this.allOptionLabel)) {
            return o;
        }
        try {
            return DataType.createObject((String)o, DataType.mapType(type));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getDefaultSql() {
        return this.defaultSql;
    }

    @Override
    public void setDefaultSql(String defaultSql) {
        this.defaultSql = defaultSql;
    }

    public String getAllOptionLabel() {
        return this.allOptionLabel;
    }

    public void setAllOptionLabel(String allOptionLabel) {
        this.allOptionLabel = allOptionLabel;
    }

    public boolean isAllOptionEnabled() {
        return this.allOptionEnabled;
    }

    public void setAllOptionEnabled(boolean allOptionEnabled) {
        this.allOptionEnabled = allOptionEnabled;
    }
}

