/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.DBDialog;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;

public class BigDataDialog
extends DBDialog {
    static final String[] DBNAMELIST = new String[]{"PostgreSQL, Amazon Redshift", "MongoDB", "Hadoop", "Other"};
    static final String[] DBDRIVERLIST = new String[]{"com.amazon.redshift.jdbc.Driver", "mongodb.jdbc.MongoDriver", "com.cloudera.hive.jdbc4.HS2Driver", ""};
    static final String[] DBURLLIST = new String[]{"jdbc:redshift://<HOST>:<PORT>/<DB>", "jdbc:mongo://<HOST>:<PORT>/<databaseName>", "jdbc:hive2://<Servername>:<Serverport>/<Databasename>", ""};

    public BigDataDialog(Manager manager, DefaultMutableTreeNode parent, BigDataNode node) {
        super(manager, parent, node, "Setup Big Data...");
        this.init();
        this.setPosition();
    }

    private void init() {
        super.init("Big Data Connection Information", "jdbc:postgresql:", "org.postgresql.Driver", 0, DBNAMELIST);
        this.setValues((BigDataNode)this.node);
    }

    private void setValues(BigDataNode node) {
        if (node != null) {
            String driverName = node.getDriver();
            for (int i = 0; i < DBDRIVERLIST.length; ++i) {
                if (DBDRIVERLIST[i].indexOf(driverName) < 0) continue;
                this.driverList.setSelectedIndex(i);
                break;
            }
            this.baseText.setText(node.getName());
            this.urlText.setText(node.getURL());
            this.driverText.setText(driverName);
            String name = node.getUserName();
            String pwd = node.getPassword();
            this.requireLogin.setSelected(node.isLoginRequired());
            this.savePassword.setSelected(node.isLoginRequired() && name != null && pwd != null);
            if (this.savePassword.isSelected()) {
                this.nameText.setText(name);
                this.pwdText.setText(pwd);
            }
            this.autoJoin.setSelected(node.isAutoJoin());
            this.tableNameFormat.setSelectedIndex(node.getTableNameFormat());
            this.checkMultipleDb();
        }
        this.enableButtons();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void enableButtons() {
        this.savePassword.setEnabled(this.requireLogin.isSelected());
        this.nameText.setEnabled(this.savePassword.isSelected());
        this.pwdText.setEnabled(this.savePassword.isSelected());
    }

    @Override
    BigDataNode getNode() {
        return (BigDataNode)this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.connectButton) {
            String driver = this.driverText.getText().trim();
            String url = this.urlText.getText().trim();
            String username = "";
            String password = "";
            if (this.requireLogin.isSelected() && this.savePassword.isSelected()) {
                username = this.nameText.getText().trim();
                password = this.pwdText.getText().trim();
            }
            DBInfoBasic dbInfo = new DBInfoBasic(url, driver, username, password, "");
            if (ServerMessage.useServer) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                IConnection socket = null;
                try {
                    int messageType = 32000;
                    dout.writeShort(messageType);
                    dbInfo.write(dout);
                    socket = ServerMessage.createConnection();
                    byte[] array = bstream.toByteArray();
                    socket.setContentLength(array.length);
                    socket.getOutputStream().write(array);
                    socket.getOutputStream().flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Failed to contact EspressReport server at") + " " + ServerMessage.getServerInfo() + " " + ex.getMessage());
                }
                try {
                    DataInputStream instream = new DataInputStream(socket.getInputStream());
                    int code = instream.readInt();
                    if (code != 0) {
                        throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                    }
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Connected to Big Data successfully!"));
                    instream.close();
                    socket.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("connection failed because the following exception occurred") + "\n" + t.toString());
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception code) {}
                }
            } else {
                try {
                    Connection con = dbInfo.openConnection();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Connected to Big Data successfully!"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("connection failed because the following exception occurred") + "\n" + ex.getMessage());
                }
            }
        } else if (source == this.addDbButton) {
            String s = (String)JOptionPane.showInputDialog(this, "Please enter database url", "Additional Database Dialog", 3, null, null, DBURLLIST[3]);
            if (s != null && s.length() > 0) {
                this.multipleDbModel.addElement(s);
            }
        } else if (source == this.removeDbButton) {
            if (this.multipleDbList.getSelectedValue() != null) {
                int[] selected;
                for (int element : selected = this.multipleDbList.getSelectedIndices()) {
                    this.multipleDbModel.remove(element);
                }
            }
        } else if (source == this.editDbButton) {
            if (this.multipleDbList.getSelectedValue() != null) {
                int selected = this.multipleDbList.getSelectedIndex();
                String s = (String)JOptionPane.showInputDialog(this, "Please enter database url", "Additional Database Dialog", 3, null, null, this.multipleDbList.getSelectedValue());
                if (s != null && s.length() > 0) {
                    this.multipleDbModel.setElementAt(s, selected);
                }
            }
        } else if (source == this.tableNameFormat) {
            this.checkMultipleDb();
        } else if (source == this.okButton) {
            String msg = null;
            String nodeName = this.baseText.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter database name!");
            } else if (nodeName.length() > 25) {
                msg = LanguageEncoder.getText("Database name can not be longer than 25 characters.");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.node == null) {
                this.node = new BigDataNode(nodeName);
                this.parent.add(this.node);
                this.node.add(new DefaultDataSourceNode("Queries"));
                this.node.add(new DefaultDataSourceNode("Data Views"));
            } else {
                this.node.setUserObject(nodeName);
            }
            this.node.setDriver(this.driverText.getText().trim());
            this.node.setURL(this.urlText.getText().trim());
            this.node.setLoginRequired(this.requireLogin.isSelected());
            if (this.requireLogin.isSelected() && this.savePassword.isSelected()) {
                this.node.setUserName(this.nameText.getText().trim());
                this.node.setPassword(this.pwdText.getText().trim());
            } else {
                this.node.setUserName(null);
                this.node.setPassword(null);
            }
            this.node.setAutoJoin(this.autoJoin.isSelected());
            this.node.setTableNameFormat(this.tableNameFormat.getSelectedIndex());
            if (this.tableNameFormat.getSelectedIndex() == 2) {
                Vector addDb = new Vector();
                for (int i = 0; i < this.multipleDbModel.getSize(); ++i) {
                    addDb.add(this.multipleDbModel.getElementAt(i));
                }
                this.node.setAdditionalDb(addDb);
            }
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.manager.managerPane.closeEditOrAddNode();
            this.dispose();
        } else if (source == this.driverList) {
            int selIndex = this.driverList.getSelectedIndex();
            if (selIndex >= 0 && selIndex <= DBNAMELIST.length) {
                this.urlText.setText(DBURLLIST[selIndex]);
                this.driverText.setText(DBDRIVERLIST[selIndex]);
            }
            this.checkMultipleDb();
        }
    }
}

