/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.DataTreeCellRenderer;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.IChangeDataRegistryPlus;
import quadbase.datasourcemanager.manager.LoginDialog;
import quadbase.datasourcemanager.manager.ManagerPane;
import quadbase.datasourcemanager.manager.ReadXMLTable;

public class ChooseDatabaseNodeDialog
extends JDialog
implements ActionListener {
    private String dataSourceLoc;
    JTree tree;
    DefaultMutableTreeNode dbRoot;
    JButton okButton;
    JButton cancelButton;
    JFrame frame;
    private boolean isModified = false;
    IChangeDataRegistryPlus changeDataRegistryPlus;
    Vector invisibleNodes;

    public ChooseDatabaseNodeDialog(JFrame frame, String dataSourceLoc, IChangeDataRegistryPlus plus) throws Exception {
        super(frame, LanguageEncoder.getText("Choose Database..."), true);
        this.frame = frame;
        this.dataSourceLoc = dataSourceLoc;
        this.changeDataRegistryPlus = plus;
        this.init();
        this.setPosition();
    }

    private void init() throws Exception {
        if (this.changeDataRegistryPlus != null) {
            this.invisibleNodes = this.changeDataRegistryPlus.getDataRegistryHiddenNodes(this.dataSourceLoc);
        }
        DefaultMutableTreeNode root = this.getDataSources(this.dataSourceLoc);
        this.dbRoot = this.getDatabases(root, (DefaultMutableTreeNode)root.getChildAt(0));
        this.tree = new JTree(this.dbRoot);
        this.tree.setCellRenderer(new DataTreeCellRenderer());
        this.tree.setRootVisible(false);
        this.expandAll(this.tree);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tree);
        this.tree.setSelectionRow(0);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("CANCEL"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", scrollPane);
        contentPane.add("South", buttonPanel);
    }

    private void setPosition() {
        this.pack();
        Dimension dim = this.getPreferredSize();
        dim.width = this.getPreferredSize().width * 2;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isModified() {
        return this.isModified;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.dbRoot;
    }

    private void expandAll(JTree tree) {
        int i;
        int rowCt = tree.getRowCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = tree.getPathForRow(i);
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    private DefaultMutableTreeNode getDataSources(String dataSourceLoc) throws Exception {
        DefaultMutableTreeNode root = null;
        ReadXMLTable readXML = new ReadXMLTable();
        root = readXML.getDataSources(dataSourceLoc);
        if (root == null) {
            root = ReadXMLTable.getDefaultDataSources();
        }
        return root;
    }

    private DefaultMutableTreeNode getDatabases(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) {
        int i;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        int count = node.getChildCount();
        Vector<DefaultMutableTreeNode> invisiblePath = new Vector<DefaultMutableTreeNode>();
        if (this.invisibleNodes != null && this.invisibleNodes.size() > 0) {
            for (i = 0; i < this.invisibleNodes.size(); ++i) {
                DefaultMutableTreeNode obj = ManagerPane.getNode(parent, this.invisibleNodes.elementAt(i).toString());
                if (obj == null) continue;
                invisiblePath.add(obj);
            }
        }
        for (i = 0; i < count; ++i) {
            DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!(tempNode instanceof DatabaseNode) || invisiblePath.contains(tempNode)) continue;
            DatabaseNode child = (DatabaseNode)tempNode;
            DatabaseNode temp = new DatabaseNode(child.getName());
            temp.setUserName(child.getUserName());
            temp.setPassword(child.getPassword());
            temp.setLoginRequired(child.isLoginRequired());
            temp.setDriver(child.getDriver());
            temp.setURL(child.getURL());
            root.add(temp);
        }
        return root;
    }

    public DatabaseNode getSelectedNode() {
        if (this.tree.isSelectionEmpty()) {
            return null;
        }
        return (DatabaseNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    private String[] login() {
        String[] defaultLogin = new String[]{"", ""};
        LoginDialog loginDialog = new LoginDialog(this.frame);
        loginDialog.setVisible(true);
        if (!loginDialog.isModified()) {
            return null;
        }
        defaultLogin[0] = loginDialog.getUserName();
        defaultLogin[1] = loginDialog.getPassword();
        return defaultLogin;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            DatabaseNode node = this.getSelectedNode();
            if (node == null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select a database node.\n"));
                return;
            }
            if (node.isLoginRequired() && !node.isPasswordSaved()) {
                String[] info = this.login();
                node.setUserName(info[0]);
                node.setPassword(info[1]);
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

