/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.DataTreeCellRenderer;
import quadbase.datasourcemanager.manager.IChangeDataRegistryPlus;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.ManagerPane;
import quadbase.datasourcemanager.manager.ReadXMLTable;

public class ChooseJNDIDataSourceNodeDialog
extends JDialog
implements ActionListener {
    private String dataSourceLoc;
    JTree tree;
    DefaultMutableTreeNode dbRoot;
    JButton okButton;
    JButton cancelButton;
    JFrame frame;
    private boolean isModified = false;
    IChangeDataRegistryPlus changeDataRegistryPlus;
    Vector invisibleNodes;

    public ChooseJNDIDataSourceNodeDialog(JFrame frame, String dataSourceLoc, IChangeDataRegistryPlus plus) throws Exception {
        super(frame, LanguageEncoder.getText("Choose JNDI Data Source..."), true);
        this.frame = frame;
        this.dataSourceLoc = dataSourceLoc;
        this.changeDataRegistryPlus = plus;
        this.init();
        this.setPosition();
    }

    private void init() throws Exception {
        if (this.changeDataRegistryPlus != null) {
            this.invisibleNodes = this.changeDataRegistryPlus.getDataRegistryHiddenNodes(this.dataSourceLoc);
        }
        DefaultMutableTreeNode root = this.getDataSources(this.dataSourceLoc);
        this.dbRoot = this.getJNDIDataSources(root, (DefaultMutableTreeNode)root.getChildAt(1));
        this.tree = new JTree(this.dbRoot);
        this.tree.setCellRenderer(new DataTreeCellRenderer());
        this.tree.setRootVisible(false);
        this.expandAll(this.tree);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tree);
        this.tree.setSelectionRow(0);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("CANCEL"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", scrollPane);
        contentPane.add("South", buttonPanel);
    }

    private void setPosition() {
        this.pack();
        Dimension dim = this.getPreferredSize();
        dim.width = this.getPreferredSize().width * 2;
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isModified() {
        return this.isModified;
    }

    public DefaultMutableTreeNode getRoot() {
        return this.dbRoot;
    }

    private void expandAll(JTree tree) {
        int i;
        int rowCt = tree.getRowCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = tree.getPathForRow(i);
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    private DefaultMutableTreeNode getDataSources(String dataSourceLoc) throws Exception {
        DefaultMutableTreeNode root = null;
        ReadXMLTable readXML = new ReadXMLTable();
        root = readXML.getDataSources(dataSourceLoc);
        if (root == null) {
            root = ReadXMLTable.getDefaultDataSources();
        }
        return root;
    }

    private DefaultMutableTreeNode getJNDIDataSources(DefaultMutableTreeNode parent, DefaultMutableTreeNode node) {
        int i;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        int count = node.getChildCount();
        Vector<DefaultMutableTreeNode> invisiblePath = new Vector<DefaultMutableTreeNode>();
        if (this.invisibleNodes != null && this.invisibleNodes.size() > 0) {
            for (i = 0; i < this.invisibleNodes.size(); ++i) {
                DefaultMutableTreeNode obj = ManagerPane.getNode(parent, this.invisibleNodes.elementAt(i).toString());
                if (obj == null) continue;
                invisiblePath.add(obj);
            }
        }
        for (i = 0; i < count; ++i) {
            DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!(tempNode instanceof JNDIDataSourceNode) || invisiblePath.contains(tempNode)) continue;
            JNDIDataSourceNode child = (JNDIDataSourceNode)tempNode;
            JNDIDataSourceNode temp = new JNDIDataSourceNode(child.getName());
            temp.setJNDIName(child.getJNDIName());
            temp.setContextFactory(child.getContextFactory());
            temp.setProviderURL(child.getProviderURL());
            root.add(temp);
        }
        return root;
    }

    public JNDIDataSourceNode getSelectedNode() {
        if (this.tree.isSelectionEmpty()) {
            return null;
        }
        return (JNDIDataSourceNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            JNDIDataSourceNode node = this.getSelectedNode();
            if (node == null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please select a JNDI DataSource node.\n"));
                return;
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

