/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFileQueryInfo;

public class ConfigParamSequenceDialog
extends JDialog
implements ActionListener {
    QueryFileInfo queryFileInfo;
    XMLFileQueryInfo queryInfo;
    QueryInParam[] inParam;
    QueryInParam[][] paramInSequence;
    String[] paramName;
    boolean modified;
    SpinBox[] order;
    JButton okButton;
    JButton cancelButton;
    public static final int DEFAULT_PANEL_WIDTH = 220;
    public static final int DEFAULT_PANEL_HEIGHT_PER_PARAM = 35;

    public ConfigParamSequenceDialog(JDialog dialog, QueryFileInfo queryFileInfo, QueryInParam[] inParam, QueryInParam[][] paramInSequence) {
        super(dialog, LanguageEncoder.getText("Config"), true);
        this.queryFileInfo = queryFileInfo;
        this.inParam = inParam;
        this.paramInSequence = paramInSequence;
        this.init();
        this.setPosition();
    }

    public ConfigParamSequenceDialog(JDialog dialog, XMLFileQueryInfo queryInfo, QueryInParam[] inParam, QueryInParam[][] paramInSequence) {
        super(dialog, LanguageEncoder.getText("Config"), true);
        this.queryInfo = queryInfo;
        this.inParam = inParam;
        this.paramInSequence = paramInSequence;
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Set the order of parameters")));
        this.paramName = this.queryFileInfo != null ? QueryParser.getAllParameters(this.queryFileInfo.getQuery()) : QueryParser.getAllParameters(this.queryInfo.getCondition());
        int size = this.paramName.length;
        topPanel.setPreferredSize(new Dimension(220, size * 35));
        this.order = new SpinBox[size];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        topPanel.setLayout(gridbag);
        for (int i = 0; i < size; ++i) {
            c.gridwidth = -1;
            this.order[i] = new SpinBox(1, size, 1);
            this.order[i].setPreferredSize(new Dimension(50, 20));
            gridbag.setConstraints(this.order[i], c);
            topPanel.add(this.order[i]);
            if (this.paramInSequence != null) {
                this.order[i].setValue(this.getOrder(this.paramName[i]) + 1);
            } else {
                this.order[i].setValue(1);
            }
            c.gridwidth = 0;
            JLabel label = new JLabel("      " + this.paramName[i] + "           ");
            gridbag.setConstraints(label, c);
            topPanel.add(label);
        }
        JPanel buttonPanel = new JPanel();
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        panel.add((Component)topPanel, "North");
        panel.add((Component)buttonPanel, "South");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add(panel);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.checkForValidParamSequence()) {
                int size = this.inParam.length;
                this.paramInSequence = new QueryInParam[size][size];
                int[] index = new int[size];
                for (int i = 0; i < size; ++i) {
                    int value = this.order[i].getValue() - 1;
                    if (this.inParam[i] == null) {
                        this.inParam[i] = new QueryInParam(this.paramName[i], "");
                    }
                    this.paramInSequence[value][index[value]] = this.inParam[i];
                    int n = value;
                    index[n] = index[n] + 1;
                }
                this.modified = true;
                this.setVisible(false);
                this.dispose();
            }
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean checkForValidParamSequence() {
        int minOrder;
        int maxOrder = 0;
        int[] values = new int[this.order.length];
        for (int i = 0; i < this.order.length; ++i) {
            values[i] = this.order[i].getValue();
            if (maxOrder >= values[i]) continue;
            maxOrder = values[i];
        }
        for (int i = minOrder = 1; i <= maxOrder; ++i) {
            boolean orderFound = false;
            for (int value : values) {
                if (value != i) continue;
                orderFound = true;
                break;
            }
            if (orderFound) continue;
            JOptionPane.showMessageDialog(this, "Invalid parameter sequence. Parameter order = " + i + " is not specified. Please specify all parameter orders between minOrder = " + minOrder + " and maxOrder = " + maxOrder + ".");
            return false;
        }
        return true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public QueryInParam[][] getParameterInPromptSequence() {
        return this.paramInSequence;
    }

    private int getOrder(String paramName) {
        for (int i = 0; i < this.paramInSequence.length; ++i) {
            for (int j = 0; j < this.paramInSequence[i].length; ++j) {
                if (this.paramInSequence[i][j] == null || !this.paramInSequence[i][j].getParamName().equals(paramName)) continue;
                return i;
            }
        }
        return 0;
    }
}

