/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.server.datareg.DataRegClient;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLTable;
import quadbase.querybuilder.designer.QueryMain;

public class CopyNodeDialog
extends JDialog
implements ActionListener {
    private JTextField oldNameField;
    private JTextField inputNameField;
    private JTextField dataRegistryFileField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton browseDataRegistryFileButton;
    private DefaultMutableTreeNode parent;
    private DefaultMutableTreeNode node;
    private DefaultMutableTreeNode[] databases;
    private DefaultMutableTreeNode newNode;
    private Manager manager;
    private boolean isModified = false;
    private JComboBox cb_databases = null;
    private BrowseDialog browseDialog;
    private JFileChooser fileChooser;
    private DefaultMutableTreeNode copy2Root = null;
    private String dataRegistryFileName = null;
    private final String DATAVIEWFILEEXT = ".dvw";
    private final String QUERYFILEEXT = ".qry";

    public CopyNodeDialog(Manager manager, DefaultMutableTreeNode parent, DefaultMutableTreeNode node) {
        this(manager, parent, node, null);
    }

    public CopyNodeDialog(Manager manager, DefaultMutableTreeNode parent, DefaultMutableTreeNode node, DefaultMutableTreeNode[] dbs) {
        super(manager, LanguageEncoder.getText("Copy Node..."), true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
        this.databases = dbs;
        this.init();
        this.setValues();
        this.setPosition();
    }

    private void setValues() {
        if (this.node != null && this.node instanceof QueryNode) {
            QueryNode qNode = (QueryNode)this.node;
            this.oldNameField.setText(qNode.getName());
            this.inputNameField.setText(qNode.getName() + "_copy");
        } else if (this.node != null && this.node instanceof DataViewNode) {
            DataViewNode dvNode = (DataViewNode)this.node;
            this.oldNameField.setText(dvNode.getName());
            this.inputNameField.setText(dvNode.getName() + "_copy");
        } else if (this.node != null && this.node instanceof DataViewQueryNode) {
            DataViewQueryNode dvqNode = (DataViewQueryNode)this.node;
            this.oldNameField.setText(dvqNode.getName());
            this.inputNameField.setText(dvqNode.getName() + "_copy");
        } else if (this.node != null && this.node instanceof DatabaseNode) {
            DatabaseNode dbNode = (DatabaseNode)this.node;
            this.oldNameField.setText(dbNode.getName());
            this.inputNameField.setText(dbNode.getName() + "_copy");
        }
        this.oldNameField.setEditable(false);
    }

    boolean isModified() {
        return this.isModified;
    }

    DefaultMutableTreeNode getNode() {
        return this.newNode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newNodeName = this.inputNameField.getText().trim();
        String oldName = this.oldNameField.getText().trim();
        String msg = null;
        if (e.getSource() == this.browseDataRegistryFileButton) {
            this.dataRegistryFileName = this.loadFile(new String[]{"XML"});
            if (this.dataRegistryFileName != null) {
                this.dataRegistryFileField.setText(this.dataRegistryFileName);
                ReadXMLTable readXML = new ReadXMLTable();
                try {
                    this.copy2Root = readXML.getDataSources(this.dataRegistryFileName);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (this.copy2Root == null) {
                    this.copy2Root = ReadXMLTable.getDefaultDataSources();
                }
            }
            return;
        }
        if (e.getSource() == this.okButton || e.getSource() == this.inputNameField) {
            DefaultMutableTreeNode dvNode;
            if (newNodeName == null || newNodeName.equals("")) {
                msg = LanguageEncoder.getText("Please enter the name of the node.");
            } else if (newNodeName.length() > 25) {
                msg = LanguageEncoder.getText("Node name can not be longer than 25 characters.");
            } else if (this.node instanceof DataViewNode) {
                if (this.cb_databases.getSelectedItem() == null) {
                    dvNode = this.parent instanceof JNDIDataSourceNode ? ((JNDIDataSourceNode)this.parent).getDataViewNode() : ((DatabaseNode)this.parent).getDataViewNode();
                    if (this.manager.managerPane.isChildNode(dvNode, newNodeName)) {
                        msg = newNodeName + " " + LanguageEncoder.getText("already exists!");
                    }
                } else {
                    dvNode = this.cb_databases.getSelectedItem() instanceof JNDIDataSourceNode ? ((JNDIDataSourceNode)this.cb_databases.getSelectedItem()).getDataViewNode() : ((DatabaseNode)this.cb_databases.getSelectedItem()).getDataViewNode();
                    if (this.manager.managerPane.isChildNode(dvNode, newNodeName)) {
                        msg = newNodeName + " " + LanguageEncoder.getText("already exists!");
                    }
                }
            } else if (newNodeName.equals(oldName)) {
                msg = LanguageEncoder.getText("Please enter a different name of the node.");
            } else if (!newNodeName.equals(this.node.getUserObject().toString())) {
                if (this.node instanceof QueryNode) {
                    dvNode = this.parent instanceof JNDIDataSourceNode ? ((JNDIDataSourceNode)this.parent).getDataViewNode() : ((DatabaseNode)this.parent).getDataViewNode();
                    if (this.manager.managerPane.isChildNode(dvNode, newNodeName)) {
                        msg = newNodeName + " " + LanguageEncoder.getText("already exists!");
                    }
                } else if (this.node instanceof DataViewQueryNode && this.manager.managerPane.isChildNode(this.parent, newNodeName)) {
                    msg = newNodeName + " " + LanguageEncoder.getText("already exists!");
                }
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.node != null && this.node instanceof QueryNode) {
                QueryNode qNode = this.getNewQueryNode((QueryNode)this.node, newNodeName);
                DefaultMutableTreeNode dmtNode = this.parent instanceof JNDIDataSourceNode ? ((JNDIDataSourceNode)this.parent).getQueryNode() : ((DatabaseNode)this.parent).getQueryNode();
                dmtNode.add(qNode);
                if (ServerMessage.useServer) {
                    String dataSourceLoc;
                    String eresDir = this.manager.getEresDir();
                    if (eresDir == null) {
                        eresDir = ServerMessage.eresDir;
                    }
                    if (!new File(dataSourceLoc = this.manager.managerPane.dataSourceLoc).isAbsolute()) {
                        dataSourceLoc = eresDir + "/" + dataSourceLoc;
                    }
                    this.copyNode(this.node, dmtNode, newNodeName, dataSourceLoc, dataSourceLoc);
                }
                this.newNode = qNode;
            } else if (this.node != null && this.node instanceof DataViewNode) {
                dvNode = this.getNewDataViewNode((DataViewNode)this.node, newNodeName);
                if (this.cb_databases.getSelectedItem() != null) {
                    DefaultMutableTreeNode dmtNode = this.cb_databases.getSelectedItem() instanceof JNDIDataSourceNode ? ((JNDIDataSourceNode)this.cb_databases.getSelectedItem()).getDataViewNode() : ((DatabaseNode)this.cb_databases.getSelectedItem()).getDataViewNode();
                    dmtNode.add(dvNode);
                    if (ServerMessage.useServer) {
                        String dataSourceLoc;
                        String eresDir = this.manager.getEresDir();
                        if (eresDir == null) {
                            eresDir = ServerMessage.eresDir;
                        }
                        if (!new File(dataSourceLoc = this.manager.managerPane.dataSourceLoc).isAbsolute()) {
                            dataSourceLoc = eresDir + "/" + dataSourceLoc;
                        }
                        this.copyNode(this.node, dmtNode, newNodeName, dataSourceLoc, dataSourceLoc);
                    }
                } else {
                    DefaultMutableTreeNode dmtNode = this.parent instanceof JNDIDataSourceNode ? ((JNDIDataSourceNode)this.parent).getDataViewNode() : ((DatabaseNode)this.parent).getDataViewNode();
                    dmtNode.add(dvNode);
                    if (ServerMessage.useServer) {
                        String dataSourceLoc;
                        String eresDir = this.manager.getEresDir();
                        if (eresDir == null) {
                            eresDir = ServerMessage.eresDir;
                        }
                        if (!new File(dataSourceLoc = this.manager.managerPane.dataSourceLoc).isAbsolute()) {
                            dataSourceLoc = eresDir + "/" + dataSourceLoc;
                        }
                        this.copyNode(this.node, dmtNode, newNodeName, dataSourceLoc, dataSourceLoc);
                    }
                }
                this.newNode = dvNode;
            } else if (this.node != null && this.node instanceof DataViewQueryNode) {
                DataViewQueryNode dvQueryNode = this.getNewDataViewQueryNode((DataViewQueryNode)this.node, newNodeName);
                ((DataViewNode)this.parent).add(dvQueryNode);
                if (ServerMessage.useServer) {
                    String dataSourceLoc;
                    String eresDir = this.manager.getEresDir();
                    if (eresDir == null) {
                        eresDir = ServerMessage.eresDir;
                    }
                    if (!new File(dataSourceLoc = this.manager.managerPane.dataSourceLoc).isAbsolute()) {
                        dataSourceLoc = eresDir + "/" + dataSourceLoc;
                    }
                    this.copyNode(this.node, this.parent, newNodeName, dataSourceLoc, dataSourceLoc);
                }
                this.newNode = dvQueryNode;
            } else if (this.node != null && this.node instanceof DatabaseNode) {
                DefaultMutableTreeNode bk_parent = this.parent;
                this.parent = this.node instanceof BigDataNode ? (DefaultMutableTreeNode)this.copy2Root.getChildAt(1) : (DefaultMutableTreeNode)this.copy2Root.getChildAt(0);
                DatabaseNode dbNode = this.getDatabaseNode((DatabaseNode)this.node, newNodeName);
                if (ServerMessage.useServer) {
                    String eresDir = this.manager.getEresDir();
                    if (eresDir == null) {
                        eresDir = ServerMessage.eresDir;
                    }
                    String destReg = this.dataRegistryFileName;
                    String srcReg = this.manager.managerPane.dataSourceLoc;
                    if (!new File(destReg).isAbsolute()) {
                        destReg = eresDir + "/" + destReg;
                    }
                    if (!new File(srcReg).isAbsolute()) {
                        srcReg = eresDir + "/" + srcReg;
                    }
                    this.copyNode(this.node, this.parent, newNodeName, destReg, srcReg);
                }
                this.newNode = dbNode;
                this.parent = bk_parent;
            } else {
                System.out.println("You can only copy the QueryNode, DataViewNode and DataViewQueryNode!");
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }

    private String loadFile(String[] ext) {
        int index;
        String regFileName = this.dataRegistryFileField.getText().trim();
        String regDir = null;
        if (regFileName != null && !regFileName.equals("") && regFileName.toUpperCase().endsWith(".XML") && (index = (regFileName = regFileName.replace('\\', '/')).lastIndexOf(47)) != -1) {
            regDir = regFileName.substring(0, index);
            try {
                if (regDir != null && !new FileInfo(regDir).isDirectory()) {
                    regDir = null;
                }
            }
            catch (Exception e) {
                regDir = null;
            }
        }
        regDir = this.manager.getDataRegistryDirectory();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
            ExtensionFilter fileFilter = new ExtensionFilter(ext);
            this.fileChooser.addChoosableFileFilter(fileFilter);
            this.fileChooser.setCurrentDirectory(new File(regDir));
            this.fileChooser.showDialog(this.manager, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        this.browseDialog = BrowseDialog.create(this.manager, regDir, ext);
        this.browseDialog.setVisible(true);
        return this.browseDialog.getSelectedFile();
    }

    private String getNewQueryFile(String newNodeName, boolean forDataViewNode, boolean forDataViewQueryNode) {
        String ext = forDataViewNode || forDataViewQueryNode ? ".dvw" : ".qry";
        String fileprefix = null;
        fileprefix = this.dataRegistryFileName != null ? this.dataRegistryFileName : this.manager.managerPane.dataSourceLoc;
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
        fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
        fileprefix = forDataViewNode && this.cb_databases == null ? fileprefix + "_" + this.parent.getUserObject() + "_" : (forDataViewNode && this.cb_databases.getSelectedItem() != null ? fileprefix + "_" + ((DefaultDataSourceNode)this.cb_databases.getSelectedItem()).getUserObject() + "_" : (forDataViewQueryNode ? fileprefix + "_" + ((DataViewNode)this.parent).getName() + "_" : fileprefix + "_" + this.parent.getUserObject() + "_"));
        String newQueryFile = fileprefix + newNodeName;
        String tmp = newQueryFile = newQueryFile.replace(' ', '_');
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ext).exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newQueryFile;
    }

    private QueryNode getNewQueryNode(QueryNode oldNode, String newNodeName) {
        QueryNode newQueryNode = new QueryNode(newNodeName);
        newQueryNode.setID(this.manager.getNextID());
        newQueryNode.setSQL(oldNode.getSQL());
        newQueryNode.setQueryBuilderUsed(oldNode.isQueryBuilderUsed());
        String oldQueryFile = oldNode.getQueryFile();
        if (oldNode.isQueryBuilderUsed() && oldQueryFile != null) {
            String newQueryFile = this.getNewQueryFile(newNodeName, false, false);
            newQueryNode.setQueryFile(newQueryFile);
            if (!ServerMessage.useServer) {
                CopyFile.copy(QueryMain.QUERYDIR + oldQueryFile + ".qry", QueryMain.QUERYDIR + newQueryFile + ".qry");
            }
        }
        newQueryNode.setDictionaryCompatible(oldNode.isDictionaryCompatible());
        newQueryNode.setInSet(oldNode.getInSet());
        return newQueryNode;
    }

    private DataViewNode getNewDataViewNode(DataViewNode oldNode, String newNodeName) {
        DataViewNode dvNode = new DataViewNode(newNodeName);
        dvNode.setID(this.manager.getNextID());
        dvNode.setSQL(oldNode.getSQL());
        String newQueryFile = this.getNewQueryFile(newNodeName, true, false);
        dvNode.setQueryFile(newQueryFile);
        String oldQueryFile = oldNode.getQueryFile();
        if (oldQueryFile != null) {
            CopyFile.copy(QueryMain.QUERYDIR + oldQueryFile + ".dvw", QueryMain.QUERYDIR + newQueryFile + ".dvw");
        }
        DefaultMutableTreeNode old_parent = this.parent;
        this.parent = dvNode;
        for (int i = 0; i < oldNode.getChildCount(); ++i) {
            if (!(oldNode.getChildAt(i) instanceof DataViewQueryNode)) continue;
            DataViewQueryNode newQuery = this.getNewDataViewQueryNode((DataViewQueryNode)oldNode.getChildAt(i), ((DataViewQueryNode)oldNode.getChildAt(i)).getName());
            dvNode.add(newQuery);
        }
        this.parent = old_parent;
        return dvNode;
    }

    private DataViewQueryNode getNewDataViewQueryNode(DataViewQueryNode oldNode, String newNodeName) {
        String newQueryFile;
        DataViewQueryNode dvQueryNode = new DataViewQueryNode(newNodeName);
        dvQueryNode.setID(this.manager.getNextID());
        dvQueryNode.setSQL(oldNode.getSQL());
        String newDataViewFile = this.getNewQueryFile(newNodeName, false, true);
        dvQueryNode.setDataViewFile(newDataViewFile);
        String oldQueryFile = oldNode.getQueryFile();
        String oldDataViewFile = oldNode.getDataViewFile();
        String tmp = newQueryFile = newDataViewFile + "_query";
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ".dvw").exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        newQueryFile = QueryMain.QUERYDIR + newQueryFile;
        dvQueryNode.setQueryFile(newQueryFile);
        CopyFile.copy(QueryMain.QUERYDIR + oldDataViewFile + ".dvw", QueryMain.QUERYDIR + newDataViewFile + ".dvw");
        CopyFile.copy(oldQueryFile + ".dvw", newQueryFile + ".dvw");
        return dvQueryNode;
    }

    private DatabaseNode getDatabaseNode(DatabaseNode oldNode, String newNodeName) {
        DatabaseNode dbNode = oldNode instanceof BigDataNode ? new BigDataNode(newNodeName) : new DatabaseNode(newNodeName);
        dbNode.setID(this.manager.getNextID());
        dbNode.setDriver(oldNode.getDriver());
        dbNode.setURL(oldNode.getURL());
        dbNode.setUserName(oldNode.getUserName());
        dbNode.setPassword(oldNode.getPassword());
        dbNode.setLoginRequired(oldNode.isLoginRequired());
        dbNode.setAutoJoin(oldNode.isAutoJoin());
        dbNode.setTableNameFormat(oldNode.getTableNameFormat());
        int numChild = oldNode.getChildCount();
        DefaultMutableTreeNode old_parent = this.parent;
        this.parent = dbNode;
        for (int i = 0; i < numChild; ++i) {
            DefaultDataSourceNode newNextLevelNode;
            DefaultDataSourceNode oldNextLevelNode = (DefaultDataSourceNode)oldNode.getChildAt(i);
            if (oldNextLevelNode.getUserObject().equals("Queries")) {
                newNextLevelNode = new DefaultDataSourceNode("Queries");
                dbNode.add(newNextLevelNode);
                for (int j = 0; j < oldNextLevelNode.getChildCount(); ++j) {
                    if (!(oldNextLevelNode.getChildAt(j) instanceof QueryNode)) continue;
                    QueryNode oldQueryNode = (QueryNode)oldNextLevelNode.getChildAt(j);
                    QueryNode newQueryNode = this.getNewQueryNode(oldQueryNode, oldQueryNode.getName());
                    newNextLevelNode.add(newQueryNode);
                }
                continue;
            }
            if (!oldNextLevelNode.getUserObject().equals("Data Views")) continue;
            newNextLevelNode = new DefaultDataSourceNode("Data Views");
            dbNode.add(newNextLevelNode);
            for (int k = 0; k < oldNextLevelNode.getChildCount(); ++k) {
                if (!(oldNextLevelNode.getChildAt(k) instanceof DataViewNode)) continue;
                DataViewNode oldDataViewNode = (DataViewNode)oldNextLevelNode.getChildAt(k);
                DataViewNode newDataViewNode = this.getNewDataViewNode(oldDataViewNode, oldDataViewNode.getName());
                newNextLevelNode.add(newDataViewNode);
            }
        }
        this.parent = old_parent;
        return dbNode;
    }

    private void init() {
        this.setBackground(Color.lightGray);
        int row = 2;
        if (this.node instanceof DataViewNode || this.node instanceof DatabaseNode) {
            row = 3;
        }
        JPanel labelPanel = new JPanel(new GridLayout(row, 1, 5, 5));
        JPanel textPanel = new JPanel(new GridLayout(row, 1, 5, 5));
        JPanel browsePanel = null;
        EmptyBorder inset = new EmptyBorder(10, 10, 10, 5);
        labelPanel.setBorder(inset);
        inset = new EmptyBorder(10, 5, 10, 10);
        textPanel.setBorder(inset);
        labelPanel.add(new JLabel(LanguageEncoder.getText("Original Name :")));
        labelPanel.add(new JLabel(LanguageEncoder.getText("New Name :")));
        this.oldNameField = new JTextField(25);
        textPanel.add(this.oldNameField);
        this.inputNameField = new JTextField(25);
        textPanel.add(this.inputNameField);
        if (this.node instanceof DataViewNode) {
            labelPanel.add(new JLabel(LanguageEncoder.getText("Destination Database :")));
            this.cb_databases = new JComboBox<DefaultMutableTreeNode>(this.databases);
            this.cb_databases.setSelectedItem(this.parent);
            textPanel.add(this.cb_databases);
        }
        if (this.node instanceof DatabaseNode) {
            browsePanel = new JPanel(new GridLayout(row, 1, 5, 5));
            labelPanel.add(new JLabel(LanguageEncoder.getText("Destination Data Registry :")));
            this.dataRegistryFileField = new JTextField(25);
            textPanel.add(this.dataRegistryFileField);
            browsePanel.add(new JLabel(""));
            browsePanel.add(new JLabel(""));
            this.browseDataRegistryFileButton = new JButton(LanguageEncoder.getText("Browse Data Registry..."));
            browsePanel.add(this.browseDataRegistryFileButton);
            this.browseDataRegistryFileButton.addActionListener(this);
        }
        this.inputNameField.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add("West", labelPanel);
        p1.add("Center", textPanel);
        if (browsePanel != null) {
            p1.add("East", browsePanel);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void copyNode(DefaultMutableTreeNode src, DefaultMutableTreeNode destParent, String destName, String destFile, String srcFile) {
        try {
            if (!DataRegClient.copyNode(src, destParent, destName, destFile, srcFile)) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), LanguageEncoder.getText("failed to copy node, the destination node already exists, or the node or its subnodes is currently being used by another user."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), e.getMessage());
        }
    }
}

