/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.SalesForceParametersDialog;
import quadbase.datasourcemanager.manager.XMLParametersDialog;

public class CustomSelectionDialog
extends JDialog
implements ActionListener,
ItemListener {
    private Vector availColumn = new Vector();
    private JRadioButton textButton;
    private JRadioButton columnButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton okButton;
    private JButton cancelButton;
    private JButton upButton;
    private JButton downButton;
    private JTextField textValues;
    private JComboBox columnChoices;
    private JComboBox typeChoices;
    private JList columnValues;
    private JList selectedValues;
    private QueryFileInfo queryFileInfo = null;
    private XMLFileQueryInfo xmlQueryInfo = null;
    private SalesForceQueryFileInfo sfQueryInfo = null;
    private int curTypeChoicesIndex = -1;
    private boolean modified = false;
    private boolean inProcess = false;
    private boolean pressNo = false;
    private int lastSelectedIndex = -1;
    private int lastCurIndex = -1;

    public CustomSelectionDialog(JDialog parent, QueryFileInfo qfi, Vector availColumn, int sqlType, Vector existingValues) {
        super((Dialog)parent, true);
        this.queryFileInfo = qfi;
        if (availColumn != null) {
            this.availColumn = availColumn;
        }
        this.init(sqlType, existingValues);
        this.setPosition();
    }

    public CustomSelectionDialog(JDialog parent, XMLFileQueryInfo queryInfo, int sqlType, Vector existingValues) {
        super((Dialog)parent, true);
        this.xmlQueryInfo = queryInfo;
        this.init(sqlType, existingValues);
        this.setPosition();
    }

    public CustomSelectionDialog(JDialog parent, SalesForceQueryFileInfo sfQueryInfo, Vector availColumn, int sqlType, Vector existingValues) {
        super((Dialog)parent, true);
        this.sfQueryInfo = sfQueryInfo;
        if (availColumn != null) {
            this.availColumn = availColumn;
        }
        this.init(sqlType, existingValues);
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(int sqlType, Vector existingValues) {
        int i;
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Setup Custom Selection Choices"));
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new TitledBorder(LanguageEncoder.getText("Build Selections")));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(gbl);
        ButtonGroup group = new ButtonGroup();
        this.textButton = new JRadioButton(LanguageEncoder.getText("Enter values as text"));
        group.add(this.textButton);
        this.textButton.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.anchor = 16;
        gbl.setConstraints(this.textButton, gbc);
        contentPane.add(this.textButton);
        Dimension dim = new Dimension(50, 5);
        Box.Filler filler = new Box.Filler(dim, dim, dim);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(filler, gbc);
        contentPane.add(filler);
        this.textValues = new JTextField();
        this.textValues.addActionListener(this);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbl.setConstraints(this.textValues, gbc);
        contentPane.add(this.textValues);
        this.columnButton = new JRadioButton(LanguageEncoder.getText("Choose values from column"));
        group.add(this.columnButton);
        this.columnButton.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 0;
        gbl.setConstraints(this.columnButton, gbc);
        contentPane.add(this.columnButton);
        filler = new Box.Filler(dim, dim, dim);
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbl.setConstraints(filler, gbc);
        contentPane.add(filler);
        this.columnChoices = new JComboBox();
        if (this.queryFileInfo != null || this.sfQueryInfo != null) {
            for (int i2 = 0; i2 < this.availColumn.size(); ++i2) {
                this.columnChoices.addItem(this.getAvailColumn(i2).getCompleteName());
            }
        } else {
            XMLFieldInfo[] fieldInfo;
            for (XMLFieldInfo element : fieldInfo = this.xmlQueryInfo.getConditionInfo()) {
                this.columnChoices.addItem(element.getColumnName());
            }
        }
        gbc.gridx = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 18;
        gbc.fill = 2;
        gbl.setConstraints(this.columnChoices, gbc);
        contentPane.add(this.columnChoices);
        this.columnChoices.addActionListener(this);
        this.columnValues = new JList(new DefaultListModel());
        JScrollPane scroll = new JScrollPane();
        dim = scroll.getPreferredSize();
        dim.width = 200;
        dim.height = 100;
        scroll.setPreferredSize(dim);
        scroll.getViewport().setView(this.columnValues);
        this.columnValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    CustomSelectionDialog.this.doAdd();
                }
            }
        });
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 1;
        gbl.setConstraints(scroll, gbc);
        contentPane.add(scroll);
        this.addButton = new JButton(LanguageEncoder.getText("ADD >>"));
        this.addButton.addActionListener(this);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbl.setConstraints(this.addButton, gbc);
        contentPane.add(this.addButton);
        this.removeButton = new JButton(LanguageEncoder.getText("<< REMOVE"));
        this.removeButton.addActionListener(this);
        gbc.gridy = 2;
        gbl.setConstraints(this.removeButton, gbc);
        contentPane.add(this.removeButton);
        this.selectedValues = new JList(new DefaultListModel());
        scroll = new JScrollPane();
        dim = scroll.getPreferredSize();
        dim.width = 200;
        scroll.setPreferredSize(dim);
        scroll.getViewport().setView(this.selectedValues);
        this.selectedValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    CustomSelectionDialog.this.doRemove();
                }
            }
        });
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridheight = 4;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbl.setConstraints(scroll, gbc);
        contentPane.add(scroll);
        if (existingValues != null && existingValues.size() > 0) {
            DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
            for (int i3 = 0; i3 < existingValues.size(); ++i3) {
                if (existingValues.elementAt(i3) == null) continue;
                listModel.addElement(existingValues.elementAt(i3));
            }
        }
        JLabel label = new JLabel(LanguageEncoder.getText("Selection Choices:"));
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 16;
        gbc.fill = 0;
        gbl.setConstraints(label, gbc);
        contentPane.add(label);
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.gridheight = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 15;
        this.upButton = new JButton(new ArrowIcon(true));
        Insets is = this.upButton.getMargin();
        is.left = 2;
        is.right = 2;
        this.upButton.setMargin(is);
        this.upButton.addActionListener(this);
        gbl.setConstraints(this.upButton, gbc);
        contentPane.add(this.upButton);
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.anchor = 11;
        this.downButton = new JButton(new ArrowIcon(false));
        is = this.downButton.getMargin();
        is.left = 2;
        is.right = 2;
        this.downButton.setMargin(is);
        this.downButton.addActionListener(this);
        gbl.setConstraints(this.downButton, gbc);
        contentPane.add(this.downButton);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new FlowLayout(0));
        leftPanel.add(new JLabel("Data Type:"));
        this.typeChoices = new JComboBox();
        if (this.queryFileInfo != null) {
            for (int element : INParametersDialog.choiceMapToType) {
                this.typeChoices.addItem(DataType.getTypeName(element));
            }
            this.typeChoices.setSelectedIndex(11);
            for (i = 0; i < INParametersDialog.choiceMapToType.length; ++i) {
                if (sqlType != INParametersDialog.choiceMapToType[i]) continue;
                this.typeChoices.setSelectedIndex(i);
            }
        } else if (this.xmlQueryInfo != null) {
            for (String element : XMLParametersDialog.XMLDataType) {
                this.typeChoices.addItem(element);
            }
            for (i = 0; i < XMLParametersDialog.XMLDataType.length; ++i) {
                if (sqlType != DataType.findType(XMLParametersDialog.XMLDataType[i])) continue;
                this.typeChoices.setSelectedIndex(i);
            }
        } else {
            for (int element : SalesForceParametersDialog.choiceMapToType) {
                this.typeChoices.addItem(DataType.getTypeName(element));
            }
            this.typeChoices.setSelectedIndex(0);
            for (i = 0; i < SalesForceParametersDialog.choiceMapToType.length; ++i) {
                if (sqlType != SalesForceParametersDialog.choiceMapToType[i]) continue;
                this.typeChoices.setSelectedIndex(i);
            }
        }
        leftPanel.add(this.typeChoices);
        this.typeChoices.addItemListener(this);
        this.curTypeChoicesIndex = this.typeChoices.getSelectedIndex();
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        rightPanel.add(this.okButton);
        rightPanel.add(this.cancelButton);
        bottomPanel.add((Component)leftPanel, "Center");
        bottomPanel.add((Component)rightPanel, "East");
        JPanel realContentPane = (JPanel)this.getContentPane();
        realContentPane.setLayout(new BorderLayout());
        realContentPane.add((Component)contentPane, "Center");
        realContentPane.add((Component)bottomPanel, "South");
        this.textButton.setSelected(true);
        this.setButtonsEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.textButton) {
            if (this.textButton.isSelected()) {
                this.columnValues.clearSelection();
            }
        } else if (e.getSource() == this.columnButton) {
            if (this.columnButton.isSelected()) {
                this.doSelectColumn();
            }
        } else if (e.getSource() == this.addButton || e.getSource() == this.textValues) {
            this.doAdd();
        } else if (e.getSource() == this.removeButton) {
            this.doRemove();
        } else if (e.getSource() == this.columnChoices) {
            this.doSelectColumn();
        } else if (e.getSource() == this.okButton) {
            this.modified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.upButton) {
            this.doMoveUp();
        } else if (e.getSource() == this.downButton) {
            this.doMoveDown();
        }
        this.setButtonsEnabled();
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getCurrentType() {
        if (this.selectedValues.getModel().getSize() > 0) {
            return DataType.mapType(this.getSQLType());
        }
        return -1;
    }

    private void updateColumnChoice(int type) {
        int i;
        ActionListener[] listeners;
        for (ActionListener listener : listeners = this.columnChoices.getActionListeners()) {
            this.columnChoices.removeActionListener(listener);
        }
        Object selectedItem = this.columnChoices.getSelectedItem();
        this.columnChoices.removeAllItems();
        if (type == -1) {
            if (this.queryFileInfo != null || this.sfQueryInfo != null) {
                for (i = 0; i < this.availColumn.size(); ++i) {
                    this.columnChoices.addItem(this.getAvailColumn(i).getCompleteName());
                }
            } else {
                XMLFieldInfo[] fieldInfo;
                for (XMLFieldInfo element : fieldInfo = this.xmlQueryInfo.getConditionInfo()) {
                    this.columnChoices.addItem(element.getColumnName());
                }
            }
        } else if (this.queryFileInfo != null || this.sfQueryInfo != null) {
            for (i = 0; i < this.availColumn.size(); ++i) {
                if (DataType.mapType(this.getAvailColumn(i).getSqlType()) != type) continue;
                this.columnChoices.addItem(this.getAvailColumn(i).getCompleteName());
            }
        } else {
            XMLFieldInfo[] fieldInfo;
            for (XMLFieldInfo element : fieldInfo = this.xmlQueryInfo.getConditionInfo()) {
                if (DataType.mapType(DataType.findType(element.getDataType())) != type) continue;
                this.columnChoices.addItem(element.getColumnName());
            }
        }
        this.columnChoices.setSelectedItem(selectedItem);
        for (ActionListener listener : listeners) {
            this.columnChoices.addActionListener(listener);
        }
    }

    private void doSelectColumn() {
        if (!this.columnButton.isSelected()) {
            return;
        }
        int currentType = this.getCurrentType();
        this.updateColumnChoice(currentType);
        Object item = this.columnChoices.getSelectedItem();
        if (item != null) {
            AvailColumn column;
            boolean success = true;
            if (currentType == -1) {
                success = this.setTypeChoice();
            }
            Vector distinctValue = new Vector();
            if (this.queryFileInfo != null) {
                column = this.getAvailColumn(item.toString());
                try {
                    distinctValue = QueryParser.getDistinctValues(this.queryFileInfo, column.getTableName(), column.getColumnName());
                }
                catch (Exception exception) {}
            } else if (this.xmlQueryInfo != null) {
                try {
                    distinctValue = QueryParser.getDistinctValues(this.xmlQueryInfo, item.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                column = this.getAvailColumn(item.toString());
                distinctValue = this.sfQueryInfo.getDistinctValues(column.getTableName(), column.getColumnName());
            }
            DefaultListModel listModel = (DefaultListModel)this.columnValues.getModel();
            listModel.removeAllElements();
            int size = distinctValue.size();
            for (int i = 0; i < size; ++i) {
                if (distinctValue.elementAt(i) == null) continue;
                listModel.addElement(distinctValue.elementAt(i).toString());
            }
            if (success) {
                this.columnValues.setEnabled(true);
            } else {
                this.columnValues.setEnabled(false);
            }
            this.columnValues.validate();
            this.columnValues.repaint();
        }
    }

    private void doAdd() {
        int currentType;
        int dataType = DataType.mapType(this.getSQLType());
        String[] values = null;
        if (this.columnButton.isSelected()) {
            Object[] selected = this.columnValues.getSelectedValues();
            values = new String[selected.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = selected[i].toString();
            }
        } else if (!this.textValues.getText().equals("")) {
            values = new String[]{this.textValues.getText()};
            this.textValues.setText("");
        }
        if (values == null) {
            return;
        }
        boolean error = false;
        boolean added = false;
        DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
        for (String value : values) {
            try {
                Object obj = DataType.createObject(value, dataType);
                if (!listModel.contains(obj)) {
                    listModel.addElement(obj);
                }
                added = true;
            }
            catch (Exception ex) {
                error = true;
            }
        }
        if (added) {
            this.setButtonsEnabled();
            this.selectedValues.validate();
            this.selectedValues.repaint();
        }
        if (error) {
            String typename = DataType.getTypeName(this.getSQLType());
            if (dataType != 10) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("One or more values do not match the '") + typename + LanguageEncoder.getText("' data type."));
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("The value does not match the '") + typename + LanguageEncoder.getText("' data type. \n Please enter one value at a time for the '") + typename + LanguageEncoder.getText("' data type."));
            }
        }
        if ((currentType = this.getCurrentType()) != -1) {
            this.updateColumnChoice(currentType);
        }
    }

    private void doRemove() {
        int[] selected = this.selectedValues.getSelectedIndices();
        DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
        for (int i = selected.length - 1; i >= 0; --i) {
            listModel.removeElementAt(selected[i]);
        }
        this.setButtonsEnabled();
        if (listModel.getSize() == 0) {
            this.doSelectColumn();
        }
        this.selectedValues.validate();
        this.selectedValues.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() != this.typeChoices) {
            return;
        }
        if (this.inProcess) {
            return;
        }
        this.inProcess = true;
        int selectedIndex = this.typeChoices.getSelectedIndex();
        if (this.pressNo && this.curTypeChoicesIndex == this.lastCurIndex && this.lastSelectedIndex == selectedIndex) {
            this.typeChoices.setSelectedIndex(this.curTypeChoicesIndex);
            this.inProcess = false;
            return;
        }
        this.pressNo = false;
        this.lastCurIndex = -1;
        this.lastSelectedIndex = -1;
        if (selectedIndex == this.curTypeChoicesIndex) {
            this.inProcess = false;
            return;
        }
        if (this.selectedValues.getModel().getSize() > 0 || this.columnButton.isSelected()) {
            JMessageDialog msgDialog = new JMessageDialog((Dialog)this, "Question", LanguageEncoder.getText("All the selection choices will be removed. Do you want to continue to change data type?"), 2);
            int response = msgDialog.getResponse();
            if (response == 4) {
                DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
                listModel.removeAllElements();
            } else {
                this.pressNo = true;
                this.lastSelectedIndex = selectedIndex;
                this.lastCurIndex = this.curTypeChoicesIndex;
                this.typeChoices.setSelectedIndex(this.curTypeChoicesIndex);
                this.inProcess = false;
                return;
            }
        }
        this.curTypeChoicesIndex = selectedIndex;
        this.inProcess = false;
    }

    private void setButtonsEnabled() {
        if (this.textButton.isSelected()) {
            this.columnChoices.setEnabled(false);
            this.columnValues.setEnabled(false);
            this.textValues.setEnabled(true);
        } else {
            this.textValues.setEnabled(false);
            this.columnChoices.setEnabled(true);
            this.columnValues.setEnabled(true);
        }
    }

    private AvailColumn getAvailColumn(int index) {
        return (AvailColumn)this.availColumn.elementAt(index);
    }

    private AvailColumn getAvailColumn(String name) {
        for (int i = 0; i < this.availColumn.size(); ++i) {
            if (!((AvailColumn)this.availColumn.elementAt(i)).getCompleteName().equals(name)) continue;
            return (AvailColumn)this.availColumn.elementAt(i);
        }
        return null;
    }

    private boolean setTypeChoice() {
        int index = this.columnChoices.getSelectedIndex();
        int willSelectIndex = -1;
        if (this.queryFileInfo != null) {
            AvailColumn column = this.getAvailColumn(index);
            for (int i = 0; i < INParametersDialog.choiceMapToType.length; ++i) {
                if (column.getSqlType() != INParametersDialog.choiceMapToType[i]) continue;
                willSelectIndex = i;
            }
        } else if (this.xmlQueryInfo != null) {
            String datatype = this.xmlQueryInfo.getConditionInfo()[index].getDataType();
            for (int i = 0; i < XMLParametersDialog.XMLDataType.length; ++i) {
                if (!datatype.equals(XMLParametersDialog.XMLDataType[i])) continue;
                willSelectIndex = i;
            }
        } else {
            AvailColumn column = this.getAvailColumn(index);
            for (int i = 0; i < SalesForceParametersDialog.choiceMapToType.length; ++i) {
                if (column.getSqlType() != SalesForceParametersDialog.choiceMapToType[i]) continue;
                willSelectIndex = i;
            }
        }
        if (willSelectIndex >= 0) {
            this.typeChoices.setSelectedIndex(willSelectIndex);
            return true;
        }
        return false;
    }

    public int getSQLType() {
        if (this.queryFileInfo != null) {
            return INParametersDialog.choiceMapToType[this.typeChoices.getSelectedIndex()];
        }
        if (this.xmlQueryInfo != null) {
            return DataType.findType(XMLParametersDialog.XMLDataType[this.typeChoices.getSelectedIndex()]);
        }
        return SalesForceParametersDialog.choiceMapToType[this.typeChoices.getSelectedIndex()];
    }

    public Vector getSelectedValues() {
        Vector ret = new Vector();
        DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ret.addElement(listModel.elementAt(i));
        }
        return ret;
    }

    private void doMoveUp() {
        int i;
        int[] indices = this.selectedValues.getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return;
        }
        int insertIndex = indices[0] - 1;
        if (insertIndex < 0) {
            insertIndex = 0;
        }
        DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
        Vector movingObjs = new Vector();
        for (i = indices.length - 1; i >= 0; --i) {
            movingObjs.add(listModel.remove(indices[i]));
        }
        for (i = 0; i < movingObjs.size(); ++i) {
            listModel.add(insertIndex, movingObjs.elementAt(i));
        }
        this.selectedValues.setSelectionInterval(insertIndex, insertIndex + indices.length - 1);
    }

    private void doMoveDown() {
        int i;
        int[] indices = this.selectedValues.getSelectedIndices();
        if (indices == null || indices.length == 0) {
            return;
        }
        int insertIndex = indices[indices.length - 1] + 2;
        DefaultListModel listModel = (DefaultListModel)this.selectedValues.getModel();
        if (insertIndex > listModel.getSize()) {
            insertIndex = listModel.getSize();
        }
        insertIndex -= indices.length;
        Vector movingObjs = new Vector();
        for (i = indices.length - 1; i >= 0; --i) {
            movingObjs.add(listModel.remove(indices[i]));
        }
        for (i = 0; i < movingObjs.size(); ++i) {
            listModel.add(insertIndex, movingObjs.elementAt(i));
        }
        this.selectedValues.setSelectionInterval(insertIndex, insertIndex + indices.length - 1);
    }

    private class ArrowIcon
    implements Icon {
        private boolean up;

        public ArrowIcon(boolean s) {
            this.up = s;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            if (this.up) {
                g.fillPolygon(new int[]{x + 2, x + 14, x + 8}, new int[]{y + 14, y + 14, y + 2}, 3);
            } else {
                g.fillPolygon(new int[]{x + 2, x + 14, x + 8}, new int[]{y + 2, y + 2, y + 13}, 3);
            }
        }
    }
}

