/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.chart.IOUtil2;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;

public class DBDialog
extends JDialog
implements ActionListener,
ItemListener {
    JTextField urlText;
    JTextField nameText;
    JTextField driverText;
    JTextField baseText;
    JComboBox driverList;
    JPasswordField pwdText;
    JCheckBox requireLogin;
    JCheckBox savePassword;
    JCheckBox autoJoin;
    JButton okButton;
    JButton cancelButton;
    JButton connectButton;
    JButton addDbButton;
    JButton editDbButton;
    JButton removeDbButton;
    protected JComboBox tableNameFormat = null;
    protected JList multipleDbList = null;
    protected DefaultListModel multipleDbModel = null;
    protected JPanel multipleDbPanel = null;
    protected boolean isModified = false;
    DefaultMutableTreeNode parent;
    DatabaseNode node;
    Manager manager;
    static final String[] DBNAMELIST = new String[]{"DB2", "HSQL", "MS-ACCESS (ODBC)", "MS SQL SERVER (all versions)", "MS SQL SERVER (2005 and newer)", "MySQL", "Oracle", "PointBase", "PostgreSQL", "Sybase", "Sybase-ADS", "Informix", "Pervasive", "Other"};
    static final String[] DBDRIVERLIST = new String[]{"com.ibm.db2.jcc.DB2Driver", "org.hsqldb.jdbcDriver", "sun.jdbc.odbc.JdbcOdbcDriver", "net.sourceforge.jtds.jdbc.Driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "com.mysql.jdbc.Driver", "oracle.jdbc.driver.OracleDriver", "com.pointbase.jdbc.jdbcUniversalDriver", "org.postgresql.Driver", "com.sybase.jdbc2.jdbc.SybDriver", "com.extendedsystems.jdbc.advantage.ADSDriver", "com.informix.jdbc.IfxDriver", "com.pervasive.jdbc.v2.Driver", ""};
    static final String[] DBURLLIST = new String[]{"jdbc:db2://<HOST>:<PORT>/<DB>", "jdbc:hsqldb://<PATH TO DB>", "jdbc:odbc:<DB_NAME>", "jdbc:jtds:sqlserver://<HOST>:<PORT>/<DB>", "jdbc:sqlserver://<HOST>:<PORT>;DatabaseName=<DB>;SelectMethod=cursor", "jdbc:mysql://<HOST>:<PORT>/<DB>", "jdbc:oracle:thin:@<HOST>:<PORT>:<SID>", "jdbc:pointbase://embedded[:<PORT>]/<DB>", "jdbc:postgresql://<HOST>:<PORT>/<DB>", "jdbc:sybase:Tds:<HOST>:<PORT>", "jdbc:extendedsystems:advantage://<HOST>:<PORT>;catalog=<PATH>", "jdbc:informix-sqli://<HOST>:<PORT>/<databaseName>:informixserver=<server_name>", "jdbc:pervasive://<HOST>:<PORT>/<databaseName>?transport=tcp", ""};

    public DBDialog(Manager manager, DefaultMutableTreeNode parent, DatabaseNode node) {
        this(manager, parent, node, "Setup Database...");
        this.init();
        this.setPosition();
    }

    public DBDialog(Manager manager, DefaultMutableTreeNode parent, DatabaseNode node, String title) {
        super(manager, LanguageEncoder.getText(title), true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
    }

    private void init() {
        this.init("Database Information", "jdbc:odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", 2, DBNAMELIST);
        this.setValues(this.node);
    }

    protected void init(String title, String url, String driver, int driverlist, String[] dbnamelist) {
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        upperPanel.setBorder(new TitledBorder(LanguageEncoder.getText(title)));
        JPanel bpanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        bpanel.setLayout(gbl);
        this.baseText = new JTextField(25);
        this.urlText = new JTextField(url, 25);
        this.driverText = new JTextField(driver, 25);
        this.nameText = new JTextField("", 25);
        this.pwdText = new JPasswordField("", 25);
        this.driverList = new JComboBox<String>(dbnamelist);
        this.driverList.setSelectedIndex(driverlist);
        this.driverList.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 10, 0, 5);
        JLabel comp = new JLabel(LanguageEncoder.getText("Name:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridy = 1;
        comp = new JLabel(LanguageEncoder.getText("Driver List:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 10, 0, 5);
        comp = new JLabel(LanguageEncoder.getText("URL:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridy = 3;
        comp = new JLabel(LanguageEncoder.getText("Driver:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridy = 4;
        comp = new JLabel(LanguageEncoder.getText("User Name:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridy = 5;
        comp = new JLabel(LanguageEncoder.getText("Password:"));
        gbl.setConstraints(comp, gbc);
        bpanel.add(comp);
        gbc.gridy = 6;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 10, 10, 5);
        gbc.gridwidth = 2;
        this.requireLogin = new JCheckBox(LanguageEncoder.getText("Require Login"));
        gbl.setConstraints(this.requireLogin, gbc);
        bpanel.add(this.requireLogin);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        this.savePassword = new JCheckBox(LanguageEncoder.getText("Save Password"));
        gbl.setConstraints(this.savePassword, gbc);
        bpanel.add(this.savePassword);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 0, 0, 10);
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        gbl.setConstraints(this.baseText, gbc);
        bpanel.add(this.baseText);
        gbc.gridy = 1;
        gbl.setConstraints(this.driverList, gbc);
        bpanel.add(this.driverList);
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 0, 0, 10);
        gbl.setConstraints(this.urlText, gbc);
        bpanel.add(this.urlText);
        gbc.gridy = 3;
        gbl.setConstraints(this.driverText, gbc);
        bpanel.add(this.driverText);
        gbc.gridy = 4;
        gbl.setConstraints(this.nameText, gbc);
        bpanel.add(this.nameText);
        gbc.gridy = 5;
        gbl.setConstraints(this.pwdText, gbc);
        bpanel.add(this.pwdText);
        this.requireLogin.addItemListener(this);
        this.savePassword.addItemListener(this);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new FlowLayout(1));
        this.connectButton = new JButton(LanguageEncoder.getText("Test Connection"));
        cpanel.add(this.connectButton);
        this.connectButton.addActionListener(this);
        upperPanel.add("Center", bpanel);
        upperPanel.add("South", cpanel);
        JPanel optionPanel = new JPanel();
        optionPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Default Options")));
        gbc = new GridBagConstraints();
        gbl = new GridBagLayout();
        optionPanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 10, 5, 10);
        gbc.anchor = 17;
        this.autoJoin = new JCheckBox(LanguageEncoder.getText("Auto Join"));
        gbl.setConstraints(this.autoJoin, gbc);
        optionPanel.add(this.autoJoin);
        this.autoJoin.setSelected(true);
        gbc.insets = new Insets(0, 10, 10, 10);
        this.tableNameFormat = new JComboBox<String>(new String[]{"Unqualified Table Name", "2-Part Qualified Table Name", "3-Part Qualified Table Name"});
        gbl.setConstraints(this.tableNameFormat, gbc);
        optionPanel.add(this.tableNameFormat);
        this.tableNameFormat.addActionListener(this);
        this.multipleDbPanel = new JPanel(new BorderLayout());
        this.multipleDbPanel.setBorder(new CompoundBorder(new TitledBorder(LanguageEncoder.getText("Multiple Database Options")), new EmptyBorder(0, 10, 10, 10)));
        JLabel multipledb = new JLabel("Specify additional databases");
        this.multipleDbPanel.add("North", multipledb);
        this.multipleDbModel = new DefaultListModel();
        this.multipleDbList = new JList(this.multipleDbModel);
        this.multipleDbList.setVisibleRowCount(4);
        JScrollPane scrollpane = new JScrollPane(this.multipleDbList);
        this.multipleDbPanel.add("Center", scrollpane);
        JPanel multiDbButPanel = new JPanel();
        this.addDbButton = new JButton("Add");
        this.addDbButton.addActionListener(this);
        multiDbButPanel.add(this.addDbButton);
        this.editDbButton = new JButton("Edit");
        this.editDbButton.addActionListener(this);
        multiDbButPanel.add(this.editDbButton);
        this.removeDbButton = new JButton("Remove");
        this.removeDbButton.addActionListener(this);
        multiDbButPanel.add(this.removeDbButton);
        this.multipleDbPanel.add("South", multiDbButPanel);
        this.setMultipleDbEnabled(false);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)upperPanel, "North");
        mainPanel.add((Component)optionPanel, "Center");
        mainPanel.add((Component)this.multipleDbPanel, "South");
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
    }

    private void setMultipleDbEnabled(boolean enable) {
        this.multipleDbList.setEnabled(enable);
        this.addDbButton.setEnabled(enable);
        this.editDbButton.setEnabled(enable);
        this.removeDbButton.setEnabled(enable);
    }

    protected void checkMultipleDb() {
        if (this.tableNameFormat.getSelectedIndex() == 2 && this.driverText.getText().toLowerCase().indexOf("sqlserver") > -1) {
            Vector addDb;
            this.setMultipleDbEnabled(true);
            if (this.node != null && (addDb = this.node.getAdditionalDb()) != null) {
                this.multipleDbModel.removeAllElements();
                for (int i = 0; i < addDb.size(); ++i) {
                    this.multipleDbModel.addElement(addDb.get(i));
                }
            }
        } else {
            this.setMultipleDbEnabled(false);
        }
    }

    private void setValues(DatabaseNode node) {
        if (node != null) {
            String driverName = node.getDriver();
            for (int i = 0; i < DBDRIVERLIST.length; ++i) {
                if (DBDRIVERLIST[i].indexOf(driverName) < 0) continue;
                this.driverList.setSelectedIndex(i);
                break;
            }
            this.baseText.setText(node.getName());
            this.urlText.setText(node.getURL());
            this.driverText.setText(driverName);
            String name = node.getUserName();
            String pwd = node.getPassword();
            this.requireLogin.setSelected(node.isLoginRequired());
            this.savePassword.setSelected(node.isLoginRequired() && name != null && pwd != null);
            if (this.savePassword.isSelected()) {
                this.nameText.setText(name);
                this.pwdText.setText(pwd);
            }
            this.autoJoin.setSelected(node.isAutoJoin());
            this.tableNameFormat.setSelectedIndex(node.getTableNameFormat());
            this.checkMultipleDb();
        }
        this.enableButtons();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableButtons();
    }

    private void enableButtons() {
        this.savePassword.setEnabled(this.requireLogin.isSelected());
        this.nameText.setEnabled(this.savePassword.isSelected());
        this.pwdText.setEnabled(this.savePassword.isSelected());
    }

    DatabaseNode getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.connectButton) {
            String driver = this.driverText.getText().trim();
            String url = this.urlText.getText().trim();
            String username = "";
            String password = "";
            if (this.requireLogin.isSelected() && this.savePassword.isSelected()) {
                username = this.nameText.getText().trim();
                password = this.pwdText.getText().trim();
            }
            DBInfoBasic dbInfo = new DBInfoBasic(url, driver, username, password, "");
            if (ServerMessage.useServer) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                IConnection socket = null;
                try {
                    int messageType = 32000;
                    dout.writeShort(messageType);
                    dbInfo.write(dout);
                    socket = ServerMessage.createConnection();
                    byte[] array = bstream.toByteArray();
                    socket.setContentLength(array.length);
                    socket.getOutputStream().write(array);
                    socket.getOutputStream().flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Failed to contact EspressReport server at") + " " + ServerMessage.getServerInfo() + " " + ex.getMessage());
                }
                try {
                    DataInputStream instream = new DataInputStream(socket.getInputStream());
                    int code = instream.readInt();
                    if (code != 0) {
                        throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                    }
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Connected to database successfully!"));
                    instream.close();
                    socket.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("connection failed because the following exception occurred") + "\n" + t.toString());
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception code) {}
                }
            } else {
                try {
                    Connection con = dbInfo.openConnection();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Connected to database successfully!"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("connection failed because the following exception occurred") + "\n" + ex.getMessage());
                }
            }
        } else if (source == this.addDbButton) {
            String s = (String)JOptionPane.showInputDialog(this, "Please enter database url", "Additional Database Dialog", 3, null, null, DBURLLIST[3]);
            if (s != null && s.length() > 0) {
                this.multipleDbModel.addElement(s);
            }
        } else if (source == this.removeDbButton) {
            if (this.multipleDbList.getSelectedValue() != null) {
                int[] selected;
                for (int element : selected = this.multipleDbList.getSelectedIndices()) {
                    this.multipleDbModel.remove(element);
                }
            }
        } else if (source == this.editDbButton) {
            if (this.multipleDbList.getSelectedValue() != null) {
                int selected = this.multipleDbList.getSelectedIndex();
                String s = (String)JOptionPane.showInputDialog(this, "Please enter database url", "Additional Database Dialog", 3, null, null, this.multipleDbList.getSelectedValue());
                if (s != null && s.length() > 0) {
                    this.multipleDbModel.setElementAt(s, selected);
                }
            }
        } else if (source == this.tableNameFormat) {
            this.checkMultipleDb();
        } else if (source == this.okButton) {
            String msg = null;
            String nodeName = this.baseText.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter database name!");
            } else if (nodeName.length() > 25) {
                msg = LanguageEncoder.getText("Database name can not be longer than 25 characters.");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.node == null) {
                this.node = new DatabaseNode(nodeName);
                this.parent.add(this.node);
                this.node.add(new DefaultDataSourceNode("Queries"));
                this.node.add(new DefaultDataSourceNode("Data Views"));
            } else {
                this.node.setUserObject(nodeName);
            }
            this.node.setDriver(this.driverText.getText().trim());
            this.node.setURL(this.urlText.getText().trim());
            this.node.setLoginRequired(this.requireLogin.isSelected());
            if (this.requireLogin.isSelected() && this.savePassword.isSelected()) {
                this.node.setUserName(this.nameText.getText().trim());
                this.node.setPassword(this.pwdText.getText().trim());
            } else {
                this.node.setUserName(null);
                this.node.setPassword(null);
            }
            this.node.setAutoJoin(this.autoJoin.isSelected());
            this.node.setTableNameFormat(this.tableNameFormat.getSelectedIndex());
            if (this.tableNameFormat.getSelectedIndex() == 2) {
                Vector addDb = new Vector();
                for (int i = 0; i < this.multipleDbModel.getSize(); ++i) {
                    addDb.add(this.multipleDbModel.getElementAt(i));
                }
                this.node.setAdditionalDb(addDb);
            }
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.manager.managerPane.closeEditOrAddNode();
            this.dispose();
        } else if (source == this.driverList) {
            int selIndex = this.driverList.getSelectedIndex();
            if (selIndex >= 0 && selIndex <= DBNAMELIST.length) {
                this.urlText.setText(DBURLLIST[selIndex]);
                this.driverText.setText(DBDRIVERLIST[selIndex]);
            }
            this.checkMultipleDb();
        }
    }
}

