/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import quadbase.common.util.dtd.elements.DTD;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDDataType;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.internal.DTDUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLDataTypeUtil;
import quadbase.datasourcemanager.manager.DTDTreeCellRenderer;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;

public class DTDTreeBuilderDialog
extends JDialog
implements ActionListener {
    JTree tree;
    DTD dtd;
    Hashtable elements;
    DefaultMutableTreeNode parent;
    DefaultMutableTreeNode node;
    JComboBox dataTypeList;
    JComboBox dateFormatList;
    JButton okButton;
    JButton cancelButton;
    boolean isModified = false;
    JPanel datePanel;
    private String[] DATATYPE = DTDDataType.DATATYPE;
    private String[] DATEFORMAT = XMLDataTypeUtil.DATETYPE;

    public DTDTreeBuilderDialog(JDialog parentDialog, DefaultMutableTreeNode parent, DefaultMutableTreeNode node, String dtdTreeLoc) {
        super(parentDialog, LanguageEncoder.getText("Setup DTD data types..."), true);
        this.parent = parent;
        this.node = node;
        this.dtd = DTDUtil.readDTD(dtdTreeLoc);
        this.elements = this.dtd.getElements();
        this.init();
        this.setPosition();
    }

    public DTDTreeBuilderDialog(JDialog parentDialog, DefaultMutableTreeNode parent, DefaultMutableTreeNode node, DTD dtd) {
        super(parentDialog, LanguageEncoder.getText("Setup DTD data types..."), true);
        this.parent = parent;
        this.node = node;
        this.dtd = dtd;
        this.elements = dtd.getElements();
        this.init();
        this.setPosition();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        DTDElement rootElt = this.dtd.getRootElement();
        DefaultDataSourceNode root = new DefaultDataSourceNode(rootElt);
        this.tree = new JTree(DTDUtil.buildTree(rootElt, this.elements, root, true));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new DTDTreeCellRenderer());
        this.tree.setRootVisible(true);
        this.expandAll(this.tree);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                DefaultMutableTreeNode tnode = null;
                if (ev.getNewLeadSelectionPath() != null) {
                    tnode = DTDTreeBuilderDialog.this.getSelectedNode();
                }
                if (tnode != null) {
                    Object userObj = tnode.getUserObject();
                    boolean enableDataTypeOption = DTDTreeBuilderDialog.this.isDataTypeSelectable(tnode);
                    DTDTreeBuilderDialog.this.dataTypeList.setEnabled(enableDataTypeOption);
                    if (enableDataTypeOption && userObj instanceof DTDElement) {
                        DTDElement elt = (DTDElement)userObj;
                        if (DTDTreeBuilderDialog.this.elements.containsKey(elt.getName())) {
                            elt = DTDTreeBuilderDialog.this.dtd.getElement(elt.getName());
                        }
                        if (elt.getDataType() != null) {
                            DTDTreeBuilderDialog.this.dataTypeList.setSelectedIndex(DTDTreeBuilderDialog.this.mapDataType(elt.getDataType()));
                            if (elt.getDataType().equals("date")) {
                                DTDTreeBuilderDialog.this.datePanel.setVisible(true);
                                DTDTreeBuilderDialog.this.dateFormatList.setEnabled(true);
                                if (elt.getDateFormat() != null) {
                                    DTDTreeBuilderDialog.this.dateFormatList.setSelectedIndex(DTDTreeBuilderDialog.this.mapDateFormat(elt.getDateFormat()));
                                } else {
                                    DTDTreeBuilderDialog.this.dateFormatList.setSelectedIndex(0);
                                }
                            } else {
                                DTDTreeBuilderDialog.this.datePanel.setVisible(false);
                            }
                        }
                    } else if (enableDataTypeOption && userObj instanceof DTDAttribute) {
                        DTDElement elt = (DTDElement)((DefaultMutableTreeNode)tnode.getParent()).getUserObject();
                        DTDAttribute attr = (DTDAttribute)userObj;
                        if (DTDTreeBuilderDialog.this.elements.containsKey(elt.getName())) {
                            elt = DTDTreeBuilderDialog.this.dtd.getElement(elt.getName());
                            attr = elt.getAttribute(attr.getName());
                        }
                        if (attr.getDataType() != null && !attr.getDataType().trim().equals("")) {
                            DTDTreeBuilderDialog.this.dataTypeList.setSelectedIndex(DTDTreeBuilderDialog.this.mapDataType(attr.getDataType()));
                            if (attr.getDataType().equals("date")) {
                                DTDTreeBuilderDialog.this.datePanel.setVisible(true);
                                DTDTreeBuilderDialog.this.dateFormatList.setEnabled(true);
                                if (attr.getDateFormat() != null) {
                                    DTDTreeBuilderDialog.this.dateFormatList.setSelectedIndex(DTDTreeBuilderDialog.this.mapDateFormat(attr.getDateFormat()));
                                } else {
                                    DTDTreeBuilderDialog.this.dateFormatList.setSelectedIndex(0);
                                }
                            } else {
                                DTDTreeBuilderDialog.this.datePanel.setVisible(false);
                            }
                        }
                    }
                }
            }
        });
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.getDTDTreePanel());
        contentPane.add("South", this.getTypePanel());
        this.tree.setSelectionRow(0);
    }

    private boolean isDataTypeSelectable(DefaultMutableTreeNode node) {
        if (node != null) {
            DTDAttribute attr;
            Object userObj = node.getUserObject();
            if (userObj instanceof DTDElement) {
                DTDElement elt = (DTDElement)userObj;
                if (node.isLeaf() && elt.isExpand() || elt.isMixedLeaf()) {
                    return true;
                }
            } else if (userObj instanceof DTDAttribute && (attr = (DTDAttribute)userObj).isCDATAType()) {
                return true;
            }
        }
        return false;
    }

    private void setPosition() {
        this.expandAll(this.tree);
        this.tree.validate();
        this.tree.repaint();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void expandAll(JTree tree) {
        int i;
        int rowCt = tree.getRowCount();
        TreePath[] path = new TreePath[rowCt];
        for (i = 0; i < rowCt; ++i) {
            path[i] = tree.getPathForRow(i);
        }
        for (i = 0; i < rowCt; ++i) {
            tree.expandPath(path[i]);
        }
    }

    public boolean isModified() {
        return this.isModified;
    }

    public DTD getDTD() {
        return this.dtd;
    }

    private JPanel getDTDTreePanel() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.tree);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add("Center", scrollPane);
        return p1;
    }

    private JPanel getTypePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("CANCEL"));
        buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BorderLayout());
        this.dataTypeList = new JComboBox();
        for (String element : this.DATATYPE) {
            this.dataTypeList.addItem(element);
        }
        this.dataTypeList.setSelectedIndex(0);
        this.dataTypeList.addActionListener(this);
        typePanel.add("West", new JLabel(LanguageEncoder.getText("Data Type")));
        typePanel.add("Center", this.dataTypeList);
        this.datePanel = new JPanel();
        this.datePanel.setLayout(new BorderLayout());
        this.dateFormatList = new JComboBox();
        for (String element : this.DATEFORMAT) {
            this.dateFormatList.addItem(element);
        }
        this.dateFormatList.setSelectedIndex(0);
        this.dateFormatList.addActionListener(this);
        this.datePanel.add("West", new JLabel(LanguageEncoder.getText("Date Format")));
        this.datePanel.add("Center", this.dateFormatList);
        this.datePanel.setVisible(false);
        panel.add("Center", typePanel);
        panel.add("East", buttonPanel);
        panel.add("South", this.datePanel);
        return panel;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.tree.isSelectionEmpty()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node = this.getSelectedNode();
        Object userObj = null;
        if (node != null) {
            userObj = node.getUserObject();
        }
        if (e.getSource() == this.dataTypeList) {
            String type = this.DATATYPE[this.dataTypeList.getSelectedIndex()];
            if (userObj instanceof DTDElement) {
                DTDElement elt = (DTDElement)userObj;
                elt.setDataType(type);
                this.dtd.getElements().put(elt.getName(), elt);
                this.datePanel.setVisible(type.equals("date"));
            } else if (userObj instanceof DTDAttribute) {
                DTDAttribute attr = (DTDAttribute)userObj;
                attr.setDataType(type);
                DTDElement elt = (DTDElement)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                elt.setAttribute(attr.getName(), attr);
                this.dtd.getElements().put(elt.getName(), elt);
                this.datePanel.setVisible(type.equals("date"));
            }
            this.isModified = true;
        } else if (e.getSource() == this.dateFormatList) {
            String format = this.DATEFORMAT[this.dateFormatList.getSelectedIndex()];
            if (userObj instanceof DTDElement) {
                DTDElement elt = (DTDElement)node.getUserObject();
                elt.setDateFormat(format);
                this.dtd.getElements().put(elt.getName(), elt);
            } else if (userObj instanceof DTDAttribute) {
                DTDAttribute attr = (DTDAttribute)userObj;
                attr.setDateFormat(format);
                DTDElement elt = (DTDElement)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                elt.setAttribute(attr.getName(), attr);
                this.dtd.getElements().put(elt.getName(), elt);
            }
            this.isModified = true;
        } else if (e.getSource() == this.okButton) {
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private int mapDataType(String type) {
        for (int i = 0; i < this.DATATYPE.length; ++i) {
            if (!this.DATATYPE[i].equals(type)) continue;
            return i;
        }
        return 0;
    }

    private int mapDateFormat(String type) {
        for (int i = 0; i < this.DATEFORMAT.length; ++i) {
            if (!this.DATEFORMAT[i].equals(type)) continue;
            return i;
        }
        return 0;
    }
}

