/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.dtd.elements.DTDAttribute;
import quadbase.common.util.dtd.elements.DTDElement;
import quadbase.common.util.internal.IOUtil;

public class DTDTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private String root = ServerMessage.reportImagesPath + "XML.gif";
    private String parentOpen = ServerMessage.reportImagesPath + "parentopen.gif";
    private String parentClosed = ServerMessage.reportImagesPath + "parentclosed.gif";
    private String leaf = ServerMessage.reportImagesPath + "leaf.gif";
    private String mixedLeaf = ServerMessage.reportImagesPath + "mixedleaf.gif";
    private String attribute = ServerMessage.reportImagesPath + "attribute.gif";
    private Icon rootIcon = IOUtil.getImageIcon(this.root);
    private Icon parentOpenIcon = IOUtil.getImageIcon(this.parentOpen);
    private Icon parentClosedIcon = IOUtil.getImageIcon(this.parentClosed);
    private Icon leafIcon = IOUtil.getImageIcon(this.leaf);
    private Icon attributeIcon;
    private Icon mixedLeafIcon = IOUtil.getImageIcon(this.mixedLeaf);

    public DTDTreeCellRenderer() {
        this.attributeIcon = IOUtil.getImageIcon(this.attribute);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.isRoot()) {
            this.setIcon(this.rootIcon);
        } else if (node.isLeaf()) {
            this.setIcon(this.leafIcon);
        } else if (expanded) {
            this.setIcon(this.parentOpenIcon);
        } else {
            this.setIcon(this.parentClosedIcon);
        }
        Object userObj = node.getUserObject();
        String name = null;
        if (userObj instanceof DTDElement) {
            DTDElement elt = (DTDElement)userObj;
            name = this.getDisplayName(elt);
            if (!node.isLeaf() && elt.isMixedLeaf()) {
                this.setIcon(this.mixedLeafIcon);
            }
            if (node.isLeaf() && !elt.isExpand()) {
                this.setIcon(this.parentClosedIcon);
            }
        } else if (userObj instanceof DTDAttribute) {
            name = this.getDisplayName((DTDAttribute)userObj);
            this.setIcon(this.attributeIcon);
        } else {
            name = (String)node.getUserObject();
        }
        this.setText(name);
        if (selected) {
            JTextField label = new JTextField("TEMP");
            this.setForeground(label.getSelectedTextColor());
            this.setBackground(label.getSelectionColor());
        } else {
            this.setForeground(tree.getForeground());
            this.setBackground(tree.getBackground());
        }
        return this;
    }

    private String getDisplayName(DTDElement elt) {
        String name = elt.getName();
        int cardinal = elt.getCardinal();
        if (cardinal == 1) {
            name = name + "?";
        } else if (cardinal == 2) {
            name = name + "*";
        } else if (cardinal == 3) {
            name = name + "+";
        }
        return name;
    }

    private String getDisplayName(DTDAttribute attr) {
        String name = attr.getName();
        name = "@" + name;
        return name;
    }

    @Override
    public void paint(Graphics g) {
        int textstart = this.getIcon().getIconWidth() + this.getIconTextGap();
        int textwidth = this.getSize().width - textstart;
        this.getIcon().paintIcon(this, g, 0, 0);
        g.setColor(this.getBackground());
        g.fillRect(textstart, 0, textwidth, this.getSize().height);
        g.setColor(this.getForeground());
        g.drawString(this.getText(), textstart, (this.getSize().height + g.getFontMetrics().getAscent()) / 2);
    }
}

