/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.INodeVisible;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPDataSourceNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceDataSourceNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;

public class DataTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private String database = ServerMessage.reportImagesPath + "Database.gif";
    private String bigdata = ServerMessage.reportImagesPath + "BigData.gif";
    private String sql = ServerMessage.reportImagesPath + "SQL.gif";
    private String text = ServerMessage.reportImagesPath + "Text.gif";
    private String xml = ServerMessage.reportImagesPath + "XML.gif";
    private String xmlquery = ServerMessage.reportImagesPath + "xmlquery.gif";
    private String jclass = ServerMessage.reportImagesPath + "Class.gif";
    private String dataview = ServerMessage.reportImagesPath + "DataView.gif";
    private String dataviewquery = ServerMessage.reportImagesPath + "DSQL.gif";
    private String ejb = ServerMessage.reportImagesPath + "ejb.gif";
    private String soap = ServerMessage.reportImagesPath + "soap.gif";
    private String salesforce = ServerMessage.reportImagesPath + "salesforce.gif";
    private String excel = ServerMessage.reportImagesPath + "excel.gif";
    private Icon sqlIcon;
    private Icon textIcon;
    private Icon xmlIcon;
    private Icon xmlqueryIcon;
    private Icon classIcon;
    private Icon databaseIcon;
    private Icon bigdataIcon;
    private Icon dataviewIcon;
    private Icon dataviewqueryIcon;
    private Icon ejbIcon;
    private Icon soapIcon;
    private Icon salesforceIcon;
    private Icon excelIcon;
    private INodeVisible checkNode = null;

    public DataTreeCellRenderer() {
        this((INodeVisible)null);
    }

    public DataTreeCellRenderer(INodeVisible checkNode) {
        this.checkNode = checkNode;
        this.databaseIcon = IOUtil.getImageIcon(this.database);
        this.bigdataIcon = IOUtil.getImageIcon(this.bigdata);
        this.sqlIcon = IOUtil.getImageIcon(this.sql);
        this.xmlIcon = IOUtil.getImageIcon(this.xml);
        this.xmlqueryIcon = IOUtil.getImageIcon(this.xmlquery);
        this.textIcon = IOUtil.getImageIcon(this.text);
        this.classIcon = IOUtil.getImageIcon(this.jclass);
        this.dataviewIcon = IOUtil.getImageIcon(this.dataview);
        this.dataviewqueryIcon = IOUtil.getImageIcon(this.dataviewquery);
        this.ejbIcon = IOUtil.getImageIcon(this.ejb);
        this.soapIcon = IOUtil.getImageIcon(this.soap);
        this.salesforceIcon = IOUtil.getImageIcon(this.salesforce);
        this.excelIcon = IOUtil.getImageIcon(this.excel);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        String file = (String)node.getUserObject();
        if (node instanceof QueryNode || file.equals("Queries")) {
            this.setIcon(this.sqlIcon);
        } else if (node instanceof DataViewNode || file.equals("Data Views")) {
            this.setIcon(this.dataviewIcon);
        } else if (node instanceof BigDataNode || file.equals("BigDatas") || file.equals("BigData")) {
            this.setIcon(this.bigdataIcon);
        } else if (node instanceof DatabaseNode || file.equals("Databases")) {
            this.setIcon(this.databaseIcon);
        } else if (node instanceof JNDIDataSourceNode || file.equals("JNDIDataSources")) {
            this.setIcon(this.databaseIcon);
        } else if (node instanceof TextFileNode || file.equals("TXTFiles")) {
            this.setIcon(this.textIcon);
        } else if (node instanceof XMLFileNode || file.equals("XMLFiles")) {
            this.setIcon(this.xmlIcon);
        } else if (node instanceof XMLQueryNode) {
            this.setIcon(this.xmlqueryIcon);
        } else if (node instanceof ClassFileNode || file.equals("ClassFiles")) {
            this.setIcon(this.classIcon);
        } else if (node instanceof EJBNode || file.equals("EJBs")) {
            this.setIcon(this.ejbIcon);
        } else if (node instanceof SOAPDataSourceNode || file.equals("SOAPServices")) {
            this.setIcon(this.soapIcon);
        } else if (node instanceof SOAPViewNode) {
            this.setIcon(this.xmlIcon);
        } else if (node instanceof SalesForceDataSourceNode || file.equals("SalesForceConnections") || node instanceof SalesForceQueryNode) {
            this.setIcon(this.salesforceIcon);
        } else if (node instanceof ExcelFileNode || file.equals("ExcelFiles")) {
            this.setIcon(this.excelIcon);
        } else if (node instanceof DataViewQueryNode) {
            this.setIcon(this.dataviewqueryIcon);
        }
        this.setText(file);
        if (selected) {
            JTextField label = new JTextField("TEMP");
            this.setForeground(label.getSelectedTextColor());
            this.setBackground(label.getSelectionColor());
        } else if (this.checkNode != null && !this.checkNode.isNodeVisible(node)) {
            this.setForeground(Color.lightGray);
            this.setBackground(tree.getBackground());
        } else {
            this.setForeground(tree.getForeground());
            this.setBackground(tree.getBackground());
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        int textstart = this.getIcon().getIconWidth() + this.getIconTextGap();
        int textwidth = this.getSize().width - textstart;
        this.getIcon().paintIcon(this, g, 0, 0);
        g.setColor(this.getBackground());
        g.fillRect(textstart, 0, textwidth, this.getSize().height);
        g.setColor(this.getForeground());
        g.drawString(this.getText(), textstart, (this.getSize().height + g.getFontMetrics().getAscent()) / 2);
    }
}

