/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import quadbase.common.paramquery.DataViewAvailColumn;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.querybuilder.query.DatabaseInfo;

public class DataViewINParametersDialog
extends INParametersDialog {
    private Object[][] columns = null;

    public DataViewINParametersDialog(JDialog dialog, QueryFileInfo queryFileInfo, Object[][] cols, boolean showPromptSequence) throws Exception {
        super(dialog, true);
        this.queryFileInfo = queryFileInfo;
        this.columns = cols;
        this.showPromptSequence = showPromptSequence;
        this.databaseInfo = !queryFileInfo.isUseJNDIDataSource() ? new DatabaseInfo(queryFileInfo.getDriverName(), queryFileInfo.getURLString(), queryFileInfo.getUserID(), queryFileInfo.getPassword()) : new DatabaseInfo(queryFileInfo.getJNDIName(), queryFileInfo.getEnvProperties());
        this.isDataview = true;
        this.init();
        this.setPosition();
    }

    @Override
    protected Vector createAvailColumnList(String paramName) throws Exception {
        if (this.columns == null) {
            return new Vector();
        }
        String query = this.queryFileInfo.getQuery();
        Vector columnVector = QueryParser.getColumnName(query, paramName);
        boolean findColumn = false;
        int columnVectorSize = columnVector.size();
        Vector<DataViewAvailColumn> vect = new Vector<DataViewAvailColumn>();
        for (Object[] column : this.columns) {
            String tableName;
            if (column == null || column.length != 4 || column[0] == null || column[1] == null || column[2] == null || column[3] == null || !(column[0] instanceof String) || !(column[1] instanceof String) || !(column[2] instanceof Integer) || !(column[3] instanceof String) || (tableName = (String)column[0]) == null) continue;
            String columnName = (String)column[1];
            if (!findColumn) {
                for (int k = 0; k < columnVectorSize; ++k) {
                    if (!columnName.equalsIgnoreCase((String)columnVector.elementAt(k))) continue;
                    vect.addElement(new DataViewAvailColumn(tableName, columnName, (Integer)column[2], true, (String)column[3]));
                    findColumn = true;
                    break;
                }
                if (findColumn) continue;
                vect.addElement(new DataViewAvailColumn(tableName, columnName, (Integer)column[2], false, (String)column[3]));
                continue;
            }
            vect.addElement(new DataViewAvailColumn(tableName, columnName, (Integer)column[2], false, (String)column[3]));
        }
        return vect;
    }

    public void convertToDatabase(String[] params) {
        block0: for (int i = 0; i < params.length; ++i) {
            for (int j = 0; j < this.availColumn.size(); ++j) {
                if (!this.getAvailColumn(j).getCompleteName().equalsIgnoreCase(params[i])) continue;
                params[i] = this.getAvailColumn(j).getTableName() + "." + this.getAvailColumn(j).getColumnName();
                continue block0;
            }
        }
    }

    @Override
    public String convertName(String fullName, JComboBox comboBox) {
        int dotIndex = fullName.indexOf(46);
        if (dotIndex >= 0) {
            String tableName = fullName.substring(0, dotIndex).trim();
            String columnName = fullName.substring(dotIndex + 1, fullName.length()).trim();
            for (int j = 0; j < this.availColumn.size(); ++j) {
                if (!this.getAvailColumn(j).getTableName().equalsIgnoreCase(tableName) || !this.getAvailColumn(j).getColumnName().equalsIgnoreCase(columnName)) continue;
                fullName = this.getAvailColumn(j).getCompleteName();
                break;
            }
        }
        return fullName;
    }
}

