/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.querybuilder.designer.QueryMain;

public class DataViewQueryNode
extends DefaultDataSourceNode {
    private String queryFile;
    private String query;
    private String dataViewFile;
    private QueryInParamSet inSet = null;
    private boolean ready = false;
    private byte[][] data = null;
    private boolean justCreated = false;

    public DataViewQueryNode(String name) {
        super(name);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public void setName(String name) {
        this.setUserObject(name);
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(String qf) {
        this.queryFile = qf;
    }

    public String getDataViewFile() {
        return this.dataViewFile;
    }

    public void setDataViewFile(String qf) {
        this.dataViewFile = qf;
    }

    public String getSQL() {
        return this.query;
    }

    public void setSQL(String q) {
        this.query = q;
    }

    public QueryInParamSet getInSet() {
        if (this.ready) {
            return this.inSet;
        }
        try {
            boolean hasParam;
            DataInputStream in;
            int version;
            ReadDataFile readfile = new ReadDataFile();
            String file = this.queryFile;
            if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
                file = file + ".dvw";
            }
            if ((version = (in = readfile.getInputStream(file)).readInt()) >= 1 && (hasParam = in.readBoolean())) {
                int chartversion = in.readInt();
                this.inSet = QueryInParamSet.read(in, chartversion);
                this.ready = true;
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.inSet;
    }

    public void setInSet(QueryInParamSet set) {
        this.inSet = set;
        this.ready = true;
    }

    public void setBytes(byte[][] bytes) {
        this.data = bytes;
    }

    public byte[][] getBytes() {
        if (this.queryFile == null || this.dataViewFile == null) {
            return null;
        }
        if (this.data != null) {
            return this.data;
        }
        try {
            ReadDataFile readfile = new ReadDataFile();
            String file = QueryMain.QUERYDIR + this.dataViewFile;
            if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
                file = file + ".dvw";
            }
            DataInputStream in = readfile.getInputStream(file);
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            int c = in.read();
            while (c != -1) {
                bstream.write(c);
                c = in.read();
            }
            in.close();
            bstream.close();
            byte[][] d2 = new byte[2][];
            d2[0] = bstream.toByteArray();
            file = this.queryFile;
            if (!file.toUpperCase().endsWith(".dvw".toUpperCase())) {
                file = file + ".dvw";
            }
            in = readfile.getInputStream(file);
            bstream = new ByteArrayOutputStream();
            c = in.read();
            while (c != -1) {
                bstream.write(c);
                c = in.read();
            }
            in.close();
            bstream.close();
            d2[1] = bstream.toByteArray();
            this.data = d2;
            return this.data;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isJustCreated() {
        return this.justCreated;
    }

    public void setJustCreated(boolean c) {
        this.justCreated = c;
    }
}

