/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;

public class DatabaseNode
extends DefaultDataSourceNode {
    String driver;
    String url;
    String userName;
    String password;
    boolean requireLogin = false;
    protected boolean autoJoin = true;
    protected int tableNameFormat = 0;
    protected Vector additionalDb = null;

    public DatabaseNode(String name) {
        super(name);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public void setName(String name) {
        this.setUserObject(name);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public boolean isLoginRequired() {
        return this.requireLogin;
    }

    public void setLoginRequired(boolean b) {
        this.requireLogin = b;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPasswordSaved() {
        return this.password != null && this.userName != null;
    }

    public DefaultMutableTreeNode getQueryNode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((DefaultMutableTreeNode)this.getChildAt(i)).getUserObject().equals("Queries")) continue;
            return (DefaultMutableTreeNode)this.getChildAt(i);
        }
        DefaultMutableTreeNode subnode = new DefaultMutableTreeNode("Queries");
        this.add(subnode);
        return subnode;
    }

    public DefaultMutableTreeNode getDataViewNode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((DefaultMutableTreeNode)this.getChildAt(i)).getUserObject().equals("Data Views")) continue;
            return (DefaultMutableTreeNode)this.getChildAt(i);
        }
        DefaultMutableTreeNode subnode = new DefaultMutableTreeNode("Data Views");
        this.add(subnode);
        return subnode;
    }

    public void setAutoJoin(boolean state) {
        this.autoJoin = state;
    }

    public boolean isAutoJoin() {
        return this.autoJoin;
    }

    public void setTableNameFormat(int format) {
        if (format < 0) {
            format = 0;
        }
        if (format > 2) {
            format = 2;
        }
        this.tableNameFormat = format;
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }

    public void setAdditionalDb(Vector dbVect) {
        this.additionalDb = dbVect;
    }

    public void setAdditionalDb(String addDb) {
        this.additionalDb = DatabaseNode.getAdditionalDb(addDb);
    }

    public static Vector getAdditionalDb(String addDb) {
        Vector<String> additionalDb = null;
        while (addDb != null && addDb.length() > 0) {
            if (additionalDb == null) {
                additionalDb = new Vector<String>();
            }
            if (addDb.indexOf("_&_") > 0) {
                additionalDb.add(addDb.substring(0, addDb.indexOf("_&_")));
                addDb = addDb.substring(addDb.indexOf("_&_") + 3);
                continue;
            }
            additionalDb.add(addDb);
            addDb = "";
        }
        return additionalDb;
    }

    public Vector getAdditionalDb() {
        return this.additionalDb;
    }

    public int getAdditionalDbSize() {
        if (this.additionalDb == null) {
            return 0;
        }
        return this.additionalDb.size();
    }
}

