/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.EJBPropertyDialog;
import quadbase.datasourcemanager.manager.Manager;

public class EJBNodeDialog
extends JDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    JTextField baseField;
    JTextField jndiText;
    JTextField homeText;
    JTextField remoteText;
    JButton okButton;
    JButton cancelButton;
    JButton importButton;
    JButton configButton;
    private boolean isModified = false;
    DefaultMutableTreeNode parent;
    EJBNode node;
    Manager manager;
    JList methodList;
    JList paramList;
    JTextField valueField;
    JTextField typeField;
    JButton saveButton;
    String[] methods;
    Hashtable paramTable;
    Hashtable retTable;
    Hashtable valueTable;
    Class[] paramTypes = null;
    Object[] values = null;
    Color notEditable = Color.lightGray;
    Hashtable environment = null;

    public EJBNodeDialog(Manager manager, DefaultMutableTreeNode parent, EJBNode node) {
        super(manager, LanguageEncoder.getText("Setup EJB component...."), true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
        if (node != null) {
            this.environment = node.getEnvironment();
        }
        this.init();
        this.setPosition();
    }

    void setValues(EJBNode node) {
        if (node != null) {
            this.importButton.setEnabled(false);
            this.importButton.setVisible(false);
            this.configButton.setEnabled(true);
            this.baseField.setText(node.getName());
            this.jndiText.setText(node.getJNDIName());
            this.homeText.setText(node.getHomeName());
            this.remoteText.setText(node.getRemoteName());
            this.jndiText.setEditable(false);
            this.homeText.setEditable(false);
            this.remoteText.setEditable(false);
            this.jndiText.setBackground(this.notEditable);
            this.homeText.setBackground(this.notEditable);
            this.remoteText.setBackground(this.notEditable);
            this.paramTable = node.getParamTable();
            this.retTable = node.getRetTable();
            this.valueTable = node.getValueTable();
            this.methodList.setListData(node.getMethods());
            if (node.getSelectedMethod() != null) {
                this.methodList.setSelectedValue(node.getSelectedMethod(), true);
                this.setParamList(node.getSelectedMethod());
                this.setTypeField(node.getSelectedMethod(), 0);
                this.setValueField(node.getSelectedMethod(), 0);
            }
        } else {
            this.okButton.setEnabled(false);
            this.saveButton.setEnabled(false);
            this.valueField.setEditable(false);
            this.importButton.setEnabled(true);
            this.configButton.setEnabled(false);
        }
    }

    boolean isModified() {
        return this.isModified;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.enableButtons();
    }

    private void enableButtons() {
    }

    EJBNode getNode() {
        return this.node;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object source = e.getSource();
        if (source == this.methodList) {
            String methodName = this.getSelectedMethod();
            if (methodName != null) {
                this.setParamList(methodName);
                this.setTypeField(methodName, 0);
                this.setValueField(methodName, 0);
            }
            this.node.setSelectedMethod(methodName);
        } else if (source == this.paramList) {
            String methodName = this.getSelectedMethod();
            String paramName = this.getSelectedParam();
            if (methodName != null && paramName != null) {
                this.setTypeField(methodName, this.paramList.getSelectedIndex());
                this.setValueField(methodName, this.paramList.getSelectedIndex());
            }
        }
    }

    public String getSelectedMethod() {
        if (this.methodList.getSelectedIndex() > -1) {
            return (String)this.methodList.getSelectedValue();
        }
        return null;
    }

    public String getSelectedParam() {
        if (this.paramList.getSelectedIndex() > -1) {
            return (String)this.paramList.getSelectedValue();
        }
        return null;
    }

    private void setParamList(String method) {
        Class[] paramTypes = (Class[])this.paramTable.get(method);
        if (paramTypes != null) {
            String[] params = new String[paramTypes.length];
            int ct = 1;
            for (int i = 0; i < params.length; ++i) {
                params[i] = "param" + ct;
                ++ct;
            }
            this.paramList.setListData(params);
            if (params.length > 0) {
                this.paramList.setSelectedIndex(0);
            }
        }
    }

    private void setTypeField(String methodName, int index) {
        Class[] types = (Class[])this.paramTable.get(methodName);
        if (types != null && types.length > index && types[index] != null) {
            this.typeField.setText(types[index].getName());
        } else {
            this.typeField.setText("");
        }
    }

    private void setValueField(String methodName, int index) {
        Object[] value = (Object[])this.valueTable.get(methodName);
        if (value != null && value.length > index && value[index] != null) {
            this.valueField.setText(value[index].toString());
        } else {
            this.valueField.setText("");
        }
    }

    private Method[] getValidFindMethods(Method[] homeMethods) {
        Vector<Method> temp = new Vector<Method>();
        for (int i = 0; i < homeMethods.length; ++i) {
            if (!homeMethods[i].getName().startsWith("find") || homeMethods[i].getName().equals("findByPrimaryKey")) continue;
            temp.addElement(homeMethods[i]);
        }
        Method[] methods = new Method[temp.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)temp.elementAt(i);
        }
        return methods;
    }

    private String[] getMethods(Method[] validFindMethods) {
        String[] methods = new String[validFindMethods.length];
        for (int i = 0; i < validFindMethods.length; ++i) {
            methods[i] = validFindMethods[i].getName();
        }
        return methods;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.importButton) {
            String msg = null;
            String nodeName = this.baseField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name");
            } else if (this.remoteText.getText().trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter the remote interface name!");
            } else if (this.jndiText.getText().trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter the jndi lookup name!");
            } else if (this.homeText.getText().trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter the home interface name!");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            EJBNode ejbNode = this.node;
            if (ejbNode == null) {
                ejbNode = new EJBNode(nodeName);
            } else {
                ejbNode.setUserObject(nodeName);
            }
            ejbNode.setJNDIName(this.jndiText.getText().trim());
            ejbNode.setHomeName(this.homeText.getText().trim());
            ejbNode.setRemoteName(this.remoteText.getText().trim());
            try {
                this.paramTable = new Hashtable();
                this.retTable = new Hashtable();
                this.valueTable = new Hashtable();
                if (!ServerMessage.useServer) {
                    Class<?> homeClass = Class.forName(ejbNode.getHomeName());
                    Method[] homeMethods = this.getValidFindMethods(homeClass.getDeclaredMethods());
                    this.methods = this.getMethods(homeMethods);
                    this.methodList.setListData(this.methods);
                    for (Method homeMethod : homeMethods) {
                        String methodName = homeMethod.getName();
                        this.paramTypes = homeMethod.getParameterTypes();
                        this.paramTable.put(methodName, this.paramTypes);
                        Class<?> returnType = homeMethod.getReturnType();
                        this.retTable.put(methodName, returnType);
                        this.values = new Object[this.paramTypes.length];
                        for (int j = 0; j < this.paramTypes.length; ++j) {
                            String name = this.paramTypes[j].getName();
                            this.values[j] = EJBUtil.getInputValue(name, null);
                        }
                        this.valueTable.put(methodName, this.values);
                    }
                } else {
                    IConnection socket = null;
                    ByteArrayOutputStream bstream = null;
                    DataOutputStream dout = null;
                    try {
                        socket = ServerMessage.createConnection();
                        bstream = new ByteArrayOutputStream(50);
                        dout = new DataOutputStream(bstream);
                        dout.writeShort(32418);
                        IOUtil.writeString(dout, ejbNode.getHomeName());
                        byte[] array = bstream.toByteArray();
                        socket.setContentLength(array.length);
                        socket.getOutputStream().write(array);
                        socket.getOutputStream().flush();
                        DataInputStream dstream = new DataInputStream(socket.getInputStream());
                        int code = dstream.readInt();
                        if (code != 0) {
                            throw new IOException(IOUtil.getErrorString(code) + IOUtil.readString(dstream, true));
                        }
                        int methodCt = dstream.readInt();
                        this.methods = new String[methodCt];
                        for (int i = 0; i < methodCt; ++i) {
                            this.methods[i] = IOUtil.readString(dstream, true);
                            int paramSize = dstream.readInt();
                            this.paramTypes = new Class[paramSize];
                            for (int k = 0; k < paramSize; ++k) {
                                this.paramTypes[k] = EJBUtil.mapTypeToClass(IOUtil.readString(dstream, true));
                            }
                            this.paramTable.put(this.methods[i], this.paramTypes);
                            this.retTable.put(this.methods[i], EJBUtil.mapTypeToClass(IOUtil.readString(dstream, true)));
                            this.values = new Object[this.paramTypes.length];
                            for (int j = 0; j < this.paramTypes.length; ++j) {
                                String name = this.paramTypes[j].getName();
                                this.values[j] = EJBUtil.getInputValue(name, null);
                            }
                            this.valueTable.put(this.methods[i], this.values);
                        }
                        this.methodList.setListData(this.methods);
                    }
                    catch (Exception ex) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ex;
                    }
                    catch (Error err) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw err;
                    }
                }
                ejbNode.setMethods(this.methods);
                ejbNode.setParamTable(this.paramTable);
                ejbNode.setRetTable(this.retTable);
                ejbNode.setValueTable(this.valueTable);
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), ex.toString());
                return;
            }
            this.node = ejbNode;
            this.importButton.setEnabled(false);
            this.okButton.setEnabled(true);
            this.saveButton.setEnabled(true);
            this.configButton.setEnabled(true);
            this.valueField.setEditable(true);
            this.jndiText.setEditable(false);
            this.homeText.setEditable(false);
            this.remoteText.setEditable(false);
            this.jndiText.setBackground(this.notEditable);
            this.homeText.setBackground(this.notEditable);
            this.remoteText.setBackground(this.notEditable);
            this.isModified = true;
        } else if (!this.importButton.isEnabled() && source == this.baseField || source == this.okButton) {
            String nodeName = this.baseField.getText().trim();
            String msg = null;
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name");
            } else if (this.node == null) {
                msg = LanguageEncoder.getText("This is not an valid EJB Node");
            } else if (!nodeName.equals(this.node.getUserObject().toString()) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.manager, LanguageEncoder.getText("Error"), msg);
                return;
            }
            this.node.setUserObject(nodeName);
            this.parent.add(this.node);
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.manager.managerPane.closeEditOrAddNode();
            this.dispose();
        } else if (source == this.saveButton) {
            String paramName;
            String methodName = this.getSelectedMethod();
            if (methodName != null && (paramName = this.getSelectedParam()) != null) {
                int selectedIndex = this.paramList.getSelectedIndex();
                Object[] paramVal = (Object[])this.valueTable.get(methodName);
                this.paramTypes = (Class[])this.paramTable.get(methodName);
                String name = this.paramTypes[selectedIndex].getName();
                paramVal[selectedIndex] = EJBUtil.getInputValue(name, this.valueField.getText());
                this.valueTable.put(methodName, paramVal);
            }
            this.node.setSelectedMethod(methodName);
            this.node.setValueTable(this.valueTable);
        } else if (source == this.configButton) {
            EJBPropertyDialog pDialog = new EJBPropertyDialog(this.manager, this.parent, this.node);
            pDialog.setVisible(true);
            if (pDialog.isModified()) {
                this.environment = pDialog.getEnvironment();
                this.node.setEnvironment(this.environment);
            }
        }
    }

    private void init() {
        JPanel bpanel = new JPanel();
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please type in entity bean information:")));
        bpanel.setLayout(new BorderLayout());
        this.baseField = new JTextField("", 25);
        this.jndiText = new JTextField("", 25);
        this.homeText = new JTextField("", 25);
        this.remoteText = new JTextField("", 25);
        JPanel mainPanelWest = new JPanel(new GridLayout(4, 1, 5, 5));
        JPanel mainPanelCenter = new JPanel(new GridLayout(4, 1, 5, 5));
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("Display Name :") + " "));
        mainPanelCenter.add(this.baseField);
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("JNDI Lookup Name :") + " "));
        mainPanelCenter.add(this.jndiText);
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("Home Interface Name :") + " "));
        mainPanelCenter.add(this.homeText);
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("Remote Interface Name :") + " "));
        mainPanelCenter.add(this.remoteText);
        this.baseField.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("Ok"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.importButton = new JButton(LanguageEncoder.getText("Import"));
        this.importButton.addActionListener(this);
        this.configButton = new JButton(LanguageEncoder.getText("Environment"));
        this.configButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.importButton);
        buttonPanel.add(this.configButton);
        bpanel.add("West", mainPanelWest);
        bpanel.add("Center", mainPanelCenter);
        bpanel.add("South", buttonPanel);
        JPanel beanPanel = new JPanel();
        beanPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please specify the method properties of this entity bean:")));
        beanPanel.setLayout(new BorderLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(1, 2, 5, 5));
        JScrollPane methodListPane = new JScrollPane();
        methodListPane.setBorder(new TitledBorder(LanguageEncoder.getText("List of Methods")));
        this.methodList = new JList();
        this.methodList.setSelectionMode(0);
        this.methodList.clearSelection();
        this.methodList.addListSelectionListener(this);
        methodListPane.getViewport().add(this.methodList);
        JScrollPane paramListPane = new JScrollPane();
        paramListPane.setBorder(new TitledBorder(LanguageEncoder.getText("Parameter List")));
        this.paramList = new JList();
        this.paramList.setSelectionMode(0);
        this.paramList.clearSelection();
        this.paramList.addListSelectionListener(this);
        paramListPane.getViewport().add(this.paramList);
        infoPanel.add(methodListPane);
        infoPanel.add(paramListPane);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new FlowLayout());
        this.typeField = new JTextField("", 25);
        this.typeField.setEditable(false);
        this.typeField.setBackground(this.notEditable);
        typePanel.add(new JLabel(LanguageEncoder.getText("Parameter Type :") + " "));
        typePanel.add(this.typeField);
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new FlowLayout());
        this.valueField = new JTextField("", 25);
        this.saveButton = new JButton(LanguageEncoder.getText("Set Value"));
        this.saveButton.addActionListener(this);
        valuePanel.add(this.valueField);
        valuePanel.add(this.saveButton);
        JPanel paramValuePanel = new JPanel();
        paramValuePanel.setLayout(new BorderLayout());
        paramValuePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please enter the parameter value")));
        paramValuePanel.add("North", typePanel);
        paramValuePanel.add("Center", valuePanel);
        beanPanel.add("North", infoPanel);
        beanPanel.add("Center", paramValuePanel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", bpanel);
        contentPane.add("Center", beanPanel);
        this.setValues(this.node);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

