/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.util.internal.EJBUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.EJBNode;

public class EJBPropertyDialog
extends JDialog
implements ActionListener {
    JTextField[] fields;
    JLabel[] labels;
    JButton okButton;
    JButton cancelButton;
    private boolean isModified = false;
    DefaultMutableTreeNode parent;
    EJBNode node;
    Hashtable<String, String> env = null;

    public EJBPropertyDialog(JDialog parentDialog, DefaultMutableTreeNode parent, EJBNode node) {
        super(parentDialog, LanguageEncoder.getText("Setup Environment...."), true);
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel envPanel = new JPanel();
        envPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please enter environment information:")));
        envPanel.setLayout(new GridBagLayout());
        int envCt = EJBUtil.PROP_KEYS.length;
        this.fields = new JTextField[envCt];
        this.labels = new JLabel[envCt];
        for (int i = 0; i < envCt; ++i) {
            GridBagConstraints cons = new GridBagConstraints();
            cons.anchor = 13;
            cons.insets = new Insets(0, 0, 0, 5);
            this.labels[i] = new JLabel(EJBUtil.PROP_KEYS[i]);
            envPanel.add((Component)this.labels[i], cons);
            GridBagConstraints cons2 = new GridBagConstraints();
            cons2.gridwidth = 0;
            this.fields[i] = new JTextField(25);
            envPanel.add((Component)this.fields[i], cons2);
            this.fields[i].setText("");
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("Ok"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", envPanel);
        contentPane.add("Center", buttonPanel);
        this.setValues(this.node);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void setValues(EJBNode node) {
        if (node != null && node.getEnvironment() != null) {
            this.env = node.getEnvironment();
            for (int i = 0; i < EJBUtil.PROP_STRINGS.length; ++i) {
                String key = EJBUtil.PROP_STRINGS[i];
                if (!this.env.containsKey(key)) continue;
                String val = this.env.get(key);
                this.fields[i].setText(val);
            }
        }
    }

    boolean isModified() {
        return this.isModified;
    }

    Hashtable<String, String> getEnvironment() {
        return this.env;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.updateEnv();
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private void updateEnv() {
        this.env = new Hashtable();
        for (int i = 0; i < this.fields.length; ++i) {
            String val = this.fields[i].getText();
            if (val.trim().length() <= 0) continue;
            this.env.put(EJBUtil.PROP_STRINGS[i], val);
        }
    }
}

