/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.datasourcemanager.manager.INParametersDialog;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.designer.SimpleQBEWindow;

public class EnterSQLDialog
extends JDialog
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(EnterSQLDialog.class.getName());
    private String query;
    JButton okButton;
    JButton cancelButton;
    JButton importButton;
    JButton exportButton;
    JButton csvButton;
    JButton paramButton;
    private boolean isModified = false;
    SimpleQBEWindow qbeWindow = null;
    QueryMain queryMain = null;
    DBInfoBasic dbInfo = null;
    private QueryInParamSet paramSet = null;
    private boolean defaultValueRequired = false;

    public EnterSQLDialog(JFrame parent, QueryMain queryMain, DBInfoBasic dbInfo, String sqlStatement, QueryInParamSet inSet) {
        super(parent, LanguageEncoder.getText("Set SQL Statement..."), true);
        this.query = sqlStatement;
        this.queryMain = queryMain;
        this.dbInfo = dbInfo;
        this.paramSet = inSet;
        this.defaultValueRequired = queryMain.isDefaultValueRequiredForParameters();
        this.init();
        this.setPosition();
    }

    public EnterSQLDialog(Dialog parent, QueryMain queryMain, DBInfoBasic dbInfo, String sqlStatement, QueryInParamSet inSet) {
        super(parent, LanguageEncoder.getText("Set SQL Statement..."), true);
        this.query = sqlStatement;
        this.queryMain = queryMain;
        this.dbInfo = dbInfo;
        this.paramSet = inSet;
        this.defaultValueRequired = queryMain.isDefaultValueRequiredForParameters();
        this.init();
        this.setPosition();
    }

    private void init() {
        this.addCloseListener();
        try {
            this.queryMain.setDatabaseInfo(this.dbInfo);
            this.qbeWindow = new SimpleQBEWindow(this.queryMain, this.query);
            this.qbeWindow.setInSet(this.paramSet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.importButton = new JButton(LanguageEncoder.getText("Import Query"));
        this.importButton.addActionListener(this);
        this.exportButton = new JButton(LanguageEncoder.getText("Export Query"));
        this.exportButton.addActionListener(this);
        this.csvButton = new JButton(LanguageEncoder.getText("Generate CSV"));
        this.csvButton.addActionListener(this);
        this.paramButton = new JButton(LanguageEncoder.getText("Initialize Parameters"));
        this.paramButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.importButton);
        buttonPanel.add(this.exportButton);
        buttonPanel.add(this.csvButton);
        buttonPanel.add(this.paramButton);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.qbeWindow);
        contentPane.add("South", buttonPanel);
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.6);
        dim.width = (int)((double)screenSize.width * 0.55);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            this.isModified = false;
        }
        super.setVisible(state);
    }

    public void setInSet(QueryInParamSet ps) {
        this.paramSet = ps;
    }

    public QueryInParamSet getInSet() {
        return this.paramSet;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getSQLStatement() {
        return this.qbeWindow.getQuery();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (!this.saveChanges()) {
                return;
            }
            this.setVisible(false);
            this.dispose();
        } else if (source == this.importButton) {
            if (Manager.getImportQRYFile() != null) {
                Manager.getImportQRYFile().importQRYFile();
                return;
            }
            String currentDir = this.queryMain.getBrowseDirectories().getQueryExportDir();
            OpenFileDialog fDialog = new OpenFileDialog(this.queryMain, LanguageEncoder.getText("Import Query File {SQL File}"), currentDir, new String[]{"SQL"}, currentDir, true);
            fDialog.setVisible(true);
            String sFile = fDialog.getSelectedFile();
            if (sFile != null) {
                this.queryMain.getBrowseDirectories().setQueryExportDir(fDialog.getCurrentDirectory());
                if (!OverWriteDialog.isFileExisted(this.queryMain, sFile)) {
                    return;
                }
                try {
                    ReadDataFile readfile = new ReadDataFile();
                    DataInputStream din = readfile.getInputStream(sFile);
                    if (din.available() < 0) {
                        readfile.close();
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Can't read") + " " + sFile + "!");
                        return;
                    }
                    byte[] b = new byte[din.available()];
                    din.readFully(b);
                    readfile.close();
                    this.qbeWindow.setQuery(new String(b));
                }
                catch (Exception ex) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Can't read") + " " + sFile + "!\n" + ex.toString());
                    return;
                }
            }
        } else if (source == this.exportButton) {
            try {
                this.queryMain.export(0, this.qbeWindow.getQuery());
            }
            catch (Exception e1) {
                LOGGER.log(Level.WARNING, "Export Query Failed", e1);
                e1.printStackTrace();
            }
        } else if (source == this.csvButton) {
            try {
                this.queryMain.export(1, this.qbeWindow.getQuery());
            }
            catch (Exception e1) {
                LOGGER.log(Level.WARNING, "Export CSV Failed", e1);
                e1.printStackTrace();
            }
        } else if (source == this.paramButton) {
            this.showParameters();
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private boolean saveChanges() {
        this.paramSet = this.qbeWindow.getInSet();
        QueryInParamSet tempParamSet = QueryParser.filterParameters(this.qbeWindow.getQuery(), this.paramSet);
        if (!this.queryMain.parameterSharingOK(tempParamSet) || !this.queryMain.parameterMappingOK(tempParamSet)) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Cannot save query, it violates parameter sharing conditions"));
            return false;
        }
        this.query = this.qbeWindow.getQuery();
        this.isModified = true;
        return true;
    }

    private void showParameters() {
        String query = this.getSQLStatement();
        if (QueryParser.hasParameters(query)) {
            QueryInParamSet tempParamSet = QueryParser.filterParameters(query, this.paramSet);
            DBInfoBasic tempDbInfo = null;
            tempDbInfo = this.dbInfo.isUseJNDIDataSource() ? new DBInfoBasic(this.dbInfo.getJNDIName(), query, this.dbInfo.getEnvProperties()) : new DBInfoBasic(this.dbInfo.getURLString(), this.dbInfo.getDriverName(), this.dbInfo.getUserID(), this.dbInfo.getPassword(), query, this.dbInfo.getAdditionalDb());
            QueryFileInfo qfi = new QueryFileInfo("", 0, tempDbInfo, tempParamSet);
            try {
                boolean showPromptSequence = !this.queryMain.forChart();
                INParametersDialog pDialog = new INParametersDialog(this, qfi, false, showPromptSequence, this.queryMain.getTableNameFormat());
                pDialog.setDefaultValueRequired(this.defaultValueRequired);
                pDialog.setVisible(true);
                if (pDialog.isModified()) {
                    tempParamSet = pDialog.getQueryInParamSet();
                    if (tempParamSet == null) {
                        throw new Exception(LanguageEncoder.getText("This query contains irrecoverable errors."));
                    }
                } else {
                    return;
                }
                this.paramSet = tempParamSet;
                this.qbeWindow.setInSet(this.paramSet);
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to initialize parameters for parameterized query."));
                return;
            }
        } else {
            new JMessageDialog((Dialog)this, "Information", LanguageEncoder.getText("This query does not contain parameters."));
            return;
        }
    }

    private void addCloseListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EnterSQLDialog.this.showCloseWarning();
            }
        });
    }

    private void showCloseWarning() {
        if (!this.qbeWindow.getQuery().equals(this.query)) {
            int response = JOptionPane.showConfirmDialog(this, LanguageEncoder.getText("Do you want to save changes?"), LanguageEncoder.getText("Warning"), 0);
            if (response == 0 && !this.saveChanges()) {
                return;
            }
            this.dispose();
        } else {
            this.dispose();
        }
    }
}

