/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.querybuilder.designer.TableTreeNode;
import quadbase.querybuilder.query.DatabaseInfo;
import quadbase.querybuilder.query.QueryBuilder;

public class EnterSQLSelectDialog
extends JDialog
implements ActionListener,
MouseListener {
    private QueryFileInfo queryFileInfo = null;
    private boolean modified = false;
    private boolean isDefaultSQL;
    private String sqlSelect;
    private UndoTextArea ta;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton insertBtn;
    private JTree tableTree;
    private DatabaseInfo databaseInfo;
    private int databaseType;
    private int tableNameFormat = 0;

    public EnterSQLSelectDialog(JDialog parent, QueryFileInfo qfi, String sqlSelect, int format, boolean isDefaultSQL) {
        super((Dialog)parent, true);
        this.queryFileInfo = qfi;
        this.sqlSelect = sqlSelect;
        this.tableNameFormat = format;
        this.isDefaultSQL = isDefaultSQL;
        this.setTitle(LanguageEncoder.getText("Map Parameter to SQL ResultSet"));
        this.init(sqlSelect);
        this.addCloseListener();
        this.setPosition();
    }

    private void init(String sqlSelect) {
        JScrollPane editPanel = new JScrollPane();
        if (sqlSelect == null || sqlSelect.equals("")) {
            sqlSelect = "SELECT DISTINCT";
        }
        this.ta = new UndoTextArea(sqlSelect, 16, 60);
        editPanel.getViewport().add(this.ta);
        JSplitPane splitPane = new JSplitPane(1, false);
        splitPane.setLeftComponent(editPanel);
        splitPane.setRightComponent(this.getHelperPanel());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JLabel helpLabel = this.isDefaultSQL ? new JLabel("<html>Please enter SQL statement that returns one column.</html>") : new JLabel("<html>Please enter SQL statement that returns one or two columns.<br>The first column of a two-column query will be displayed in the parameter prompt and the second will be used in the query.</html>");
        helpLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)helpLabel, "North");
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    public JScrollPane getHelperPanel() {
        Vector tablelist = null;
        try {
            this.databaseInfo = this.queryFileInfo.isUseJNDIDataSource() ? new DatabaseInfo(this.queryFileInfo.getJNDIName(), this.queryFileInfo.getEnvProperties()) : new DatabaseInfo(this.queryFileInfo.getDriverName(), this.queryFileInfo.getURLString(), this.queryFileInfo.getUserID(), this.queryFileInfo.getPassword());
            tablelist = this.databaseInfo.getTableList(new String[]{"TABLE", "VIEW", "MATERIALIZED QUERY TABLE", "SYNONYM", "ALIAS"}, this.tableNameFormat);
            this.databaseType = QueryBuilder.mapDatabaseType(this.databaseInfo.getProductName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TableTreeNode[] allTables = new TableTreeNode[tablelist.size()];
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        DefaultMutableTreeNode tables = new DefaultMutableTreeNode("Tables");
        root.add(tables);
        for (int i = 0; i < tablelist.size(); ++i) {
            TableTreeNode node = new TableTreeNode(this.databaseInfo, (String)tablelist.elementAt(i));
            node.setMaster(true);
            allTables[i] = node;
        }
        for (TableTreeNode allTable : allTables) {
            tables.add(allTable);
        }
        DefaultMutableTreeNode parameters = this.getParameterList();
        root.add(parameters);
        this.tableTree = new JTree(root, true);
        this.tableTree.setRootVisible(false);
        this.tableTree.setShowsRootHandles(false);
        this.tableTree.setVisibleRowCount(14);
        this.tableTree.addMouseListener(this);
        this.tableTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                Object node;
                if (event.getSource() == EnterSQLSelectDialog.this.tableTree && (node = event.getPath().getLastPathComponent()) instanceof TableTreeNode) {
                    try {
                        ((TableTreeNode)node).generateColumns();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        String excep = "";
                        try {
                            excep = QbUtil.replace(ex.toString(), "Exception: ", "Exception:\n");
                            excep = "\n" + excep;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        new JMessageDialog((Dialog)EnterSQLSelectDialog.this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to retrieve columns for this table.\n") + excep);
                    }
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        });
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.tableTree);
        Dimension d = scroll.getPreferredSize();
        scroll.setPreferredSize(new Dimension(250, (int)d.getHeight()));
        return scroll;
    }

    private DefaultMutableTreeNode getParameterList() {
        DefaultMutableTreeNode paramNode = new DefaultMutableTreeNode("Parameters");
        String[] paramNames = QueryParser.getAllParameters(this.queryFileInfo.getQuery());
        for (int i = 0; paramNames != null && i < paramNames.length; ++i) {
            paramNode.add(new DefaultMutableTreeNode(":" + paramNames[i]));
        }
        return paramNode;
    }

    public JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.insertBtn = new JButton(LanguageEncoder.getText("Insert"));
        buttonPanel.add(this.insertBtn);
        this.insertBtn.addActionListener(this);
        this.okBtn = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.okBtn);
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton(LanguageEncoder.getText("Cancel"));
        buttonPanel.add(this.cancelBtn);
        this.cancelBtn.addActionListener(this);
        return buttonPanel;
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okBtn) {
            if (!this.saveChanges()) {
                return;
            }
        } else if (source == this.insertBtn) {
            this.insertText(this.getSelectedText());
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private boolean saveChanges() {
        String s = QueryParser.testSqlSelect(this.queryFileInfo, this.ta.getText(), this.isDefaultSQL);
        if (!s.equals("success")) {
            new JMessageDialog((Dialog)this, "ERROR", LanguageEncoder.getText("The sql statement is not valid!\n") + s);
            return false;
        }
        this.sqlSelect = this.ta.getText();
        this.modified = true;
        return true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int selRow = this.tableTree.getRowForLocation(e.getX(), e.getY());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tableTree.getSelectionPath().getLastPathComponent();
        if (!node.isLeaf()) {
            return;
        }
        if (selRow != -1 && e.getClickCount() >= 2) {
            this.insertText(this.getSelectedText());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private String getSelectedText() {
        if (this.tableTree.isSelectionEmpty()) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tableTree.getSelectionPath().getLastPathComponent();
        DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)node.getParent();
        if (tableNode.getUserObject().toString().equals("Parameters")) {
            return node.getUserObject().toString();
        }
        if (node instanceof TableTreeNode) {
            return QueryBuilder.print(this.databaseType, node.getUserObject().toString());
        }
        String tableName = tableNode.getUserObject().toString();
        String columnName = node.getUserObject().toString();
        return QueryBuilder.print(this.databaseType, tableName) + "." + QueryBuilder.print(this.databaseType, columnName);
    }

    private void insertText(String newStr) {
        if (newStr == null) {
            return;
        }
        this.ta.replaceSelection(newStr);
    }

    private void addCloseListener() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EnterSQLSelectDialog.this.showCloseWarning();
            }
        });
    }

    private void showCloseWarning() {
        if (!this.ta.getText().equals(this.sqlSelect)) {
            int response = JOptionPane.showConfirmDialog(this, LanguageEncoder.getText("Do you want to save changes?"), LanguageEncoder.getText("Warning"), 0);
            if (response == 0 && !this.saveChanges()) {
                return;
            }
            this.dispose();
        } else {
            this.dispose();
        }
    }
}

