/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.ExcelDataSourceDialogPanel1;
import quadbase.datasourcemanager.manager.ExcelDataSourceDialogPanel2;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.Manager;

public class ExcelDataSourceDialog
extends JDialog
implements ActionListener {
    private Manager manager;
    private DefaultMutableTreeNode parent;
    private ExcelFileNode node;
    private JTextField nameField;
    private JTabbedPane tabbedPane;
    private ExcelDataSourceDialogPanel1 panel1;
    private ExcelDataSourceDialogPanel2 panel2;
    private JButton okButton;
    private JButton cancelButton;
    private boolean isModified = false;
    private boolean reloadPanel2 = false;

    public ExcelDataSourceDialog(Manager manager, DefaultMutableTreeNode parent, ExcelFileNode node) {
        super(manager, LanguageEncoder.getText("Setup Excel Data Source"), true);
        this.manager = manager;
        this.parent = parent;
        this.node = node;
        this.init();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public ExcelFileNode getNode() {
        return this.node;
    }

    public ExcelFileInfo createExcelFileInfo() {
        ExcelFileInfo ifo = new ExcelFileInfo(null);
        this.panel1.setAttributes(ifo);
        this.panel2.setAttributes(ifo);
        return ifo;
    }

    public void setPanel2Enabled(boolean state) {
        this.tabbedPane.setEnabledAt(1, state);
        this.okButton.setEnabled(state);
    }

    public void reloadPanel2() {
        this.reloadPanel2 = true;
    }

    private void init() {
        JPanel namePanel = new JPanel(new BorderLayout(5, 5));
        namePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        namePanel.add("West", new JLabel(LanguageEncoder.getText("Data Source Name:")));
        this.nameField = new JTextField();
        namePanel.add("Center", this.nameField);
        this.tabbedPane = new JTabbedPane();
        this.panel1 = new ExcelDataSourceDialogPanel1(this);
        this.panel2 = new ExcelDataSourceDialogPanel2(this);
        this.tabbedPane.add(LanguageEncoder.getText("Data"), this.panel1);
        this.tabbedPane.add(LanguageEncoder.getText("Options"), this.panel2);
        this.tabbedPane.setModel(new CheckingSelectionModel());
        this.tabbedPane.setSelectedIndex(0);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        Container cp = this.getContentPane();
        cp.add("North", namePanel);
        cp.add("Center", this.tabbedPane);
        cp.add("South", buttonPanel);
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setValues();
    }

    private void setValues() {
        if (this.node != null) {
            this.nameField.setText(this.node.getName());
        }
        this.panel1.setValues(this.node);
        this.panel2.setValues(this.node);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            if (this.reloadPanel2) {
                this.panel2.reloadPreview();
                this.reloadPanel2 = false;
            }
            String msg = null;
            String nodeName = this.nameField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name!");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            } else if (this.panel1.getErrorMessage() != null) {
                msg = this.panel1.getErrorMessage();
            } else if (this.panel2.getErrorMessage() != null) {
                msg = this.panel2.getErrorMessage();
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.node == null) {
                this.node = new ExcelFileNode(nodeName);
                this.parent.add(this.node);
            } else {
                this.node.setUserObject(nodeName);
            }
            this.panel1.setAttributes(this.node);
            this.panel2.setAttributes(this.node);
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.cancelButton) {
            this.isModified = false;
            this.manager.managerPane.closeEditOrAddNode();
            this.setVisible(false);
            this.dispose();
        }
    }

    private class CheckingSelectionModel
    extends DefaultSingleSelectionModel {
        private CheckingSelectionModel() {
        }

        @Override
        public void setSelectedIndex(int newIndex) {
            int oldIndex = this.getSelectedIndex();
            if (oldIndex == 0) {
                String msg = ExcelDataSourceDialog.this.panel1.getErrorMessage();
                if (msg != null) {
                    new JMessageDialog((Dialog)ExcelDataSourceDialog.this, LanguageEncoder.getText("Error"), msg);
                    return;
                }
                if (ExcelDataSourceDialog.this.reloadPanel2) {
                    ExcelDataSourceDialog.this.panel2.reloadPreview();
                    ExcelDataSourceDialog.this.reloadPanel2 = false;
                }
            }
            super.setSelectedIndex(newIndex);
        }
    }
}

