/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import quadbase.chart.ColData;
import quadbase.chart.ExcelAccess;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.JSpreadsheetTable;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.ExcelReader;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.ExcelDataSourceDialog;
import quadbase.datasourcemanager.manager.ExcelFileNode;

public class ExcelDataSourceDialogPanel1
extends JPanel
implements ActionListener,
ItemListener {
    private ExcelDataSourceDialog excelDialog;
    private boolean isModified = false;
    private JTextField filePathField;
    private JCheckBox relativePathCheckbox;
    private JButton browseButton;
    private JComboBox sheetList;
    private JTextField rangeField;
    private JFileChooser fileChooser;
    private BrowseDialog browseDialog;
    private JPanel previewPanel;
    private JSpreadsheetTable spreadsheet;

    public ExcelDataSourceDialogPanel1(ExcelDataSourceDialog excelDialog) {
        super(new BorderLayout());
        this.excelDialog = excelDialog;
        this.init();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public String getErrorMessage() {
        String errorMessage = null;
        if (this.spreadsheet == null) {
            errorMessage = LanguageEncoder.getText("No data available.");
        } else if (this.spreadsheet.getFirstSelectedColumnIndex() < 0 || this.spreadsheet.getFirstSelectedRowIndex() < 0) {
            errorMessage = LanguageEncoder.getText("Please select data range.");
            String range = this.rangeField.getText();
            try {
                if (range != null && range.length() > 0 && !range.equals("0:0")) {
                    new AreaReference(range, SpreadsheetVersion.EXCEL97);
                }
            }
            catch (Exception e) {
                errorMessage = LanguageEncoder.getText("Invalid data range.");
            }
        }
        return errorMessage;
    }

    public void setAttributes(ExcelFileNode node) {
        node.setFilename(this.filePathField.getText());
        node.setSheetName((String)this.sheetList.getSelectedItem());
        node.setMinRow(this.spreadsheet.getFirstSelectedRowIndex());
        node.setMinColumn(this.spreadsheet.getFirstSelectedColumnIndex());
        node.setMaxRow(this.spreadsheet.getLastSelectedRowIndex());
        node.setMaxColumn(this.spreadsheet.getLastSelectedColumnIndex());
    }

    public void setAttributes(ExcelFileInfo ifo) {
        ifo.setFilename(this.filePathField.getText());
        ifo.setSheetName((String)this.sheetList.getSelectedItem());
        ifo.setMinRow(this.spreadsheet.getFirstSelectedRowIndex());
        ifo.setMinColumn(this.spreadsheet.getFirstSelectedColumnIndex());
        ifo.setMaxRow(this.spreadsheet.getLastSelectedRowIndex());
        ifo.setMaxColumn(this.spreadsheet.getLastSelectedColumnIndex());
    }

    public void setValues(ExcelFileNode node) {
        if (node != null) {
            this.filePathField.setText(node.getFilename());
            this.rangeField.setText(ExcelReader.getExcelColumnNameForIndex(node.getMinColumn()) + (node.getMinRow() + 1) + ":" + ExcelReader.getExcelColumnNameForIndex(node.getMaxColumn()) + (node.getMaxRow() + 1));
            if (this.readFile(node.getSheetName())) {
                this.spreadsheet.setSelection(node.getMinRow(), node.getMinColumn(), node.getMaxRow(), node.getMaxColumn());
            }
        } else {
            this.setPreviewEnabled(false, null, null);
        }
        this.setRelativePathCheckBox();
        this.relativePathCheckbox.addItemListener(this);
        this.sheetList.addItemListener(this);
    }

    private void init() {
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Select Excel spreadsheet")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 5, 5);
        gbc.anchor = 17;
        gbc.gridy = 0;
        topPanel.add((Component)new JLabel(LanguageEncoder.getText("File path:")), gbc);
        this.filePathField = new JTextField(50);
        this.filePathField.setEditable(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        topPanel.add((Component)this.filePathField, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        this.browseButton.addActionListener(this);
        topPanel.add((Component)this.browseButton, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 3;
        this.relativePathCheckbox = new JCheckBox(LanguageEncoder.getText("Use relative path"), true);
        topPanel.add((Component)this.relativePathCheckbox, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        topPanel.add((Component)new JLabel(LanguageEncoder.getText("Sheet:")), gbc);
        this.sheetList = new JComboBox();
        gbc.ipadx = 50;
        topPanel.add((Component)this.sheetList, gbc);
        ++gbc.gridy;
        gbc.ipadx = 0;
        topPanel.add((Component)new JLabel(LanguageEncoder.getText("Range:")), gbc);
        this.rangeField = new JTextField();
        this.rangeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExcelDataSourceDialogPanel1.this.displayRange();
                ExcelDataSourceDialogPanel1.this.excelDialog.reloadPanel2();
            }
        });
        gbc.fill = 2;
        topPanel.add((Component)this.rangeField, gbc);
        gbc.fill = 0;
        topPanel.add((Component)new JLabel(LanguageEncoder.getText("(either type it in manually or select it using mouse in the preview below)")), gbc);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.setBorder(BorderFactory.createTitledBorder(LanguageEncoder.getText("Select data range")));
        this.add("North", topPanel);
        this.add("Center", this.previewPanel);
    }

    private void setPreviewEnabled(boolean state, String[] sheetNames, String sheetName) {
        this.excelDialog.setPanel2Enabled(state);
        this.sheetList.setEnabled(state);
        this.rangeField.setEnabled(state);
        if (state && sheetNames != null) {
            this.sheetList.setModel(new DefaultComboBoxModel<String>(sheetNames));
            if (sheetName != null) {
                this.sheetList.setSelectedItem(sheetName);
            }
            this.showPreview();
        } else {
            String msg = LanguageEncoder.getText("Select file first");
            this.sheetList.setModel(new DefaultComboBoxModel<String>(new String[]{msg}));
            this.previewPanel.removeAll();
            this.previewPanel.revalidate();
            this.previewPanel.repaint();
        }
    }

    private void showPreview() {
        ColData[] colData;
        String errorMsg;
        block7: {
            errorMsg = null;
            colData = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ExcelFileInfo ifo = new ExcelFileInfo(this.filePathField.getText());
                ifo.setSheetName((String)this.sheetList.getSelectedItem());
                colData = ExcelAccess.getColData(ifo);
                if (colData == null || colData.length == 1) {
                    errorMsg = LanguageEncoder.getText("No data available.");
                }
            }
            catch (Exception e) {
                errorMsg = LanguageEncoder.getText("Failed to retrieve data.");
                if (e.getMessage() == null) break block7;
                errorMsg = errorMsg + "\n" + e.getMessage();
            }
        }
        this.previewPanel.removeAll();
        if (errorMsg == null && colData != null) {
            String[] columnNames = new String[colData.length - 1];
            Object[][] data = new Object[colData[0].getSize()][colData.length - 1];
            for (int i = 0; i < colData.length - 1; ++i) {
                columnNames[i] = colData[i].getName();
                for (int j = 0; j < colData[i].getSize(); ++j) {
                    data[j][i] = colData[i].getData(j);
                }
            }
            this.spreadsheet = new JSpreadsheetTable(data, columnNames);
            this.spreadsheet.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ExcelDataSourceDialogPanel1.this.updateRange();
                    ExcelDataSourceDialogPanel1.this.excelDialog.reloadPanel2();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    ExcelDataSourceDialogPanel1.this.updateRange();
                    ExcelDataSourceDialogPanel1.this.excelDialog.reloadPanel2();
                }
            });
            this.previewPanel.add("Center", this.spreadsheet);
            this.displayRange();
        } else {
            errorMsg = "<html>" + QbUtil.escapeHTML(errorMsg) + "</html>";
            JLabel text = new JLabel(errorMsg);
            this.previewPanel.add("North", text);
            this.spreadsheet = null;
        }
        this.previewPanel.revalidate();
        this.previewPanel.repaint();
        this.excelDialog.reloadPanel2();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean readFile(String sheetName) {
        String path = this.filePathField.getText();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] sheetNames = ExcelAccess.getSheetNames(path);
            if (sheetName != null && !Arrays.asList(sheetNames).contains(sheetName)) {
                new JMessageDialog((Dialog)this.excelDialog, LanguageEncoder.getText("Error"), sheetName + " " + LanguageEncoder.getText("sheet not found. First sheet will be selected."));
                sheetName = null;
            }
            this.setPreviewEnabled(true, sheetNames, sheetName);
            this.setCursor(Cursor.getDefaultCursor());
            return true;
        }
        catch (Throwable e) {
            this.setCursor(Cursor.getDefaultCursor());
            String msg = LanguageEncoder.getText("Failed to read file.");
            if (e.getMessage() != null) {
                msg = msg + "\n" + e.getMessage();
            }
            new JMessageDialog((Dialog)this.excelDialog, LanguageEncoder.getText("Error"), msg);
            this.setPreviewEnabled(false, null, null);
            return false;
        }
    }

    private void updateRange() {
        if (this.spreadsheet == null) {
            return;
        }
        int minRow = this.spreadsheet.getFirstSelectedRowIndex();
        int maxRow = this.spreadsheet.getLastSelectedRowIndex();
        int minColumn = this.spreadsheet.getFirstSelectedColumnIndex();
        int maxColumn = this.spreadsheet.getLastSelectedColumnIndex();
        this.rangeField.setText(ExcelReader.getExcelColumnNameForIndex(minColumn) + (minRow + 1) + ":" + ExcelReader.getExcelColumnNameForIndex(maxColumn) + (maxRow + 1));
    }

    private void displayRange() {
        AreaReference ref;
        if (this.spreadsheet == null) {
            return;
        }
        String range = this.rangeField.getText();
        try {
            ref = new AreaReference(range, SpreadsheetVersion.EXCEL97);
        }
        catch (Exception e) {
            this.spreadsheet.clearSelection();
            return;
        }
        CellReference firstCell = ref.getFirstCell();
        CellReference lastCell = ref.getLastCell();
        int minRow = Math.min(firstCell.getRow(), lastCell.getRow());
        int minColumn = Math.min(firstCell.getCol(), lastCell.getCol());
        int maxRow = Math.max(firstCell.getRow(), lastCell.getRow());
        int maxColumn = Math.max(firstCell.getCol(), lastCell.getCol());
        this.spreadsheet.setSelection(minRow, minColumn, maxRow, maxColumn);
    }

    private void setRelativePathCheckBox() {
        String path = this.filePathField.getText();
        File f = new File(path);
        if (f.isAbsolute()) {
            String relativePath = QbUtil.createRelativePath(path, IOUtil.getWorkingDirectory());
            this.relativePathCheckbox.setEnabled(relativePath != null);
            this.relativePathCheckbox.setSelected(false);
        } else {
            this.relativePathCheckbox.setEnabled(true);
            this.relativePathCheckbox.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.browseButton) {
            String dir = this.filePathField.getText();
            if (dir != null) {
                int idx = (dir = dir.replace('\\', '/')).lastIndexOf(47);
                dir = idx > 0 ? dir.substring(0, idx) : null;
            }
            String selectedFile = null;
            if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                if (this.fileChooser == null) {
                    this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                    if (dir != null) {
                        this.fileChooser.setCurrentDirectory(new File(dir));
                    } else {
                        this.fileChooser.setCurrentDirectory(new File("."));
                    }
                    this.fileChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"XLS", "XLSX"}));
                }
                this.fileChooser.showDialog(this, null);
                File f = this.fileChooser.getSelectedFile();
                if (f != null) {
                    selectedFile = f.getAbsolutePath();
                }
            } else {
                if (this.browseDialog == null) {
                    this.browseDialog = BrowseDialog.create(this.excelDialog, dir, new String[]{"XLS", "XLSX"});
                }
                this.browseDialog.setVisible(true);
                selectedFile = this.browseDialog.getSelectedFile();
            }
            if (selectedFile != null) {
                String relativePath;
                File file = new File(selectedFile);
                if (this.relativePathCheckbox.isSelected() && file.isAbsolute() && (relativePath = QbUtil.createRelativePath(selectedFile, IOUtil.getWorkingDirectory())) != null) {
                    selectedFile = relativePath;
                }
                this.filePathField.setText(selectedFile);
                this.setRelativePathCheckBox();
                this.readFile(null);
            }
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this.sheetList) {
            this.excelDialog.reloadPanel2();
            this.showPreview();
        } else if (e.getSource() == this.relativePathCheckbox) {
            if (!this.relativePathCheckbox.isEnabled()) {
                return;
            }
            String path = this.filePathField.getText();
            if (path == null || path.length() == 0) {
                return;
            }
            path = e.getStateChange() == 1 ? QbUtil.createRelativePath(path, IOUtil.getWorkingDirectory()) : QbUtil.createAbsolutePath(path, IOUtil.getWorkingDirectory());
            this.filePathField.setText(path);
        }
    }
}

