/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.chart.ColData;
import quadbase.chart.ExcelAccess;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.datasourcemanager.manager.ExcelDataSourceDialog;
import quadbase.datasourcemanager.manager.ExcelDataTypesPanel;
import quadbase.datasourcemanager.manager.ExcelFileNode;

public class ExcelDataSourceDialogPanel2
extends JPanel
implements ItemListener {
    private ExcelDataSourceDialog excelDialog;
    private JRadioButton dataAreRowsRadio;
    private JRadioButton dataAreColumnsRadio;
    private JCheckBox includeNewDataCheckbox;
    private JCheckBox hasHeaderCheckBox;
    private JPanel previewPanel;
    private ExcelDataTypesPanel dataTypesPanel;
    int[] dataTypes = null;

    public ExcelDataSourceDialogPanel2(ExcelDataSourceDialog excelDialog) {
        super(new BorderLayout());
        this.excelDialog = excelDialog;
        this.init();
    }

    public String getErrorMessage() {
        if (this.dataTypesPanel == null) {
            return LanguageEncoder.getText("Cannot save datasource without any data.");
        }
        return null;
    }

    public void setAttributes(ExcelFileNode node) {
        node.setIncludeNewData(this.includeNewDataCheckbox.isSelected());
        node.setHasHeader(this.hasHeaderCheckBox.isSelected());
        node.setDataAreRows(this.dataAreRowsRadio.isSelected());
        node.setDataTypes(this.dataTypesPanel.getDataTypes());
    }

    public void setAttributes(ExcelFileInfo ifo) {
        ifo.setIncludeNewData(this.includeNewDataCheckbox.isSelected());
        ifo.setHasHeader(this.hasHeaderCheckBox.isSelected());
        ifo.setDataAreRows(this.dataAreRowsRadio.isSelected());
        ifo.setDataTypes(this.dataTypes);
    }

    public void setValues(ExcelFileNode node) {
        if (node != null) {
            this.includeNewDataCheckbox.setSelected(node.isIncludeNewData());
            this.hasHeaderCheckBox.setSelected(node.isHasHeader());
            if (node.isDataAreRows()) {
                this.dataAreRowsRadio.setSelected(true);
            } else {
                this.dataAreColumnsRadio.setSelected(true);
            }
            this.dataTypes = node.getDataTypes();
            this.showPreview();
        }
        this.hasHeaderCheckBox.addItemListener(this);
        this.includeNewDataCheckbox.addItemListener(this);
        this.dataAreColumnsRadio.addItemListener(this);
        this.dataAreRowsRadio.addItemListener(this);
    }

    public void reloadPreview() {
        this.dataTypes = null;
        this.showPreview();
    }

    private void init() {
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        optionsPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data options")));
        gbc.gridy = 0;
        optionsPanel.add((Component)new JLabel(LanguageEncoder.getText("Data are in:") + " "), gbc);
        this.dataAreColumnsRadio = new JRadioButton(LanguageEncoder.getText("columns"), true);
        optionsPanel.add((Component)this.dataAreColumnsRadio, gbc);
        this.dataAreRowsRadio = new JRadioButton(LanguageEncoder.getText("rows"), false);
        optionsPanel.add((Component)this.dataAreRowsRadio, gbc);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(this.dataAreColumnsRadio);
        radioGroup.add(this.dataAreRowsRadio);
        gbc.weightx = 1.0;
        optionsPanel.add((Component)new JPanel(), gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 4;
        this.hasHeaderCheckBox = new JCheckBox(LanguageEncoder.getText("Table has headers"), true);
        optionsPanel.add((Component)this.hasHeaderCheckBox, gbc);
        ++gbc.gridy;
        this.includeNewDataCheckbox = new JCheckBox("", true);
        optionsPanel.add((Component)this.includeNewDataCheckbox, gbc);
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Preview")));
        this.add("North", optionsPanel);
        this.add("Center", this.previewPanel);
        if (this.dataAreColumnsRadio.isSelected()) {
            this.includeNewDataCheckbox.setText(LanguageEncoder.getText("Include additional rows"));
        } else {
            this.includeNewDataCheckbox.setText(LanguageEncoder.getText("Include additional columns"));
        }
    }

    private void showPreview() {
        ColData[] colData;
        String errorMsg;
        block7: {
            errorMsg = null;
            colData = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ExcelFileInfo ifo = this.excelDialog.createExcelFileInfo();
                colData = ExcelAccess.getColData(ifo);
                if (colData == null || colData.length == 1) {
                    errorMsg = LanguageEncoder.getText("No data available.");
                }
            }
            catch (Exception e) {
                errorMsg = LanguageEncoder.getText("Failed to retrieve data.");
                if (e.getMessage() == null) break block7;
                errorMsg = errorMsg + "\n" + e.getMessage();
            }
        }
        this.previewPanel.removeAll();
        if (errorMsg == null && colData != null) {
            this.dataTypesPanel = new ExcelDataTypesPanel(colData);
            this.previewPanel.add("Center", this.dataTypesPanel);
        } else {
            errorMsg = "<html>" + QbUtil.escapeHTML(errorMsg) + "</html>";
            JLabel text = new JLabel(errorMsg);
            this.dataTypesPanel = null;
            if (errorMsg.indexOf("Failed to parse value") > 0) {
                JButton button = new JButton("Auto-detect data types");
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExcelDataSourceDialogPanel2.this.reloadPreview();
                    }
                });
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 1));
                p.add(text);
                p.add(Box.createVerticalStrut(10));
                p.add(button);
                this.previewPanel.add("North", p);
            } else {
                this.previewPanel.add("North", text);
            }
        }
        this.previewPanel.revalidate();
        this.previewPanel.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if ((source == this.dataAreColumnsRadio || source == this.dataAreRowsRadio) && e.getStateChange() == 1 || source == this.hasHeaderCheckBox || source == this.includeNewDataCheckbox) {
            this.reloadPreview();
        }
        if (e.getStateChange() == 1) {
            if (source == this.dataAreColumnsRadio) {
                this.includeNewDataCheckbox.setText(LanguageEncoder.getText("Include additional rows"));
            } else if (source == this.dataAreRowsRadio) {
                this.includeNewDataCheckbox.setText(LanguageEncoder.getText("Include additional columns"));
            }
        }
    }
}

