/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import quadbase.chart.ColData;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ExcelDataTypesPanel
extends JScrollPane {
    private static final String[] DATA_TYPES = new String[]{"Varchar", "Integer", "Double", "Date", "Time", "Timestamp"};
    private JComboBox[] dataTypesCombo;

    public ExcelDataTypesPanel(ColData[] colData) {
        int i;
        int size = colData[0].getSize();
        int fieldNo = colData.length - 1;
        Object[] name = new String[fieldNo + 1];
        name[0] = "INDEX";
        for (int i2 = 1; i2 <= fieldNo; ++i2) {
            name[i2] = colData[i2 - 1].getName().trim();
        }
        Object[][] data = new Object[size + 1][fieldNo + 1];
        this.dataTypesCombo = new JComboBox[fieldNo];
        data[0][0] = "TYPE";
        for (i = 1; i <= fieldNo; ++i) {
            data[0][i] = DataType.getTypeName(colData[i - 1].getOriginalDataType());
            this.dataTypesCombo[i - 1] = new JComboBox<String>(DATA_TYPES);
            this.dataTypesCombo[i - 1].setSelectedItem(data[0][i]);
        }
        for (i = 1; i <= size; ++i) {
            data[i][0] = i + "";
            for (int j = 1; j <= fieldNo; ++j) {
                data[i][j] = colData[j - 1].getData(i - 1);
            }
        }
        DataTypesTable table = new DataTypesTable(data, name);
        this.setViewportView(table);
    }

    public int[] getDataTypes() {
        int[] result = new int[this.dataTypesCombo.length];
        for (int i = 0; i < this.dataTypesCombo.length; ++i) {
            result[i] = DataType.findType((String)this.dataTypesCombo[i].getSelectedItem());
        }
        return result;
    }

    private class DataTypesTableCellRenderer
    extends DefaultTableCellRenderer {
        private DataTypesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                return new JButton(value + "");
            }
            if (row == 0) {
                return ExcelDataTypesPanel.this.dataTypesCombo[column - 1];
            }
            if (value == null) {
                return super.getTableCellRendererComponent(table, "null", isSelected, hasFocus, row, column);
            }
            int dataType = DataType.mapType(DataType.findType((String)table.getValueAt(0, column)));
            Object o = DataType.createObject(value.toString(), dataType);
            return super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
        }
    }

    private class DataTypesTable
    extends JTable {
        private TableCellRenderer cellRenderer;

        public DataTypesTable(Object[][] rowData, Object[] columnNames) {
            super(rowData, columnNames);
            this.cellRenderer = new DataTypesTableCellRenderer();
            this.getTableHeader().setReorderingAllowed(false);
            this.setCellSelectionEnabled(true);
            this.setAutoResizeMode(0);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setPreferredWidth(80);
            }
            this.setRowHeight(18);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return row == 0;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (row == 0) {
                return new DefaultCellEditor(ExcelDataTypesPanel.this.dataTypesCombo[column - 1]);
            }
            return super.getCellEditor(row, column);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.cellRenderer;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row == 0 && column > 0) {
                int newDataType = DataType.mapType(DataType.findType((String)value));
                Vector incorrectValues = this.verifyDataType(column, newDataType);
                if (incorrectValues.isEmpty()) {
                    super.setValueAt(value, row, column);
                    this.repaint();
                } else {
                    JDialog parentDialog = (JDialog)SwingUtilities.getWindowAncestor(this);
                    JPanel errorPanel = new JPanel(new BorderLayout(10, 10));
                    errorPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
                    errorPanel.add("North", new JLabel(LanguageEncoder.getText("These values cannot be changed to the selected data type:")));
                    errorPanel.add("Center", new JScrollPane(new JList(incorrectValues)));
                    new JMessageDialog((Dialog)parentDialog, LanguageEncoder.getText("Error"), (JComponent)errorPanel);
                    ExcelDataTypesPanel.this.dataTypesCombo[column - 1].setSelectedItem(this.getValueAt(row, column));
                    return;
                }
            }
            super.setValueAt(value, row, column);
        }

        private Vector verifyDataType(int column, int newDataType) {
            Vector<Object> result = new Vector<Object>();
            for (int row = 1; row < this.getRowCount(); ++row) {
                Object o = this.getValueAt(row, column);
                if (o == null) continue;
                try {
                    DataType.createObject(o.toString(), newDataType);
                    continue;
                }
                catch (Exception e) {
                    result.add(o);
                }
            }
            return result;
        }
    }
}

