/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.TextFileNode;

public class FileNodeDialog
extends JDialog
implements ActionListener {
    private JTextField baseField;
    private JTextField tf;
    private JButton browseButton;
    private JButton okButton;
    private JButton cancelButton;
    private JFileChooser fileChooser;
    private BrowseDialog browseDialog;
    private DefaultMutableTreeNode parent;
    private DefaultMutableTreeNode node;
    private Manager frame;
    private boolean isModified = false;
    private boolean isClass;
    private Manager manager;

    public FileNodeDialog(Manager frame, DefaultMutableTreeNode parent, DefaultMutableTreeNode node, boolean isClass) {
        super(frame, isClass ? LanguageEncoder.getText("Setup Class File...") : LanguageEncoder.getText("Setup Text File..."), true);
        this.frame = frame;
        this.manager = frame;
        this.parent = parent;
        this.node = node;
        this.isClass = isClass;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel labelPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel textPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel browsePanel = new JPanel(new GridLayout(2, 1, 5, 5));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Name :") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("File :") + " "));
        this.baseField = new JTextField(25);
        textPanel.add(this.baseField);
        this.tf = new JTextField(25);
        textPanel.add(this.tf);
        browsePanel.add(new JLabel(""));
        this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
        browsePanel.add(this.browseButton);
        this.browseButton.addActionListener(this);
        this.baseField.addActionListener(this);
        this.tf.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add("West", labelPanel);
        p1.add("Center", textPanel);
        if (!this.isClass) {
            p1.add("East", browsePanel);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Information")));
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
        this.setValues();
    }

    private void setValues() {
        if (this.node != null) {
            if (this.isClass) {
                ClassFileNode classNode = (ClassFileNode)this.node;
                this.baseField.setText(classNode.getName());
                this.tf.setText(classNode.getFile());
            } else {
                TextFileNode txtNode = (TextFileNode)this.node;
                this.baseField.setText(txtNode.getName());
                this.tf.setText(txtNode.getFile());
            }
        } else {
            String val = this.manager.getDataSourceTextDir();
            if (this.isClass) {
                val = val.replace('/', '.');
                val = val.replace('\\', '.');
            }
            this.tf.setText(val);
        }
    }

    private String loadFile() {
        String currentDir = this.manager.getDataSourceTextDir();
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                this.fileChooser.setCurrentDirectory(new File(currentDir));
            }
            this.fileChooser.showDialog(this.frame, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            this.manager.setDataSourceTextDir(this.fileChooser.getCurrentDirectory().getAbsolutePath());
            return this.fileChooser.getSelectedFile().getAbsolutePath();
        }
        if (this.browseDialog == null) {
            this.browseDialog = BrowseDialog.create(this.frame, currentDir);
        }
        this.browseDialog.setVisible(true);
        this.manager.setDataSourceTextDir(this.browseDialog.getCurrentDirectory());
        return this.browseDialog.getSelectedFile();
    }

    boolean isModified() {
        return this.isModified;
    }

    DefaultMutableTreeNode getNode() {
        return this.node;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename = this.tf.getText();
        String msg = null;
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                this.tf.setText(fileText);
            }
            return;
        }
        if (e.getSource() == this.okButton || e.getSource() == this.tf || e.getSource() == this.baseField) {
            String nodeName = this.baseField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter data source name");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.manager.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null && (filename == null || filename.equals(""))) {
                msg = LanguageEncoder.getText("Please input a file name");
            }
            if (!this.isClass && !OverWriteDialog.isFileExisted(this.frame, filename)) {
                return;
            }
            if (msg != null) {
                new JMessageDialog((Dialog)this.frame, LanguageEncoder.getText("Error"), msg);
                return;
            }
            if (this.isClass) {
                ClassFileNode classNode = (ClassFileNode)this.node;
                if (classNode == null) {
                    classNode = new ClassFileNode(nodeName);
                    this.parent.add(classNode);
                } else {
                    classNode.setUserObject(nodeName);
                }
                classNode.setFile(filename);
                this.node = classNode;
            } else {
                TextFileNode txtNode = (TextFileNode)this.node;
                if (txtNode == null) {
                    txtNode = new TextFileNode(nodeName);
                    this.parent.add(txtNode);
                } else {
                    txtNode.setUserObject(nodeName);
                }
                txtNode.setFile(filename);
                this.node = txtNode;
            }
            this.isModified = true;
        }
        this.setVisible(false);
        this.manager.managerPane.closeEditOrAddNode();
        this.dispose();
    }
}

