/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.INParametersDialog;

public class FunctionComboBox
extends JComboBox
implements ItemListener {
    protected int PAUSE_DURATION = 1000;
    private Vector availFunctions;
    private KeyWait wait;
    private JTextField tf;
    private int width = 150;
    private int height = -1;
    private Window window;
    private INParametersDialog dialog;

    public FunctionComboBox(INParametersDialog dialog, Window w, Vector functions) {
        this.window = w;
        this.dialog = dialog;
        this.availFunctions = functions;
        this.setEditable(true);
        Component c = this.getEditor().getEditorComponent();
        if (c instanceof JTextField) {
            this.tf = (JTextField)c;
            this.tf.addKeyListener(new FunctionKeyAdapter());
        }
        this.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getItem().toString().equalsIgnoreCase("NONE")) {
            this.setNone();
            this.updateList();
        }
    }

    public void setNone() {
        this.tf.setText("None");
    }

    public void setDimensions(int width, int height) {
        if (width > 0 && height > 0) {
            this.width = width;
            this.height = height;
        }
    }

    public void setAvailFunctions(Vector functions) {
        this.availFunctions = functions;
    }

    public Dimension getDimensions() {
        return new Dimension(this.width, this.height);
    }

    public synchronized void updateList() {
        if (this.availFunctions != null) {
            String text;
            ActionListener[] al = this.getActionListeners();
            ItemListener[] il = this.getItemListeners();
            for (ActionListener actionListener : al) {
                this.removeActionListener(actionListener);
            }
            for (EventListener eventListener : il) {
                this.removeItemListener((ItemListener)eventListener);
            }
            String textFunction = text = this.tf.getText().trim();
            int caretPosition = this.tf.getCaretPosition();
            int n = text.indexOf(40);
            if (n > -1) {
                textFunction = text.substring(0, n);
            } else if (text.equalsIgnoreCase("None")) {
                textFunction = "";
            }
            this.removeAllItems();
            this.addItem(LanguageEncoder.getText("None"));
            int sizeFunGroups = this.availFunctions.size();
            for (int i = 0; i < sizeFunGroups; ++i) {
                int sizeFun = ((Vector)this.availFunctions.get(i)).size();
                for (int j = 0; j < sizeFun; ++j) {
                    String string = (String)((Vector)this.availFunctions.get(i)).get(j);
                    if (string.indexOf(40) <= -1 || !string.toLowerCase().startsWith(textFunction.toLowerCase())) continue;
                    this.addItem(string);
                }
            }
            if (this.width > -1 && this.height > -1) {
                this.setPreferredSize(new Dimension(this.width, this.height));
                this.window.pack();
                this.window.validate();
            }
            this.tf.setText(text);
            this.tf.setCaretPosition(caretPosition);
            this.dialog.setParamPanel(false);
            for (ActionListener actionListener : al) {
                this.addActionListener(actionListener);
            }
            for (EventListener eventListener : il) {
                this.addItemListener((ItemListener)eventListener);
            }
        }
    }

    public class FunctionKeyAdapter
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (FunctionComboBox.this.wait != null) {
                FunctionComboBox.this.wait.setKeyPressed(true);
            }
            FunctionComboBox.this.wait = new KeyWait();
            Thread waitThread = new Thread(FunctionComboBox.this.wait);
            waitThread.start();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    public class KeyWait
    implements Runnable {
        boolean keyPressed = false;

        @Override
        public void run() {
            try {
                Thread.sleep(FunctionComboBox.this.PAUSE_DURATION);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.keyPressed) {
                FunctionComboBox.this.updateList();
            }
        }

        public void setKeyPressed(boolean kp) {
            this.keyPressed = kp;
        }
    }
}

