/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sf.jsqlparser.JSQLParserException;
import quadbase.common.formula.DateFormulaParser;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.AvailColumn;
import quadbase.common.paramquery.BuildDateFormatDialog;
import quadbase.common.paramquery.DateVariableDialog;
import quadbase.common.paramquery.MapToFunction;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.allparser.AllParser;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.ReplaceColumnInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbDateFormat;
import quadbase.datasourcemanager.manager.ConfigParamSequenceDialog;
import quadbase.datasourcemanager.manager.CustomSelectionDialog;
import quadbase.datasourcemanager.manager.EnterSQLSelectDialog;
import quadbase.datasourcemanager.manager.FunctionComboBox;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.querybuilder.query.DatabaseInfo;

public class INParametersDialog
extends JDialog
implements ActionListener,
ItemListener {
    QueryFileInfo queryFileInfo;
    protected JPanel mainPanel;
    JPanel subPanel1b;
    JPanel subPanel2a;
    JPanel subPanel5b;
    JPanel subPanel6a;
    JPanel warningPanel;
    JCheckBox mapDBcheckbox;
    JCheckBox mapFunctionCheckBox;
    JCheckBox useCustomSelection;
    JCheckBox dateFormatCheckbox;
    JCheckBox sequenceCheckbox;
    JCheckBox mapToSqlSelect;
    JCheckBox allOptionCheckBox;
    JComboBox paramChoice;
    JComboBox columnChoice;
    JComboBox typeChoice;
    JComboBox defaultChoice;
    JComboBox[] functionParams;
    FunctionComboBox functionChoice;
    JButton prevParamButton;
    JButton nextParamButton;
    JButton prevPanelButton;
    JButton cancelButton;
    JButton nextPanelButton;
    JButton setupSelection;
    JButton sequenceButton;
    JButton dateVariableButton;
    JButton enterSQLStmt;
    JButton enterDefaultSQL;
    JButton buildDateFormatButton;
    JButton updateDateFormatButton;
    JButton allUpdateButton;
    JRadioButton regularDefaultRadio;
    JRadioButton sqlDefaultRadio;
    JLabel regDefLabel;
    JLabel sqlDefLabel;
    JLabel allLabel;
    JTextField promptText;
    JTextField defaultText;
    JTextField dateFormatText;
    JTextField allOptionLabelText;
    Vector availColumn = null;
    Vector availFunctions = null;
    Vector distinctValue;
    Hashtable distinctTable;
    DatabaseInfo databaseInfo;
    boolean showingDefaultText;
    boolean isCallableStmt;
    boolean[] isParamInitialized;
    boolean[] isMultiValue;
    int nParam;
    int prevParamIndex = 0;
    public static final int[] choiceMapToType = new int[]{-7, 16, -6, 5, 4, -5, 6, 7, 8, 2, 3, 1, 12, -1, 91, 92, 93};
    private boolean modified = false;
    private boolean recheckMapToFunction = false;
    private boolean defaultValueRequired = false;
    protected boolean isDataview = false;
    private boolean allowMapping = true;
    String query;
    QueryInParam[] queryInParam;
    QueryInParam[][] paramInSequence;
    int[][] inParamMap;
    Vector inParamType;
    private Vector customSelection = null;
    private int customSelectionDataType = 12;
    private String sqlSelect = null;
    private String defaultSql = null;
    protected boolean showPromptSequence = true;
    private Window container = this;
    private boolean promptSequenceBeforeClose = false;
    private String typeMessage = "Select Type";
    private int tableNameFormat = 0;
    private static final Logger LOGGER = Logger.getLogger(INParametersDialog.class.getName());

    public INParametersDialog(JDialog dialog, boolean modal) {
        super((Dialog)dialog, modal);
    }

    public INParametersDialog(JDialog dialog, QueryFileInfo queryFileInfo, int format) throws Exception {
        this(dialog, queryFileInfo, false, format);
    }

    public INParametersDialog(JDialog dialog, QueryFileInfo queryFileInfo, boolean useAsContainer, int format) throws Exception {
        this(dialog, queryFileInfo, useAsContainer, true, format);
    }

    public INParametersDialog(JDialog dialog, QueryFileInfo queryFileInfo, boolean useAsContainer, boolean showPromptSequence, int format) throws Exception {
        super((Dialog)dialog, true);
        this.showPromptSequence = showPromptSequence;
        if (useAsContainer) {
            this.container = dialog;
        }
        this.queryFileInfo = queryFileInfo;
        this.databaseInfo = queryFileInfo.getJNDIName() != null ? new DatabaseInfo(queryFileInfo.getJNDIName(), queryFileInfo.getEnvProperties()) : new DatabaseInfo(queryFileInfo.getDriverName(), queryFileInfo.getURLString(), queryFileInfo.getUserID(), queryFileInfo.getPassword());
        this.tableNameFormat = format;
        this.init();
        this.setPosition();
    }

    public INParametersDialog(JFrame frame, QueryFileInfo queryFileInfo, int format) throws Exception {
        this(frame, queryFileInfo, true, format);
    }

    public INParametersDialog(JFrame frame, QueryFileInfo queryFileInfo, boolean showPromptSequence, int format) throws Exception {
        super((Frame)frame, true);
        this.showPromptSequence = showPromptSequence;
        this.queryFileInfo = queryFileInfo;
        this.databaseInfo = queryFileInfo.getJNDIName() != null ? new DatabaseInfo(queryFileInfo.getJNDIName(), queryFileInfo.getEnvProperties()) : new DatabaseInfo(queryFileInfo.getDriverName(), queryFileInfo.getURLString(), queryFileInfo.getUserID(), queryFileInfo.getPassword());
        this.tableNameFormat = format;
        this.init();
        this.setPosition();
    }

    protected void init() throws Exception {
        this.query = QueryParser.removeComments(this.queryFileInfo.getQuery());
        this.inParamMap = QueryInParamSet.makeParamMap(this.query);
        this.isCallableStmt = QueryParser.isCallableStmt(this.query);
        this.inParamType = QueryParser.getParamTypes(this.queryFileInfo);
        if (this.showPromptSequence) {
            boolean bl = this.showPromptSequence = this.inParamMap.length > 1;
        }
        if (this.showPromptSequence && this.queryFileInfo.getInSet() != null) {
            this.paramInSequence = this.queryFileInfo.getInSet().getParameterInPromptSequence();
        }
        this.setBackground(Color.lightGray);
        this.setTitle(LanguageEncoder.getText("Initialize Parameters"));
        JPanel bpanel = (JPanel)this.getContentPane();
        bpanel.setLayout(new BorderLayout());
        this.makeMainPanel();
        if (this.queryFileInfo.getInSet() != null) {
            this.queryInParam = this.queryFileInfo.getInSet().getParameter();
            boolean displayDefaults = false;
            for (int i = 0; i < this.nParam; ++i) {
                if (this.queryInParam[i] != null) {
                    this.isParamInitialized[i] = true;
                    if (i != 0) continue;
                    displayDefaults = true;
                    continue;
                }
                if (!this.showPromptSequence || this.queryFileInfo.getInSet() == null || this.queryFileInfo.getInSet().getParameterInPromptSequence() == null) continue;
                this.promptSequenceBeforeClose = true;
            }
            if (displayDefaults) {
                this.resetAttributePanel();
            }
        }
        JPanel okPanel = new JPanel(new FlowLayout(2));
        this.nextPanelButton = new JButton(LanguageEncoder.getText("OK"));
        okPanel.add(this.nextPanelButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        okPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.nextPanelButton.addActionListener(this);
        JScrollPane mainPanelScrollPane = new JScrollPane(this.mainPanel);
        mainPanelScrollPane.setBorder(new TitledBorder(LanguageEncoder.getText("IN Parameters")));
        bpanel.add((Component)mainPanelScrollPane, "Center");
        bpanel.add((Component)okPanel, "South");
    }

    protected void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.width = Math.min(dim.width + 20, screenSize.width);
        dim.height = Math.min(dim.height, screenSize.height - 75);
        this.setSize(dim);
        if (this.availFunctions != null && (double)this.functionChoice.getWidth() > this.functionChoice.getDimensions().getWidth()) {
            this.functionChoice.setDimensions(this.functionChoice.getWidth(), this.functionChoice.getHeight());
        }
        this.setLocationRelativeTo(this.getParent());
    }

    private void adjustPosition() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getSize();
        if (this.getY() + dim.height > screenSize.height - 75) {
            dim.height = screenSize.height - 75 - this.getY();
        }
        dim.width = Math.min(dim.width, screenSize.width);
        this.setSize(dim);
    }

    private void makeMainPanel() throws Exception {
        int i;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane();
        JTextArea sqlText = new JTextArea(this.breakQuery(this.query), 4, 50);
        scroll.getViewport().add(sqlText);
        sqlText.setEditable(false);
        Dimension d = scroll.getPreferredSize();
        if (d.getHeight() > 150.0) {
            scroll.setPreferredSize(new Dimension((int)d.getWidth(), 150));
        }
        topPanel.add("North", scroll);
        JPanel sequencePanel = new JPanel();
        sequencePanel.setLayout(new FlowLayout(0));
        this.sequenceCheckbox = new JCheckBox(LanguageEncoder.getText("Prompt parameter in sequence"));
        sequencePanel.add(this.sequenceCheckbox);
        this.sequenceButton = new JButton(LanguageEncoder.getText("Config"));
        sequencePanel.add(this.sequenceButton);
        if (this.paramInSequence != null) {
            this.sequenceCheckbox.setSelected(true);
            this.sequenceButton.setEnabled(true);
        } else {
            this.sequenceCheckbox.setSelected(false);
            this.sequenceButton.setEnabled(false);
        }
        this.sequenceCheckbox.addItemListener(this);
        this.sequenceButton.addActionListener(this);
        if (this.showPromptSequence) {
            topPanel.add("North", scroll);
            topPanel.add("Center", sequencePanel);
        } else {
            topPanel.add("Center", scroll);
        }
        JPanel paramPanel = new JPanel();
        this.paramChoice = new JComboBox();
        String[] paramName = QueryParser.getAllParameters(this.query);
        String[] multiValueParamName = QueryParser.getMultiValueParameters(this.query);
        this.nParam = paramName.length;
        for (i = 0; i < this.nParam; ++i) {
            this.paramChoice.addItem(paramName[i]);
        }
        this.isParamInitialized = new boolean[this.nParam];
        this.isMultiValue = new boolean[this.nParam];
        for (i = 0; i < this.nParam; ++i) {
            this.isMultiValue[i] = false;
            if (multiValueParamName != null) {
                for (int j = 0; j < multiValueParamName.length; ++j) {
                    if (!paramName[i].equals(multiValueParamName[j])) continue;
                    this.isMultiValue[i] = true;
                    j = multiValueParamName.length;
                }
            }
            this.isParamInitialized[i] = false;
        }
        this.queryInParam = new QueryInParam[this.nParam];
        paramPanel.setLayout(new FlowLayout(0));
        paramPanel.add(new JLabel(LanguageEncoder.getText("Parameter")));
        paramPanel.add(this.paramChoice);
        this.paramChoice.addItemListener(this);
        topPanel.add("South", paramPanel);
        JPanel attributePanel = new JPanel();
        attributePanel.setBorder(new TitledBorder(LanguageEncoder.getText("Attributes")));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        attributePanel.setLayout(gbl);
        this.warningPanel = new JPanel(new BorderLayout());
        JPanel subPanel1 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel1a = new JPanel();
        this.mapDBcheckbox = new JCheckBox(LanguageEncoder.getText("Map to database column"));
        subPanel1a.add(this.mapDBcheckbox);
        this.mapDBcheckbox.addItemListener(this);
        this.columnChoice = new JComboBox();
        this.subPanel1b = new JPanel();
        this.subPanel1b.add(this.columnChoice);
        try {
            this.availColumn = this.createAvailColumnList((String)this.paramChoice.getItemAt(0));
            this.updateAllowMapping();
        }
        catch (Exception ex) {
            this.availColumn = new Vector();
        }
        this.mapDBcheckbox.setEnabled(this.allowMapping && this.availColumn.size() > 0);
        this.setupColumnChoice();
        this.columnChoice.addItemListener(this);
        this.columnChoice.setEnabled(this.mapDBcheckbox.isSelected());
        subPanel1.add(subPanel1a);
        subPanel1.add(this.subPanel1b);
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbl.setConstraints(subPanel1, gbc);
        attributePanel.add(subPanel1);
        JPanel subPanel5 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel5a = new JPanel();
        this.mapFunctionCheckBox = new JCheckBox(LanguageEncoder.getText("Map to database function"));
        subPanel5a.add(this.mapFunctionCheckBox);
        this.mapFunctionCheckBox.addItemListener(this);
        this.functionChoice = new FunctionComboBox(this, this.container, this.availFunctions);
        this.subPanel5b = new JPanel();
        this.subPanel5b.add(this.functionChoice);
        this.mapFunctionCheckBox.setEnabled(this.allowMapping && this.databaseInfo != null);
        if (this.databaseInfo != null) {
            this.createAvailFunctionList();
            this.setupFunctionChoice();
        }
        this.functionChoice.addItemListener(this);
        this.functionChoice.addActionListener(this);
        this.functionChoice.setEnabled(this.mapFunctionCheckBox.isSelected());
        subPanel5.add(subPanel5a);
        subPanel5.add(this.subPanel5b);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbl.setConstraints(subPanel5, gbc);
        attributePanel.add(subPanel5);
        JPanel subPanel6 = new JPanel(new FlowLayout(0, 0, 0));
        this.subPanel6a = new JPanel();
        this.setupPanel6a();
        subPanel6.add(this.subPanel6a);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.gridx = 0;
        gbl.setConstraints(subPanel6, gbc);
        attributePanel.add(subPanel6);
        JPanel subPanel7 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel7a = new JPanel();
        this.mapToSqlSelect = new JCheckBox(LanguageEncoder.getText("Map to SQL ResultSet"));
        subPanel7a.add(this.mapToSqlSelect);
        this.mapToSqlSelect.setEnabled(this.allowMapping);
        this.mapToSqlSelect.addItemListener(this);
        this.enterSQLStmt = new JButton(LanguageEncoder.getText("Enter SQL Statement"));
        JPanel subPanel7b = new JPanel();
        subPanel7b.add(this.enterSQLStmt);
        this.enterSQLStmt.setEnabled(false);
        this.enterSQLStmt.addActionListener(this);
        subPanel7.add(subPanel7a);
        subPanel7.add(subPanel7b);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbl.setConstraints(subPanel7, gbc);
        attributePanel.add(subPanel7);
        JPanel subPanel3 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel3a = new JPanel();
        this.useCustomSelection = new JCheckBox(LanguageEncoder.getText("Use custom selection choices"));
        subPanel3a.add(this.useCustomSelection);
        this.useCustomSelection.setEnabled(this.allowMapping);
        this.useCustomSelection.addItemListener(this);
        this.setupSelection = new JButton(LanguageEncoder.getText("Setup Choices"));
        JPanel subPanel3b = new JPanel();
        subPanel3b.add(this.setupSelection);
        this.setupSelection.setEnabled(false);
        this.setupSelection.addActionListener(this);
        subPanel3.add(subPanel3a);
        subPanel3.add(subPanel3b);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbl.setConstraints(subPanel3, gbc);
        attributePanel.add(subPanel3);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbl.setConstraints(this.warningPanel, gbc);
        attributePanel.add(this.warningPanel);
        JPanel subPanelDatatype = new JPanel(new FlowLayout());
        subPanelDatatype.add(new JLabel(LanguageEncoder.getText("Data Type")));
        this.typeChoice = new JComboBox();
        subPanelDatatype.add(this.typeChoice);
        this.addAllTypes(this.typeChoice);
        this.typeChoice.addItemListener(this);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbl.setConstraints(subPanelDatatype, gbc);
        attributePanel.add(subPanelDatatype);
        JPanel subPanel2 = new JPanel(new BorderLayout());
        subPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Default Value:"));
        this.subPanel2a = new JPanel(new FlowLayout());
        this.regularDefaultRadio = new JRadioButton();
        this.subPanel2a.add(this.regularDefaultRadio);
        this.regularDefaultRadio.setSelected(true);
        this.regularDefaultRadio.addActionListener(this);
        this.regDefLabel = new JLabel(LanguageEncoder.getText("Define Value"));
        this.subPanel2a.add(this.regDefLabel);
        this.defaultText = new JTextField(10);
        this.subPanel2a.add(this.defaultText);
        this.dateVariableButton = new JButton(LanguageEncoder.getText("Date Variable"));
        this.subPanel2a.add(this.dateVariableButton);
        this.dateVariableButton.addActionListener(this);
        this.sqlDefaultRadio = new JRadioButton();
        this.subPanel2a.add(this.sqlDefaultRadio);
        this.sqlDefaultRadio.addActionListener(this);
        this.sqlDefLabel = new JLabel(LanguageEncoder.getText("Map to SQL"));
        this.subPanel2a.add(this.sqlDefLabel);
        this.enterDefaultSQL = new JButton(LanguageEncoder.getText("Enter SQL"));
        this.subPanel2a.add(this.enterDefaultSQL);
        this.enterDefaultSQL.addActionListener(this);
        this.enterDefaultSQL.setEnabled(false);
        this.showingDefaultText = true;
        this.defaultChoice = new JComboBox();
        ButtonGroup group = new ButtonGroup();
        group.add(this.regularDefaultRadio);
        group.add(this.sqlDefaultRadio);
        subPanel2.add("Center", this.subPanel2a);
        gbc.insets = new Insets(5, 5, 0, 5);
        gbl.setConstraints(subPanel2, gbc);
        attributePanel.add(subPanel2);
        JPanel subPanel8 = new JPanel(new BorderLayout());
        this.allOptionCheckBox = new JCheckBox(LanguageEncoder.getText("Allow Select All Option"));
        this.allOptionCheckBox.addActionListener(this);
        this.allLabel = new JLabel(LanguageEncoder.getText("Select All Label:") + " ");
        this.allOptionLabelText = new JTextField(20);
        this.allOptionLabelText.setEnabled(false);
        this.allUpdateButton = new JButton(LanguageEncoder.getText("Update"));
        this.allUpdateButton.addActionListener(this);
        subPanel8.add((Component)this.allOptionCheckBox, "West");
        JPanel tmpPanel = new JPanel();
        tmpPanel.add(this.allLabel);
        tmpPanel.add(this.allOptionLabelText);
        tmpPanel.add(this.allUpdateButton);
        subPanel8.add((Component)tmpPanel, "East");
        subPanel8.add((Component)new JLabel(LanguageEncoder.getText("When Select All Label is selected from the parameter list, all values will be selected.")), "South");
        gbc.insets = new Insets(5, 5, 5, 5);
        gbl.setConstraints(subPanel8, gbc);
        attributePanel.add(subPanel8);
        this.updateAllowAllOptions(null);
        JPanel subPanel4 = new JPanel(new FlowLayout(0, 0, 0));
        JPanel subPanel4a = new JPanel();
        this.dateFormatCheckbox = new JCheckBox(LanguageEncoder.getText("Custom date format"));
        subPanel4a.add(this.dateFormatCheckbox);
        this.dateFormatCheckbox.addItemListener(this);
        this.dateFormatCheckbox.setEnabled(false);
        this.dateFormatText = new JTextField(10);
        this.dateFormatText.setEnabled(false);
        JPanel subPanel4b = new JPanel();
        subPanel4b.add(this.dateFormatText);
        this.buildDateFormatButton = new JButton("Build");
        this.buildDateFormatButton.addActionListener(this);
        subPanel4b.add(this.buildDateFormatButton);
        this.updateDateFormatButton = new JButton("Update Defaults");
        this.updateDateFormatButton.addActionListener(this);
        subPanel4b.add(this.updateDateFormatButton);
        this.buildDateFormatButton.setEnabled(false);
        this.updateDateFormatButton.setEnabled(false);
        subPanel4.add(subPanel4a);
        subPanel4.add(subPanel4b);
        gbc.insets = new Insets(0, 5, 5, 5);
        gbl.setConstraints(subPanel4, gbc);
        attributePanel.add(subPanel4);
        JPanel UIpanel = new JPanel(new FlowLayout(0));
        UIpanel.setBorder(new TitledBorder(LanguageEncoder.getText("User Interface")));
        UIpanel.add(new JLabel(LanguageEncoder.getText("Prompt Name:")));
        this.promptText = new JTextField((String)this.paramChoice.getItemAt(0), 20);
        UIpanel.add(this.promptText);
        JPanel bodyPanel = new JPanel(new BorderLayout());
        bodyPanel.add("North", attributePanel);
        bodyPanel.add("Center", UIpanel);
        JPanel flowPanel = new JPanel(new FlowLayout(2));
        this.prevParamButton = new JButton(LanguageEncoder.getText("Previous Parameter"));
        flowPanel.add(this.prevParamButton);
        this.nextParamButton = new JButton(LanguageEncoder.getText("Next Parameter"));
        flowPanel.add(this.nextParamButton);
        this.prevParamButton.addActionListener(this);
        this.nextParamButton.addActionListener(this);
        this.setFlowButtons();
        this.setParamTypeForProcedure();
        this.mainPanel.add("North", topPanel);
        this.mainPanel.add("Center", bodyPanel);
        this.mainPanel.add("South", flowPanel);
    }

    protected AvailColumn getAvailColumn(int index) {
        return (AvailColumn)this.availColumn.elementAt(index);
    }

    private void updateAllowMapping() {
        this.allowMapping = true;
        if (QueryMain.getReplaceColInfoList() == null) {
            this.warningPanel.removeAll();
            return;
        }
        for (Object element : this.availColumn) {
            AvailColumn availCol = (AvailColumn)element;
            if (!availCol.isDefaultColumn()) continue;
            Vector colInfoVect = this.getColInfoVector();
            for (int j = 0; colInfoVect != null && j < colInfoVect.size(); ++j) {
                ReplaceColumnInfo colInfo = (ReplaceColumnInfo)colInfoVect.get(j);
                Vector<String[]> colPairVect = colInfo.getColumnPair();
                for (String[] element2 : colPairVect) {
                    if (!((AvailColumn)element).getTableName().equals(colInfo.getTableName()) || !availCol.getColumnName().equals(element2[0]) && !(availCol.getTableName() + "." + availCol.getColumnName()).equals(element2[0])) continue;
                    this.allowMapping = false;
                }
            }
        }
        if (this.allowMapping) {
            this.warningPanel.removeAll();
        } else {
            JLabel warning = new JLabel(LanguageEncoder.getText("Parameters for Replace Column Info Fields Cannot Be Mapped"));
            warning.setForeground(new Color(255, 0, 0));
            this.warningPanel.add(warning);
        }
    }

    public Vector getColInfoVector() {
        try {
            Object replaceColInfoList = QueryMain.getReplaceColInfoList();
            Class<?> c = Class.forName("quadbase.reportdesigner.util.ReplaceColumnInfoList");
            Class[] paramTypes = new Class[]{String.class, String.class};
            Method getReplaceColumnInfoMethod = c.getMethod("getReplaceColumnInfo", paramTypes);
            Object[] arguments = new Object[]{this.databaseInfo.getDriver(), this.databaseInfo.getURL()};
            Object result = getReplaceColumnInfoMethod.invoke(replaceColInfoList, arguments);
            return (Vector)result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.paramChoice && this.prevParamIndex != this.paramChoice.getSelectedIndex()) {
            if (this.makeQueryInParam(this.prevParamIndex)) {
                this.prevParamIndex = this.paramChoice.getSelectedIndex();
                this.resetAttributePanel();
            }
        } else if (source == this.mapDBcheckbox) {
            if (this.mapDBcheckbox.isSelected() && (this.useCustomSelection.isSelected() || this.mapFunctionCheckBox.isSelected() || this.mapToSqlSelect.isSelected())) {
                this.mapFunctionCheckBox.setSelected(false);
                this.useCustomSelection.setSelected(false);
                this.mapToSqlSelect.setSelected(false);
            }
            this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
            this.selectColumnChoice();
            this.setParamPanel(false);
            this.setDefaultValueUI();
            if (!this.mapDBcheckbox.isSelected() || choiceMapToType[this.typeChoice.getSelectedIndex()] != 91 && choiceMapToType[this.typeChoice.getSelectedIndex()] != 92 && choiceMapToType[this.typeChoice.getSelectedIndex()] != 93) {
                this.dateFormatText.setText("");
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
            } else {
                this.dateFormatCheckbox.setEnabled(true);
                if (this.dateFormatCheckbox.isSelected()) {
                    this.buildDateFormatButton.setEnabled(true);
                    this.updateDateFormatButton.setEnabled(true);
                }
            }
        } else if (source == this.mapFunctionCheckBox) {
            if ((this.mapDBcheckbox.isSelected() || this.useCustomSelection.isSelected() || this.mapToSqlSelect.isSelected()) && this.mapFunctionCheckBox.isSelected()) {
                this.mapDBcheckbox.setSelected(false);
                this.useCustomSelection.setSelected(false);
                this.mapToSqlSelect.setSelected(false);
            }
            this.typeChoice.setEnabled(!this.mapFunctionCheckBox.isSelected());
            this.selectFunctionColumnChoice();
            if (this.availFunctions != null && (double)this.functionChoice.getWidth() > this.functionChoice.getDimensions().getWidth()) {
                this.functionChoice.setDimensions(this.functionChoice.getWidth(), this.functionChoice.getHeight());
            }
            this.setDefaultValueUI();
            if (this.mapFunctionCheckBox.isSelected()) {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
            } else {
                this.dateFormatCheckbox.setEnabled(false);
                this.recheckMapToFunction = true;
            }
        } else if (source == this.columnChoice) {
            this.setTypeChoice();
            this.setDefaultValueUI();
        } else if (source == this.useCustomSelection) {
            if ((this.mapDBcheckbox.isSelected() || this.mapFunctionCheckBox.isSelected() || this.mapToSqlSelect.isSelected()) && this.useCustomSelection.isSelected()) {
                this.mapDBcheckbox.setSelected(false);
                this.mapFunctionCheckBox.setSelected(false);
                this.mapToSqlSelect.setSelected(false);
            }
            this.setupSelection.setEnabled(this.useCustomSelection.isSelected());
            this.typeChoice.setEnabled(!this.useCustomSelection.isSelected());
            this.setParamPanel(false);
            this.setTypeChoice();
            this.setDefaultValueUI();
            if (this.useCustomSelection.isSelected()) {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
            } else {
                this.dateFormatCheckbox.setEnabled(false);
            }
        } else if (source == this.mapToSqlSelect) {
            if ((this.mapDBcheckbox.isSelected() || this.mapFunctionCheckBox.isSelected() || this.useCustomSelection.isSelected()) && this.mapToSqlSelect.isSelected()) {
                this.mapDBcheckbox.setSelected(false);
                this.mapFunctionCheckBox.setSelected(false);
                this.useCustomSelection.setSelected(false);
            }
            this.enterSQLStmt.setEnabled(this.mapToSqlSelect.isSelected());
            this.typeChoice.setEnabled(!this.mapToSqlSelect.isSelected());
            this.setParamPanel(false);
            this.setTypeChoice();
            this.setDefaultValueUI();
            if (this.mapToSqlSelect.isSelected()) {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
            } else {
                this.dateFormatCheckbox.setEnabled(false);
            }
        } else if (source == this.dateFormatCheckbox) {
            if (this.dateFormatCheckbox.isSelected()) {
                this.dateFormatText.setEnabled(true);
                this.buildDateFormatButton.setEnabled(true);
                if (this.mapDBcheckbox.isSelected()) {
                    this.updateDateFormatButton.setEnabled(true);
                } else {
                    this.updateDateFormatButton.setEnabled(false);
                }
                this.updateDateFormat(true);
            } else {
                this.dateFormatText.setEnabled(false);
                this.buildDateFormatButton.setEnabled(false);
                this.updateDateFormatButton.setEnabled(false);
            }
        } else if (source == this.sequenceCheckbox) {
            this.sequenceButton.setEnabled(this.sequenceCheckbox.isSelected());
            if (!this.sequenceCheckbox.isSelected()) {
                this.paramInSequence = null;
            }
        } else if (source == this.typeChoice) {
            if ((this.typeChoice.getSelectedItem().equals(DataType.getTypeName(91)) || this.typeChoice.getSelectedItem().equals(DataType.getTypeName(92)) || this.typeChoice.getSelectedItem().equals(DataType.getTypeName(93))) && (this.mapDBcheckbox.isSelected() || !this.mapDBcheckbox.isSelected() && !this.mapFunctionCheckBox.isSelected() && !this.mapToSqlSelect.isSelected() && !this.useCustomSelection.isSelected())) {
                this.dateFormatCheckbox.setEnabled(true);
                if (this.dateFormatCheckbox.isSelected()) {
                    this.updateDateFormat(true);
                }
            } else {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatCheckbox.setEnabled(false);
                this.dateFormatText.setText("");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        int index = this.paramChoice.getSelectedIndex();
        if (source == this.prevParamButton || source == this.nextParamButton) {
            if (this.makeQueryInParam(index)) {
                this.isParamInitialized[index] = true;
                if (e.getSource() == this.prevParamButton && index > 0) {
                    this.paramChoice.setSelectedIndex(--index);
                    this.prevParamIndex = index;
                    this.resetAttributePanel();
                } else if (e.getSource() == this.nextParamButton && index < this.nParam - 1) {
                    this.paramChoice.setSelectedIndex(++index);
                    this.prevParamIndex = index;
                    this.resetAttributePanel();
                }
            }
        } else if (source == this.nextPanelButton) {
            if (this.makeQueryInParam(index)) {
                QueryInParamSet set = this.getQueryInParamSet();
                if (set == null) {
                    String paramString = "";
                    int count = 0;
                    for (int i = 0; i < this.isParamInitialized.length; ++i) {
                        if (this.isParamInitialized[i]) continue;
                        paramString = paramString + (String)this.paramChoice.getItemAt(i) + ", ";
                        ++count;
                    }
                    paramString = paramString.substring(0, paramString.length() - 2);
                    String message = count == 1 ? LanguageEncoder.getText("Parameter:") + " " + paramString + " " + LanguageEncoder.getText("is not initialized") : LanguageEncoder.getText("Parameter:") + " " + paramString + " " + LanguageEncoder.getText("are not initialized");
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), message);
                } else {
                    if (this.sequenceCheckbox.isSelected() && this.promptSequenceBeforeClose) {
                        ConfigParamSequenceDialog dialog = new ConfigParamSequenceDialog((JDialog)this, this.queryFileInfo, this.queryInParam, this.paramInSequence);
                        dialog.setVisible(true);
                        if (dialog.isModified()) {
                            this.paramInSequence = dialog.getParameterInPromptSequence();
                            this.promptSequenceBeforeClose = false;
                        } else {
                            return;
                        }
                    }
                    this.modified = true;
                    this.setVisible(false);
                    this.dispose();
                }
            }
        } else if (source == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (source == this.enterSQLStmt) {
            this.showEnterSQLSelectDialog(false);
        } else if (source == this.enterDefaultSQL) {
            this.showEnterSQLSelectDialog(true);
        } else if (source == this.setupSelection) {
            CustomSelectionDialog cDialog = new CustomSelectionDialog((JDialog)this, this.queryFileInfo, this.availColumn, choiceMapToType[this.typeChoice.getSelectedIndex()], this.customSelection);
            cDialog.setVisible(true);
            if (cDialog.isModified()) {
                this.customSelection = cDialog.getSelectedValues();
                this.customSelectionDataType = cDialog.getSQLType();
            }
            this.setTypeChoice();
            this.setDefaultValueUI();
        } else if (source == this.sequenceButton) {
            ConfigParamSequenceDialog dialog = new ConfigParamSequenceDialog((JDialog)this, this.queryFileInfo, this.queryInParam, this.paramInSequence);
            dialog.setVisible(true);
            if (dialog.isModified()) {
                this.paramInSequence = dialog.getParameterInPromptSequence();
                this.promptSequenceBeforeClose = false;
            }
        } else if (source == this.dateVariableButton) {
            DateVariableDialog dialog = new DateVariableDialog(this, this.defaultText.getText());
            dialog.setVisible(true);
            if (dialog.isModified() && dialog.getText() != null) {
                this.defaultText.setText(dialog.getText());
                if (dialog.getText().toLowerCase().indexOf("currentdatetime") > -1) {
                    this.typeChoice.setSelectedItem(DataType.getTypeName(93));
                } else if (dialog.getText().toLowerCase().indexOf("currentdate") > -1) {
                    this.typeChoice.setSelectedItem(DataType.getTypeName(91));
                } else if (dialog.getText().toLowerCase().indexOf("currenttime") > -1) {
                    this.typeChoice.setSelectedItem(DataType.getTypeName(92));
                }
            }
        } else if (source == this.buildDateFormatButton) {
            BuildDateFormatDialog dialog = new BuildDateFormatDialog(this, this.dateFormatText.getText());
            dialog.setVisible(true);
            if (dialog.isModified() && dialog.getText() != null) {
                this.dateFormatText.setText(dialog.getText());
                this.setDefaultValueUI();
            }
        } else if (source == this.updateDateFormatButton) {
            String checkDateFormat = QbDateFormat.checkDateFormat(this.dateFormatText.getText());
            if (checkDateFormat == null) {
                this.setDefaultValueUI();
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), checkDateFormat);
            }
        } else if (source == this.functionChoice) {
            this.setParamPanel(false);
            this.checkParamSet();
            if (this.functionChoice.getSelectedIndex() == 0) {
                this.functionChoice.setNone();
                this.functionChoice.updateList();
                this.typeChoice.setEnabled(false);
                this.defaultChoice.setEnabled(false);
            }
        } else if (source == this.regularDefaultRadio) {
            this.setDefaultValueUI();
        } else if (source == this.sqlDefaultRadio) {
            this.setDefaultValueUI();
        } else if (source == this.allOptionCheckBox) {
            this.enableAllOptionLabelText(this.allOptionCheckBox.isSelected());
            if (this.mapDBcheckbox.isSelected()) {
                this.resetDefaultChoice();
            }
        } else if (this.functionParams != null) {
            for (JComboBox functionParam : this.functionParams) {
                if (source != functionParam) continue;
                this.checkParamSet();
                break;
            }
        } else if (source == this.allUpdateButton) {
            this.updateDefaultListWithAllOption();
        }
    }

    private void enableAllOptionLabelText(boolean enable) {
        this.allOptionLabelText.setEnabled(enable);
        if (enable) {
            this.allLabel.setEnabled(true);
            if (this.mapDBcheckbox.isSelected()) {
                this.allOptionLabelText.setText(LanguageEncoder.getText("Select All"));
                this.allUpdateButton.setEnabled(true);
            } else {
                this.allOptionLabelText.setText("");
                this.allUpdateButton.setEnabled(false);
            }
        } else {
            this.allOptionLabelText.setText("");
            this.allUpdateButton.setEnabled(false);
        }
    }

    private void checkParamSet() {
        if (this.functionParams != null) {
            boolean allSet = true;
            String param = "";
            for (JComboBox functionParam : this.functionParams) {
                param = ((JTextField)functionParam.getEditor().getEditorComponent()).getText();
                if (!param.startsWith("Enter Parameter")) continue;
                allSet = false;
            }
            if (allSet) {
                this.setTypeChoice();
                this.setDefaultValueUI();
            }
        }
    }

    private void setupPanel6a() {
        int width = -1;
        if (this.columnChoice != null) {
            width = this.columnChoice.getWidth();
        }
        if (width > 0) {
            this.subPanel6a.setLayout(new GridLayout(0, this.getWidth() / width));
        } else {
            this.subPanel6a.setLayout(new GridLayout(0, 1));
        }
    }

    public void setParamPanel(boolean loadFromMemory) {
        if (this.availColumn != null) {
            String function = ((JTextField)this.functionChoice.getEditor().getEditorComponent()).getText();
            if (this.subPanel6a != null) {
                this.subPanel6a.removeAll();
            }
            if (this.mapFunctionCheckBox.isSelected()) {
                this.setupPanel6a();
                int openParen = function.indexOf(40);
                int closeParen = function.lastIndexOf(41);
                if (openParen > -1 && closeParen > -1) {
                    int foundIndex;
                    int i;
                    int numOfParams = 0;
                    for (int i2 = openParen + 1; i2 < closeParen; ++i2) {
                        if (function.charAt(i2) == ' ') continue;
                        ++numOfParams;
                        break;
                    }
                    if (numOfParams == 0) {
                        this.functionParams = new JComboBox[0];
                        this.setDefaultValueUI();
                        this.container.pack();
                        this.container.validate();
                        this.adjustPosition();
                        return;
                    }
                    int fromIndex = 0;
                    JLabel tmp = new JLabel("Set Parameter Values:");
                    this.subPanel6a.add(tmp);
                    for (i = 1; i < ((GridLayout)this.subPanel6a.getLayout()).getColumns(); ++i) {
                        this.subPanel6a.add(new JLabel());
                    }
                    do {
                        if ((foundIndex = function.indexOf(",", fromIndex)) < 0) continue;
                        ++numOfParams;
                        fromIndex = foundIndex + 1;
                    } while (foundIndex >= 0);
                    this.functionParams = new JComboBox[numOfParams];
                    for (i = 0; i < this.functionParams.length; ++i) {
                        QueryInParam currentParam;
                        String param;
                        this.functionParams[i] = new JComboBox();
                        this.functionParams[i].addItem("Enter Parameter " + (i + 1));
                        for (int j = 0; j < this.availColumn.size(); ++j) {
                            this.functionParams[i].addItem(this.getAvailColumn(j).getCompleteName());
                        }
                        this.functionParams[i].setEditable(true);
                        if (loadFromMemory && this.queryInParam[this.paramChoice.getSelectedIndex()] != null && (param = MapToFunction.getFunctionParam(currentParam = this.queryInParam[this.paramChoice.getSelectedIndex()], i)) != null) {
                            param = this.convertName(param, this.functionParams[i]);
                            this.functionParams[i].setSelectedItem(param);
                        }
                        this.functionParams[i].addActionListener(this);
                        this.subPanel6a.add(this.functionParams[i]);
                    }
                } else {
                    this.functionParams = new JComboBox[0];
                    this.setDefaultValueUI();
                }
            }
            this.container.pack();
            this.container.validate();
            this.adjustPosition();
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * Unable to fully structure code
     */
    private void setTypeChoice() {
        mapState = this.mapDBcheckbox.isSelected() != false || this.useCustomSelection.isSelected() != false || this.mapToSqlSelect.isSelected() != false || this.mapFunctionCheckBox.isSelected() != false;
        this.typeChoice.setEnabled(mapState == false);
        typeFound = false;
        if (this.mapDBcheckbox.isSelected()) {
            index = this.columnChoice.getSelectedIndex();
            for (i = 0; i < INParametersDialog.choiceMapToType.length; ++i) {
                if (index < 0 || this.getAvailColumn(index).getSqlType() != INParametersDialog.choiceMapToType[i]) continue;
                this.typeChoice.setSelectedIndex(i);
                typeFound = true;
                break;
            }
        } else if (this.mapFunctionCheckBox.isSelected() && this.functionParams != null) {
            funParams = new String[this.functionParams.length];
            param = "";
            allSet = true;
            for (i = 0; i < this.functionParams.length; ++i) {
                funParams[i] = param = ((JTextField)this.functionParams[i].getEditor().getEditorComponent()).getText();
                if (!param.startsWith("Enter Parameter")) continue;
                allSet = false;
            }
            if (allSet && (function = MapToFunction.getFullFunction(funName = ((JTextField)this.functionChoice.getEditor().getEditorComponent()).getText(), funParams)) != null) {
                try {
                    dataTypeIndex = MapToFunction.getDataType(this.queryFileInfo, function, MapToFunction.getFunctionTableNames(function));
                    if (dataTypeIndex == -999) ** GOTO lbl40
                    for (i = 0; i < INParametersDialog.choiceMapToType.length; ++i) {
                        if (dataTypeIndex != INParametersDialog.choiceMapToType[i]) continue;
                        this.typeChoice.setSelectedIndex(i);
                        typeFound = true;
                    }
                }
                catch (Exception var8_13) {}
            }
        } else if (this.useCustomSelection.isSelected()) {
            for (i = 0; i < INParametersDialog.choiceMapToType.length; ++i) {
                if (this.customSelectionDataType != INParametersDialog.choiceMapToType[i]) continue;
                this.typeChoice.setSelectedIndex(i);
                typeFound = true;
                break;
            }
        }
        if (!typeFound) {
            this.typeChoice.setSelectedIndex(11);
        }
    }

    private String breakQuery(String query) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(query, " \t\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equalsIgnoreCase("from") || token.equalsIgnoreCase("where") || token.equalsIgnoreCase("group") || token.equalsIgnoreCase("having") || token.equalsIgnoreCase("order")) {
                sb.append("\n");
            }
            sb.append(token);
            sb.append(" ");
        }
        return sb.toString();
    }

    private void addAllTypes(JComboBox choice) {
        for (int element : choiceMapToType) {
            choice.addItem(DataType.getTypeName(element));
        }
        if (this.mapDBcheckbox.isSelected() && this.availColumn.size() > 0) {
            int target = this.getAvailColumn(0).getSqlType();
            for (int i = 0; i < choiceMapToType.length; ++i) {
                if (target != choiceMapToType[i]) continue;
                choice.setSelectedIndex(i);
            }
        }
    }

    private void setFlowButtons() {
        int nParameter = this.paramChoice.getItemCount();
        int index = this.paramChoice.getSelectedIndex();
        this.prevParamButton.setEnabled(index > 0);
        this.nextParamButton.setEnabled(index < nParameter - 1);
    }

    private void setDefaultValueUI() {
        this.setDefaultValueUI(null);
    }

    private void setDefaultValueUI(QueryInParam qip) {
        if (!(this.mapDBcheckbox.isSelected() || this.mapFunctionCheckBox.isSelected() || this.useCustomSelection.isSelected() || this.showingDefaultText || this.mapToSqlSelect.isSelected())) {
            this.removeDefaultChoice();
        } else if (this.mapDBcheckbox.isSelected() || this.mapFunctionCheckBox.isSelected() || this.useCustomSelection.isSelected() || this.mapToSqlSelect.isSelected()) {
            this.resetDefaultChoice();
        } else {
            this.updateDefaultRadio();
        }
        this.updateAllowAllOptions(qip);
    }

    private void removeDefaultChoice() {
        boolean saveState = this.mapDBcheckbox.isEnabled();
        boolean saveFunState = this.mapFunctionCheckBox.isEnabled();
        this.setEnableState(false);
        this.subPanel2a.removeAll();
        this.showingDefaultText = true;
        this.defaultText.setText("");
        this.subPanel2a.add(this.regularDefaultRadio);
        this.subPanel2a.add(this.regDefLabel);
        this.subPanel2a.add(this.defaultText);
        this.subPanel2a.add(this.dateVariableButton);
        this.subPanel2a.add(this.sqlDefaultRadio);
        this.subPanel2a.add(this.sqlDefLabel);
        this.subPanel2a.add(this.enterDefaultSQL);
        this.updateDefaultRadio();
        this.subPanel2a.revalidate();
        this.container.pack();
        this.container.validate();
        this.adjustPosition();
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
        this.mapFunctionCheckBox.setEnabled(saveFunState);
    }

    private void resetDefaultChoice() {
        Object defaultValue;
        QueryInParam currParam;
        boolean saveState = this.mapDBcheckbox.isEnabled();
        boolean saveFunState = this.mapFunctionCheckBox.isEnabled();
        this.setEnableState(false);
        this.subPanel2a.removeAll();
        this.showingDefaultText = false;
        this.defaultChoice.removeItemListener(this);
        this.defaultChoice = new JComboBox();
        if (this.allOptionCheckBox.isSelected()) {
            this.defaultChoice.addItem(this.allOptionLabelText.getText());
        }
        if (this.useCustomSelection.isSelected()) {
            if (this.customSelection == null) {
                this.customSelection = new Vector();
            }
            for (int i = 0; i < this.customSelection.size(); ++i) {
                if (this.customSelection.elementAt(i) == null) continue;
                this.defaultChoice.addItem(this.customSelection.elementAt(i).toString());
            }
        } else if (this.mapToSqlSelect.isSelected()) {
            if (this.sqlSelect != null) {
                int i;
                Vector result = new Vector();
                int sqlType = -1;
                try {
                    result = QueryParser.executeSQLSelect((IDatabaseInfo)this.queryFileInfo, this.sqlSelect, this.queryInParam, true);
                    this.distinctValue = (Vector)result.elementAt(0);
                    sqlType = (Integer)this.distinctValue.elementAt(this.distinctValue.size() - 1);
                    this.distinctValue.remove(this.distinctValue.size() - 1);
                    if (result.size() > 1) {
                        if (this.distinctTable == null) {
                            this.distinctTable = new Hashtable();
                        }
                        Hashtable table = new Hashtable();
                        for (i = 0; i < this.distinctValue.size(); ++i) {
                            Object key = this.distinctValue.elementAt(i);
                            Object object = ((Vector)result.elementAt(1)).elementAt(i);
                            table.put(key, object);
                        }
                        this.distinctTable.put(this.sqlSelect, table);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.distinctValue != null) {
                    int size = this.distinctValue.size();
                    for (i = 0; i < size; ++i) {
                        if (this.distinctValue.elementAt(i) == null) continue;
                        this.defaultChoice.addItem(this.distinctValue.elementAt(i).toString());
                    }
                }
                for (int i2 = 0; i2 < choiceMapToType.length; ++i2) {
                    if (sqlType != choiceMapToType[i2]) continue;
                    this.typeChoice.setSelectedIndex(i2);
                }
            }
        } else if (this.mapDBcheckbox.isSelected()) {
            AvailColumn temp = this.getAvailColumn(this.columnChoice.getSelectedIndex());
            this.distinctValue = new Vector();
            try {
                this.distinctValue = QueryParser.getDistinctValues(this.queryFileInfo, temp.getTableName(), temp.getColumnName());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to get distinct values.", ex);
            }
            Vector vals = this.distinctValue;
            if ((choiceMapToType[this.typeChoice.getSelectedIndex()] == 91 || choiceMapToType[this.typeChoice.getSelectedIndex()] == 92 || choiceMapToType[this.typeChoice.getSelectedIndex()] == 93) && this.dateFormatCheckbox.isSelected() && this.dateFormatText.getText() != null && !this.dateFormatText.getText().trim().equals("")) {
                QbDateFormat dateFormat = new QbDateFormat(this.distinctValue);
                String dateformat = this.dateFormatText.getText();
                try {
                    String allOption = null;
                    if (this.allOptionLabelText.getText() != null && this.allOptionLabelText.getText().length() > 0) {
                        allOption = this.allOptionLabelText.getText();
                    }
                    vals = dateFormat.getFormattedDate(dateformat, allOption);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int size = vals.size();
            for (int i = 0; i < size; ++i) {
                if (vals.elementAt(i) == null) continue;
                this.defaultChoice.addItem(vals.elementAt(i).toString());
            }
        } else if (this.mapFunctionCheckBox.isSelected()) {
            boolean skip = false;
            if (this.functionParams == null) {
                skip = true;
            }
            if (!skip && this.functionParams.length > 0 && ((JTextField)this.functionParams[0].getEditor().getEditorComponent()).getText().startsWith("Enter Parameter")) {
                this.defaultChoice.setEnabled(false);
                skip = true;
            }
            if (!skip) {
                String funName = ((JTextField)this.functionChoice.getEditor().getEditorComponent()).getText();
                String[] funParams = new String[this.functionParams.length];
                for (int i = 0; i < this.functionParams.length; ++i) {
                    funParams[i] = ((JTextField)this.functionParams[i].getEditor().getEditorComponent()).getText();
                }
                String fullFunction = MapToFunction.getFullFunction(funName, funParams);
                if (fullFunction != null) {
                    this.distinctValue = new Vector();
                    try {
                        this.distinctValue = QueryParser.getDistinctValues(this.queryFileInfo, MapToFunction.getFunctionTableNames(fullFunction), fullFunction);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.distinctValue != null) {
                        int size = this.distinctValue.size();
                        for (int i = 0; i < size; ++i) {
                            if (this.distinctValue.elementAt(i) == null) continue;
                            this.defaultChoice.addItem(this.distinctValue.elementAt(i).toString());
                        }
                    }
                }
            }
        }
        if ((currParam = this.queryInParam[this.paramChoice.getSelectedIndex()]) != null && (defaultValue = currParam.getDefaultValue()) != null) {
            if ((choiceMapToType[this.typeChoice.getSelectedIndex()] == 91 || choiceMapToType[this.typeChoice.getSelectedIndex()] == 92 || choiceMapToType[this.typeChoice.getSelectedIndex()] == 93) && this.dateFormatCheckbox.isSelected() && this.dateFormatText.getText() != null && !this.dateFormatText.getText().trim().equals("")) {
                defaultValue = QbDateFormat.getFormattedDateTime((Date)defaultValue, this.dateFormatText.getText());
            }
            String defaultString = defaultValue.toString();
            for (int i = 0; i < this.defaultChoice.getItemCount(); ++i) {
                if (!((String)this.defaultChoice.getItemAt(i)).equals(defaultString)) continue;
                this.defaultChoice.setSelectedIndex(i);
                break;
            }
        }
        this.subPanel2a.add(this.regularDefaultRadio);
        this.subPanel2a.add(this.regDefLabel);
        this.subPanel2a.add(this.defaultChoice);
        this.subPanel2a.add(this.sqlDefaultRadio);
        this.subPanel2a.add(this.sqlDefLabel);
        this.subPanel2a.add(this.enterDefaultSQL);
        this.updateDefaultRadio();
        this.subPanel2a.revalidate();
        this.container.pack();
        this.container.validate();
        this.adjustPosition();
        if (this.availFunctions != null && (double)this.functionChoice.getWidth() > this.functionChoice.getDimensions().getWidth()) {
            this.functionChoice.setDimensions(this.functionChoice.getWidth(), this.functionChoice.getHeight());
        }
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(saveState);
        this.mapFunctionCheckBox.setEnabled(saveFunState);
    }

    private void showEnterSQLSelectDialog(boolean isDefaultSQL) {
        String def = this.sqlSelect;
        if (isDefaultSQL) {
            def = this.defaultSql;
        }
        EnterSQLSelectDialog sqlDialog = new EnterSQLSelectDialog(this, this.queryFileInfo, def, this.tableNameFormat, isDefaultSQL);
        sqlDialog.setVisible(true);
        if (sqlDialog.isModified()) {
            if (isDefaultSQL) {
                this.defaultSql = sqlDialog.getSqlSelect();
            } else {
                this.sqlSelect = sqlDialog.getSqlSelect();
            }
        } else if (isDefaultSQL && this.sqlDefaultRadio.isSelected() && this.defaultSql == null) {
            this.regularDefaultRadio.setSelected(true);
        }
        this.setDefaultValueUI();
    }

    private void updateDefaultRadio() {
        if (this.sqlDefaultRadio.isSelected()) {
            Vector result;
            this.defaultText.setEnabled(false);
            this.defaultChoice.setEnabled(false);
            this.dateVariableButton.setEnabled(false);
            this.enterDefaultSQL.setEnabled(true);
            if (this.defaultSql == null) {
                this.showEnterSQLSelectDialog(true);
            }
            if (this.defaultSql != null && (result = QueryParser.executeSQLSelect((IDatabaseInfo)this.queryFileInfo, this.defaultSql, this.queryInParam, true)) != null && result.size() == 1 && (Vector)result.get(0) != null && ((Vector)result.get(0)).size() > 0) {
                String defval = ((Vector)result.get(0)).get(0).toString();
                this.defaultText.setText(defval);
                for (int i = 0; i < this.defaultChoice.getItemCount(); ++i) {
                    if (!this.defaultChoice.getItemAt(i).equals(defval)) continue;
                    this.defaultChoice.setSelectedIndex(i);
                }
            }
        } else {
            this.defaultText.setEnabled(true);
            this.dateVariableButton.setEnabled(true);
            this.enterDefaultSQL.setEnabled(false);
        }
    }

    private boolean areAllInitialized() {
        for (int i = 0; i < this.isParamInitialized.length; ++i) {
            if (this.isParamInitialized[i]) continue;
            return false;
        }
        return true;
    }

    private Object makeDefaultValue() {
        if (this.showingDefaultText) {
            try {
                return this.makeDefaultValueFromText();
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return this.makeDefaultValueFromChoice();
    }

    private Object makeDefaultValueFromChoice() {
        if (this.useCustomSelection.isSelected()) {
            if (this.customSelection == null || this.customSelection.size() == 0) {
                throw new IllegalArgumentException("Empty parameter list.");
            }
            return this.customSelection.elementAt(this.defaultChoice.getSelectedIndex());
        }
        if (this.distinctValue == null || this.distinctValue.size() == 0) {
            throw new IllegalArgumentException("Empty parameter list.");
        }
        if (this.distinctTable == null) {
            if (this.allOptionCheckBox.isSelected() && this.allOptionLabelText.getText().equals(this.defaultChoice.getSelectedItem())) {
                return this.allOptionLabelText.getText();
            }
            if (this.allOptionCheckBox.isSelected()) {
                return this.distinctValue.elementAt(this.defaultChoice.getSelectedIndex() - 1);
            }
            return this.distinctValue.elementAt(this.defaultChoice.getSelectedIndex());
        }
        Object key = this.distinctValue.elementAt(this.defaultChoice.getSelectedIndex());
        Hashtable table = (Hashtable)this.distinctTable.get(this.sqlSelect);
        if (table != null) {
            return table.get(key);
        }
        return key;
    }

    private Object makeDefaultValueFromText() throws IllegalArgumentException, NumberFormatException, ParseException {
        String error;
        String text = this.defaultText.getText();
        text = text.trim();
        int dataType = DataType.mapType(choiceMapToType[this.typeChoice.getSelectedIndex()]);
        if (this.defaultValueRequired && text.equals("")) {
            throw new IllegalArgumentException("Missing default value.");
        }
        String dateformat = null;
        if (this.dateFormatCheckbox.isSelected() && this.dateFormatText.getText() != null && !this.dateFormatText.getText().trim().equals("") && (error = QbDateFormat.checkDateFormat(dateformat = this.dateFormatText.getText())) != null) {
            throw new IllegalArgumentException(error);
        }
        if (text.equals("") && dataType != 7) {
            return null;
        }
        if (text.equals(this.allOptionLabelText.getText())) {
            return text;
        }
        try {
            return DataType.createObject(text, dataType, dateformat);
        }
        catch (Exception ex) {
            try {
                Formula formula = new Formula(null, text);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                DateFormulaParser parser = new DateFormulaParser(inputStreamReader);
                formula.setFormula(parser.parse());
                return formula;
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                return null;
            }
        }
    }

    public QueryFileInfo getQueryFileInfo() {
        if (!this.areAllInitialized()) {
            return null;
        }
        this.makeParamInSequence();
        QueryInParamSet inSet = new QueryInParamSet(this.queryInParam, this.paramInSequence, this.queryFileInfo.getQuery());
        this.queryFileInfo.setInSet(inSet);
        return this.queryFileInfo;
    }

    public QueryInParamSet getQueryInParamSet() {
        if (!this.areAllInitialized()) {
            return null;
        }
        this.makeParamInSequence();
        return new QueryInParamSet(this.queryInParam, this.paramInSequence, this.queryFileInfo.getQuery());
    }

    public boolean makeCurrParam() {
        return this.makeQueryInParam(this.paramChoice.getSelectedIndex());
    }

    private boolean makeQueryInParam(int paramIndex) {
        Object defaultValue;
        String checkDateFormat;
        String columnName;
        String tableName;
        String paramName = (String)this.paramChoice.getItemAt(paramIndex);
        String promptName = this.promptText.getText();
        boolean mapToColumn = this.mapDBcheckbox.isSelected();
        boolean mapToFunction = this.mapFunctionCheckBox.isSelected();
        if (mapToColumn) {
            int columnIndex = this.columnChoice.getSelectedIndex();
            tableName = this.getAvailColumn(columnIndex).getTableName();
            columnName = this.getAvailColumn(columnIndex).getColumnName();
        } else if (mapToFunction) {
            String funName = ((JTextField)this.functionChoice.getEditor().getEditorComponent()).getText();
            String[] funParams = new String[this.functionParams.length];
            for (int i = 0; i < this.functionParams.length; ++i) {
                funParams[i] = ((JTextField)this.functionParams[i].getEditor().getEditorComponent()).getText();
            }
            columnName = MapToFunction.getFullFunction(funName, funParams);
            if (columnName == null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Function or parameter values are not set correctly"));
                this.isParamInitialized[paramIndex] = false;
                return false;
            }
            tableName = MapToFunction.getFunctionTableNames(columnName);
        } else {
            tableName = "";
            columnName = "";
        }
        String dateformat = null;
        if (this.dateFormatCheckbox.isSelected() && this.dateFormatText.getText() != null && !this.dateFormatText.getText().trim().equals("") && (checkDateFormat = QbDateFormat.checkDateFormat(dateformat = this.dateFormatText.getText())) != null) {
            new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), checkDateFormat);
            return false;
        }
        int sqlType = ((String)this.typeChoice.getItemAt(0)).equalsIgnoreCase(this.typeMessage) && this.typeChoice.getSelectedIndex() > 0 ? choiceMapToType[this.typeChoice.getSelectedIndex() - 1] : choiceMapToType[this.typeChoice.getSelectedIndex()];
        try {
            defaultValue = this.makeDefaultValue();
        }
        catch (Exception ex) {
            if (ex.getMessage() != null && ex.getMessage().equals("Missing default value.")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please specify a default value for this parameter."));
            } else if (ex.getMessage() != null && ex.getMessage().equals("Empty parameter list.")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Parameter value list is empty."));
            } else if (ex.getMessage() != null && ex.getMessage().endsWith("is invalid symbol for date format!")) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
            } else {
                ex.printStackTrace();
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Default value doesn't match data type."));
            }
            this.isParamInitialized[paramIndex] = false;
            return false;
        }
        boolean isAllParamSelected = this.allOptionCheckBox.isSelected();
        String allOptionText = null;
        if (isAllParamSelected) {
            allOptionText = this.allOptionLabelText.getText();
        }
        this.queryInParam[paramIndex] = !this.isMultiValue[paramIndex] ? new QueryInParam(this.inParamMap[paramIndex], paramName, promptName, mapToColumn, mapToFunction, tableName, columnName, sqlType, defaultValue, null, isAllParamSelected, allOptionText, null) : new QueryMultiValueInParam(this.inParamMap[paramIndex], paramName, promptName, mapToColumn, mapToFunction, tableName, columnName, sqlType, defaultValue, null, isAllParamSelected, allOptionText, null, null);
        this.queryInParam[paramIndex].setDateFormat(dateformat);
        if (this.useCustomSelection.isSelected()) {
            this.queryInParam[paramIndex].setSelectionChoices(this.customSelection);
        }
        if (this.mapToSqlSelect.isSelected()) {
            this.queryInParam[paramIndex].setSqlSelect(this.sqlSelect);
        }
        if (this.sqlDefaultRadio.isSelected()) {
            this.queryInParam[paramIndex].setDefaultSql(this.defaultSql);
        } else {
            this.queryInParam[paramIndex].setDefaultSql(null);
        }
        this.isParamInitialized[paramIndex] = true;
        return true;
    }

    private void resetAttributePanel() {
        this.setFlowButtons();
        int paramIndex = this.paramChoice.getSelectedIndex();
        this.resetColumnChoice(paramIndex);
        if (this.isParamInitialized[paramIndex]) {
            int choiceSize;
            QueryInParam currParam = this.queryInParam[paramIndex];
            this.promptText.setText(currParam.getPromptName());
            boolean mapToColState = currParam.isMapToColumnOnly();
            boolean mapToFunState = currParam.isMapToFunctionOnly();
            this.mapDBcheckbox.setSelected(mapToColState && !mapToFunState);
            this.mapFunctionCheckBox.setSelected(mapToFunState);
            if (mapToColState && !mapToFunState) {
                int i;
                this.selectColumnChoice();
                choiceSize = this.columnChoice.getItemCount();
                boolean mapColumnFound = false;
                for (i = 0; i < choiceSize; ++i) {
                    if (!currParam.getCompleteName().equals(this.columnChoice.getItemAt(i))) continue;
                    this.columnChoice.setSelectedIndex(i);
                    mapColumnFound = true;
                }
                if (!mapColumnFound) {
                    if (this.availColumn != null) {
                        for (i = 0; i < this.availColumn.size(); ++i) {
                            if (!((AvailColumn)this.availColumn.get(i)).isDefaultColumn()) continue;
                            this.columnChoice.setSelectedIndex(i);
                            mapColumnFound = true;
                        }
                    }
                    mapToColState = mapColumnFound;
                }
            } else {
                this.mapDBcheckbox.setSelected(mapToColState && !mapToFunState);
            }
            this.columnChoice.setEnabled(mapToColState && !mapToFunState);
            if (mapToFunState) {
                this.selectFunctionColumnChoice();
            } else {
                this.mapFunctionCheckBox.setSelected(mapToFunState);
                this.functionChoice.setSelectedIndex(0);
            }
            if (currParam.getSelectionChoices() != null) {
                this.customSelectionDataType = currParam.getSqlType();
                this.customSelection = currParam.getSelectionChoices();
                this.useCustomSelection.setSelected(true);
            } else {
                this.customSelectionDataType = 12;
                this.customSelection = null;
                this.useCustomSelection.setSelected(false);
            }
            if (currParam.getSqlSelect() != null) {
                this.sqlSelect = currParam.getSqlSelect();
                this.mapToSqlSelect.setSelected(true);
            } else {
                this.sqlSelect = null;
                this.mapToSqlSelect.setSelected(false);
            }
            choiceSize = choiceMapToType.length;
            for (int i = 0; i < choiceSize; ++i) {
                if (choiceMapToType[i] != currParam.getSqlType()) continue;
                this.typeChoice.setSelectedIndex(i);
                break;
            }
            this.typeChoice.setEnabled(!mapToColState && !mapToFunState && !this.useCustomSelection.isSelected() && !this.mapToSqlSelect.isSelected());
            if (currParam.getDefaultSql() != null) {
                this.defaultSql = currParam.getDefaultSql();
                this.sqlDefaultRadio.setSelected(true);
            } else {
                this.defaultSql = null;
                this.regularDefaultRadio.setSelected(true);
            }
            this.updateAllowAllOptions(currParam);
            this.setDefaultValueUI(currParam);
            String dateformat = currParam.getDateFormat();
            if (dateformat != null) {
                this.dateFormatCheckbox.setSelected(true);
                this.dateFormatText.setText(dateformat);
                this.dateFormatText.setEnabled(true);
            } else {
                this.dateFormatCheckbox.setSelected(false);
                this.dateFormatText.setText("");
            }
            Object defaultValue = currParam.getDefaultValue();
            Formula defaultValueVariable = currParam.getDefaultValueVariable();
            if (defaultValueVariable != null) {
                this.defaultText.setText(defaultValueVariable.getText());
            } else if (defaultValue != null) {
                this.defaultText.setText(DataType.toString(defaultValue, dateformat));
            }
        } else {
            this.promptText.setText((String)this.paramChoice.getItemAt(paramIndex));
            this.mapDBcheckbox.setSelected(false);
            this.mapFunctionCheckBox.setSelected(false);
            this.useCustomSelection.setSelected(false);
            this.mapToSqlSelect.setSelected(false);
            this.sqlDefaultRadio.setSelected(false);
            this.regularDefaultRadio.setSelected(true);
            this.customSelectionDataType = 12;
            this.customSelection = null;
            this.sqlSelect = null;
            this.defaultSql = null;
            if (this.availColumn.size() > 0) {
                int target = this.getAvailColumn(0).getSqlType();
                for (int i = 0; i < choiceMapToType.length; ++i) {
                    if (target != choiceMapToType[i]) continue;
                    this.typeChoice.setSelectedIndex(i);
                    break;
                }
            }
            this.setParamTypeForProcedure();
            this.setDefaultValueUI();
            this.setParamPanel(false);
            this.defaultText.setText("");
            this.dateFormatCheckbox.setSelected(false);
            this.dateFormatText.setText("");
        }
    }

    private void resetColumnChoice(int paramIndex) {
        this.setEnableState(false);
        this.subPanel1b.remove(this.columnChoice);
        this.columnChoice.removeItemListener(this);
        this.subPanel5b.remove(this.functionChoice);
        this.functionChoice.removeItemListener(this);
        this.columnChoice = new JComboBox();
        this.functionChoice = new FunctionComboBox(this, this.container, this.availFunctions);
        try {
            this.availColumn = this.createAvailColumnList((String)this.paramChoice.getItemAt(paramIndex));
            this.updateAllowMapping();
        }
        catch (Exception ex) {
            this.availColumn = new Vector();
        }
        this.mapDBcheckbox.setEnabled(this.allowMapping && this.availColumn.size() > 0);
        this.typeChoice.setEnabled(!this.mapDBcheckbox.isSelected());
        this.setupColumnChoice();
        this.columnChoice.setEnabled(false);
        this.columnChoice.addItemListener(this);
        this.setupFunctionChoice();
        this.functionChoice.setEnabled(false);
        this.functionChoice.addItemListener(this);
        this.functionChoice.addActionListener(this);
        this.subPanel1b.add(this.columnChoice);
        this.subPanel5b.add(this.functionChoice);
        this.container.pack();
        this.container.validate();
        this.adjustPosition();
        if (this.availFunctions != null && (double)this.functionChoice.getWidth() > this.functionChoice.getDimensions().getWidth()) {
            this.functionChoice.setDimensions(this.functionChoice.getWidth(), this.functionChoice.getHeight());
        }
        this.setEnableState(true);
        this.mapDBcheckbox.setEnabled(this.allowMapping && this.availColumn.size() > 0);
        this.mapFunctionCheckBox.setEnabled(this.allowMapping && this.databaseInfo != null);
        this.useCustomSelection.setEnabled(this.allowMapping);
        this.mapToSqlSelect.setEnabled(this.allowMapping);
    }

    private void setParamTypeForProcedure() {
        if (this.isCallableStmt) {
            int index = this.paramChoice.getSelectedIndex();
            if (this.inParamType.size() > index) {
                int dataType = (Integer)this.inParamType.elementAt(index);
                for (int i = 0; i < choiceMapToType.length; ++i) {
                    if (dataType != choiceMapToType[i]) continue;
                    this.typeChoice.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    private void setupColumnChoice() {
        int size = this.availColumn.size();
        for (int i = 0; i < size; ++i) {
            this.columnChoice.addItem(this.getAvailColumn(i).getCompleteName());
        }
        this.selectColumnChoice();
    }

    private void setupFunctionChoice() {
        this.functionChoice.addItem(LanguageEncoder.getText("None"));
        this.selectFunctionColumnChoice();
    }

    private void selectColumnChoice() {
        boolean mapState = this.mapDBcheckbox.isSelected();
        this.columnChoice.setEnabled(mapState);
        if (!mapState) {
            return;
        }
        boolean findColumn = false;
        int size = this.availColumn.size();
        for (int i = 0; i < size; ++i) {
            if (!this.getAvailColumn(i).isDefaultColumn()) continue;
            this.columnChoice.setSelectedIndex(i);
            if (this.typeChoice != null) {
                this.setTypeChoice();
            }
            findColumn = true;
            break;
        }
        if (!findColumn && this.columnChoice.getItemCount() != 0) {
            this.columnChoice.setSelectedIndex(0);
            if (this.typeChoice != null) {
                this.setTypeChoice();
            }
        }
    }

    private void selectFunctionColumnChoice() {
        boolean mapState = this.mapFunctionCheckBox.isSelected();
        ActionListener[] al = this.functionChoice.getActionListeners();
        ItemListener[] il = this.functionChoice.getItemListeners();
        for (ActionListener actionListener : al) {
            this.functionChoice.removeActionListener(actionListener);
        }
        EventListener[] eventListenerArray = il;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            EventListener eventListener = eventListenerArray[i];
            this.functionChoice.removeItemListener((ItemListener)eventListener);
        }
        this.functionChoice.setEnabled(mapState);
        if (!mapState) {
            this.functionChoice.setSelectedIndex(0);
            for (EventListener eventListener : al) {
                this.functionChoice.addActionListener((ActionListener)eventListener);
            }
            for (EventListener eventListener : il) {
                this.functionChoice.addItemListener((ItemListener)eventListener);
            }
            this.setParamPanel(false);
            return;
        }
        if (this.availFunctions != null) {
            int sizeFunGroups = this.availFunctions.size();
            this.functionChoice.removeAllItems();
            this.functionChoice.addItem(LanguageEncoder.getText("None"));
            for (int i = 0; i < sizeFunGroups; ++i) {
                int sizeFun = ((Vector)this.availFunctions.get(i)).size();
                for (int j = 0; j < sizeFun; ++j) {
                    String tmp = (String)((Vector)this.availFunctions.get(i)).get(j);
                    if (tmp.indexOf(40) <= 0) continue;
                    this.functionChoice.addItem(tmp);
                }
            }
            this.functionChoice.validate();
        }
        if (!this.recheckMapToFunction && this.queryInParam[this.paramChoice.getSelectedIndex()] != null && this.queryInParam[this.paramChoice.getSelectedIndex()].isMapToFunctionOnly()) {
            QueryInParam currentParam = this.queryInParam[this.paramChoice.getSelectedIndex()];
            if (currentParam != null) {
                String function = MapToFunction.getSelectedFunction(currentParam.getColumnName(), this.availFunctions);
                if (function != null) {
                    this.functionChoice.setSelectedItem(function);
                }
                this.setParamPanel(true);
                this.checkParamSet();
            }
        } else {
            try {
                Object[] params;
                String function = MapToFunction.getFunctionFromQuery(this.query, (String)this.paramChoice.getSelectedItem(), this.availFunctions);
                if (function != null) {
                    this.functionChoice.setSelectedItem(function);
                }
                if ((params = MapToFunction.getFunctionParamsFromQuery(this.query, (String)this.paramChoice.getSelectedItem())) != null && params.length > 0) {
                    this.setParamPanel(false);
                    for (int i = 0; i < this.functionParams.length; ++i) {
                        if (i >= params.length) continue;
                        params[i] = this.convertName((String)params[i], this.functionParams[i]);
                        this.functionParams[i].setSelectedItem(params[i]);
                    }
                    this.checkParamSet();
                }
            }
            catch (Exception e) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), e.getMessage());
            }
        }
        for (ActionListener actionListener : al) {
            this.functionChoice.addActionListener(actionListener);
        }
        for (EventListener eventListener : il) {
            this.functionChoice.addItemListener((ItemListener)eventListener);
        }
    }

    public String convertName(String name, JComboBox comboBox) {
        String colName;
        int i;
        for (i = 0; i < comboBox.getItemCount(); ++i) {
            colName = (String)comboBox.getItemAt(i);
            if (!colName.endsWith("." + name)) continue;
            return colName;
        }
        if (name.contains(".")) {
            name = name.substring(name.indexOf(46) + 1);
            for (i = 0; i < comboBox.getItemCount(); ++i) {
                colName = (String)comboBox.getItemAt(i);
                if (!colName.endsWith("." + name)) continue;
                return colName;
            }
        }
        return name;
    }

    private void setEnableState(boolean state) {
        this.mapDBcheckbox.setEnabled(state);
        if (this.prevPanelButton != null) {
            this.prevPanelButton.setEnabled(state);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
        if (this.nextPanelButton != null) {
            this.nextPanelButton.setEnabled(state);
        }
    }

    protected Vector createAvailColumnList(String paramName) throws Exception {
        return AvailColumn.makeArray(this.queryFileInfo, paramName);
    }

    private void createAvailFunctionList() {
        try {
            if (this.databaseInfo != null) {
                String temp;
                Vector innerVec;
                this.availFunctions = this.databaseInfo.getFunctions();
                boolean withArguments = false;
                for (Object availFunction : this.availFunctions) {
                    innerVec = (Vector)availFunction;
                    for (Object element : innerVec) {
                        temp = (String)element;
                        if (temp.indexOf(41) - temp.indexOf(40) <= 2) continue;
                        withArguments = true;
                        break;
                    }
                    if (!withArguments) continue;
                    break;
                }
                if (!withArguments) {
                    for (int j = 0; j < this.availFunctions.size(); ++j) {
                        innerVec = (Vector)this.availFunctions.get(j);
                        for (int i = 0; i < innerVec.size(); ++i) {
                            temp = (String)innerVec.get(i);
                            if (temp.indexOf(40) <= -1) continue;
                            innerVec.set(i, temp.subSequence(0, temp.indexOf(40) + 1) + " Enter Parameter Type )");
                        }
                    }
                }
                this.functionChoice.setAvailFunctions(this.availFunctions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDefaultValueRequired(boolean state) {
        this.defaultValueRequired = state;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void makeParamInSequence() {
        if (this.paramInSequence == null) {
            return;
        }
        for (int i = 0; i < this.paramInSequence.length; ++i) {
            for (int j = 0; j < this.paramInSequence[i].length; ++j) {
                for (QueryInParam element : this.queryInParam) {
                    if (this.paramInSequence[i][j] == null || !this.paramInSequence[i][j].getParamName().equals(element.getParamName())) continue;
                    this.paramInSequence[i][j] = element;
                }
            }
        }
    }

    private void updateDateFormat(boolean selected) {
        if (selected) {
            if (choiceMapToType[this.typeChoice.getSelectedIndex()] == 91) {
                if (QbDateFormat.getDefaultDateFormat() != null && QbDateFormat.getDefaultDateFormat().length() > 0) {
                    this.dateFormatText.setText(QbDateFormat.getDefaultDateFormat());
                }
            } else if (choiceMapToType[this.typeChoice.getSelectedIndex()] == 92) {
                if (QbDateFormat.getDefaultTimeFormat() != null && QbDateFormat.getDefaultTimeFormat().length() > 0) {
                    this.dateFormatText.setText(QbDateFormat.getDefaultTimeFormat());
                }
            } else if (choiceMapToType[this.typeChoice.getSelectedIndex()] == 93 && QbDateFormat.getDefaultTimestampFormat() != null && QbDateFormat.getDefaultTimestampFormat().length() > 0) {
                this.dateFormatText.setText(QbDateFormat.getDefaultTimestampFormat());
            }
            this.setDefaultValueUI();
        }
    }

    private boolean isAllowAllOptionEnabled() throws JSQLParserException {
        String param = this.paramChoice.getSelectedItem().toString();
        AllParser ap = new AllParser(this.query);
        ap.parse(param);
        ArrayList<String> compOps = ap.getComparisonOperators();
        if (compOps == null) {
            return false;
        }
        for (String compOp : compOps) {
            if (!compOp.trim().equals("<>")) continue;
            return false;
        }
        return !this.mapFunctionCheckBox.isSelected() && !this.mapToSqlSelect.isSelected() && !this.useCustomSelection.isSelected();
    }

    private void enableAllOptions(boolean enabled) {
        this.allOptionCheckBox.setEnabled(enabled);
        this.allOptionLabelText.setEnabled(enabled);
        this.allLabel.setEnabled(enabled);
        this.allUpdateButton.setEnabled(enabled);
    }

    private void updateAllowAllOptions(QueryInParam qip) {
        boolean isAllOptionEnabled = false;
        try {
            isAllOptionEnabled = this.isAllowAllOptionEnabled();
        }
        catch (JSQLParserException jsqlpe) {
            LOGGER.log(Level.FINEST, "Error when checking is allow all option enabled.", jsqlpe);
        }
        this.allOptionCheckBox.setEnabled(isAllOptionEnabled);
        if (qip != null) {
            if (qip instanceof QueryMultiValueInParam) {
                this.enableAllOptions(false);
                this.allOptionCheckBox.setSelected(false);
                this.allOptionLabelText.setText("");
            }
            this.allOptionCheckBox.setSelected(qip.isAllOptionEnabled());
            if (qip.isAllOptionEnabled()) {
                this.allLabel.setEnabled(true);
                this.allOptionLabelText.setEnabled(true);
                this.allUpdateButton.setEnabled(true);
            }
            if (qip.getAllOptionLabel() != null) {
                this.allOptionLabelText.setText(qip.getAllOptionLabel());
            }
        } else if (this.isMultiValue[this.paramChoice.getSelectedIndex()]) {
            this.enableAllOptions(false);
            this.allOptionCheckBox.setSelected(false);
            this.allOptionLabelText.setText("");
        } else if (!this.allOptionCheckBox.isSelected()) {
            this.allOptionLabelText.setText("");
            this.allOptionLabelText.setEnabled(false);
            this.allLabel.setEnabled(false);
            this.allUpdateButton.setEnabled(false);
        } else {
            this.allLabel.setEnabled(true);
            this.allOptionLabelText.setEnabled(true);
            if (this.mapDBcheckbox.isSelected()) {
                if (this.allOptionLabelText.getText().length() == 0) {
                    this.allOptionLabelText.setText("Select All");
                }
                this.allUpdateButton.setEnabled(true);
            } else {
                this.allUpdateButton.setEnabled(false);
            }
        }
    }

    private void updateDefaultListWithAllOption() {
        if (this.mapDBcheckbox.isSelected()) {
            this.resetDefaultChoice();
        }
    }
}

