/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;

public class JNDIDataSourceNode
extends DefaultDataSourceNode {
    private String JNDIName;
    private Hashtable env = new Hashtable();
    private boolean autoJoin = true;
    private int tableNameFormat = 0;

    public JNDIDataSourceNode(String name) {
        super(name);
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public void setName(String name) {
        this.setUserObject(name);
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public void setJNDIName(String JNDIName) {
        this.JNDIName = JNDIName;
    }

    public void setContextFactory(String ctxFactory) {
        if (ctxFactory != null && !ctxFactory.equals("")) {
            this.env.put("java.naming.factory.initial", ctxFactory);
        }
    }

    public String getContextFactory() {
        return (String)this.env.get("java.naming.factory.initial");
    }

    public void setProviderURL(String url) {
        if (url != null && !url.equals("")) {
            this.env.put("java.naming.provider.url", url);
        }
    }

    public String getProviderURL() {
        return (String)this.env.get("java.naming.provider.url");
    }

    public Hashtable getEnvProperties() {
        return this.env;
    }

    public void setEnvProperties(Hashtable env) {
        this.env = env;
    }

    public DefaultMutableTreeNode getQueryNode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((DefaultMutableTreeNode)this.getChildAt(i)).getUserObject().equals("Queries")) continue;
            return (DefaultMutableTreeNode)this.getChildAt(i);
        }
        DefaultMutableTreeNode subnode = new DefaultMutableTreeNode("Queries");
        this.add(subnode);
        return subnode;
    }

    public DefaultMutableTreeNode getDataViewNode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!((DefaultMutableTreeNode)this.getChildAt(i)).getUserObject().equals("Data Views")) continue;
            return (DefaultMutableTreeNode)this.getChildAt(i);
        }
        DefaultMutableTreeNode subnode = new DefaultMutableTreeNode("Data Views");
        this.add(subnode);
        return subnode;
    }

    public void setAutoJoin(boolean state) {
        this.autoJoin = state;
    }

    public boolean isAutoJoin() {
        return this.autoJoin;
    }

    public void setTableNameFormat(int format) {
        if (format < 0) {
            format = 0;
        }
        if (format > 2) {
            format = 2;
        }
        this.tableNameFormat = format;
    }

    public int getTableNameFormat() {
        return this.tableNameFormat;
    }
}

