/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.reportdesigner.report.IOUtil2;

public class JNDIDialog
extends JDialog
implements ActionListener {
    JTextField nameField;
    JTextField DBField;
    JTextField ctxFactoryField;
    JTextField urlField;
    JCheckBox autoJoin;
    private JComboBox tableNameFormat = null;
    JButton okButton;
    JButton cancelButton;
    JButton connectButton;
    DefaultMutableTreeNode parent;
    JNDIDataSourceNode node;
    Manager frame;
    boolean isModified = false;

    public JNDIDialog(Manager frame, DefaultMutableTreeNode parent, JNDIDataSourceNode node) {
        super(frame, LanguageEncoder.getText("Setup JNDI data source..."), true);
        this.frame = frame;
        this.parent = parent;
        this.node = node;
        this.init();
        this.setPosition();
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new BorderLayout());
        upperPanel.setBorder(new TitledBorder(LanguageEncoder.getText("Data Source Information")));
        JPanel p1 = new JPanel();
        JPanel labelPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        JPanel textPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Name :") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("JNDI lookup Name:") + " "));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Intial_Context_Factory:")));
        labelPanel.add(new JLabel(LanguageEncoder.getText("Provider_URL:")));
        this.nameField = new JTextField(25);
        textPanel.add(this.nameField);
        this.DBField = new JTextField(25);
        textPanel.add(this.DBField);
        this.ctxFactoryField = new JTextField(25);
        textPanel.add(this.ctxFactoryField);
        this.urlField = new JTextField(25);
        textPanel.add(this.urlField);
        this.nameField.addActionListener(this);
        this.DBField.addActionListener(this);
        this.ctxFactoryField.addActionListener(this);
        this.urlField.addActionListener(this);
        p1.setLayout(new BorderLayout());
        p1.add("West", labelPanel);
        p1.add("Center", textPanel);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new FlowLayout(1));
        this.connectButton = new JButton(LanguageEncoder.getText("Test Connection"));
        cpanel.add(this.connectButton);
        this.connectButton.addActionListener(this);
        upperPanel.add("Center", p1);
        upperPanel.add("South", cpanel);
        JPanel p2 = new JPanel();
        p2.setBorder(new TitledBorder(LanguageEncoder.getText("Default Options")));
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        p2.setLayout(gbl);
        p2.setLayout(gbl);
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 10, 5, 10);
        gbc.anchor = 17;
        this.autoJoin = new JCheckBox(LanguageEncoder.getText("Auto Join"));
        gbl.setConstraints(this.autoJoin, gbc);
        p2.add(this.autoJoin);
        this.autoJoin.setSelected(true);
        gbc.insets = new Insets(0, 10, 10, 10);
        this.tableNameFormat = new JComboBox<String>(new String[]{"Unqualified Table Name", "2-Part Qualified Table Name", "3-Part Qualified Table Name"});
        gbl.setConstraints(this.tableNameFormat, gbc);
        p2.add(this.tableNameFormat);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(2));
        p3.add(this.okButton);
        p3.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("North", upperPanel);
        contentPane.add("Center", p2);
        contentPane.add("South", p3);
        this.pack();
        this.setValues();
    }

    private void setValues() {
        if (this.node != null) {
            this.nameField.setText(this.node.getName());
            this.DBField.setText(this.node.getJNDIName());
            this.ctxFactoryField.setText(this.node.getContextFactory());
            this.urlField.setText(this.node.getProviderURL());
            this.autoJoin.setSelected(this.node.isAutoJoin());
            this.tableNameFormat.setSelectedIndex(this.node.getTableNameFormat());
        }
    }

    boolean isModified() {
        return this.isModified;
    }

    DefaultMutableTreeNode getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = null;
        if (e.getSource() == this.connectButton) {
            String JNDIName = this.DBField.getText().trim();
            String ctxFactory = this.ctxFactoryField.getText().trim();
            String url = this.urlField.getText().trim();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", ctxFactory);
            env.put("java.naming.provider.url", url);
            DBInfoBasic dbInfo = new DBInfoBasic(JNDIName, "", env);
            if (ServerMessage.useServer) {
                ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
                DataOutputStream dout = new DataOutputStream(bstream);
                IConnection socket = null;
                try {
                    int messageType = 32000;
                    dout.writeShort(messageType);
                    dbInfo.write(dout);
                    socket = ServerMessage.createConnection();
                    byte[] array = bstream.toByteArray();
                    socket.setContentLength(array.length);
                    socket.getOutputStream().write(array);
                    socket.getOutputStream().flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception ex2) {
                        ex2.printStackTrace();
                    }
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Failed to contact EspressReport server at") + " " + ServerMessage.getServerInfo() + " " + ex.getMessage());
                }
                try {
                    DataInputStream instream = new DataInputStream(socket.getInputStream());
                    int code = instream.readInt();
                    if (code != 0) {
                        throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                    }
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Connected to database successfully!"));
                    instream.close();
                    socket.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("connection failed because the following exception occurred") + "\n" + t.toString());
                }
                finally {
                    try {
                        socket.close();
                    }
                    catch (Exception code) {}
                }
            } else {
                try {
                    Connection con = dbInfo.openConnection();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("Connected to database successfully!"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new JMessageDialog((Dialog)this, "Info", LanguageEncoder.getText("connection failed because the following exception occurred") + "\n" + ex.getMessage());
                }
            }
        } else if (e.getSource() == this.okButton || e.getSource() == this.nameField || e.getSource() == this.DBField || e.getSource() == this.ctxFactoryField || e.getSource() == this.urlField) {
            String nodeName = this.nameField.getText().trim();
            if (nodeName == null || nodeName.trim().equals("")) {
                msg = LanguageEncoder.getText("Please enter database name!");
            } else if ((this.node == null || !nodeName.equals(this.node.getUserObject().toString())) && this.frame.managerPane.isChildNode(this.parent, nodeName)) {
                msg = nodeName + " " + LanguageEncoder.getText("already exists!");
            }
            if (msg != null) {
                return;
            }
            if (this.node == null) {
                this.node = new JNDIDataSourceNode(nodeName);
                this.parent.add(this.node);
                this.node.add(new DefaultDataSourceNode("Queries"));
                this.node.add(new DefaultDataSourceNode("Data Views"));
            } else {
                this.node.setUserObject(nodeName);
            }
            this.node.setJNDIName(this.DBField.getText());
            if (!this.ctxFactoryField.getText().trim().equals("")) {
                this.node.setContextFactory(this.ctxFactoryField.getText());
            }
            if (!this.urlField.getText().trim().equals("")) {
                this.node.setProviderURL(this.urlField.getText());
            }
            this.node.setAutoJoin(this.autoJoin.isSelected());
            this.node.setTableNameFormat(this.tableNameFormat.getSelectedIndex());
            this.isModified = true;
            this.setVisible(false);
            this.dispose();
        } else {
            this.setVisible(false);
            this.frame.managerPane.closeEditOrAddNode();
            this.dispose();
        }
    }
}

