/*
 * Decompiled with CFR 0.152.
 */
package quadbase.datasourcemanager.manager;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;

public class LoginDialog
extends JDialog
implements ActionListener {
    public JTextField nameText;
    public JPasswordField pwdText;
    private String name = "";
    private String pwd = "";
    JButton okButton;
    JButton cancelButton;
    private boolean isModified = false;

    public LoginDialog(Dialog parent) {
        super(parent, LanguageEncoder.getText("New Database..."), true);
        this.init();
        this.setPosition();
    }

    public LoginDialog(Frame parent) {
        super(parent, LanguageEncoder.getText("New Database..."), true);
        this.init();
        this.setPosition();
    }

    private void init() {
        JPanel bpanel = new JPanel();
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Please type in database source")));
        bpanel.setLayout(new BorderLayout());
        this.nameText = new JTextField(this.name, 15);
        this.pwdText = new JPasswordField(this.pwd, 15);
        JPanel mainPanelWest = new JPanel(new GridLayout(2, 1, 5, 5));
        JPanel mainPanelCenter = new JPanel(new GridLayout(2, 1, 5, 5));
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("User Name :")));
        mainPanelCenter.add(this.nameText);
        mainPanelWest.add(new JLabel(LanguageEncoder.getText("Password :") + " "));
        mainPanelCenter.add(this.pwdText);
        bpanel.add("West", mainPanelWest);
        bpanel.add("Center", mainPanelCenter);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", bpanel);
        contentPane.add("South", this.okButton);
    }

    private void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    boolean isModified() {
        return this.isModified;
    }

    String getUserName() {
        return this.name;
    }

    String getPassword() {
        return this.pwd;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.name = this.nameText.getText().trim();
            this.pwd = this.pwdText.getText().trim();
            this.isModified = true;
        }
        this.setVisible(false);
        this.dispose();
    }
}

